/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.concurrent.Executor;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InsufficientThreadsDetectionTest {
    private Server _server;

    @AfterEach
    public void dispose() throws Exception {
        this._server.stop();
    }

    @Test
    public void testConnectorUsesServerExecutorWithNotEnoughThreads() throws Exception {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            this._server = new Server((ThreadPool)new QueuedThreadPool(3));
            Executor connectorPool = null;
            ServerConnector connector = new ServerConnector(this._server, connectorPool, null, null, 2, 4, new ConnectionFactory[]{new HttpConnectionFactory()});
            connector.setPort(0);
            this._server.addConnector((Connector)connector);
            this._server.start();
        });
    }

    @Test
    public void testConnectorWithDedicatedExecutor() throws Exception {
        this._server = new Server((ThreadPool)new QueuedThreadPool(3));
        QueuedThreadPool connectorPool = new QueuedThreadPool(100);
        ServerConnector connector = new ServerConnector(this._server, (Executor)connectorPool, null, null, 2, 4, new ConnectionFactory[]{new HttpConnectionFactory()});
        connector.setPort(0);
        this._server.addConnector((Connector)connector);
        this._server.start();
    }

    @Test
    public void testCaseForMultipleConnectors() throws Exception {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            this._server = new Server((ThreadPool)new QueuedThreadPool(4));
            this._server.addConnector((Connector)new ServerConnector(this._server, null, null, null, 1, 1, new ConnectionFactory[]{new HttpConnectionFactory()}));
            QueuedThreadPool connectorPool = new QueuedThreadPool(4, 4);
            this._server.addConnector((Connector)new ServerConnector(this._server, (Executor)connectorPool, null, null, 1, 1, new ConnectionFactory[]{new HttpConnectionFactory()}));
            this._server.addConnector((Connector)new ServerConnector(this._server, null, null, null, 1, 1, new ConnectionFactory[]{new HttpConnectionFactory()}));
            this._server.start();
        });
    }
}

