/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DumpHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.TimerScheduler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class LowResourcesMonitorTest {
    QueuedThreadPool _threadPool;
    Server _server;
    ServerConnector _connector;
    LowResourceMonitor _lowResourcesMonitor;

    @BeforeEach
    public void before() throws Exception {
        this._threadPool = new QueuedThreadPool();
        this._threadPool.setMaxThreads(50);
        this._server = new Server((ThreadPool)this._threadPool);
        this._server.manage((Object)this._threadPool);
        this._server.addBean((Object)new TimerScheduler());
        this._connector = new ServerConnector(this._server);
        this._connector.setPort(0);
        this._connector.setIdleTimeout(35000L);
        this._server.addConnector((Connector)this._connector);
        this._server.setHandler((Handler)new DumpHandler());
        this._lowResourcesMonitor = new LowResourceMonitor(this._server);
        this._lowResourcesMonitor.setLowResourcesIdleTimeout(200);
        this._lowResourcesMonitor.setPeriod(900);
        this._lowResourcesMonitor.setMonitoredConnectors(Collections.singleton(this._connector));
        this._server.addBean((Object)this._lowResourcesMonitor);
        this._server.start();
    }

    @AfterEach
    public void after() throws Exception {
        this._server.stop();
    }

    @Test
    public void testLowOnThreads() throws Exception {
        this._lowResourcesMonitor.setMonitorThreads(true);
        Thread.sleep(1200L);
        this._threadPool.setMaxThreads(this._threadPool.getThreads() - this._threadPool.getIdleThreads() + 10);
        Thread.sleep(1200L);
        Assertions.assertFalse((boolean)this._lowResourcesMonitor.isLowOnResources(), (String)this._lowResourcesMonitor.getReasons());
        CountDownLatch latch = new CountDownLatch(1);
        for (int i = 0; i < 100; ++i) {
            this._threadPool.execute(() -> {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }
        Thread.sleep(1200L);
        Assertions.assertTrue((boolean)this._lowResourcesMonitor.isLowOnResources());
        latch.countDown();
        Thread.sleep(1200L);
        Assertions.assertFalse((boolean)this._lowResourcesMonitor.isLowOnResources(), (String)this._lowResourcesMonitor.getReasons());
    }

    @Test
    public void testNotAccepting() throws Exception {
        this._lowResourcesMonitor.setAcceptingInLowResources(false);
        this._lowResourcesMonitor.setMonitorThreads(true);
        Thread.sleep(1200L);
        int maxThreads = this._threadPool.getThreads() - this._threadPool.getIdleThreads() + 10;
        System.out.println("maxThreads:" + maxThreads);
        this._threadPool.setMaxThreads(maxThreads);
        Thread.sleep(1200L);
        Assertions.assertFalse((boolean)this._lowResourcesMonitor.isLowOnResources(), (String)this._lowResourcesMonitor.getReasons());
        for (AbstractConnector c : this._server.getBeans(AbstractConnector.class)) {
            MatcherAssert.assertThat((Object)c.isAccepting(), (Matcher)Matchers.is((Object)true));
        }
        CountDownLatch latch = new CountDownLatch(1);
        for (int i = 0; i < 100; ++i) {
            this._threadPool.execute(() -> {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }
        Thread.sleep(1200L);
        Assertions.assertTrue((boolean)this._lowResourcesMonitor.isLowOnResources());
        for (AbstractConnector c : this._server.getBeans(AbstractConnector.class)) {
            MatcherAssert.assertThat((Object)c.isAccepting(), (Matcher)Matchers.is((Object)false));
        }
        latch.countDown();
        Thread.sleep(1200L);
        Assertions.assertFalse((boolean)this._lowResourcesMonitor.isLowOnResources(), (String)this._lowResourcesMonitor.getReasons());
        for (AbstractConnector c : this._server.getBeans(AbstractConnector.class)) {
            MatcherAssert.assertThat((Object)c.isAccepting(), (Matcher)Matchers.is((Object)true));
        }
    }

    @Disabled(value="not reliable")
    @Test
    public void testLowOnMemory() throws Exception {
        this._lowResourcesMonitor.setMaxMemory(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() + 0x6400000L);
        Thread.sleep(1200L);
        Assertions.assertFalse((boolean)this._lowResourcesMonitor.isLowOnResources(), (String)this._lowResourcesMonitor.getReasons());
        byte[] data = new byte[0x6400000];
        Arrays.fill(data, (byte)1);
        int hash = Arrays.hashCode(data);
        MatcherAssert.assertThat((Object)hash, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)0)));
        Thread.sleep(1200L);
        Assertions.assertTrue((boolean)this._lowResourcesMonitor.isLowOnResources());
        data = null;
        System.gc();
        System.gc();
        Thread.sleep(1200L);
        Assertions.assertFalse((boolean)this._lowResourcesMonitor.isLowOnResources(), (String)this._lowResourcesMonitor.getReasons());
    }

    @Test
    public void testMaxLowResourcesTime() throws Exception {
        int monitorPeriod = this._lowResourcesMonitor.getPeriod();
        int lowResourcesIdleTimeout = this._lowResourcesMonitor.getLowResourcesIdleTimeout();
        MatcherAssert.assertThat((Object)lowResourcesIdleTimeout, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(monitorPeriod)));
        int maxLowResourcesTime = 5 * monitorPeriod;
        this._lowResourcesMonitor.setMaxLowResourcesTime(maxLowResourcesTime);
        Assertions.assertFalse((boolean)this._lowResourcesMonitor.isLowOnResources(), (String)this._lowResourcesMonitor.getReasons());
        try (Socket socket0 = new Socket("localhost", this._connector.getLocalPort());){
            this._lowResourcesMonitor.setMaxMemory(1L);
            Thread.sleep(2 * monitorPeriod);
            Assertions.assertTrue((boolean)this._lowResourcesMonitor.isLowOnResources());
            Assertions.assertEquals((int)-1, (int)socket0.getInputStream().read());
            try (Socket socket1 = new Socket("localhost", this._connector.getLocalPort());){
                socket1.setSoTimeout(1);
                InputStream input1 = socket1.getInputStream();
                Assertions.assertTrue((boolean)this._lowResourcesMonitor.isLowOnResources());
                Assertions.assertThrows(SocketTimeoutException.class, () -> input1.read());
                Thread.sleep(2 * lowResourcesIdleTimeout);
                Assertions.assertTrue((boolean)this._lowResourcesMonitor.isLowOnResources());
                Assertions.assertThrows(SocketTimeoutException.class, () -> input1.read());
                Thread.sleep(maxLowResourcesTime);
                Assertions.assertTrue((boolean)this._lowResourcesMonitor.isLowOnResources());
                Assertions.assertEquals((int)-1, (int)input1.read());
            }
        }
    }
}

