/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.MappingMatch;
import jakarta.servlet.http.Part;
import jakarta.servlet.http.PushBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Principal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.logging.StacklessLogging;
import org.eclipse.jetty.server.CharEncodingContextHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServletPathMapping;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDir;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDirExtension;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={WorkDirExtension.class})
public class RequestTest {
    private static final Logger LOG = LoggerFactory.getLogger(RequestTest.class);
    public WorkDir workDir;
    private Server _server;
    private LocalConnector _connector;
    private RequestHandler _handler;

    @BeforeEach
    public void init() throws Exception {
        this._server = new Server();
        HttpConnectionFactory http = new HttpConnectionFactory();
        http.setInputBufferSize(1024);
        http.getHttpConfiguration().setRequestHeaderSize(512);
        http.getHttpConfiguration().setResponseHeaderSize(512);
        http.getHttpConfiguration().setOutputBufferSize(2048);
        http.getHttpConfiguration().addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        this._connector = new LocalConnector(this._server, (ConnectionFactory)http);
        this._server.addConnector((Connector)this._connector);
        this._connector.setIdleTimeout(500L);
        this._handler = new RequestHandler();
        this._server.setHandler((Handler)this._handler);
        ErrorHandler errors = new ErrorHandler();
        errors.setServer(this._server);
        errors.setShowStacks(true);
        this._server.addBean((Object)errors);
        this._server.start();
    }

    @AfterEach
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testRequestCharacterEncoding() throws Exception {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        final AtomicReference<Object> overrideCharEncoding = new AtomicReference<Object>(null);
        this._server.stop();
        CharEncodingContextHandler handler = new CharEncodingContextHandler();
        this._server.setHandler((Handler)handler);
        handler.setHandler((Handler)this._handler);
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                try {
                    String s = (String)overrideCharEncoding.get();
                    if (s != null) {
                        request.setCharacterEncoding(s);
                    }
                    result.set(request.getCharacterEncoding());
                    return true;
                }
                catch (UnsupportedEncodingException e) {
                    return false;
                }
            }
        };
        this._server.start();
        String request = "GET / HTTP/1.1\nHost: whatever\r\nContent-Type: text/html;charset=utf8\nConnection: close\n\n";
        handler.setDefaultRequestCharacterEncoding("ascii");
        String response = this._connector.getResponse(request);
        Assertions.assertTrue((boolean)response.startsWith("HTTP/1.1 200"));
        Assertions.assertEquals((Object)"ascii", result.get());
        result.set(null);
        overrideCharEncoding.set("utf-16");
        response = this._connector.getResponse(request);
        Assertions.assertTrue((boolean)response.startsWith("HTTP/1.1 200"));
        Assertions.assertEquals((Object)"utf-16", result.get());
        result.set(null);
        overrideCharEncoding.set(null);
        handler.setDefaultRequestCharacterEncoding(null);
        response = this._connector.getResponse(request);
        Assertions.assertTrue((boolean)response.startsWith("HTTP/1.1 200"));
        Assertions.assertEquals((Object)"utf-8", result.get());
    }

    @Test
    public void testParamExtraction() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                try {
                    request.getParameterMap();
                    return false;
                }
                catch (BadMessageException e) {
                    String rawQuery = request.getQueryString();
                    return rawQuery.equals("param=aaa%ZZbbb&other=value");
                }
            }
        };
        String request = "GET /?param=aaa%ZZbbb&other=value HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/html;charset=utf8\nConnection: close\n\n";
        String responses = this._connector.getResponse(request);
        Assertions.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testParamExtractionBadSequence() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                request.getParameterMap();
                return false;
            }
        };
        String request = "GET /?test_%e0%x8%81=missing HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/html;charset=utf8\nConnection: close\n\n";
        String responses = this._connector.getResponse(request);
        MatcherAssert.assertThat((String)"Responses", (Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 400"));
    }

    @Test
    public void testParamExtractionTimeout() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                request.getParameterMap();
                return false;
            }
        };
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\nConnection: close\nContent-Length: 100\n\nname=value";
        LocalConnector.LocalEndPoint endp = this._connector.connect();
        endp.addInput(request);
        String response = BufferUtil.toString((ByteBuffer)endp.waitForResponse(false, 1L, TimeUnit.SECONDS));
        MatcherAssert.assertThat((String)"Responses", (Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 500"));
    }

    @Test
    public void testEmptyHeaders() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                Assertions.assertNotNull((Object)request.getLocale());
                Assertions.assertTrue((boolean)request.getLocales().hasMoreElements());
                Assertions.assertEquals((Object)"", (Object)request.getContentType());
                Assertions.assertNull((Object)request.getCharacterEncoding());
                Assertions.assertEquals((int)0, (int)request.getQueryString().length());
                Assertions.assertEquals((int)-1, (int)request.getContentLength());
                Assertions.assertNull((Object)request.getCookies());
                Assertions.assertEquals((Object)"", (Object)request.getHeader("Name"));
                Assertions.assertTrue((boolean)request.getHeaders("Name").hasMoreElements());
                Assertions.assertThrows(IllegalArgumentException.class, () -> request.getDateHeader("Name"));
                Assertions.assertEquals((long)-1L, (long)request.getDateHeader("Other"));
                return true;
            }
        };
        String request = "GET /? HTTP/1.1\r\nHost: whatever\r\nConnection: close\nContent-Type: \nAccept-Language: \nCookie: \nName: \n\n";
        String responses = this._connector.getResponse(request);
        Assertions.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testMultiPartNoConfig() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                try {
                    request.getPart("stuff");
                    return false;
                }
                catch (IllegalStateException e) {
                    Assertions.assertTrue((boolean)e.getMessage().startsWith("No multipart config"));
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        String multipart = "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"\r\nContent-Type: text/plain;charset=ISO-8859-1\r\n\r\n000000000000000000000000000000000000000000000000000\r\n--AaB03x--\r\n";
        String request = "GET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data; boundary=\"AaB03x\"\r\nContent-Length: " + multipart.getBytes().length + "\r\nConnection: close\r\n\r\n" + multipart;
        String responses = this._connector.getResponse(request);
        Assertions.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testLocale() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                MatcherAssert.assertThat((Object)request.getLocale().getLanguage(), (Matcher)Matchers.is((Object)"da"));
                Enumeration locales = request.getLocales();
                Locale locale = (Locale)locales.nextElement();
                MatcherAssert.assertThat((Object)locale.getLanguage(), (Matcher)Matchers.is((Object)"da"));
                MatcherAssert.assertThat((Object)locale.getCountry(), (Matcher)Matchers.is((Object)""));
                locale = (Locale)locales.nextElement();
                MatcherAssert.assertThat((Object)locale.getLanguage(), (Matcher)Matchers.is((Object)"en"));
                MatcherAssert.assertThat((Object)locale.getCountry(), (Matcher)Matchers.is((Object)"AU"));
                locale = (Locale)locales.nextElement();
                MatcherAssert.assertThat((Object)locale.getLanguage(), (Matcher)Matchers.is((Object)"en"));
                MatcherAssert.assertThat((Object)locale.getCountry(), (Matcher)Matchers.is((Object)"GB"));
                locale = (Locale)locales.nextElement();
                MatcherAssert.assertThat((Object)locale.getLanguage(), (Matcher)Matchers.is((Object)"en"));
                MatcherAssert.assertThat((Object)locale.getCountry(), (Matcher)Matchers.is((Object)""));
                Assertions.assertFalse((boolean)locales.hasMoreElements());
                return true;
            }
        };
        String request = "GET / HTTP/1.1\r\nHost: whatever\r\nConnection: close\r\nAccept-Language: da, en-gb;q=0.8, en;q=0.7\r\nAccept-Language: XX;q=0, en-au;q=0.9\r\n\r\n";
        String response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
    }

    @Test
    public void testMultiPart() throws Exception {
        Path testTmpDir = this.workDir.getEmptyPathDir();
        RequestTester tester = (request, response) -> Files.list(testTmpDir).count() == 2L;
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath("/foo");
        contextHandler.setResourceBase(".");
        contextHandler.setHandler((Handler)new MultiPartRequestHandler(testTmpDir.toFile(), tester));
        this._server.stop();
        this._server.setHandler((Handler)contextHandler);
        this._server.start();
        String multipart = "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"; filename=\"foo.upload\"\r\nContent-Type: text/plain;charset=ISO-8859-1\r\n\r\n000000000000000000000000000000000000000000000000000\r\n--AaB03x--\r\n";
        String request2 = "GET /foo/x.html HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data; boundary=\"AaB03x\"\r\nContent-Length: " + multipart.getBytes().length + "\r\n\r\n" + multipart;
        LocalConnector.LocalEndPoint endPoint = this._connector.connect();
        endPoint.addInput(request2);
        Assertions.assertTrue((boolean)endPoint.getResponse().startsWith("HTTP/1.1 200"));
        String cleanupRequest = "GET /foo/cleanup HTTP/1.1\r\nHost: whatever\r\nConnection: close\r\n\r\n";
        endPoint.addInput(cleanupRequest);
        Assertions.assertTrue((boolean)endPoint.getResponse().startsWith("HTTP/1.1 200"));
        MatcherAssert.assertThat((String)("File Count in dir: " + testTmpDir), (Object)RequestTest.getFileCount(testTmpDir), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testBadMultiPart() throws Exception {
        Path testTmpDir = this.workDir.getEmptyPathDir();
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath("/foo");
        contextHandler.setResourceBase(".");
        contextHandler.setHandler((Handler)new BadMultiPartRequestHandler(testTmpDir));
        this._server.stop();
        this._server.setHandler((Handler)contextHandler);
        this._server.start();
        String multipart = "--AaB03x\r\ncontent-disposition: form-data; name=\"xxx\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data;  filename=\"foo.upload\"\r\nContent-Type: text/plain;charset=ISO-8859-1\r\n\r\n000000000000000000000000000000000000000000000000000\r\n--AaB03x--\r\n";
        String request = "GET /foo/x.html HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data; boundary=\"AaB03x\"\r\nContent-Length: " + multipart.getBytes().length + "\r\nConnection: close\r\n\r\n" + multipart;
        LocalConnector.LocalEndPoint endPoint = this._connector.connect();
        try (StacklessLogging ignored = new StacklessLogging(new Class[]{HttpChannel.class});){
            endPoint.addInput(request);
            Assertions.assertTrue((boolean)endPoint.getResponse().startsWith("HTTP/1.1 500"));
        }
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            while (RequestTest.getFileCount(testTmpDir) > 0L) {
                Thread.yield();
            }
        });
    }

    @Test
    public void testBadUtf8ParamExtraction() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                try {
                    request.getParameter("param");
                    return false;
                }
                catch (BadMessageException e) {
                    String rawQuery = request.getQueryString();
                    return rawQuery.equals("param=aaa%E7bbb");
                }
            }
        };
        String request = "GET /?param=aaa%E7bbb HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/html;charset=utf8\nConnection: close\n\n";
        LOG.info("Expecting NotUtf8Exception in state 36...");
        String responses = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
    }

    @Test
    public void testEncodedParamExtraction() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                try {
                    request.getParameter("param");
                    return false;
                }
                catch (BadMessageException e) {
                    return e.getCode() == 415;
                }
            }
        };
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/x-www-form-urlencoded; charset=utf-8\nContent-Length: 10\nContent-Encoding: gzip\nConnection: close\n\n0123456789\n";
        String responses = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
    }

    @Test
    public void testContentLengthExceedsMaxInteger() throws Exception {
        long HUGE_LENGTH = 0x4FFFFFFF6L;
        this._handler._checker = (request, response) -> request.getContentLength() == -1 && request.getContentLengthLong() == 0x4FFFFFFF6L;
        String request2 = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/octet-stream\nContent-Length: 21474836470\nConnection: close\n\n<insert huge amount of content here>\n";
        System.out.println(request2);
        String responses = this._connector.getResponse(request2);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
    }

    @Test
    public void testContentLengthExceedsMaxLong() throws Exception {
        String hugeLength = "92233720368547758070";
        this._handler._checker = (request, response) -> request.getHeader("Content-Length").equals(hugeLength) && request.getContentLength() == -1 && request.getContentLengthLong() == -1L;
        String request2 = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/octet-stream\nContent-Length: " + hugeLength + "\nConnection: close\n\n<insert huge amount of content here>\n";
        String responses = this._connector.getResponse(request2);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 400"));
    }

    @Test
    public void testIdentityParamExtraction() throws Exception {
        this._handler._checker = (request, response) -> "bar".equals(request.getParameter("foo"));
        String request2 = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/x-www-form-urlencoded; charset=utf-8\nContent-Length: 7\nContent-Encoding: identity\nConnection: close\n\nfoo=bar\n";
        String responses = this._connector.getResponse(request2);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
    }

    @Test
    public void testEncodedNotParams() throws Exception {
        this._handler._checker = (request, response) -> request.getParameter("param") == null;
        String request2 = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/octet-stream\nContent-Length: 10\nContent-Encoding: gzip\nConnection: close\n\n0123456789\n";
        String responses = this._connector.getResponse(request2);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
    }

    @Test
    public void testInvalidHostHeader() throws Exception {
        ContextHandler context = new ContextHandler();
        context.addVirtualHosts(new String[]{"something"});
        this._server.stop();
        this._server.setHandler((Handler)context);
        this._server.start();
        String request = "GET / HTTP/1.1\nHost: whatever.com:xxxx\nContent-Type: text/html;charset=utf8\nConnection: close\n\n";
        String responses = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 400"));
    }

    @Test
    public void testContentTypeEncoding() throws Exception {
        final ArrayList results = new ArrayList();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                results.add(request.getContentType());
                results.add(request.getCharacterEncoding());
                return true;
            }
        };
        LocalConnector.LocalEndPoint endp = this._connector.executeRequest("GET / HTTP/1.1\nHost: whatever\nContent-Type: text/test\n\nGET / HTTP/1.1\nHost: whatever\nContent-Type: text/html;charset=utf8\n\nGET / HTTP/1.1\nHost: whatever\nContent-Type: text/html; charset=\"utf8\"\n\nGET / HTTP/1.1\nHost: whatever\nContent-Type: text/html; other=foo ; blah=\"charset=wrong;\" ; charset =   \" x=z; \"   ; more=values \nConnection: close\n\n");
        endp.getResponse();
        endp.getResponse();
        endp.getResponse();
        endp.getResponse();
        int i = 0;
        Assertions.assertEquals((Object)"text/test", results.get(i++));
        Assertions.assertEquals(null, results.get(i++));
        Assertions.assertEquals((Object)"text/html;charset=utf8", results.get(i++));
        Assertions.assertEquals((Object)"utf-8", results.get(i++));
        Assertions.assertEquals((Object)"text/html; charset=\"utf8\"", results.get(i++));
        Assertions.assertEquals((Object)"utf-8", results.get(i++));
        Assertions.assertTrue((boolean)((String)results.get(i++)).startsWith("text/html"));
        Assertions.assertEquals((Object)" x=z; ", results.get(i++));
    }

    @Test
    public void testHostPort() throws Exception {
        final ArrayList results = new ArrayList();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                results.add(request.getRequestURL().toString());
                results.add(request.getRemoteAddr());
                results.add(request.getServerName());
                results.add(String.valueOf(request.getServerPort()));
                return true;
            }
        };
        results.clear();
        String response = this._connector.getResponse("GET / HTTP/1.1\nHost: myhost\nConnection: close\n\n");
        int i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://myhost/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"myhost", results.get(i++));
        Assertions.assertEquals((Object)"80", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: myhost:8888\nConnection: close\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://myhost:8888/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"myhost", results.get(i++));
        Assertions.assertEquals((Object)"8888", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET http://myhost:8888/ HTTP/1.0\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://myhost:8888/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"myhost", results.get(i++));
        Assertions.assertEquals((Object)"8888", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET http://myhost:8888/ HTTP/1.1\nHost: wrong:666\nConnection: close\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://myhost:8888/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"myhost", results.get(i++));
        Assertions.assertEquals((Object)"8888", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: 1.2.3.4\nConnection: close\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://1.2.3.4/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"1.2.3.4", results.get(i++));
        Assertions.assertEquals((Object)"80", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: 1.2.3.4:8888\nConnection: close\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://1.2.3.4:8888/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"1.2.3.4", results.get(i++));
        Assertions.assertEquals((Object)"8888", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: [::1]\nConnection: close\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://[::1]/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"[::1]", results.get(i++));
        Assertions.assertEquals((Object)"80", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: [::1]:8888\nConnection: close\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://[::1]:8888/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"[::1]", results.get(i++));
        Assertions.assertEquals((Object)"8888", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: [::1]\nx-forwarded-for: remote\nx-forwarded-proto: https\nConnection: close\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"https://[::1]/", results.get(i++));
        Assertions.assertEquals((Object)"remote", results.get(i++));
        Assertions.assertEquals((Object)"[::1]", results.get(i++));
        Assertions.assertEquals((Object)"443", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: [::1]:8888\nConnection: close\nx-forwarded-for: remote\nx-forwarded-proto: https\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"https://[::1]:8888/", results.get(i++));
        Assertions.assertEquals((Object)"remote", results.get(i++));
        Assertions.assertEquals((Object)"[::1]", results.get(i++));
        Assertions.assertEquals((Object)"8888", results.get(i++));
    }

    @Test
    public void testContent() throws Exception {
        final AtomicInteger length = new AtomicInteger();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                int len = request.getContentLength();
                ServletInputStream in = request.getInputStream();
                for (int i = 0; i < len; ++i) {
                    int b = in.read();
                    if (b >= 0) continue;
                    return false;
                }
                if (in.read() > 0) {
                    return false;
                }
                length.set(len);
                return true;
            }
        };
        Object content = "";
        for (int l = 0; l < 1024; ++l) {
            String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data-test\r\nContent-Length: " + l + "\r\nConnection: close\r\n\r\n" + (String)content;
            LOG.debug("test l={}", (Object)l);
            String response = this._connector.getResponse(request);
            LOG.debug(response);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
            Assertions.assertEquals((int)l, (int)length.get());
            content = (String)content + "x";
        }
    }

    @Test
    public void testEncodedForm() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                String actual = request.getParameter("name2");
                return "test2".equals(actual);
            }
        };
        String content = "name1=test&name2=test2&name3=&name4=test";
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\nContent-Length: " + content.length() + "\r\nConnection: close\r\n\r\n" + content;
        String response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
    }

    @Test
    public void testEncodedFormUnknownMethod() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                return request.getParameter("name1") == null && request.getParameter("name2") == null && request.getParameter("name3") == null;
            }
        };
        String content = "name1=test&name2=test2&name3=&name4=test";
        String request = "UNKNOWN / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\nContent-Length: " + content.length() + "\r\nConnection: close\r\n\r\n" + content;
        String response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
    }

    @Test
    public void testEncodedFormExtraMethod() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                String actual = request.getParameter("name2");
                return "test2".equals(actual);
            }
        };
        ((HttpConnectionFactory)this._connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration().addFormEncodedMethod("Extra");
        String content = "name1=test&name2=test2&name3=&name4=test";
        String request = "EXTRA / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\nContent-Length: " + content.length() + "\r\nConnection: close\r\n\r\n" + content;
        String response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
    }

    @Test
    public void test8859EncodedForm() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                request.setCharacterEncoding(StandardCharsets.ISO_8859_1.name());
                String actual = request.getParameter("name2");
                return "test\u00e4".equals(actual);
            }
        };
        String content = "name1=test&name2=test%E4&name3=&name4=test";
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\nContent-Length: " + content.length() + "\r\nConnection: close\r\n\r\n" + content;
        String response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
    }

    @Test
    public void testUTF8EncodedForm() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                String actual = request.getParameter("name2");
                return "test\u00e4".equals(actual);
            }
        };
        String content = "name1=test&name2=test%C3%A4&name3=&name4=test";
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\nContent-Length: " + content.length() + "\r\nConnection: close\r\n\r\n" + content;
        String response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
    }

    @Test
    @Disabled(value="See issue #1175")
    public void testMultiPartFormDataReadInputThenParams() throws Exception {
        final File tmpdir = MavenTestingUtils.getTargetTestingDir((String)"multipart");
        FS.ensureEmpty((File)tmpdir);
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (baseRequest.getDispatcherType() != DispatcherType.REQUEST) {
                    return;
                }
                MultipartConfigElement multipartConfig = new MultipartConfigElement(tmpdir.getAbsolutePath());
                request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)multipartConfig);
                baseRequest.setHandled(true);
                int length = request.getContentLength();
                ServletInputStream in = request.getInputStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IO.copy((InputStream)in, (OutputStream)out, (long)length);
                response.setIntHeader("x-request-content-length", request.getContentLength());
                response.setIntHeader("x-request-content-read", out.size());
                String foo = request.getParameter("foo");
                String bar = request.getParameter("bar");
                response.setHeader("x-foo", foo == null ? "null" : foo);
                response.setHeader("x-bar", bar == null ? "null" : bar);
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String multipart = "--AaBbCc\r\ncontent-disposition: form-data; name=\"bar\"\r\n\r\nBarContent\r\n--AaBbCc\r\ncontent-disposition: form-data; name=\"stuff\"\r\nContent-Type: text/plain;charset=ISO-8859-1\r\n\r\n000000000000000000000000000000000000000000000000000\r\n--AaBbCc--\r\n";
        String request = "POST /?foo=FooUri HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data; boundary=\"AaBbCc\"\r\nContent-Length: " + multipart.getBytes().length + "\r\nConnection: close\r\n\r\n" + multipart;
        HttpTester.Response response = HttpTester.parseResponse((String)this._connector.getResponse(request));
        MatcherAssert.assertThat((String)"response.x-foo", (Object)response.get("x-foo"), (Matcher)Matchers.is((Object)"FooUri"));
        MatcherAssert.assertThat((String)"response.x-bar", (Object)response.get("x-bar"), (Matcher)Matchers.is((Object)"null"));
    }

    @Test
    public void testPartialRead() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                BufferedReader reader = request.getReader();
                byte[] b = ("read=" + ((Reader)reader).read() + "\n").getBytes(StandardCharsets.UTF_8);
                response.setContentLength(b.length);
                response.getOutputStream().write(b);
                response.flushBuffer();
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String requests = "GET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\n\r\n0123456789\r\nGET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\nConnection: close\r\n\r\nABCDEFGHIJ\r\n";
        LocalConnector.LocalEndPoint endp = this._connector.executeRequest(requests);
        String responses = endp.getResponse() + endp.getResponse();
        int index = responses.indexOf("read=48");
        Assertions.assertTrue((index > 0 ? 1 : 0) != 0);
        index = responses.indexOf("read=65", index + 7);
        Assertions.assertTrue((index > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryAfterRead() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                BufferedReader reader = request.getReader();
                String in = IO.toString((Reader)reader);
                String param = request.getParameter("param");
                byte[] b = ("read='" + in + "' param=" + param + "\n").getBytes(StandardCharsets.UTF_8);
                response.setContentLength(b.length);
                response.getOutputStream().write(b);
                response.flushBuffer();
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String request = "POST /?param=right HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: 11\r\nConnection: close\r\n\r\nparam=wrong\r\n";
        String responses = this._connector.getResponse(request);
        Assertions.assertTrue((responses.indexOf("read='param=wrong' param=right") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSessionAfterRedirect() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.sendRedirect("/foo");
                try {
                    request.getSession(true);
                    Assertions.fail((String)"Session should not be created after response committed");
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (Exception e) {
                    Assertions.fail((String)"Session creation after response commit should throw IllegalStateException");
                }
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String response = this._connector.getResponse("GET / HTTP/1.1\nHost: myhost\nConnection: close\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 302 Found"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Location: http://myhost/foo"));
    }

    @Test
    public void testPartialInput() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                ServletInputStream in = request.getInputStream();
                byte[] b = ("read=" + in.read() + "\n").getBytes(StandardCharsets.UTF_8);
                response.setContentLength(b.length);
                response.getOutputStream().write(b);
                response.flushBuffer();
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String requests = "GET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\n\r\n0123456789\r\nGET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\nConnection: close\r\n\r\nABCDEFGHIJ\r\n";
        LocalConnector.LocalEndPoint endp = this._connector.executeRequest(requests);
        String responses = endp.getResponse() + endp.getResponse();
        int index = responses.indexOf("read=48");
        Assertions.assertTrue((index > 0 ? 1 : 0) != 0);
        index = responses.indexOf("read=65", index + 7);
        Assertions.assertTrue((index > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConnectionClose() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.getOutputStream().println("Hello World");
                return true;
            }
        };
        String response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\n\n", 200L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Connection: close")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\nConnection: close\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: close"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\nConnection: Other, close\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: close"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
        response = this._connector.getResponse("GET / HTTP/1.0\nHost: whatever\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Connection: close")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
        response = this._connector.getResponse("GET / HTTP/1.0\nHost: whatever\nConnection: Other, close\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
        response = this._connector.getResponse("GET / HTTP/1.0\nHost: whatever\nConnection: Other,,keep-alive\n\n", 200L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: keep-alive"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.setHeader("Connection", "TE");
                response.addHeader("Connection", "Other");
                response.getOutputStream().println("Hello World");
                return true;
            }
        };
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\n\n", 200L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: TE"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: Other"));
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\nConnection: close\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: close"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testCookies() throws Exception {
        final ArrayList cookies = new ArrayList();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                Cookie[] ca = request.getCookies();
                if (ca != null) {
                    cookies.addAll(Arrays.asList(ca));
                }
                response.getOutputStream().println("Hello World");
                return true;
            }
        };
        cookies.clear();
        String response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\nConnection: close\n\n");
        Assertions.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assertions.assertEquals((int)0, (int)cookies.size());
        cookies.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\nCookie: name=quoted=\"\\\"badly\\\"\"\nConnection: close\n\n");
        Assertions.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assertions.assertEquals((int)1, (int)cookies.size());
        Assertions.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assertions.assertEquals((Object)"quoted=\"\\\"badly\\\"\"", (Object)((Cookie)cookies.get(0)).getValue());
        cookies.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\nCookie: name=value; other=\"quoted=;value\"\nConnection: close\n\n");
        Assertions.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assertions.assertEquals((int)2, (int)cookies.size());
        Assertions.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assertions.assertEquals((Object)"value", (Object)((Cookie)cookies.get(0)).getValue());
        Assertions.assertEquals((Object)"other", (Object)((Cookie)cookies.get(1)).getName());
        Assertions.assertEquals((Object)"quoted=;value", (Object)((Cookie)cookies.get(1)).getValue());
        cookies.clear();
        LocalConnector.LocalEndPoint endp = this._connector.executeRequest("GET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"quoted=;value\"\n\nGET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"quoted=;value\"\nConnection: close\n\n");
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        Assertions.assertEquals((int)4, (int)cookies.size());
        Assertions.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assertions.assertEquals((Object)"value", (Object)((Cookie)cookies.get(0)).getValue());
        Assertions.assertEquals((Object)"other", (Object)((Cookie)cookies.get(1)).getName());
        Assertions.assertEquals((Object)"quoted=;value", (Object)((Cookie)cookies.get(1)).getValue());
        Assertions.assertSame(cookies.get(0), cookies.get(2));
        Assertions.assertSame(cookies.get(1), cookies.get(3));
        cookies.clear();
        endp = this._connector.executeRequest("GET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"quoted=;value\"\n\nGET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"othervalue\"\nConnection: close\n\n");
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        Assertions.assertEquals((int)4, (int)cookies.size());
        Assertions.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assertions.assertEquals((Object)"value", (Object)((Cookie)cookies.get(0)).getValue());
        Assertions.assertEquals((Object)"other", (Object)((Cookie)cookies.get(1)).getName());
        Assertions.assertEquals((Object)"quoted=;value", (Object)((Cookie)cookies.get(1)).getValue());
        Assertions.assertNotSame(cookies.get(0), cookies.get(2));
        Assertions.assertNotSame(cookies.get(1), cookies.get(3));
        cookies.clear();
        response = this._connector.getResponse("GET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: __utmz=14316.133020.1.1.utr=gna.de|ucn=(real)|utd=reral|utct=/games/hen-one,gnt-50-ba-keys:key,2072262.html\nConnection: close\n\n");
        Assertions.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assertions.assertEquals((int)1, (int)cookies.size());
        Assertions.assertEquals((Object)"__utmz", (Object)((Cookie)cookies.get(0)).getName());
        Assertions.assertEquals((Object)"14316.133020.1.1.utr=gna.de|ucn=(real)|utd=reral|utct=/games/hen-one,gnt-50-ba-keys:key,2072262.html", (Object)((Cookie)cookies.get(0)).getValue());
    }

    @Test
    public void testBadCookies() throws Exception {
        final ArrayList cookies = new ArrayList();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                Cookie[] ca = request.getCookies();
                if (ca != null) {
                    cookies.addAll(Arrays.asList(ca));
                }
                response.getOutputStream().println("Hello World");
                return true;
            }
        };
        cookies.clear();
        String response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\nCookie: Path=value\nCookie: name=value\nConnection: close\n\n");
        Assertions.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assertions.assertEquals((int)1, (int)cookies.size());
        Assertions.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assertions.assertEquals((Object)"value", (Object)((Cookie)cookies.get(0)).getValue());
    }

    @Disabled(value="No longer relevant")
    @Test
    public void testCookieLeak() throws Exception {
        final String[] cookie = new String[10];
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                for (int i = 0; i < cookie.length; ++i) {
                    cookie[i] = null;
                }
                Cookie[] cookies = request.getCookies();
                for (int i = 0; cookies != null && i < cookies.length; ++i) {
                    cookie[i] = cookies[i].getValue();
                }
                return true;
            }
        };
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nCookie: other=cookie\r\n\r\nPOST / HTTP/1.1\r\nHost: whatever\r\nCookie: name=value\r\nConnection: close\r\n\r\n";
        this._connector.getResponse(request);
        Assertions.assertEquals((Object)"value", (Object)cookie[0]);
        Assertions.assertEquals(null, (Object)cookie[1]);
        request = "POST / HTTP/1.1\r\nHost: whatever\r\nCookie: name=value\r\n\r\nPOST / HTTP/1.1\r\nHost: whatever\r\nCookie: \r\nConnection: close\r\n\r\n";
        this._connector.getResponse(request);
        Assertions.assertEquals(null, (Object)cookie[0]);
        Assertions.assertEquals(null, (Object)cookie[1]);
        request = "POST / HTTP/1.1\r\nHost: whatever\r\nCookie: name=value\r\nCookie: other=cookie\r\n\r\nPOST / HTTP/1.1\r\nHost: whatever\r\nCookie: name=value\r\nCookie:\r\nConnection: close\r\n\r\n";
        this._connector.getResponse(request);
        Assertions.assertEquals((Object)"value", (Object)cookie[0]);
        Assertions.assertEquals(null, (Object)cookie[1]);
    }

    @Test
    public void testHashDOSKeys() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)-1);
            this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormKeys", (Object)1000);
            StringBuilder buf = new StringBuilder(4000000);
            buf.append("a=b");
            File evilKeys = new File("/tmp/keys_mapping_to_zero_2m");
            if (evilKeys.exists()) {
                try (BufferedReader in = new BufferedReader(new FileReader(evilKeys));){
                    String key = null;
                    while ((key = in.readLine()) != null) {
                        buf.append("&").append(key).append("=").append("x");
                    }
                }
            } else {
                for (int i = 0; i < 2000; ++i) {
                    buf.append("&").append("K").append(i).append("=").append("x");
                }
            }
            buf.append("&c=d");
            this._handler._checker = new RequestTester(){

                @Override
                public boolean check(HttpServletRequest request, HttpServletResponse response) {
                    return "b".equals(request.getParameter("a")) && request.getParameter("c") == null;
                }
            };
            String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\nContent-Length: " + buf.length() + "\r\nConnection: close\r\n\r\n" + buf;
            long start = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            String rawResponse = this._connector.getResponse(request);
            HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
            MatcherAssert.assertThat((String)"Response body content", (Object)response.getContent(), (Matcher)Matchers.containsString((String)BadMessageException.class.getName()));
            MatcherAssert.assertThat((String)"Response body content", (Object)response.getContent(), (Matcher)Matchers.containsString((String)IllegalStateException.class.getName()));
            long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            Assertions.assertTrue((now - start < 5000L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testHashDOSSize() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            LOG.info("Expecting maxFormSize limit and too much data exceptions...");
            this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)3396);
            this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormKeys", (Object)1000);
            StringBuilder buf = new StringBuilder(4000000);
            buf.append("a=b");
            for (int i = 0; i < 500; ++i) {
                buf.append("&").append("K").append(i).append("=").append("x");
            }
            buf.append("&c=d");
            this._handler._checker = new RequestTester(){

                @Override
                public boolean check(HttpServletRequest request, HttpServletResponse response) {
                    return "b".equals(request.getParameter("a")) && request.getParameter("c") == null;
                }
            };
            String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\nContent-Length: " + buf.length() + "\r\nConnection: close\r\n\r\n" + buf;
            long start = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            String rawResponse = this._connector.getResponse(request);
            HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
            MatcherAssert.assertThat((String)"Response body content", (Object)response.getContent(), (Matcher)Matchers.containsString((String)BadMessageException.class.getName()));
            MatcherAssert.assertThat((String)"Response body content", (Object)response.getContent(), (Matcher)Matchers.containsString((String)IllegalStateException.class.getName()));
            long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            Assertions.assertTrue((now - start < 5000L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNotSupportedCharacterEncoding() throws UnsupportedEncodingException {
        Request request = new Request(null, null);
        Assertions.assertThrows(UnsupportedEncodingException.class, () -> request.setCharacterEncoding("doesNotExist"));
    }

    @Test
    public void testGetterSafeFromNullPointerException() {
        Request request = new Request(null, null);
        Assertions.assertNull((Object)request.getAuthType());
        Assertions.assertNull((Object)request.getAuthentication());
        Assertions.assertNull((Object)request.getContentType());
        Assertions.assertNull((Object)request.getCookies());
        Assertions.assertNull((Object)request.getContext());
        Assertions.assertNull((Object)request.getContextPath());
        Assertions.assertNull((Object)request.getHttpFields());
        Assertions.assertNull((Object)request.getHttpURI());
        Assertions.assertNotNull((Object)request.getScheme());
        Assertions.assertNotNull((Object)request.getServerName());
        Assertions.assertNotNull((Object)request.getServerPort());
        Assertions.assertNotNull((Object)request.getAttributeNames());
        Assertions.assertFalse((boolean)request.getAttributeNames().hasMoreElements());
        request.getParameterMap();
        Assertions.assertNull((Object)request.getQueryString());
        Assertions.assertNotNull((Object)request.getQueryParameters());
        Assertions.assertEquals((int)0, (int)request.getQueryParameters().size());
        Assertions.assertNotNull((Object)request.getParameterMap());
        Assertions.assertEquals((int)0, (int)request.getParameterMap().size());
    }

    @Test
    public void testPushBuilder() throws Exception {
        String uri = "/foo/something";
        TestRequest request = new TestRequest(null, null);
        request.getResponse().getHttpFields().add((HttpField)new HttpCookie.SetCookieHttpField(new HttpCookie("good", "thumbsup", 100L), CookieCompliance.RFC6265));
        request.getResponse().getHttpFields().add((HttpField)new HttpCookie.SetCookieHttpField(new HttpCookie("bonza", "bewdy", 1L), CookieCompliance.RFC6265));
        request.getResponse().getHttpFields().add((HttpField)new HttpCookie.SetCookieHttpField(new HttpCookie("bad", "thumbsdown", 0L), CookieCompliance.RFC6265));
        HttpFields.Mutable fields = HttpFields.build();
        fields.add(HttpHeader.AUTHORIZATION, "Basic foo");
        request.setMetaData(new MetaData.Request("GET", (HttpURI)HttpURI.from((String)uri), HttpVersion.HTTP_1_0, (HttpFields)fields));
        Assertions.assertTrue((boolean)request.isPushSupported());
        PushBuilder builder = request.newPushBuilder();
        Assertions.assertNotNull((Object)builder);
        Assertions.assertEquals((Object)"GET", (Object)builder.getMethod());
        Assertions.assertThrows(NullPointerException.class, () -> builder.method(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.method(""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.method("   "));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.method("POST"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.method("PUT"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.method("DELETE"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.method("CONNECT"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.method("OPTIONS"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.method("TRACE"));
        Assertions.assertEquals((Object)"abc123", (Object)builder.getSessionId());
        builder.path("/foo/something-else.txt");
        Assertions.assertEquals((Object)"/foo/something-else.txt", (Object)builder.getPath());
        Assertions.assertEquals((Object)"Basic foo", (Object)builder.getHeader("Authorization"));
        MatcherAssert.assertThat((Object)builder.getHeader("Cookie"), (Matcher)Matchers.containsString((String)"bonza"));
        MatcherAssert.assertThat((Object)builder.getHeader("Cookie"), (Matcher)Matchers.containsString((String)"good"));
        MatcherAssert.assertThat((Object)builder.getHeader("Cookie"), (Matcher)Matchers.containsString((String)"maxpos"));
        MatcherAssert.assertThat((Object)builder.getHeader("Cookie"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"bad")));
    }

    @Test
    public void testPushBuilderWithIdNoAuth() throws Exception {
        String uri = "/foo/something";
        TestRequest request = new TestRequest(null, null){

            @Override
            public Principal getUserPrincipal() {
                return () -> "test";
            }
        };
        HttpFields.Mutable fields = HttpFields.build();
        request.setMetaData(new MetaData.Request("GET", (HttpURI)HttpURI.from((String)uri), HttpVersion.HTTP_1_0, (HttpFields)fields));
        Assertions.assertTrue((boolean)request.isPushSupported());
        PushBuilder builder = request.newPushBuilder();
        Assertions.assertNotNull((Object)builder);
    }

    @Test
    public void testServletPathMapping() throws Exception {
        ServletPathSpec spec = null;
        String uri = null;
        ServletPathMapping m = new ServletPathMapping(spec, null, uri);
        MatcherAssert.assertThat((Object)m.getMappingMatch(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)m.getMatchValue(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)m.getPattern(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)m.getServletName(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)m.getServletPath(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)m.getPathInfo(), (Matcher)Matchers.nullValue());
        spec = new ServletPathSpec("");
        uri = "/";
        m = new ServletPathMapping((PathSpec)spec, "Something", uri);
        MatcherAssert.assertThat((Object)m.getMappingMatch(), (Matcher)Matchers.is((Object)MappingMatch.CONTEXT_ROOT));
        MatcherAssert.assertThat((Object)m.getMatchValue(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)m.getPattern(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)m.getServletName(), (Matcher)Matchers.is((Object)"Something"));
        MatcherAssert.assertThat((Object)m.getServletPath(), (Matcher)Matchers.is((Object)spec.getPathMatch(uri)));
        MatcherAssert.assertThat((Object)m.getPathInfo(), (Matcher)Matchers.is((Object)spec.getPathInfo(uri)));
        spec = new ServletPathSpec("/");
        uri = "/some/path";
        m = new ServletPathMapping((PathSpec)spec, "Default", uri);
        MatcherAssert.assertThat((Object)m.getMappingMatch(), (Matcher)Matchers.is((Object)MappingMatch.DEFAULT));
        MatcherAssert.assertThat((Object)m.getMatchValue(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)m.getPattern(), (Matcher)Matchers.is((Object)"/"));
        MatcherAssert.assertThat((Object)m.getServletName(), (Matcher)Matchers.is((Object)"Default"));
        MatcherAssert.assertThat((Object)m.getServletPath(), (Matcher)Matchers.is((Object)spec.getPathMatch(uri)));
        MatcherAssert.assertThat((Object)m.getPathInfo(), (Matcher)Matchers.is((Object)spec.getPathInfo(uri)));
        spec = new ServletPathSpec("/foo/*");
        uri = "/foo/bar";
        m = new ServletPathMapping((PathSpec)spec, "FooServlet", uri);
        MatcherAssert.assertThat((Object)m.getMappingMatch(), (Matcher)Matchers.is((Object)MappingMatch.PATH));
        MatcherAssert.assertThat((Object)m.getMatchValue(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)m.getPattern(), (Matcher)Matchers.is((Object)"/foo/*"));
        MatcherAssert.assertThat((Object)m.getServletName(), (Matcher)Matchers.is((Object)"FooServlet"));
        MatcherAssert.assertThat((Object)m.getServletPath(), (Matcher)Matchers.is((Object)spec.getPathMatch(uri)));
        MatcherAssert.assertThat((Object)m.getPathInfo(), (Matcher)Matchers.is((Object)spec.getPathInfo(uri)));
        uri = "/foo/";
        m = new ServletPathMapping((PathSpec)spec, "FooServlet", uri);
        MatcherAssert.assertThat((Object)m.getMappingMatch(), (Matcher)Matchers.is((Object)MappingMatch.PATH));
        MatcherAssert.assertThat((Object)m.getMatchValue(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)m.getPattern(), (Matcher)Matchers.is((Object)"/foo/*"));
        MatcherAssert.assertThat((Object)m.getServletName(), (Matcher)Matchers.is((Object)"FooServlet"));
        MatcherAssert.assertThat((Object)m.getServletPath(), (Matcher)Matchers.is((Object)spec.getPathMatch(uri)));
        MatcherAssert.assertThat((Object)m.getPathInfo(), (Matcher)Matchers.is((Object)spec.getPathInfo(uri)));
        uri = "/foo";
        m = new ServletPathMapping((PathSpec)spec, "FooServlet", uri);
        MatcherAssert.assertThat((Object)m.getMappingMatch(), (Matcher)Matchers.is((Object)MappingMatch.PATH));
        MatcherAssert.assertThat((Object)m.getMatchValue(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)m.getPattern(), (Matcher)Matchers.is((Object)"/foo/*"));
        MatcherAssert.assertThat((Object)m.getServletName(), (Matcher)Matchers.is((Object)"FooServlet"));
        MatcherAssert.assertThat((Object)m.getServletPath(), (Matcher)Matchers.is((Object)spec.getPathMatch(uri)));
        MatcherAssert.assertThat((Object)m.getPathInfo(), (Matcher)Matchers.is((Object)spec.getPathInfo(uri)));
        spec = new ServletPathSpec("*.jsp");
        uri = "/foo/bar.jsp";
        m = new ServletPathMapping((PathSpec)spec, "JspServlet", uri);
        MatcherAssert.assertThat((Object)m.getMappingMatch(), (Matcher)Matchers.is((Object)MappingMatch.EXTENSION));
        MatcherAssert.assertThat((Object)m.getMatchValue(), (Matcher)Matchers.is((Object)"foo/bar"));
        MatcherAssert.assertThat((Object)m.getPattern(), (Matcher)Matchers.is((Object)"*.jsp"));
        MatcherAssert.assertThat((Object)m.getServletName(), (Matcher)Matchers.is((Object)"JspServlet"));
        MatcherAssert.assertThat((Object)m.getServletPath(), (Matcher)Matchers.is((Object)spec.getPathMatch(uri)));
        MatcherAssert.assertThat((Object)m.getPathInfo(), (Matcher)Matchers.is((Object)spec.getPathInfo(uri)));
        spec = new ServletPathSpec("/catalog");
        uri = "/catalog";
        m = new ServletPathMapping((PathSpec)spec, "CatalogServlet", uri);
        MatcherAssert.assertThat((Object)m.getMappingMatch(), (Matcher)Matchers.is((Object)MappingMatch.EXACT));
        MatcherAssert.assertThat((Object)m.getMatchValue(), (Matcher)Matchers.is((Object)"catalog"));
        MatcherAssert.assertThat((Object)m.getPattern(), (Matcher)Matchers.is((Object)"/catalog"));
        MatcherAssert.assertThat((Object)m.getServletName(), (Matcher)Matchers.is((Object)"CatalogServlet"));
        MatcherAssert.assertThat((Object)m.getServletPath(), (Matcher)Matchers.is((Object)spec.getPathMatch(uri)));
        MatcherAssert.assertThat((Object)m.getPathInfo(), (Matcher)Matchers.is((Object)spec.getPathInfo(uri)));
    }

    private static long getFileCount(Path path) {
        try {
            return Files.list(path).count();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get file list count: " + path, e);
        }
    }

    private class TestUserIdentityScope
    implements UserIdentity.Scope {
        private ContextHandler _handler;
        private String _contextPath;
        private String _name;

        public TestUserIdentityScope(ContextHandler handler, String contextPath, String name) {
            this._handler = handler;
            this._contextPath = contextPath;
            this._name = name;
        }

        public ContextHandler getContextHandler() {
            return this._handler;
        }

        public String getContextPath() {
            return this._contextPath;
        }

        public String getName() {
            return this._name;
        }

        public Map<String, String> getRoleRefMap() {
            return null;
        }
    }

    private class BadMultiPartRequestHandler
    extends AbstractHandler {
        final Path tmpDir;

        public BadMultiPartRequestHandler(Path tmpDir) {
            this.tmpDir = tmpDir;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ((Request)request).setHandled(true);
            if ("/cleanup".equals(target)) {
                response.setStatus(200);
                return;
            }
            try {
                MultipartConfigElement mpce = new MultipartConfigElement(this.tmpDir.toString(), -1L, -1L, 2);
                request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)mpce);
                request.getPart("xxx");
            }
            catch (RuntimeException e) {
                response.sendError(500);
            }
        }
    }

    private class MultiPartRequestHandler
    extends AbstractHandler {
        RequestTester checker;
        File tmpDir;

        public MultiPartRequestHandler(File tmpDir, RequestTester checker) {
            this.tmpDir = tmpDir;
            this.checker = checker;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ((Request)request).setHandled(true);
            if ("/cleanup".equals(target)) {
                response.setStatus(200);
                return;
            }
            try {
                MultipartConfigElement mpce = new MultipartConfigElement(this.tmpDir.getAbsolutePath(), -1L, -1L, 2);
                request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)mpce);
                String field1 = request.getParameter("field1");
                Assertions.assertNotNull((Object)field1);
                Part foo = request.getPart("stuff");
                Assertions.assertNotNull((Object)foo);
                Assertions.assertTrue((foo.getSize() > 0L ? 1 : 0) != 0);
                response.setStatus(200);
                List violations = (List)request.getAttribute("org.eclipse.jetty.http.compliance.violations");
                if (violations != null) {
                    for (String v : violations) {
                        response.addHeader("Violation", v);
                    }
                }
                if (this.checker != null && !this.checker.check(request, response)) {
                    response.sendError(500);
                }
            }
            catch (IllegalStateException e) {
                Assertions.assertTrue((boolean)e.getMessage().startsWith("No multipart config"));
                response.setStatus(200);
            }
            catch (Exception e) {
                response.sendError(500);
            }
        }
    }

    private class RequestHandler
    extends AbstractHandler {
        private RequestTester _checker;
        private String _content;

        private RequestHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ((Request)request).setHandled(true);
            if (request.getContentLength() > 0 && !request.getContentType().startsWith(MimeTypes.Type.FORM_ENCODED.asString()) && !request.getContentType().startsWith("multipart/form-data")) {
                this._content = IO.toString((InputStream)request.getInputStream());
            }
            if (this._checker != null && this._checker.check(request, response)) {
                response.setStatus(200);
            } else {
                response.sendError(500);
            }
        }
    }

    private class TestRequest
    extends Request {
        public static final String TEST_SESSION_ID = "abc123";
        Response _response;
        Cookie c1;
        Cookie c2;

        public TestRequest(HttpChannel channel, HttpInput input) {
            super(channel, input);
            this._response = new Response(null, null);
            this.c1 = new Cookie("maxpos", "xxx");
            this.c1.setMaxAge(1);
            this.c2 = new Cookie("maxneg", "yyy");
            this.c2.setMaxAge(-1);
        }

        public boolean isPushSupported() {
            return true;
        }

        public HttpSession getSession() {
            return new Session(new SessionHandler(), new SessionData(TEST_SESSION_ID, "", "0.0.0.0", 0L, 0L, 0L, 300L));
        }

        public Principal getUserPrincipal() {
            return new Principal(){

                @Override
                public String getName() {
                    return "user";
                }
            };
        }

        public Response getResponse() {
            return this._response;
        }

        public Cookie[] getCookies() {
            return new Cookie[]{this.c1, this.c2};
        }
    }

    static interface RequestTester {
        public boolean check(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
    }
}

