/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.ResourceHttpContent;
import org.eclipse.jetty.server.CachedContentFactory;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDir;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDirExtension;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkDirExtension.class})
public class ResourceCacheTest {
    public WorkDir workDir;

    public Path createUtilTestResources(Path basePath) throws IOException {
        this.makeFile(basePath.resolve("resource.txt"), "this is test data");
        Path one = basePath.resolve("one");
        FS.ensureDirExists((Path)one);
        this.makeFile(one.resolve("1.txt"), "1 - one");
        Path oneDir = one.resolve("dir");
        FS.ensureDirExists((Path)oneDir);
        this.makeFile(oneDir.resolve("1.txt"), "1 - one");
        Path two = basePath.resolve("two");
        FS.ensureDirExists((Path)two);
        this.makeFile(two.resolve("1.txt"), "1 - two");
        this.makeFile(two.resolve("2.txt"), "2 - two");
        Path twoDir = two.resolve("dir");
        FS.ensureDirExists((Path)twoDir);
        this.makeFile(twoDir.resolve("2.txt"), "2 - two");
        Path three = basePath.resolve("three");
        FS.ensureDirExists((Path)three);
        this.makeFile(three.resolve("2.txt"), "2 - three");
        this.makeFile(three.resolve("3.txt"), "3 - three");
        Path threeDir = three.resolve("dir");
        FS.ensureDirExists((Path)threeDir);
        this.makeFile(threeDir.resolve("3.txt"), "3 - three");
        Path four = basePath.resolve("four");
        FS.ensureDirExists((Path)four);
        this.makeFile(four.resolve("four"), "4 - four (no extension)");
        this.makeFile(four.resolve("four.txt"), "4 - four");
        return basePath;
    }

    private void makeFile(Path file, String contents) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);){
            writer.write(contents);
            writer.flush();
        }
    }

    @Test
    public void testMultipleSources1() throws Exception {
        Path basePath = this.createUtilTestResources(this.workDir.getEmptyPathDir());
        ResourceCollection rc = new ResourceCollection(new Resource[]{new PathResource(basePath.resolve("one")), new PathResource(basePath.resolve("two")), new PathResource(basePath.resolve("three"))});
        List r = rc.getResources();
        MimeTypes mime = new MimeTypes();
        CachedContentFactory rc3 = new CachedContentFactory(null, (ResourceFactory)r.get(2), mime, false, false, CompressedContentFormat.NONE);
        CachedContentFactory rc2 = new CachedContentFactory(rc3, (ResourceFactory)r.get(1), mime, false, false, CompressedContentFormat.NONE);
        CachedContentFactory rc1 = new CachedContentFactory(rc2, (ResourceFactory)r.get(0), mime, false, false, CompressedContentFormat.NONE);
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc1, "1.txt"), (Object)"1 - one");
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc1, "2.txt"), (Object)"2 - two");
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc1, "3.txt"), (Object)"3 - three");
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc2, "1.txt"), (Object)"1 - two");
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc2, "2.txt"), (Object)"2 - two");
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc2, "3.txt"), (Object)"3 - three");
        Assertions.assertEquals(null, (Object)ResourceCacheTest.getContent(rc3, "1.txt"));
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc3, "2.txt"), (Object)"2 - three");
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc3, "3.txt"), (Object)"3 - three");
    }

    @Test
    public void testUncacheable() throws Exception {
        Path basePath = this.createUtilTestResources(this.workDir.getEmptyPathDir());
        ResourceCollection rc = new ResourceCollection(new Resource[]{new PathResource(basePath.resolve("one")), new PathResource(basePath.resolve("two")), new PathResource(basePath.resolve("three"))});
        List r = rc.getResources();
        MimeTypes mime = new MimeTypes();
        CachedContentFactory rc3 = new CachedContentFactory(null, (ResourceFactory)r.get(2), mime, false, false, CompressedContentFormat.NONE);
        CachedContentFactory rc2 = new CachedContentFactory(rc3, (ResourceFactory)r.get(1), mime, false, false, CompressedContentFormat.NONE){

            public boolean isCacheable(Resource resource) {
                return super.isCacheable(resource) && resource.getName().indexOf("2.txt") < 0;
            }
        };
        CachedContentFactory rc1 = new CachedContentFactory(rc2, (ResourceFactory)r.get(0), mime, false, false, CompressedContentFormat.NONE);
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc1, "1.txt"), (Object)"1 - one");
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc1, "2.txt"), (Object)"2 - two");
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc1, "3.txt"), (Object)"3 - three");
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc2, "1.txt"), (Object)"1 - two");
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc2, "2.txt"), (Object)"2 - two");
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc2, "3.txt"), (Object)"3 - three");
        Assertions.assertEquals(null, (Object)ResourceCacheTest.getContent(rc3, "1.txt"));
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc3, "2.txt"), (Object)"2 - three");
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(rc3, "3.txt"), (Object)"3 - three");
    }

    @Test
    public void testResourceCache() throws Exception {
        File[] files = new File[10];
        String[] names = new String[files.length];
        Path basePath = this.workDir.getEmptyPathDir();
        for (int i = 0; i < files.length; ++i) {
            Path tmpFile = basePath.resolve("R-" + i + ".txt");
            try (BufferedWriter writer = Files.newBufferedWriter(tmpFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);){
                for (int j = 0; j < i * 10 - 1; ++j) {
                    writer.write(32);
                }
                writer.write(10);
            }
            files[i] = tmpFile.toFile();
            names[i] = tmpFile.getFileName().toString();
        }
        Resource directory = Resource.newResource((String)files[0].getParentFile().getAbsolutePath());
        CachedContentFactory cache = new CachedContentFactory(null, (ResourceFactory)directory, new MimeTypes(), false, false, CompressedContentFormat.NONE);
        cache.setMaxCacheSize(95);
        cache.setMaxCachedFileSize(85);
        cache.setMaxCachedFiles(4);
        Assertions.assertTrue((cache.getContent("does not exist", 4096) == null ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)(cache.getContent(names[9], 4096) instanceof ResourceHttpContent));
        Assertions.assertTrue((cache.getContent(names[9], 4096).getIndirectBuffer() != null ? 1 : 0) != 0);
        HttpContent content = cache.getContent(names[8], 4096);
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assertions.assertEquals((long)80L, (long)content.getContentLengthValue());
        Assertions.assertEquals((int)0, (int)cache.getCachedSize());
        if (OS.LINUX.isCurrentOs()) {
            content.getDirectBuffer();
            Assertions.assertEquals((int)80, (int)cache.getCachedSize());
            content.getIndirectBuffer();
            Assertions.assertEquals((int)0, (int)cache.getCachedSize());
            Assertions.assertEquals((int)0, (int)cache.getCachedFiles());
            cache = new CachedContentFactory(null, (ResourceFactory)directory, new MimeTypes(), true, false, CompressedContentFormat.NONE);
            cache.setMaxCacheSize(95);
            cache.setMaxCachedFileSize(85);
            cache.setMaxCachedFiles(4);
            content = cache.getContent(names[8], 4096);
            content.getDirectBuffer();
            Assertions.assertEquals((int)(cache.isUseFileMappedBuffer() ? 0 : 80), (int)cache.getCachedSize());
        }
        content.getIndirectBuffer();
        Assertions.assertEquals((int)80, (int)cache.getCachedSize());
        Assertions.assertEquals((int)1, (int)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.getContent(names[1], 4096);
        Assertions.assertEquals((int)80, (int)cache.getCachedSize());
        content.getIndirectBuffer();
        Assertions.assertEquals((int)90, (int)cache.getCachedSize());
        Assertions.assertEquals((int)2, (int)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.getContent(names[2], 4096);
        content.getIndirectBuffer();
        Assertions.assertEquals((int)30, (int)cache.getCachedSize());
        Assertions.assertEquals((int)2, (int)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.getContent(names[3], 4096);
        content.getIndirectBuffer();
        Assertions.assertEquals((int)60, (int)cache.getCachedSize());
        Assertions.assertEquals((int)3, (int)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.getContent(names[4], 4096);
        content.getIndirectBuffer();
        Assertions.assertEquals((int)90, (int)cache.getCachedSize());
        Assertions.assertEquals((int)3, (int)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.getContent(names[5], 4096);
        content.getIndirectBuffer();
        Assertions.assertEquals((int)90, (int)cache.getCachedSize());
        Assertions.assertEquals((int)2, (int)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.getContent(names[6], 4096);
        content.getIndirectBuffer();
        Assertions.assertEquals((int)60, (int)cache.getCachedSize());
        Assertions.assertEquals((int)1, (int)cache.getCachedFiles());
        Thread.sleep(200L);
        try (FileOutputStream out = new FileOutputStream(files[6]);){
            ((OutputStream)out).write(32);
        }
        content = cache.getContent(names[7], 4096);
        content.getIndirectBuffer();
        Assertions.assertEquals((int)70, (int)cache.getCachedSize());
        Assertions.assertEquals((int)1, (int)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.getContent(names[6], 4096);
        content.getIndirectBuffer();
        Assertions.assertEquals((int)71, (int)cache.getCachedSize());
        Assertions.assertEquals((int)2, (int)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.getContent(names[0], 4096);
        content.getIndirectBuffer();
        Assertions.assertEquals((int)72, (int)cache.getCachedSize());
        Assertions.assertEquals((int)3, (int)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.getContent(names[1], 4096);
        content.getIndirectBuffer();
        Assertions.assertEquals((int)82, (int)cache.getCachedSize());
        Assertions.assertEquals((int)4, (int)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.getContent(names[2], 4096);
        content.getIndirectBuffer();
        Assertions.assertEquals((int)32, (int)cache.getCachedSize());
        Assertions.assertEquals((int)4, (int)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.getContent(names[3], 4096);
        content.getIndirectBuffer();
        Assertions.assertEquals((int)61, (int)cache.getCachedSize());
        Assertions.assertEquals((int)4, (int)cache.getCachedFiles());
        Thread.sleep(200L);
        cache.flushCache();
        Assertions.assertEquals((int)0, (int)cache.getCachedSize());
        Assertions.assertEquals((int)0, (int)cache.getCachedFiles());
        cache.flushCache();
    }

    @Test
    public void testNoextension() throws Exception {
        Path basePath = this.createUtilTestResources(this.workDir.getEmptyPathDir());
        PathResource resource = new PathResource(basePath.resolve("four"));
        MimeTypes mime = new MimeTypes();
        CachedContentFactory cache = new CachedContentFactory(null, (ResourceFactory)resource, mime, false, false, CompressedContentFormat.NONE);
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(cache, "four.txt"), (Object)"4 - four");
        Assertions.assertEquals((Object)ResourceCacheTest.getContent(cache, "four"), (Object)"4 - four (no extension)");
    }

    static String getContent(CachedContentFactory rc, String path) throws Exception {
        HttpContent content = rc.getContent(path, rc.getMaxCachedFileSize());
        if (content == null) {
            return null;
        }
        return BufferUtil.toString((ByteBuffer)content.getIndirectBuffer());
    }
}

