/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.CharEncodingContextHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DumpHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.DefaultSessionCache;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.NullSessionDataStore;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionCache;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.TimerScheduler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ResponseTest {
    static final InetSocketAddress LOCALADDRESS;
    private Server _server;
    private HttpChannel _channel;
    private ByteBuffer _content = BufferUtil.allocate((int)16384);

    @BeforeEach
    public void init() throws Exception {
        BufferUtil.clear((ByteBuffer)this._content);
        this._server = new Server();
        TimerScheduler scheduler = new TimerScheduler();
        HttpConfiguration config = new HttpConfiguration();
        LocalConnector connector = new LocalConnector(this._server, null, (Scheduler)scheduler, null, 1, new ConnectionFactory[]{new HttpConnectionFactory(config)});
        this._server.addConnector((Connector)connector);
        this._server.setHandler((Handler)new DumpHandler());
        this._server.start();
        ByteArrayEndPoint endp = new ByteArrayEndPoint((Scheduler)scheduler, 5000L){

            public InetSocketAddress getLocalAddress() {
                return LOCALADDRESS;
            }
        };
        this._channel = new HttpChannel((Connector)connector, new HttpConfiguration(), (EndPoint)endp, new HttpTransport(){
            private Throwable _channelError;

            public void send(MetaData.Request request, MetaData.Response response, ByteBuffer content, boolean lastContent, Callback callback) {
                if (BufferUtil.hasContent((ByteBuffer)content)) {
                    BufferUtil.append((ByteBuffer)ResponseTest.this._content, (ByteBuffer)content);
                }
                if (this._channelError == null) {
                    callback.succeeded();
                } else {
                    callback.failed(this._channelError);
                }
            }

            public boolean isPushSupported() {
                return false;
            }

            public void push(MetaData.Request request) {
            }

            public void onCompleted() {
            }

            public void abort(Throwable failure) {
                this._channelError = failure;
            }
        });
    }

    @AfterEach
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testContentType() throws Exception {
        Response response = this.getResponse();
        Assertions.assertNull((Object)response.getContentType());
        response.setHeader("Content-Type", "text/something");
        Assertions.assertEquals((Object)"text/something", (Object)response.getContentType());
        response.setContentType("foo/bar");
        Assertions.assertEquals((Object)"foo/bar", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"foo/bar;charset=iso-8859-1", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assertions.assertEquals((Object)"foo2/bar2;charset=iso-8859-1", (Object)response.getContentType());
        response.setHeader("name", "foo");
        Iterator en = response.getHeaders("name").iterator();
        Assertions.assertEquals((Object)"foo", en.next());
        Assertions.assertFalse((boolean)en.hasNext());
        response.addHeader("name", "bar");
        en = response.getHeaders("name").iterator();
        Assertions.assertEquals((Object)"foo", en.next());
        Assertions.assertEquals((Object)"bar", en.next());
        Assertions.assertFalse((boolean)en.hasNext());
        response.recycle();
        response.setContentType("text/html");
        Assertions.assertEquals((Object)"text/html", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"text/html;charset=utf-8", (Object)response.getContentType());
        response.setContentType("foo2/bar2;charset=utf-8");
        Assertions.assertEquals((Object)"foo2/bar2;charset=utf-8", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/xml;charset=ISO-8859-7");
        response.getWriter();
        Assertions.assertEquals((Object)"text/xml;charset=ISO-8859-7", (Object)response.getContentType());
        response.setContentType("text/html;charset=UTF-8");
        Assertions.assertEquals((Object)"text/html;charset=ISO-8859-7", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/html;charset=US-ASCII");
        response.getWriter();
        Assertions.assertEquals((Object)"text/html;charset=US-ASCII", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/html; charset=UTF-8");
        response.getWriter();
        Assertions.assertEquals((Object)"text/html;charset=utf-8", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/json");
        response.getWriter();
        Assertions.assertEquals((Object)"text/json", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/json");
        response.setCharacterEncoding("UTF-8");
        response.getWriter();
        Assertions.assertEquals((Object)"text/json;charset=utf-8", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("xyz");
        response.setContentType("foo/bar");
        Assertions.assertEquals((Object)"foo/bar;charset=xyz", (Object)response.getContentType());
        response.recycle();
        response.setContentType("foo/bar");
        response.setCharacterEncoding("xyz");
        Assertions.assertEquals((Object)"foo/bar;charset=xyz", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("xyz");
        response.setContentType("foo/bar;charset=abc");
        Assertions.assertEquals((Object)"foo/bar;charset=abc", (Object)response.getContentType());
        response.recycle();
        response.setContentType("foo/bar;charset=abc");
        response.setCharacterEncoding("xyz");
        Assertions.assertEquals((Object)"foo/bar;charset=xyz", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("xyz");
        response.setContentType("foo/bar");
        response.setCharacterEncoding(null);
        Assertions.assertEquals((Object)"foo/bar", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("xyz");
        response.setCharacterEncoding(null);
        response.setContentType("foo/bar");
        Assertions.assertEquals((Object)"foo/bar", (Object)response.getContentType());
        response.recycle();
        response.addHeader("Content-Type", "text/something");
        Assertions.assertEquals((Object)"text/something", (Object)response.getContentType());
        response.recycle();
        response.addHeader("Content-Type", "application/json");
        response.getWriter();
        Assertions.assertEquals((Object)"application/json", (Object)response.getContentType());
    }

    @Test
    public void testInferredCharset() throws Exception {
        Response response = this.getResponse();
        Assertions.assertNull((Object)response.getContentType());
        response.setHeader("Content-Type", "application/xhtml+xml");
        Assertions.assertEquals((Object)"application/xhtml+xml", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"application/xhtml+xml;charset=utf-8", (Object)response.getContentType());
        Assertions.assertEquals((Object)"utf-8", (Object)response.getCharacterEncoding());
    }

    @Test
    public void testAssumedCharset() throws Exception {
        Response response = this.getResponse();
        Assertions.assertNull((Object)response.getContentType());
        response.setHeader("Content-Type", "text/json");
        Assertions.assertEquals((Object)"text/json", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"text/json", (Object)response.getContentType());
        Assertions.assertEquals((Object)"utf-8", (Object)response.getCharacterEncoding());
        response.recycle();
        Assertions.assertNull((Object)response.getContentType());
        response.setHeader("Content-Type", "application/vnd.api+json");
        Assertions.assertEquals((Object)"application/vnd.api+json", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"application/vnd.api+json", (Object)response.getContentType());
        Assertions.assertEquals((Object)"utf-8", (Object)response.getCharacterEncoding());
    }

    @Test
    public void testStrangeContentType() throws Exception {
        Response response = this.getResponse();
        Assertions.assertNull((Object)response.getContentType());
        response.recycle();
        response.setContentType("text/html;charset=utf-8;charset=UTF-8");
        response.getWriter();
        Assertions.assertEquals((Object)"text/html;charset=utf-8;charset=UTF-8", (Object)response.getContentType());
        Assertions.assertEquals((Object)"utf-8", (Object)response.getCharacterEncoding().toLowerCase(Locale.ENGLISH));
    }

    @Test
    public void testLocale() {
        Response response = this.getResponse();
        ContextHandler context = new ContextHandler();
        context.addLocaleEncoding(Locale.ENGLISH.toString(), "ISO-8859-1");
        context.addLocaleEncoding(Locale.ITALIAN.toString(), "ISO-8859-2");
        response.getHttpChannel().getRequest().setContext(context.getServletContext(), "/");
        response.setLocale(Locale.ITALIAN);
        Assertions.assertNull((Object)response.getContentType());
        response.setContentType("text/plain");
        Assertions.assertEquals((Object)"text/plain;charset=ISO-8859-2", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/plain");
        response.setCharacterEncoding("utf-8");
        response.setLocale(Locale.ITALIAN);
        Assertions.assertEquals((Object)"text/plain;charset=utf-8", (Object)response.getContentType());
        Assertions.assertTrue((response.toString().indexOf("charset=utf-8") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLocaleFormat() throws Exception {
        Response response = this.getResponse();
        ContextHandler context = new ContextHandler();
        context.addLocaleEncoding(Locale.ENGLISH.toString(), "ISO-8859-1");
        context.addLocaleEncoding(Locale.ITALIAN.toString(), "ISO-8859-2");
        response.getHttpChannel().getRequest().setContext(context.getServletContext(), "/");
        response.setLocale(Locale.ITALIAN);
        PrintWriter out = response.getWriter();
        out.format("TestA1 %,.2f%n", 1234567.89);
        out.format("TestA2 %,.2f%n", 1234567.89);
        out.format((Locale)null, "TestB1 %,.2f%n", 1234567.89);
        out.format((Locale)null, "TestB2 %,.2f%n", 1234567.89);
        out.format(Locale.ENGLISH, "TestC1 %,.2f%n", 1234567.89);
        out.format(Locale.ENGLISH, "TestC2 %,.2f%n", 1234567.89);
        out.format(Locale.ITALIAN, "TestD1 %,.2f%n", 1234567.89);
        out.format(Locale.ITALIAN, "TestD2 %,.2f%n", 1234567.89);
        out.close();
        MatcherAssert.assertThat((Object)BufferUtil.toString((ByteBuffer)this._content), (Matcher)Matchers.containsString((String)"TestA1 1.234.567,89"));
        MatcherAssert.assertThat((Object)BufferUtil.toString((ByteBuffer)this._content), (Matcher)Matchers.containsString((String)"TestA2 1.234.567,89"));
        MatcherAssert.assertThat((Object)BufferUtil.toString((ByteBuffer)this._content), (Matcher)Matchers.containsString((String)"TestB1 1.234.567,89"));
        MatcherAssert.assertThat((Object)BufferUtil.toString((ByteBuffer)this._content), (Matcher)Matchers.containsString((String)"TestB2 1.234.567,89"));
        MatcherAssert.assertThat((Object)BufferUtil.toString((ByteBuffer)this._content), (Matcher)Matchers.containsString((String)"TestC1 1,234,567.89"));
        MatcherAssert.assertThat((Object)BufferUtil.toString((ByteBuffer)this._content), (Matcher)Matchers.containsString((String)"TestC2 1,234,567.89"));
        MatcherAssert.assertThat((Object)BufferUtil.toString((ByteBuffer)this._content), (Matcher)Matchers.containsString((String)"TestD1 1.234.567,89"));
        MatcherAssert.assertThat((Object)BufferUtil.toString((ByteBuffer)this._content), (Matcher)Matchers.containsString((String)"TestD2 1.234.567,89"));
    }

    @Test
    public void testResponseCharacterEncoding() throws Exception {
        this._server.stop();
        CharEncodingContextHandler handler = new CharEncodingContextHandler();
        this._server.setHandler((Handler)handler);
        handler.setDefaultResponseCharacterEncoding("utf-16");
        handler.setHandler((Handler)new DumpHandler());
        this._server.start();
        Response response = this.getResponse();
        response.getHttpChannel().getRequest().setContext(handler.getServletContext(), "/");
        MatcherAssert.assertThat((Object)"utf-16", (Matcher)Matchers.equalTo((Object)response.getCharacterEncoding()));
        this._channel.getRequest().setContext(null, "/");
        response.recycle();
        response = this.getResponse();
        this._channel.getRequest().setContext(handler.getServletContext(), "/");
        response.setCharacterEncoding("ascii");
        MatcherAssert.assertThat((Object)"ascii", (Matcher)Matchers.equalTo((Object)response.getCharacterEncoding()));
        response.getWriter();
        MatcherAssert.assertThat((Object)"ascii", (Matcher)Matchers.equalTo((Object)response.getCharacterEncoding()));
        this._channel.getRequest().setContext(null, "/");
        response.recycle();
        response = this.getResponse();
        this._channel.getRequest().setContext(handler.getServletContext(), "/");
        response.setContentType("application/json");
        MatcherAssert.assertThat((Object)"utf-8", (Matcher)Matchers.equalTo((Object)response.getCharacterEncoding()));
        response.getWriter();
        MatcherAssert.assertThat((Object)"utf-8", (Matcher)Matchers.equalTo((Object)response.getCharacterEncoding()));
        this._channel.getRequest().setContext(null, "/");
        response.recycle();
        response = this.getResponse();
        this._channel.getRequest().setContext(handler.getServletContext(), "/");
        response.setContentType("application/xhtml+xml");
        MatcherAssert.assertThat((Object)"utf-8", (Matcher)Matchers.equalTo((Object)response.getCharacterEncoding()));
        response.getWriter();
        MatcherAssert.assertThat((Object)"utf-8", (Matcher)Matchers.equalTo((Object)response.getCharacterEncoding()));
        this._channel.getRequest().setContext(null, "/");
        response.recycle();
        response = this.getResponse();
        MatcherAssert.assertThat((Object)"iso-8859-1", (Matcher)Matchers.equalTo((Object)response.getCharacterEncoding()));
        response.getWriter();
        MatcherAssert.assertThat((Object)"iso-8859-1", (Matcher)Matchers.equalTo((Object)response.getCharacterEncoding()));
    }

    @Test
    public void testLocaleAndContentTypeEncoding() throws Exception {
        this._server.stop();
        MimeTypes.getInferredEncodings().put("text/html", "iso-8859-1");
        ContextHandler handler = new ContextHandler();
        handler.addLocaleEncoding("ja", "euc-jp");
        handler.addLocaleEncoding("zh_CN", "gb18030");
        this._server.setHandler((Handler)handler);
        handler.setHandler((Handler)new DumpHandler());
        this._server.start();
        Response response = this.getResponse();
        response.getHttpChannel().getRequest().setContext(handler.getServletContext(), "/");
        response.setContentType("text/html");
        Assertions.assertEquals((Object)"iso-8859-1", (Object)response.getCharacterEncoding());
        response.setLocale(Locale.JAPAN);
        Assertions.assertEquals((Object)"euc-jp", (Object)response.getCharacterEncoding());
        response.setLocale(Locale.CHINA);
        Assertions.assertEquals((Object)"gb18030", (Object)response.getCharacterEncoding());
        response.setContentType("text/html");
        Assertions.assertEquals((Object)"gb18030", (Object)response.getCharacterEncoding());
        response.setCharacterEncoding("utf-8");
        Assertions.assertEquals((Object)"utf-8", (Object)response.getCharacterEncoding());
        response.setLocale(Locale.JAPAN);
        Assertions.assertEquals((Object)"utf-8", (Object)response.getCharacterEncoding());
        response.setContentType("text/html;charset=gb18030");
        Assertions.assertEquals((Object)"gb18030", (Object)response.getCharacterEncoding());
        response.setCharacterEncoding("utf-8");
        Assertions.assertEquals((Object)"utf-8", (Object)response.getCharacterEncoding());
        PrintWriter pw = response.getWriter();
        Assertions.assertEquals((Object)"utf-8", (Object)response.getCharacterEncoding());
        response.setCharacterEncoding("iso-8859-1");
        Assertions.assertEquals((Object)"utf-8", (Object)response.getCharacterEncoding());
        response.setLocale(Locale.JAPAN);
        Assertions.assertEquals((Object)"utf-8", (Object)response.getCharacterEncoding());
    }

    @Test
    public void testContentTypeCharacterEncoding() throws Exception {
        Response response = this.getResponse();
        response.setContentType("foo/bar");
        response.setCharacterEncoding("utf-8");
        Assertions.assertEquals((Object)"foo/bar;charset=utf-8", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"foo/bar;charset=utf-8", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assertions.assertEquals((Object)"foo2/bar2;charset=utf-8", (Object)response.getContentType());
        response.setCharacterEncoding("ISO-8859-1");
        Assertions.assertEquals((Object)"foo2/bar2;charset=utf-8", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        Assertions.assertEquals((Object)"text/html;charset=utf-8", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"text/html;charset=utf-8", (Object)response.getContentType());
        response.setContentType("text/xml");
        Assertions.assertEquals((Object)"text/xml;charset=utf-8", (Object)response.getContentType());
        response.setCharacterEncoding("ISO-8859-1");
        Assertions.assertEquals((Object)"text/xml;charset=utf-8", (Object)response.getContentType());
    }

    @Test
    public void testContentEncodingViaContentTypeChange() throws Exception {
        Response response = this.getResponse();
        response.setContentType("text/html;charset=Shift_Jis");
        Assertions.assertEquals((Object)"Shift_Jis", (Object)response.getCharacterEncoding());
        response.setContentType("text/xml");
        Assertions.assertEquals((Object)"Shift_Jis", (Object)response.getCharacterEncoding());
    }

    @Test
    public void testCharacterEncodingContentType() throws Exception {
        Response response = this.getResponse();
        response.setCharacterEncoding("utf-8");
        response.setContentType("foo/bar");
        Assertions.assertEquals((Object)"foo/bar;charset=utf-8", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"foo/bar;charset=utf-8", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assertions.assertEquals((Object)"foo2/bar2;charset=utf-8", (Object)response.getContentType());
        response.setCharacterEncoding("ISO-8859-1");
        Assertions.assertEquals((Object)"foo2/bar2;charset=utf-8", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html");
        Assertions.assertEquals((Object)"text/html;charset=utf-8", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"text/html;charset=utf-8", (Object)response.getContentType());
        response.setContentType("text/xml");
        Assertions.assertEquals((Object)"text/xml;charset=utf-8", (Object)response.getContentType());
        response.setCharacterEncoding("iso-8859-1");
        Assertions.assertEquals((Object)"text/xml;charset=utf-8", (Object)response.getContentType());
    }

    @Test
    public void testContentTypeWithCharacterEncoding() throws Exception {
        Response response = this.getResponse();
        response.setCharacterEncoding("utf16");
        response.setContentType("foo/bar; charset=UTF-8");
        Assertions.assertEquals((Object)"foo/bar; charset=UTF-8", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"foo/bar; charset=UTF-8", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assertions.assertEquals((Object)"foo2/bar2;charset=utf-8", (Object)response.getContentType());
        response.setCharacterEncoding("ISO-8859-1");
        Assertions.assertEquals((Object)"foo2/bar2;charset=utf-8", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("utf16");
        response.setContentType("text/html; charset=utf-8");
        Assertions.assertEquals((Object)"text/html;charset=utf-8", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"text/html;charset=utf-8", (Object)response.getContentType());
        response.setContentType("text/xml");
        Assertions.assertEquals((Object)"text/xml;charset=utf-8", (Object)response.getContentType());
        response.setCharacterEncoding("iso-8859-1");
        Assertions.assertEquals((Object)"text/xml;charset=utf-8", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("utf-16");
        response.setContentType("foo/bar");
        Assertions.assertEquals((Object)"foo/bar;charset=utf-16", (Object)response.getContentType());
        response.getOutputStream();
        response.setCharacterEncoding("utf-8");
        Assertions.assertEquals((Object)"foo/bar;charset=utf-8", (Object)response.getContentType());
        response.flushBuffer();
        response.setCharacterEncoding("utf-16");
        Assertions.assertEquals((Object)"foo/bar;charset=utf-8", (Object)response.getContentType());
    }

    @Test
    public void testResetWithNewSession() throws Exception {
        Response response = this.getResponse();
        Request request = response.getHttpChannel().getRequest();
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setServer(this._server);
        sessionHandler.setUsingCookies(true);
        sessionHandler.start();
        request.setSessionHandler(sessionHandler);
        HttpSession session = request.getSession(true);
        MatcherAssert.assertThat((Object)session, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assertions.assertTrue((boolean)session.isNew());
        HttpField setCookie = response.getHttpFields().getField(HttpHeader.SET_COOKIE);
        MatcherAssert.assertThat((Object)setCookie, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)setCookie.getValue(), (Matcher)Matchers.startsWith((String)"JSESSIONID"));
        MatcherAssert.assertThat((Object)setCookie.getValue(), (Matcher)Matchers.containsString((String)session.getId()));
        response.setHeader("Some", "Header");
        response.addCookie(new Cookie("Some", "Cookie"));
        response.getOutputStream().print("X");
        MatcherAssert.assertThat((Object)response.getHttpFields().size(), (Matcher)Matchers.is((Object)4));
        response.reset();
        setCookie = response.getHttpFields().getField(HttpHeader.SET_COOKIE);
        MatcherAssert.assertThat((Object)setCookie, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)setCookie.getValue(), (Matcher)Matchers.startsWith((String)"JSESSIONID"));
        MatcherAssert.assertThat((Object)setCookie.getValue(), (Matcher)Matchers.containsString((String)session.getId()));
        MatcherAssert.assertThat((Object)response.getHttpFields().size(), (Matcher)Matchers.is((Object)2));
        response.getWriter();
    }

    @Test
    public void testResetContentTypeWithoutCharacterEncoding() throws Exception {
        Response response = this.getResponse();
        response.setCharacterEncoding("utf-8");
        response.setContentType("wrong/answer");
        response.setContentType("foo/bar");
        Assertions.assertEquals((Object)"foo/bar;charset=utf-8", (Object)response.getContentType());
        response.getWriter();
        response.setContentType("foo2/bar2");
        Assertions.assertEquals((Object)"foo2/bar2;charset=utf-8", (Object)response.getContentType());
    }

    @Test
    public void testResetContentTypeWithCharacterEncoding() throws Exception {
        Response response = this.getResponse();
        response.setContentType("wrong/answer;charset=utf-8");
        response.setContentType("foo/bar");
        Assertions.assertEquals((Object)"foo/bar;charset=utf-8", (Object)response.getContentType());
        response.setContentType("wrong/answer;charset=utf-8");
        response.getWriter();
        response.setContentType("foo2/bar2;charset=utf-16");
        Assertions.assertEquals((Object)"foo2/bar2;charset=utf-8", (Object)response.getContentType());
    }

    @Test
    public void testPrintEmpty() throws Exception {
        Response response = this.getResponse();
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.print("ABC");
            outputStream.print("");
            outputStream.println();
            outputStream.flush();
        }
        String expected = "ABC\r\n";
        Assertions.assertEquals((Object)expected, (Object)BufferUtil.toString((ByteBuffer)this._content, (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testPrintln() throws Exception {
        Response response = this.getResponse();
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        Object expected = "";
        response.getOutputStream().print("ABC");
        expected = (String)expected + "ABC";
        response.getOutputStream().println("XYZ");
        expected = (String)expected + "XYZ\r\n";
        Object s = "";
        for (int i = 0; i < 100; ++i) {
            s = (String)s + "\u20ac\u20ac\u20ac\u20ac\u20ac\u20ac\u20ac\u20ac\u20ac\u20ac";
        }
        response.getOutputStream().println((String)s);
        expected = (String)expected + (String)s + "\r\n";
        response.getOutputStream().close();
        Assertions.assertEquals((Object)expected, (Object)BufferUtil.toString((ByteBuffer)this._content, (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testContentTypeWithOther() throws Exception {
        Response response = this.getResponse();
        response.setContentType("foo/bar; other=xyz");
        Assertions.assertEquals((Object)"foo/bar; other=xyz", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"foo/bar; other=xyz;charset=iso-8859-1", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assertions.assertEquals((Object)"foo2/bar2;charset=iso-8859-1", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("uTf-8");
        response.setContentType("text/html; other=xyz");
        Assertions.assertEquals((Object)"text/html; other=xyz;charset=utf-8", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"text/html; other=xyz;charset=utf-8", (Object)response.getContentType());
        response.setContentType("text/xml");
        Assertions.assertEquals((Object)"text/xml;charset=utf-8", (Object)response.getContentType());
    }

    @Test
    public void testContentTypeWithCharacterEncodingAndOther() throws Exception {
        Response response = this.getResponse();
        response.setCharacterEncoding("utf16");
        response.setContentType("foo/bar; charset=utf-8 other=xyz");
        Assertions.assertEquals((Object)"foo/bar; charset=utf-8 other=xyz", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"foo/bar; charset=utf-8 other=xyz", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("utf16");
        response.setContentType("text/html; other=xyz charset=utf-8");
        Assertions.assertEquals((Object)"text/html; other=xyz charset=utf-8;charset=utf-16", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"text/html; other=xyz charset=utf-8;charset=utf-16", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("utf16");
        response.setContentType("foo/bar; other=pq charset=utf-8 other=xyz");
        Assertions.assertEquals((Object)"foo/bar; other=pq charset=utf-8 other=xyz;charset=utf-16", (Object)response.getContentType());
        response.getWriter();
        Assertions.assertEquals((Object)"foo/bar; other=pq charset=utf-8 other=xyz;charset=utf-16", (Object)response.getContentType());
    }

    public static Stream<Object[]> sendErrorTestCodes() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{404, null, "Not Found"});
        data.add(new Object[]{500, "Database Error", "Database Error"});
        data.add(new Object[]{406, "Super Nanny", "Super Nanny"});
        return data.stream();
    }

    @ParameterizedTest
    @MethodSource(value={"sendErrorTestCodes"})
    public void testStatusCodes(int code, String message, String expectedMessage) throws Exception {
        Response response = this.getResponse();
        MatcherAssert.assertThat((Object)response.getHttpChannel().getState().handling(), (Matcher)Matchers.is((Object)HttpChannelState.Action.DISPATCH));
        if (message == null) {
            response.sendError(code);
        } else {
            response.sendError(code, message);
        }
        Assertions.assertTrue((boolean)response.getHttpOutput().isClosed());
        Assertions.assertEquals((int)code, (int)response.getStatus());
        Assertions.assertEquals(null, (Object)response.getReason());
        response.setHeader("Should-Be-Ignored", "value");
        Assertions.assertFalse((boolean)response.getHttpFields().contains("Should-Be-Ignored"));
        Assertions.assertEquals((Object)expectedMessage, (Object)response.getHttpChannel().getRequest().getAttribute("jakarta.servlet.error.message"));
        MatcherAssert.assertThat((Object)response.getHttpChannel().getState().unhandle(), (Matcher)Matchers.is((Object)HttpChannelState.Action.SEND_ERROR));
        MatcherAssert.assertThat((Object)response.getHttpChannel().getState().unhandle(), (Matcher)Matchers.is((Object)HttpChannelState.Action.COMPLETE));
    }

    @ParameterizedTest
    @MethodSource(value={"sendErrorTestCodes"})
    public void testStatusCodesNoErrorHandler(int code, String message, String expectedMessage) throws Exception {
        this._server.removeBean(this._server.getBean(ErrorHandler.class));
        this.testStatusCodes(code, message, expectedMessage);
    }

    @Test
    public void testWriteCheckError() throws Exception {
        Response response = this.getResponse();
        PrintWriter writer = response.getWriter();
        writer.println("test");
        writer.flush();
        Assertions.assertFalse((boolean)writer.checkError());
        IOException cause = new IOException("problem at mill");
        this._channel.abort((Throwable)cause);
        writer.println("test");
        Assertions.assertTrue((boolean)writer.checkError());
        writer.println("test");
        Assertions.assertTrue((boolean)writer.checkError());
    }

    @Test
    public void testEncodeRedirect() {
        ContextHandler context = new ContextHandler("/path");
        Response response = this.getResponse();
        Request request = response.getHttpChannel().getRequest();
        request.setHttpURI((HttpURI)HttpURI.build((HttpURI)request.getHttpURI()).host("myhost").port(8888));
        request.setContext(context.getServletContext(), "/info");
        Assertions.assertEquals((Object)"http://myhost:8888/path/info;param?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/path/info;param?query=0&more=1#target"));
        request.setRequestedSessionId("12345");
        request.setRequestedSessionIdFromCookie(false);
        SessionHandler handler = new SessionHandler();
        DefaultSessionCache ss = new DefaultSessionCache(handler);
        NullSessionDataStore ds = new NullSessionDataStore();
        ss.setSessionDataStore((SessionDataStore)ds);
        DefaultSessionIdManager idMgr = new DefaultSessionIdManager(this._server);
        idMgr.setWorkerName(null);
        handler.setSessionIdManager((SessionIdManager)idMgr);
        request.setSessionHandler(handler);
        TestSession tsession = new TestSession(handler, "12345");
        tsession.setExtendedId(handler.getSessionIdManager().getExtendedId("12345", null));
        request.setSession((HttpSession)tsession);
        handler.setCheckingRemoteSessionIdEncoding(false);
        Assertions.assertEquals((Object)"http://myhost:8888/path/info;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/path/info;param?query=0&more=1#target"));
        Assertions.assertEquals((Object)"http://other:8888/path/info;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://other:8888/path/info;param?query=0&more=1#target"));
        Assertions.assertEquals((Object)"http://myhost/path/info;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost/path/info;param?query=0&more=1#target"));
        Assertions.assertEquals((Object)"http://myhost:8888/other/info;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/other/info;param?query=0&more=1#target"));
        handler.setCheckingRemoteSessionIdEncoding(true);
        Assertions.assertEquals((Object)"http://myhost:8888/path/info;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/path/info;param?query=0&more=1#target"));
        Assertions.assertEquals((Object)"http://other:8888/path/info;param?query=0&more=1#target", (Object)response.encodeURL("http://other:8888/path/info;param?query=0&more=1#target"));
        Assertions.assertEquals((Object)"http://myhost/path/info;param?query=0&more=1#target", (Object)response.encodeURL("http://myhost/path/info;param?query=0&more=1#target"));
        Assertions.assertEquals((Object)"http://myhost:8888/other/info;param?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/other/info;param?query=0&more=1#target"));
        context = new ContextHandler("/");
        request.setContext(context.getServletContext(), "/");
        Assertions.assertEquals((Object)"http://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("http://myhost:8888"));
        Assertions.assertEquals((Object)"https://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("https://myhost:8888"));
        Assertions.assertEquals((Object)"mailto:/foo", (Object)response.encodeURL("mailto:/foo"));
        Assertions.assertEquals((Object)"http://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("http://myhost:8888/"));
        Assertions.assertEquals((Object)"http://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("http://myhost:8888/;jsessionid=7777"));
        Assertions.assertEquals((Object)"http://myhost:8888/;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/;param?query=0&more=1#target"));
        Assertions.assertEquals((Object)"http://other:8888/path/info;param?query=0&more=1#target", (Object)response.encodeURL("http://other:8888/path/info;param?query=0&more=1#target"));
        handler.setCheckingRemoteSessionIdEncoding(false);
        Assertions.assertEquals((Object)"/foo;jsessionid=12345", (Object)response.encodeURL("/foo"));
        Assertions.assertEquals((Object)"/;jsessionid=12345", (Object)response.encodeURL("/"));
        Assertions.assertEquals((Object)"/foo.html;jsessionid=12345#target", (Object)response.encodeURL("/foo.html#target"));
        Assertions.assertEquals((Object)";jsessionid=12345", (Object)response.encodeURL(""));
        request.setContext(null, "/");
        handler.setCheckingRemoteSessionIdEncoding(true);
        Assertions.assertEquals((Object)"http://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("http://myhost:8888"));
        Assertions.assertEquals((Object)"https://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("https://myhost:8888"));
        Assertions.assertEquals((Object)"mailto:/foo", (Object)response.encodeURL("mailto:/foo"));
        Assertions.assertEquals((Object)"http://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("http://myhost:8888/"));
        Assertions.assertEquals((Object)"http://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("http://myhost:8888/;jsessionid=7777"));
        Assertions.assertEquals((Object)"http://myhost:8888/;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/;param?query=0&more=1#target"));
        Assertions.assertEquals((Object)"http://other:8888/path/info;param?query=0&more=1#target", (Object)response.encodeURL("http://other:8888/path/info;param?query=0&more=1#target"));
        handler.setCheckingRemoteSessionIdEncoding(false);
        Assertions.assertEquals((Object)"/foo;jsessionid=12345", (Object)response.encodeURL("/foo"));
        Assertions.assertEquals((Object)"/;jsessionid=12345", (Object)response.encodeURL("/"));
        Assertions.assertEquals((Object)"/foo.html;jsessionid=12345#target", (Object)response.encodeURL("/foo.html#target"));
        Assertions.assertEquals((Object)";jsessionid=12345", (Object)response.encodeURL(""));
    }

    @Test
    public void testSendRedirect() throws Exception {
        String[][] tests = new String[][]{{"http://myhost:8888/other/location;jsessionid=12345?name=value", "http://myhost:8888/other/location;jsessionid=12345?name=value"}, {"/other/location;jsessionid=12345?name=value", "http://@HOST@@PORT@/other/location;jsessionid=12345?name=value"}, {"./location;jsessionid=12345?name=value", "http://@HOST@@PORT@/path/location;jsessionid=12345?name=value"}, {"/other/location", "http://@HOST@@PORT@/other/location"}, {"/other/l%20cation", "http://@HOST@@PORT@/other/l%20cation"}, {"location", "http://@HOST@@PORT@/path/location"}, {"./location", "http://@HOST@@PORT@/path/location"}, {"../location", "http://@HOST@@PORT@/location"}, {"/other/l%20cation", "http://@HOST@@PORT@/other/l%20cation"}, {"l%20cation", "http://@HOST@@PORT@/path/l%20cation"}, {"./l%20cation", "http://@HOST@@PORT@/path/l%20cation"}, {"../l%20cation", "http://@HOST@@PORT@/l%20cation"}, {"../locati%C3%abn", "http://@HOST@@PORT@/locati%C3%abn"}, {"../other%2fplace", "http://@HOST@@PORT@/other%2fplace"}, {"http://somehost.com/other/location", "http://somehost.com/other/location"}};
        ContextHandler context = new ContextHandler("/path");
        int[] ports = new int[]{8080, 80};
        String[] hosts = new String[]{null, "myhost", "192.168.0.1", "[0::1]"};
        for (int port : ports) {
            for (String host : hosts) {
                for (int i = 0; i < tests.length; ++i) {
                    Response response = this.getResponse();
                    Request request = response.getHttpChannel().getRequest();
                    HttpURI.Mutable uri = HttpURI.build((HttpURI)request.getHttpURI(), (String)"/path/info;param;jsessionid=12345?query=0&more=1#target");
                    uri.scheme("http");
                    if (host != null) {
                        uri.host(host).port(port);
                    }
                    request.setHttpURI((HttpURI)uri);
                    request.setContext(context.getServletContext(), "/info");
                    request.setRequestedSessionId("12345");
                    request.setRequestedSessionIdFromCookie(i > 2);
                    SessionHandler handler = new SessionHandler();
                    NullSessionDataStore ds = new NullSessionDataStore();
                    DefaultSessionCache ss = new DefaultSessionCache(handler);
                    handler.setSessionCache((SessionCache)ss);
                    ss.setSessionDataStore((SessionDataStore)ds);
                    DefaultSessionIdManager idMgr = new DefaultSessionIdManager(this._server);
                    idMgr.setWorkerName(null);
                    handler.setSessionIdManager((SessionIdManager)idMgr);
                    request.setSessionHandler(handler);
                    request.setSession((HttpSession)new TestSession(handler, "12345"));
                    handler.setCheckingRemoteSessionIdEncoding(false);
                    response.sendRedirect(tests[i][0]);
                    String location = response.getHeader("Location");
                    String expected = tests[i][1].replace("@HOST@", host == null ? request.getLocalAddr() : host).replace("@PORT@", (CharSequence)(host == null ? ":8888" : (port == 80 ? "" : ":" + port)));
                    Assertions.assertEquals((Object)expected, (Object)location, (String)("test-" + i + " " + host + ":" + port));
                    request.setContext(null, "/info");
                }
            }
        }
    }

    @Test
    public void testSendRedirectRelative() throws Exception {
        String[][] tests = new String[][]{{"http://myhost:8888/other/location;jsessionid=12345?name=value", "http://myhost:8888/other/location;jsessionid=12345?name=value"}, {"/other/location;jsessionid=12345?name=value", "/other/location;jsessionid=12345?name=value"}, {"./location;jsessionid=12345?name=value", "/path/location;jsessionid=12345?name=value"}, {"/other/location", "/other/location"}, {"/other/l%20cation", "/other/l%20cation"}, {"location", "/path/location"}, {"./location", "/path/location"}, {"../location", "/location"}, {"/other/l%20cation", "/other/l%20cation"}, {"l%20cation", "/path/l%20cation"}, {"./l%20cation", "/path/l%20cation"}, {"../l%20cation", "/l%20cation"}, {"../locati%C3%abn", "/locati%C3%abn"}, {"../other%2fplace", "/other%2fplace"}, {"http://somehost.com/other/location", "http://somehost.com/other/location"}};
        int[] ports = new int[]{8080, 80};
        String[] hosts = new String[]{null, "myhost", "192.168.0.1", "[0::1]"};
        for (int port : ports) {
            for (String host : hosts) {
                for (int i = 0; i < tests.length; ++i) {
                    Response response = this.getResponse();
                    Request request = response.getHttpChannel().getRequest();
                    request.getHttpChannel().getHttpConfiguration().setRelativeRedirectAllowed(true);
                    HttpURI.Mutable uri = HttpURI.build((HttpURI)request.getHttpURI());
                    uri.scheme("http");
                    if (host != null) {
                        uri.authority(host, port);
                    }
                    uri.pathQuery("/path/info;param;jsessionid=12345?query=0&more=1#target");
                    request.setHttpURI((HttpURI)uri);
                    request.setContext(null, "/path");
                    request.setRequestedSessionId("12345");
                    request.setRequestedSessionIdFromCookie(i > 2);
                    SessionHandler handler = new SessionHandler();
                    NullSessionDataStore ds = new NullSessionDataStore();
                    DefaultSessionCache ss = new DefaultSessionCache(handler);
                    handler.setSessionCache((SessionCache)ss);
                    ss.setSessionDataStore((SessionDataStore)ds);
                    DefaultSessionIdManager idMgr = new DefaultSessionIdManager(this._server);
                    idMgr.setWorkerName(null);
                    handler.setSessionIdManager((SessionIdManager)idMgr);
                    request.setSessionHandler(handler);
                    request.setSession((HttpSession)new TestSession(handler, "12345"));
                    handler.setCheckingRemoteSessionIdEncoding(false);
                    response.sendRedirect(tests[i][0]);
                    String location = response.getHeader("Location");
                    String expected = tests[i][1].replace("@HOST@", host == null ? request.getLocalAddr() : host).replace("@PORT@", (CharSequence)(host == null ? ":8888" : (port == 80 ? "" : ":" + port)));
                    Assertions.assertEquals((Object)expected, (Object)location, (String)("test-" + i + " " + host + ":" + port));
                }
            }
        }
    }

    @Test
    public void testInvalidSendRedirect() {
        Response response = this.getResponse();
        Assertions.assertThrows(IllegalStateException.class, () -> response.sendRedirect("../../../invalid"));
    }

    @Test
    public void testSetBufferSizeAfterHavingWrittenContent() throws Exception {
        Response response = this.getResponse();
        response.setBufferSize(20480);
        response.getWriter().print("hello");
        Assertions.assertThrows(IllegalStateException.class, () -> response.setBufferSize(21504));
    }

    @Test
    public void testZeroContent() throws Exception {
        Response response = this.getResponse();
        PrintWriter writer = response.getWriter();
        response.setContentLength(0);
        Assertions.assertFalse((boolean)response.isCommitted());
        Assertions.assertFalse((boolean)writer.checkError());
        writer.print("");
        Assertions.assertTrue((boolean)response.isCommitted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHead() throws Exception {
        Server server = new Server(0);
        try {
            server.setHandler((Handler)new AbstractHandler(){

                public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                    response.setStatus(200);
                    response.setContentType("text/plain");
                    PrintWriter w = response.getWriter();
                    w.flush();
                    w.println("Geht");
                    w.flush();
                    w.println("Doch");
                    w.flush();
                    ((Request)request).setHandled(true);
                }
            });
            server.start();
            try (Socket socket = new Socket("localhost", ((NetworkConnector)server.getConnectors()[0]).getLocalPort());){
                socket.setSoTimeout(500000);
                socket.getOutputStream().write("HEAD / HTTP/1.1\r\nHost: localhost\r\n\r\n".getBytes());
                socket.getOutputStream().write("GET / HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n".getBytes());
                socket.getOutputStream().flush();
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                String line = reader.readLine();
                MatcherAssert.assertThat((Object)line, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
                while (line != null && line.length() > 0) {
                    line = reader.readLine();
                }
                line = reader.readLine();
                MatcherAssert.assertThat((Object)line, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
                String last = null;
                while (line != null) {
                    last = line;
                    line = reader.readLine();
                }
                Assertions.assertEquals((Object)"Doch", (Object)last);
            }
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testAddCookie() {
        Response response = this.getResponse();
        Cookie cookie = new Cookie("name", "value");
        cookie.setDomain("domain");
        cookie.setPath("/path");
        cookie.setSecure(true);
        cookie.setComment("comment__HTTP_ONLY__");
        response.addCookie(cookie);
        String set = response.getHttpFields().get("Set-Cookie");
        Assertions.assertEquals((Object)"name=value; Path=/path; Domain=domain; Secure; HttpOnly", (Object)set);
    }

    @Test
    public void testAddCookieInInclude() throws Exception {
        Response response = this.getResponse();
        response.include();
        Cookie cookie = new Cookie("naughty", "value");
        cookie.setDomain("domain");
        cookie.setPath("/path");
        cookie.setSecure(true);
        cookie.setComment("comment__HTTP_ONLY__");
        response.addCookie(cookie);
        Assertions.assertNull((Object)response.getHttpFields().get("Set-Cookie"));
    }

    @Test
    public void testAddCookieSameSiteDefault() throws Exception {
        Response response = this.getResponse();
        TestServletContextHandler context = new TestServletContextHandler();
        this._channel.getRequest().setContext(context.getServletContext(), "/");
        context.setAttribute("org.eclipse.jetty.cookie.sameSiteDefault", HttpCookie.SameSite.STRICT);
        Cookie cookie = new Cookie("name", "value");
        cookie.setDomain("domain");
        cookie.setPath("/path");
        cookie.setSecure(true);
        cookie.setComment("comment__HTTP_ONLY__");
        response.addCookie(cookie);
        String set = response.getHttpFields().get("Set-Cookie");
        Assertions.assertEquals((Object)"name=value; Path=/path; Domain=domain; Secure; HttpOnly; SameSite=Strict", (Object)set);
        response.getHttpFields().remove("Set-Cookie");
        context.setAttribute("org.eclipse.jetty.cookie.sameSiteDefault", "FooBar");
        Assertions.assertThrows(IllegalStateException.class, () -> response.addCookie(cookie));
    }

    @Test
    public void testAddCookieComplianceRFC2965() {
        Response response = this.getResponse();
        response.getHttpChannel().getHttpConfiguration().setResponseCookieCompliance(CookieCompliance.RFC2965);
        Cookie cookie = new Cookie("name", "value");
        cookie.setDomain("domain");
        cookie.setPath("/path");
        cookie.setSecure(true);
        cookie.setComment("comment__HTTP_ONLY__");
        response.addCookie(cookie);
        String set = response.getHttpFields().get("Set-Cookie");
        Assertions.assertEquals((Object)"name=value;Version=1;Path=/path;Domain=domain;Secure;HttpOnly;Comment=comment", (Object)set);
    }

    @Test
    public void testAddCookieJavaxServletHttp() throws Exception {
        Response response = this.getResponse();
        Cookie cookie = new Cookie("foo", URLEncoder.encode("bar;baz", StandardCharsets.UTF_8.toString()));
        cookie.setPath("/secure");
        response.addCookie(cookie);
        String set = response.getHttpFields().get("Set-Cookie");
        Assertions.assertEquals((Object)"foo=bar%3Bbaz; Path=/secure", (Object)set);
    }

    @Test
    public void testAddCookieJavaNet() throws Exception {
        java.net.HttpCookie cookie = new java.net.HttpCookie("foo", URLEncoder.encode("bar;baz", StandardCharsets.UTF_8.toString()));
        cookie.setPath("/secure");
        Assertions.assertEquals((Object)"foo=\"bar%3Bbaz\";$Path=\"/secure\"", (Object)cookie.toString());
    }

    @Test
    public void testResetContent() throws Exception {
        Response response = this.getResponse();
        Cookie cookie = new Cookie("name", "value");
        cookie.setDomain("domain");
        cookie.setPath("/path");
        cookie.setSecure(true);
        cookie.setComment("comment__HTTP_ONLY__");
        response.addCookie(cookie);
        Cookie cookie2 = new Cookie("name2", "value2");
        cookie2.setDomain("domain");
        cookie2.setPath("/path");
        response.addCookie(cookie2);
        response.setContentType("some/type");
        response.setContentLength(3);
        response.setHeader(HttpHeader.EXPIRES, "never");
        response.setHeader("SomeHeader", "SomeValue");
        response.getOutputStream();
        response.resetContent();
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)response.getContentLength(), (Matcher)Matchers.is((Object)-1L));
        MatcherAssert.assertThat((Object)response.getHeader(HttpHeader.EXPIRES.asString()), (Matcher)Matchers.nullValue());
        response.getWriter();
        MatcherAssert.assertThat((Object)response.getHeader("SomeHeader"), (Matcher)Matchers.is((Object)"SomeValue"));
        Enumeration set = response.getHttpFields().getValues("Set-Cookie");
        Assertions.assertNotNull((Object)set);
        ArrayList list = Collections.list(set);
        MatcherAssert.assertThat(list, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"name=value; Path=/path; Domain=domain; Secure; HttpOnly", "name2=value2; Path=/path; Domain=domain"}));
        response.reset();
        set = response.getHttpFields().getValues("Set-Cookie");
        Assertions.assertFalse((boolean)set.hasMoreElements());
    }

    @Test
    public void testReplaceHttpCookie() {
        Response response = this.getResponse();
        response.replaceCookie(new HttpCookie("Foo", "123456"));
        response.replaceCookie(new HttpCookie("Foo", "123456", "A", "/path"));
        response.replaceCookie(new HttpCookie("Foo", "123456", "B", "/path"));
        response.replaceCookie(new HttpCookie("Bar", "123456"));
        response.replaceCookie(new HttpCookie("Bar", "123456", null, "/left"));
        response.replaceCookie(new HttpCookie("Bar", "123456", null, "/right"));
        response.replaceCookie(new HttpCookie("Bar", "value", null, "/right"));
        response.replaceCookie(new HttpCookie("Bar", "value", null, "/left"));
        response.replaceCookie(new HttpCookie("Bar", "value"));
        response.replaceCookie(new HttpCookie("Foo", "value", "B", "/path"));
        response.replaceCookie(new HttpCookie("Foo", "value", "A", "/path"));
        response.replaceCookie(new HttpCookie("Foo", "value"));
        Object[] expected = new String[]{"Foo=value", "Foo=value; Path=/path; Domain=A", "Foo=value; Path=/path; Domain=B", "Bar=value", "Bar=value; Path=/left", "Bar=value; Path=/right"};
        ArrayList actual = Collections.list(response.getHttpFields().getValues("Set-Cookie"));
        MatcherAssert.assertThat((String)"HttpCookie order", actual, (Matcher)Matchers.hasItems((Object[])expected));
    }

    @Test
    public void testReplaceHttpCookieSameSite() {
        Response response = this.getResponse();
        TestServletContextHandler context = new TestServletContextHandler();
        context.setAttribute("org.eclipse.jetty.cookie.sameSiteDefault", "LAX");
        this._channel.getRequest().setContext(context.getServletContext(), "/");
        response.replaceCookie(new HttpCookie("Foo", "123456"));
        String set = response.getHttpFields().get("Set-Cookie");
        Assertions.assertEquals((Object)"Foo=123456; SameSite=Lax", (Object)set);
        response.replaceCookie(new HttpCookie("Foo", "other"));
        set = response.getHttpFields().get("Set-Cookie");
        Assertions.assertEquals((Object)"Foo=other; SameSite=Lax", (Object)set);
    }

    @Test
    public void testReplaceParsedHttpCookie() {
        Response response = this.getResponse();
        response.addHeader(HttpHeader.SET_COOKIE.asString(), "Foo=123456");
        response.replaceCookie(new HttpCookie("Foo", "value"));
        ArrayList actual = Collections.list(response.getHttpFields().getValues("Set-Cookie"));
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasItems((Object[])new String[]{"Foo=value"}));
        response.setHeader(HttpHeader.SET_COOKIE, "Foo=123456; domain=Bah; Path=/path");
        response.replaceCookie(new HttpCookie("Foo", "other"));
        actual = Collections.list(response.getHttpFields().getValues("Set-Cookie"));
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasItems((Object[])new String[]{"Foo=123456; domain=Bah; Path=/path", "Foo=other"}));
        response.replaceCookie(new HttpCookie("Foo", "replaced", "Bah", "/path"));
        actual = Collections.list(response.getHttpFields().getValues("Set-Cookie"));
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasItems((Object[])new String[]{"Foo=replaced; Path=/path; Domain=Bah", "Foo=other"}));
        response.setHeader(HttpHeader.SET_COOKIE, "Foo=123456; domain=Bah; Expires=Thu, 01-Jan-1970 00:00:00 GMT; Max-Age=0; Secure; HttpOnly; Path=/path");
        response.replaceCookie(new HttpCookie("Foo", "replaced", "Bah", "/path"));
        actual = Collections.list(response.getHttpFields().getValues("Set-Cookie"));
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasItems((Object[])new String[]{"Foo=replaced; Path=/path; Domain=Bah"}));
    }

    @Test
    public void testReplaceParsedHttpCookieSiteDefault() {
        Response response = this.getResponse();
        TestServletContextHandler context = new TestServletContextHandler();
        context.setAttribute("org.eclipse.jetty.cookie.sameSiteDefault", "LAX");
        this._channel.getRequest().setContext(context.getServletContext(), "/");
        response.addHeader(HttpHeader.SET_COOKIE.asString(), "Foo=123456");
        response.replaceCookie(new HttpCookie("Foo", "value"));
        String set = response.getHttpFields().get("Set-Cookie");
        Assertions.assertEquals((Object)"Foo=value; SameSite=Lax", (Object)set);
    }

    @Test
    public void testFlushAfterFullContent() throws Exception {
        Response response = this.getResponse();
        byte[] data = new byte[]{-54, -2};
        ServletOutputStream output = response.getOutputStream();
        response.setContentLength(data.length);
        output.write(data);
        output.flush();
    }

    private Response getResponse() {
        this._channel.recycle();
        this._channel.getRequest().setMetaData(new MetaData.Request("GET", (HttpURI)HttpURI.from((String)"/path/info"), HttpVersion.HTTP_1_0, HttpFields.EMPTY));
        BufferUtil.clear((ByteBuffer)this._content);
        return this._channel.getResponse();
    }

    static {
        InetAddress ip = null;
        try {
            ip = Inet4Address.getByName("127.0.0.42");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        finally {
            LOCALADDRESS = new InetSocketAddress(ip, 8888);
        }
    }

    private static class TestServletContextHandler
    extends ContextHandler {
        private TestServletContextHandler() {
        }

        private class Context
        extends ContextHandler.Context {
            private Map<String, Object> _attributes;

            private Context() {
                super((ContextHandler)TestServletContextHandler.this);
                this._attributes = new HashMap<String, Object>();
            }

            public Object getAttribute(String name) {
                return this._attributes.get(name);
            }

            public Enumeration<String> getAttributeNames() {
                return Collections.enumeration(this._attributes.keySet());
            }

            public void setAttribute(String name, Object object) {
                this._attributes.put(name, object);
            }

            public void removeAttribute(String name) {
                this._attributes.remove(name);
            }
        }
    }

    private static class TestSession
    extends Session {
        protected TestSession(SessionHandler handler, String id) {
            super(handler, new SessionData(id, "", "0.0.0.0", 0L, 0L, 0L, 300L));
        }
    }
}

