/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.BindException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ServerSocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.logging.StacklessLogging;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.OS;

public class ServerConnectorTest {
    private URI toServerURI(ServerConnector connector) throws URISyntaxException {
        String host = connector.getHost();
        if (host == null) {
            host = "localhost";
        }
        int port = connector.getLocalPort();
        return new URI(String.format("http://%s:%d/", host, port));
    }

    private String getResponse(URI uri) throws IOException {
        HttpURLConnection http = (HttpURLConnection)uri.toURL().openConnection();
        MatcherAssert.assertThat((String)"Valid Response Code", (Object)http.getResponseCode(), (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)200), (Matcher)Matchers.is((Object)404)));
        try (InputStream in = http.getInputStream();){
            String string = IO.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReuseAddressDefault() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.addConnector((Connector)connector);
        server.setHandler((Handler)new HandlerList(new Handler[]{new ReuseInfoHandler(), new DefaultHandler()}));
        try {
            server.start();
            URI uri = this.toServerURI(connector);
            String response = this.getResponse(uri);
            MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"connector.getReuseAddress() = true"));
            MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"connector._reuseAddress() = true"));
            if (!OS.WINDOWS.isCurrentOs()) {
                MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"socket.getReuseAddress() = true"));
            }
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReuseAddressTrue() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        connector.setReuseAddress(true);
        server.addConnector((Connector)connector);
        server.setHandler((Handler)new HandlerList(new Handler[]{new ReuseInfoHandler(), new DefaultHandler()}));
        try {
            server.start();
            URI uri = this.toServerURI(connector);
            String response = this.getResponse(uri);
            MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"connector.getReuseAddress() = true"));
            MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"connector._reuseAddress() = true"));
            if (!OS.WINDOWS.isCurrentOs()) {
                MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"socket.getReuseAddress() = true"));
            }
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReuseAddressFalse() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        connector.setReuseAddress(false);
        server.addConnector((Connector)connector);
        server.setHandler((Handler)new HandlerList(new Handler[]{new ReuseInfoHandler(), new DefaultHandler()}));
        try {
            server.start();
            URI uri = this.toServerURI(connector);
            String response = this.getResponse(uri);
            MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"connector.getReuseAddress() = false"));
            MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"connector._reuseAddress() = false"));
            if (!OS.WINDOWS.isCurrentOs()) {
                MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"socket.getReuseAddress() = false"));
            }
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testAddFirstConnectionFactory() {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        HttpConnectionFactory http = new HttpConnectionFactory();
        connector.addConnectionFactory((ConnectionFactory)http);
        ProxyConnectionFactory proxy = new ProxyConnectionFactory();
        connector.addFirstConnectionFactory((ConnectionFactory)proxy);
        Collection factories = connector.getConnectionFactories();
        Assertions.assertEquals((int)2, (int)factories.size());
        Assertions.assertSame((Object)proxy, factories.iterator().next());
        Assertions.assertEquals((int)2, (int)connector.getBeans(ConnectionFactory.class).size());
        Assertions.assertEquals((Object)proxy.getProtocol(), (Object)connector.getDefaultProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptionWhileAccepting() throws Exception {
        Server server = new Server();
        try (StacklessLogging ignored = new StacklessLogging(new Class[]{AbstractConnector.class});){
            final AtomicLong spins = new AtomicLong();
            ServerConnector connector = new ServerConnector(server, 1, 1){

                public void accept(int acceptorID) throws IOException {
                    spins.incrementAndGet();
                    throw new IOException("explicitly_thrown_by_test");
                }
            };
            server.addConnector((Connector)connector);
            server.start();
            Thread.sleep(1500L);
            MatcherAssert.assertThat((Object)spins.get(), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(5L)));
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testOpenWithServerSocketChannel() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        ServerSocketChannel channel = ServerSocketChannel.open();
        channel.bind(new InetSocketAddress(0));
        Assertions.assertTrue((boolean)channel.isOpen());
        int port = channel.socket().getLocalPort();
        MatcherAssert.assertThat((Object)port, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        connector.open(channel);
        MatcherAssert.assertThat((Object)connector.getLocalPort(), (Matcher)Matchers.is((Object)port));
        server.start();
        MatcherAssert.assertThat((Object)connector.getLocalPort(), (Matcher)Matchers.is((Object)port));
        MatcherAssert.assertThat((Object)connector.getTransport(), (Matcher)Matchers.is((Object)channel));
        server.stop();
        MatcherAssert.assertThat((Object)connector.getTransport(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testBindToAddressWhichIsInUse() throws Exception {
        try (ServerSocket socket = new ServerSocket(0);){
            int port = socket.getLocalPort();
            Server server = new Server();
            ServerConnector connector = new ServerConnector(server);
            connector.setPort(port);
            server.addConnector((Connector)connector);
            server.setHandler((Handler)new HandlerList(new Handler[]{new DefaultHandler()}));
            IOException x = (IOException)Assertions.assertThrows(IOException.class, () -> ((Server)server).start());
            MatcherAssert.assertThat((Object)x.getCause(), (Matcher)Matchers.instanceOf(BindException.class));
            MatcherAssert.assertThat((Object)x.getMessage(), (Matcher)Matchers.containsString((String)("0.0.0.0:" + port)));
        }
    }

    public static class ReuseInfoHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.setContentType("text/plain");
            EndPoint endPoint = baseRequest.getHttpChannel().getEndPoint();
            MatcherAssert.assertThat((String)"Endpoint", (Object)endPoint, (Matcher)Matchers.instanceOf(SocketChannelEndPoint.class));
            SocketChannelEndPoint channelEndPoint = (SocketChannelEndPoint)endPoint;
            Socket socket = channelEndPoint.getChannel().socket();
            ServerConnector connector = (ServerConnector)baseRequest.getHttpChannel().getConnector();
            PrintWriter out = response.getWriter();
            out.printf("connector.getReuseAddress() = %b%n", connector.getReuseAddress());
            try {
                Field fld = connector.getClass().getDeclaredField("_reuseAddress");
                MatcherAssert.assertThat((String)"Field[_reuseAddress]", (Object)fld, (Matcher)Matchers.notNullValue());
                fld.setAccessible(true);
                Object val = fld.get(connector);
                out.printf("connector._reuseAddress() = %b%n", val);
            }
            catch (Throwable t) {
                t.printStackTrace(out);
            }
            out.printf("socket.getReuseAddress() = %b%n", socket.getReuseAddress());
            baseRequest.setHandled(true);
        }
    }
}

