/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.logging.StacklessLogging;
import org.eclipse.jetty.server.ConnectorTimeoutTest;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SuspendHandler;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServerConnectorTimeoutTest
extends ConnectorTimeoutTest {
    @BeforeEach
    public void init() throws Exception {
        ServerConnector connector = new ServerConnector(this._server, 1, 1);
        connector.setIdleTimeout(2000L);
        this.startServer(connector);
    }

    @Test
    public void testStartStopStart() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(10L), () -> {
            this._server.stop();
            this._server.start();
        });
    }

    @Test
    public void testIdleTimeoutAfterSuspend() throws Exception {
        this._server.stop();
        SuspendHandler handler = new SuspendHandler();
        SessionHandler session = new SessionHandler();
        session.setHandler((Handler)handler);
        this._server.setHandler((Handler)session);
        this._server.start();
        handler.setSuspendFor(100L);
        handler.setResumeAfter(25L);
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(10L), () -> {
            String process = this.process(null).toUpperCase(Locale.ENGLISH);
            MatcherAssert.assertThat((Object)process, (Matcher)Matchers.containsString((String)"RESUMED"));
        });
    }

    @Test
    public void testIdleTimeoutAfterTimeout() throws Exception {
        SuspendHandler handler = new SuspendHandler();
        this._server.stop();
        SessionHandler session = new SessionHandler();
        session.setHandler((Handler)handler);
        this._server.setHandler((Handler)session);
        this._server.start();
        handler.setSuspendFor(50L);
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(10L), () -> {
            String process = this.process(null).toUpperCase(Locale.ENGLISH);
            MatcherAssert.assertThat((Object)process, (Matcher)Matchers.containsString((String)"TIMEOUT"));
        });
    }

    @Test
    public void testIdleTimeoutAfterComplete() throws Exception {
        SuspendHandler handler = new SuspendHandler();
        this._server.stop();
        SessionHandler session = new SessionHandler();
        session.setHandler((Handler)handler);
        this._server.setHandler((Handler)session);
        this._server.start();
        handler.setSuspendFor(100L);
        handler.setCompleteAfter(25L);
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(10L), () -> {
            String process = this.process(null).toUpperCase(Locale.ENGLISH);
            MatcherAssert.assertThat((Object)process, (Matcher)Matchers.containsString((String)"COMPLETED"));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String process(String content) throws IOException, InterruptedException {
        ServerConnectorTimeoutTest serverConnectorTimeoutTest = this;
        synchronized (serverConnectorTimeoutTest) {
            Object request = "GET / HTTP/1.1\r\nHost: localhost\r\n";
            request = content == null ? (String)request + "\r\n" : (String)request + "Content-Length: " + content.length() + "\r\n\r\n" + content;
            return this.getResponse((String)request);
        }
    }

    private String getResponse(String request) throws IOException, InterruptedException {
        try (Socket socket = new Socket((String)null, this._connector.getLocalPort());){
            socket.setSoTimeout(20000);
            socket.getOutputStream().write(request.getBytes(StandardCharsets.UTF_8));
            InputStream inputStream = socket.getInputStream();
            long start = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            String response = IO.toString((InputStream)inputStream);
            long timeElapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - start;
            MatcherAssert.assertThat((Object)timeElapsed, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1900L)));
            String string = response;
            return string;
        }
    }

    @Test
    public void testHttpWriteIdleTimeout() throws Exception {
        this._httpConfiguration.setIdleTimeout(500L);
        this.configureServer((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                IO.copy((InputStream)request.getInputStream(), (OutputStream)response.getOutputStream());
            }
        });
        Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
        client.setSoTimeout(10000);
        Assertions.assertFalse((boolean)client.isClosed());
        OutputStream os = client.getOutputStream();
        InputStream is = client.getInputStream();
        StringBuilder response = new StringBuilder();
        CompletableFuture<Void> responseFuture = CompletableFuture.runAsync(() -> {
            try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                int c;
                while ((c = reader.read()) != -1) {
                    response.append((char)c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        CompletableFuture<Void> requestFuture = CompletableFuture.runAsync(() -> {
            try {
                os.write(("POST /echo HTTP/1.0\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\ncontent-type: text/plain; charset=utf-8\r\ncontent-length: 20\r\n\r\n").getBytes("utf-8"));
                os.flush();
                os.write("123456789\n".getBytes("utf-8"));
                os.flush();
                TimeUnit.SECONDS.sleep(1L);
                os.write("=========\n".getBytes("utf-8"));
                os.flush();
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        });
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{HttpChannel.class});){
            requestFuture.get(2L, TimeUnit.SECONDS);
            responseFuture.get(3L, TimeUnit.SECONDS);
            MatcherAssert.assertThat((Object)response.toString(), (Matcher)Matchers.containsString((String)" 500 "));
            MatcherAssert.assertThat((Object)response.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"=========")));
        }
    }
}

