/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServletRequestWrapperTest {
    private Server server;
    private LocalConnector connector;
    private RequestHandler handler;

    @BeforeEach
    public void init() throws Exception {
        this.server = new Server();
        this.connector = new LocalConnector(this.server, (ConnectionFactory)new HttpConnectionFactory());
        this.server.addConnector((Connector)this.connector);
        this.handler = new RequestHandler();
        this.server.setHandler((Handler)this.handler);
        this.server.start();
    }

    @Test
    public void testServletRequestWrapper() throws Exception {
        String request = "GET / HTTP/1.1\r\nHost: whatever\r\n\n";
        String response = this.connector.getResponse(request);
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"200"));
    }

    private class RequestHandler
    extends AbstractHandler {
        private RequestHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            RequestWrapper requestWrapper = new RequestWrapper((ServletRequest)request);
            AsyncContext context = request.startAsync((ServletRequest)requestWrapper, (ServletResponse)response);
            context.complete();
            baseRequest.setHandled(true);
        }
    }

    private class RequestWrapper
    extends ServletRequestWrapper {
        public RequestWrapper(ServletRequest request) {
            super(request);
        }
    }
}

