/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ServletWriterTest {
    private Server server;
    private ServerConnector connector;

    private void start(int aggregationSize, Handler handler) throws Exception {
        this.server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setOutputBufferSize(2 * aggregationSize);
        httpConfig.setOutputAggregationSize(2 * aggregationSize);
        this.connector = new ServerConnector(this.server, 1, 1, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        this.server.addConnector((Connector)this.connector);
        this.server.setHandler(handler);
        this.server.start();
    }

    @AfterEach
    public void dispose() throws Exception {
        this.server.stop();
    }

    @Test
    public void testTCPCongestedCloseDoesNotDeadlock() throws Exception {
        final char[] chars = new char[0x8000000];
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference serverThreadRef = new AtomicReference();
        this.start(chars.length, (Handler)new AbstractHandler(){

            public void handle(String target, Request jettyRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                serverThreadRef.set(Thread.currentThread());
                jettyRequest.setHandled(true);
                response.setContentType("text/plain; charset=utf-8");
                PrintWriter writer = response.getWriter();
                Arrays.fill(chars, '0');
                writer.write(chars);
                latch.countDown();
                writer.close();
            }
        });
        try (Socket socket = new Socket("localhost", this.connector.getLocalPort());){
            String request = "GET / HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
            OutputStream output = socket.getOutputStream();
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            Thread.sleep(1000L);
            socket.setSoTimeout(5000);
            InputStream input = socket.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            String line = reader.readLine();
            MatcherAssert.assertThat((Object)line, (Matcher)Matchers.containsString((String)" 200 "));
            while (line != null) {
                line = reader.readLine();
            }
        }
        catch (Throwable x) {
            Thread thread = (Thread)serverThreadRef.get();
            if (thread != null) {
                thread.interrupt();
            }
            throw x;
        }
    }
}

