/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled
@Tag(value="stress")
@DisabledOnOs(value={OS.MAC})
public class StressTest {
    private static final Logger LOG = LoggerFactory.getLogger(StressTest.class);
    private static QueuedThreadPool _threads;
    private static Server _server;
    private static ServerConnector _connector;
    private static final AtomicInteger _handled;
    private static final ConcurrentLinkedQueue[] _latencies;
    private volatile AtomicInteger[] _loops;
    private final Random _random = new Random();
    private static final String[] __tests;

    @BeforeAll
    public static void init() throws Exception {
        _threads = new QueuedThreadPool();
        _threads.setMaxThreads(200);
        _server = new Server((ThreadPool)_threads);
        _server.manage((Object)_threads);
        _connector = new ServerConnector(_server, null, null, null, 1, 1, new ConnectionFactory[]{new HttpConnectionFactory()});
        _connector.setAcceptQueueSize(5000);
        _connector.setIdleTimeout(30000L);
        _server.addConnector((Connector)_connector);
        TestHandler handler = new TestHandler();
        _server.setHandler((Handler)handler);
        _server.start();
    }

    @AfterAll
    public static void destroy() throws Exception {
        _server.stop();
        _server.join();
    }

    @BeforeEach
    public void reset() {
        _handled.set(0);
        for (ConcurrentLinkedQueue q : _latencies) {
            q.clear();
        }
    }

    @Test
    public void testMinNonPersistent() throws Throwable {
        this.doThreads(10, 10, false);
    }

    @Test
    public void testNonPersistent() throws Throwable {
        this.doThreads(20, 20, false);
        Thread.sleep(1000L);
        this.doThreads(200, 10, false);
        Thread.sleep(1000L);
        this.doThreads(200, 200, false);
    }

    @Test
    public void testMinPersistent() throws Throwable {
        this.doThreads(10, 10, true);
    }

    @Test
    public void testPersistent() throws Throwable {
        this.doThreads(40, 40, true);
        Thread.sleep(1000L);
        this.doThreads(200, 10, true);
        Thread.sleep(1000L);
        this.doThreads(200, 200, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doThreads(int threadCount, final int loops, final boolean persistent) throws Throwable {
        int i;
        final Throwable[] throwables = new Throwable[threadCount];
        Thread[] threads = new Thread[threadCount];
        try {
            int errors;
            int finished;
            int i2;
            for (i2 = 0; i2 < threadCount; ++i2) {
                final int id = i2;
                final String name = "T" + i2;
                Thread.sleep(this._random.nextInt(100));
                threads[i2] = new Thread(){

                    @Override
                    public void run() {
                        try {
                            StressTest.this.doLoops(id, name, loops, persistent);
                        }
                        catch (Throwable th) {
                            th.printStackTrace();
                            throwables[id] = th;
                        }
                    }
                };
            }
            this._loops = new AtomicInteger[threadCount];
            for (i2 = 0; i2 < threadCount; ++i2) {
                this._loops[i2] = new AtomicInteger(0);
                threads[i2].start();
            }
            String last = null;
            int same = 0;
            do {
                Thread.sleep(1000L);
                finished = 0;
                errors = 0;
                int min = loops;
                int max = 0;
                int total = 0;
                for (int i3 = 0; i3 < threadCount; ++i3) {
                    int l = this._loops[i3].get();
                    if (l < 0) {
                        ++errors;
                        total -= l;
                        continue;
                    }
                    if (l < min) {
                        min = l;
                    }
                    if (l > max) {
                        max = l;
                    }
                    total += l;
                    if (l != loops) continue;
                    ++finished;
                }
                String status = "min/ave/max/target=" + min + "/" + total / threadCount + "/" + max + "/" + loops + " errors/finished/loops=" + errors + "/" + finished + "/" + threadCount + " idle/threads=" + _threads.getIdleThreads() + "/" + _threads.getThreads();
                if (status.equals(last)) {
                    if (same++ > 5) {
                        System.err.println("STALLED!!!");
                        System.err.println(_server.getThreadPool().toString());
                        Thread.sleep(5000L);
                        System.exit(1);
                    }
                } else {
                    same = 0;
                }
                last = status;
                LOG.info(_server.getThreadPool().toString() + " " + status);
            } while (finished + errors != threadCount);
            for (Thread thread : threads) {
                thread.join();
            }
            for (Throwable throwable : throwables) {
                if (throwable == null) continue;
                throw throwable;
            }
            for (ConcurrentLinkedQueue latency : _latencies) {
                Assertions.assertEquals((int)_handled.get(), (int)latency.size());
            }
            int quantums = 48;
        }
        catch (Throwable throwable) {
            int i4;
            int quantums = 48;
            int[][] count = new int[_latencies.length][48];
            int[] length = new int[_latencies.length];
            int[] other = new int[_latencies.length];
            long total = 0L;
            for (i4 = 0; i4 < _latencies.length; ++i4) {
                ConcurrentLinkedQueue latencies = _latencies[i4];
                length[i4] = latencies.size();
                Iterator iterator = latencies.iterator();
                block18: while (iterator.hasNext()) {
                    long latency = (Long)iterator.next();
                    if (i4 == 4) {
                        total += latency;
                    }
                    for (int q = 0; q < 48; ++q) {
                        if (latency < (long)(q * 100) || latency >= (long)((q + 1) * 100)) continue;
                        int[] nArray = count[i4];
                        int n = q;
                        nArray[n] = nArray[n] + 1;
                        continue block18;
                    }
                    int n = i4;
                    other[n] = other[n] + 1;
                }
            }
            System.out.println("           stage:\tbind\twrite\trecv\tdispatch\twrote\ttotal");
            for (int q = 0; q < 48; ++q) {
                System.out.printf("%02d00<=l<%02d00", q, q + 1);
                for (int i5 = 0; i5 < _latencies.length; ++i5) {
                    System.out.print("\t" + count[i5][q]);
                }
                System.out.println();
            }
            System.out.print("other       ");
            for (i4 = 0; i4 < _latencies.length; ++i4) {
                System.out.print("\t" + other[i4]);
            }
            System.out.println();
            System.out.print("HANDLED     ");
            for (i4 = 0; i4 < _latencies.length; ++i4) {
                System.out.print("\t" + _handled.get());
            }
            System.out.println();
            System.out.print("TOTAL       ");
            for (i4 = 0; i4 < _latencies.length; ++i4) {
                System.out.print("\t" + length[i4]);
            }
            System.out.println();
            long ave = total / (long)_latencies[4].size();
            System.out.println("ave=" + ave);
            throw throwable;
        }
        int[][] count = new int[_latencies.length][48];
        int[] length = new int[_latencies.length];
        int[] other = new int[_latencies.length];
        long total = 0L;
        for (i = 0; i < _latencies.length; ++i) {
            ConcurrentLinkedQueue latencies = _latencies[i];
            length[i] = latencies.size();
            Iterator iterator = latencies.iterator();
            block10: while (iterator.hasNext()) {
                long latency = (Long)iterator.next();
                if (i == 4) {
                    total += latency;
                }
                for (int q = 0; q < 48; ++q) {
                    if (latency < (long)(q * 100) || latency >= (long)((q + 1) * 100)) continue;
                    int[] nArray = count[i];
                    int n = q;
                    nArray[n] = nArray[n] + 1;
                    continue block10;
                }
                int n = i;
                other[n] = other[n] + 1;
            }
        }
        System.out.println("           stage:\tbind\twrite\trecv\tdispatch\twrote\ttotal");
        for (int q = 0; q < 48; ++q) {
            System.out.printf("%02d00<=l<%02d00", q, q + 1);
            for (int i6 = 0; i6 < _latencies.length; ++i6) {
                System.out.print("\t" + count[i6][q]);
            }
            System.out.println();
        }
        System.out.print("other       ");
        for (i = 0; i < _latencies.length; ++i) {
            System.out.print("\t" + other[i]);
        }
        System.out.println();
        System.out.print("HANDLED     ");
        for (i = 0; i < _latencies.length; ++i) {
            System.out.print("\t" + _handled.get());
        }
        System.out.println();
        System.out.print("TOTAL       ");
        for (i = 0; i < _latencies.length; ++i) {
            System.out.print("\t" + length[i]);
        }
        System.out.println();
        long ave = total / (long)_latencies[4].size();
        System.out.println("ave=" + ave);
    }

    private void doLoops(int thread, String name, int loops, boolean persistent) throws Exception {
        try {
            for (int i = 0; i < loops; ++i) {
                this._loops[thread].set(i);
                this.doPaths(thread, name + "-" + i, persistent);
                Thread.sleep(1 + this._random.nextInt(20) * this._random.nextInt(20));
                Thread.sleep(20L);
            }
            this._loops[thread].set(loops);
        }
        catch (Exception e) {
            System.err.println(e);
            this._loops[thread].set(-this._loops[thread].get());
            throw e;
        }
    }

    private void doPaths(int thread, String name, boolean persistent) throws Exception {
        if (persistent) {
            long start = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            Socket socket = new Socket("localhost", _connector.getLocalPort());
            socket.setSoTimeout(30000);
            long connected = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            for (int i = 0; i < __tests.length; ++i) {
                String uri = __tests[i] + "/" + name + "/" + i;
                String close = i + 1 < __tests.length ? "" : "Connection: close\r\n";
                String request = "GET " + uri + " HTTP/1.1\r\nHost: localhost\r\nstart: " + start + "\r\n" + close + "\r\n";
                socket.getOutputStream().write(request.getBytes());
                socket.getOutputStream().flush();
                Thread.yield();
            }
            long written = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            String response = IO.toString((InputStream)socket.getInputStream());
            socket.close();
            long end = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            int bodies = this.count(response, "HTTP/1.1 200 OK");
            if (__tests.length != bodies) {
                System.err.println("responses=\n" + response + "\n---");
            }
            Assertions.assertEquals((int)__tests.length, (int)bodies, (String)name);
            long bind = connected - start;
            long flush = (written - connected) / (long)__tests.length;
            long read = (end - written) / (long)__tests.length;
            int offset = 0;
            for (int i = 0; i < __tests.length; ++i) {
                offset = response.indexOf("DATA " + __tests[i], offset);
                Assertions.assertTrue((offset >= 0 ? 1 : 0) != 0);
                offset += __tests[i].length() + 5;
                if (bind < 0L || flush < 0L || read < 0L) {
                    System.err.println(bind + "," + flush + "," + read);
                }
                _latencies[0].add(i == 0 ? bind : 0L);
                _latencies[1].add(i == 0 ? bind + flush : flush);
                _latencies[5].add(i == 0 ? bind + flush + read : flush + read);
            }
        } else {
            for (int i = 0; i < __tests.length; ++i) {
                String uri = __tests[i] + "/" + name + "/" + i;
                long start = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                String close = "Connection: close\r\n";
                String request = "GET " + uri + " HTTP/1.1\r\nHost: localhost\r\nstart: " + start + "\r\n" + close + "\r\n";
                Socket socket = new Socket("localhost", _connector.getLocalPort());
                socket.setSoTimeout(10000);
                _latencies[0].add(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - start);
                socket.getOutputStream().write(request.getBytes());
                socket.getOutputStream().flush();
                _latencies[1].add(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - start);
                String response = IO.toString((InputStream)socket.getInputStream());
                socket.close();
                long end = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                String endOfResponse = "\r\n\r\n";
                MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)endOfResponse));
                response = response.substring(response.indexOf(endOfResponse) + endOfResponse.length());
                MatcherAssert.assertThat((String)uri, (Object)response, (Matcher)Matchers.startsWith((String)("DATA " + __tests[i])));
                long latency = end - start;
                _latencies[5].add(latency);
            }
        }
    }

    private int count(String s, String sub) {
        int count = 0;
        int index = s.indexOf(sub);
        while (index >= 0) {
            ++count;
            index = s.indexOf(sub, index + sub.length());
        }
        return count;
    }

    static {
        _handled = new AtomicInteger(0);
        _latencies = new ConcurrentLinkedQueue[]{new ConcurrentLinkedQueue(), new ConcurrentLinkedQueue(), new ConcurrentLinkedQueue(), new ConcurrentLinkedQueue(), new ConcurrentLinkedQueue(), new ConcurrentLinkedQueue()};
        __tests = new String[]{"/path/0", "/path/1", "/path/2", "/path/3", "/path/4", "/path/5", "/path/6", "/path/7", "/path/8", "/path/9", "/path/a", "/path/b", "/path/c", "/path/d", "/path/e", "/path/f"};
    }

    private static class TestHandler
    extends HandlerWrapper {
        private TestHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            long start = Long.parseLong(baseRequest.getHeader("start"));
            long received = baseRequest.getTimeStamp();
            _handled.incrementAndGet();
            long delay = received - start;
            if (delay < 0L) {
                delay = 0L;
            }
            _latencies[2].add(delay);
            _latencies[3].add(now - start);
            response.setStatus(200);
            response.getOutputStream().print("DATA " + request.getPathInfo() + "\n\n");
            baseRequest.setHandled(true);
            _latencies[4].add(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - start);
        }
    }
}

