/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.LeakTrackingByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ThreadStarvationTest {
    static final int BUFFER_SIZE = 0x100000;
    static final int BUFFERS = 64;
    static final int THREADS = 5;
    static final int CLIENTS = 7;
    private QueuedThreadPool _threadPool;
    private Server _server;
    private ServerConnector _connector;

    public static Stream<Arguments> scenarios() {
        ArrayList<Scenario> params = new ArrayList<Scenario>();
        ConnectorProvider http = ServerConnector::new;
        ClientSocketProvider httpClient = Socket::new;
        params.add(new Scenario("http", http, httpClient));
        ConnectorProvider https = (server, acceptors, selectors) -> {
            Path keystorePath = MavenTestingUtils.getTestResourcePath((String)"keystore.p12");
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(keystorePath.toString());
            sslContextFactory.setKeyStorePassword("storepwd");
            LeakTrackingByteBufferPool pool = new LeakTrackingByteBufferPool((ByteBufferPool)new MappedByteBufferPool.Tagged());
            HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory();
            ServerConnector connector = new ServerConnector(server, null, null, (ByteBufferPool)pool, acceptors, selectors, AbstractConnectionFactory.getFactories((SslContextFactory.Server)sslContextFactory, (ConnectionFactory[])new ConnectionFactory[]{httpConnectionFactory}));
            SecureRequestCustomizer secureRequestCustomer = new SecureRequestCustomizer();
            secureRequestCustomer.setSslSessionAttribute("SSL_SESSION");
            httpConnectionFactory.getHttpConfiguration().addCustomizer((HttpConfiguration.Customizer)secureRequestCustomer);
            return connector;
        };
        ClientSocketProvider httpsClient = new ClientSocketProvider(){
            private SSLContext sslContext;
            {
                try {
                    HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
                    this.sslContext = SSLContext.getInstance("TLS");
                    this.sslContext.init(null, SslContextFactory.TRUST_ALL_CERTS, new SecureRandom());
                    HttpsURLConnection.setDefaultSSLSocketFactory(this.sslContext.getSocketFactory());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Socket newSocket(String host, int port) throws IOException {
                return this.sslContext.getSocketFactory().createSocket(host, port);
            }
        };
        params.add(new Scenario("https/ssl/tls", https, httpsClient));
        return params.stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private Server prepareServer(Scenario scenario, Handler handler) {
        this._threadPool = new QueuedThreadPool();
        this._threadPool.setMinThreads(5);
        this._threadPool.setMaxThreads(5);
        this._threadPool.setDetailedDump(true);
        this._server = new Server((ThreadPool)this._threadPool);
        int acceptors = 1;
        int selectors = 1;
        this._connector = scenario.connectorProvider.newConnector(this._server, acceptors, selectors);
        this._server.addConnector((Connector)this._connector);
        this._server.setHandler(handler);
        return this._server;
    }

    @AfterEach
    public void dispose() throws Exception {
        this._server.stop();
    }

    @ParameterizedTest
    @MethodSource(value={"scenarios"})
    public void testReadInput(Scenario scenario) throws Exception {
        this.prepareServer(scenario, (Handler)new ReadHandler()).start();
        try (Socket client = scenario.clientSocketProvider.newSocket("localhost", this._connector.getLocalPort());){
            client.setSoTimeout(10000);
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            String request = "GET / HTTP/1.0\r\nHost: localhost\r\nContent-Length: 10\r\n\r\n0123456789\r\n";
            os.write(request.getBytes(StandardCharsets.UTF_8));
            os.flush();
            String response = IO.toString((InputStream)is);
            Assertions.assertEquals((int)-1, (int)is.read());
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Read Input 10"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"scenarios"})
    public void testReadStarvation(Scenario scenario) throws Exception {
        this.prepareServer(scenario, (Handler)new ReadHandler());
        this._server.start();
        ExecutorService clientExecutors = Executors.newFixedThreadPool(7);
        ArrayList<Callable<String>> clientTasks = new ArrayList<Callable<String>>();
        for (int i = 0; i < 7; ++i) {
            clientTasks.add(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }
        try {
            List responses = clientExecutors.invokeAll(clientTasks, 60L, TimeUnit.SECONDS);
            for (Future responseFut : responses) {
                String response = (String)responseFut.get();
                MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
                MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Read Input 10"));
            }
        }
        finally {
            clientExecutors.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"scenarios"})
    public void testWriteStarvation(Scenario scenario) throws Exception {
        this.prepareServer(scenario, (Handler)new WriteHandler());
        this._server.start();
        ExecutorService clientExecutors = Executors.newFixedThreadPool(7);
        ArrayList<Callable<Long>> clientTasks = new ArrayList<Callable<Long>>();
        for (int i = 0; i < 7; ++i) {
            clientTasks.add(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }
        try {
            List responses = clientExecutors.invokeAll(clientTasks, 60L, TimeUnit.SECONDS);
            long expected = 0x4000000L;
            for (Future responseFut : responses) {
                Long bodyCount = (Long)responseFut.get();
                MatcherAssert.assertThat((Object)bodyCount, (Matcher)Matchers.is((Object)expected));
            }
        }
        finally {
            clientExecutors.shutdownNow();
        }
    }

    public static class Scenario {
        public final String testType;
        public final ConnectorProvider connectorProvider;
        public final ClientSocketProvider clientSocketProvider;

        public Scenario(String testType, ConnectorProvider connectorProvider, ClientSocketProvider clientSocketProvider) {
            this.testType = testType;
            this.connectorProvider = connectorProvider;
            this.clientSocketProvider = clientSocketProvider;
        }

        public String toString() {
            return this.testType;
        }
    }

    protected static class WriteHandler
    extends AbstractHandler {
        byte[] content = new byte[0x100000];

        protected WriteHandler() {
            Arrays.fill(this.content, (byte)33);
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setStatus(200);
            response.setContentLength(0x4000000);
            ServletOutputStream out = response.getOutputStream();
            for (int i = 0; i < 64; ++i) {
                out.write(this.content);
                out.flush();
            }
        }
    }

    protected static class ReadHandler
    extends AbstractHandler {
        protected ReadHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            if (request.getDispatcherType() == DispatcherType.REQUEST) {
                response.setStatus(200);
                int l = request.getContentLength();
                int r = 0;
                while (r < l) {
                    if (request.getInputStream().read() < 0) continue;
                    ++r;
                }
                response.getOutputStream().write(("Read Input " + r + "\r\n").getBytes());
            } else {
                response.sendError(500);
            }
        }
    }

    static interface ClientSocketProvider {
        public Socket newSocket(String var1, int var2) throws IOException;
    }

    static interface ConnectorProvider {
        public ServerConnector newConnector(Server var1, int var2, int var3);
    }
}

