/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AllowSymLinkAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.TestAbortedException;

public class AllowSymLinkAliasCheckerTest {
    private Server server;
    private LocalConnector localConnector;
    private Path rootPath;

    public static Stream<Arguments> params() {
        String[] dirs;
        ArrayList<Arguments> data = new ArrayList<Arguments>();
        for (String dirname : dirs = new String[]{"/workDir/", "/testdirlnk/", "/testdirprefixlnk/", "/testdirsuffixlnk/", "/testdirwraplnk/"}) {
            data.add(Arguments.of((Object[])new Object[]{dirname, 200, "text/html", "Directory: " + dirname}));
            data.add(Arguments.of((Object[])new Object[]{dirname + "testfile.txt", 200, "text/plain", "Hello TestFile"}));
            data.add(Arguments.of((Object[])new Object[]{dirname + "testfilelnk.txt", 200, "text/plain", "Hello TestFile"}));
            data.add(Arguments.of((Object[])new Object[]{dirname + "testfileprefixlnk.txt", 200, "text/plain", "Hello TestFile"}));
        }
        return data.stream();
    }

    @BeforeEach
    public void setup() throws Exception {
        this.setupRoot();
        this.setupServer();
    }

    @AfterEach
    public void teardown() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private void setupRoot() throws IOException {
        this.rootPath = MavenTestingUtils.getTargetTestingPath((String)AllowSymLinkAliasCheckerTest.class.getSimpleName());
        FS.ensureEmpty((Path)this.rootPath);
        Path testdir = this.rootPath.resolve("workDir");
        FS.ensureDirExists((Path)testdir);
        try {
            Files.createSymbolicLink(this.rootPath.resolve("testdirlnk"), new File("workDir").toPath(), new FileAttribute[0]);
            Files.createSymbolicLink(this.rootPath.resolve("testdirprefixlnk"), new File("./workDir").toPath(), new FileAttribute[0]);
            Files.createSymbolicLink(this.rootPath.resolve("testdirsuffixlnk"), new File("workDir/").toPath(), new FileAttribute[0]);
            Files.createSymbolicLink(this.rootPath.resolve("testdirwraplnk"), new File("./workDir/").toPath(), new FileAttribute[0]);
        }
        catch (UnsupportedOperationException | FileSystemException e) {
            this.abortNotSupported(e);
        }
        Path testfileTxt = testdir.resolve("testfile.txt");
        Files.createFile(testfileTxt, new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(testfileTxt, new OpenOption[0]);){
            out.write("Hello TestFile".getBytes(StandardCharsets.UTF_8));
        }
        try {
            Path testfileTxtLnk = testdir.resolve("testfilelnk.txt");
            Files.createSymbolicLink(testfileTxtLnk, new File("testfile.txt").toPath(), new FileAttribute[0]);
        }
        catch (UnsupportedOperationException | FileSystemException e) {
            this.abortNotSupported(e);
        }
        try {
            Path testfilePrefixTxtLnk = testdir.resolve("testfileprefixlnk.txt");
            Files.createSymbolicLink(testfilePrefixTxtLnk, new File("./testfile.txt").toPath(), new FileAttribute[0]);
        }
        catch (UnsupportedOperationException | FileSystemException e) {
            this.abortNotSupported(e);
        }
    }

    private void abortNotSupported(Throwable t) {
        if (t == null) {
            return;
        }
        throw new TestAbortedException("Unsupported Behavior", t);
    }

    private void setupServer() throws Exception {
        this.server = new Server();
        this.localConnector = new LocalConnector(this.server);
        this.server.addConnector((Connector)this.localConnector);
        ResourceHandler fileResourceHandler = new ResourceHandler();
        fileResourceHandler.setDirectoriesListed(true);
        fileResourceHandler.setWelcomeFiles(new String[]{"index.html"});
        fileResourceHandler.setEtags(true);
        ContextHandler fileResourceContext = new ContextHandler();
        fileResourceContext.setContextPath("/");
        fileResourceContext.setAllowNullPathInfo(true);
        fileResourceContext.setHandler((Handler)fileResourceHandler);
        fileResourceContext.setBaseResource((Resource)new PathResource(this.rootPath));
        fileResourceContext.clearAliasChecks();
        fileResourceContext.addAliasCheck((ContextHandler.AliasCheck)new AllowSymLinkAliasChecker());
        this.server.setHandler((Handler)fileResourceContext);
        this.server.start();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    public void testAccess(String requestURI, int expectedResponseStatus, String expectedResponseContentType, String expectedResponseContentContains) throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setHeader("Host", "tester");
        request.setURI(requestURI);
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            String responseString = this.localConnector.getResponse(BufferUtil.toString((ByteBuffer)request.generate()));
            MatcherAssert.assertThat((String)"Response status code", (Object)responseString, (Matcher)Matchers.startsWith((String)("HTTP/1.1 " + expectedResponseStatus + " ")));
            MatcherAssert.assertThat((String)"Response Content-Type", (Object)responseString, (Matcher)Matchers.containsString((String)("\nContent-Type: " + expectedResponseContentType)));
            MatcherAssert.assertThat((String)"Response", (Object)responseString, (Matcher)Matchers.containsString((String)expectedResponseContentContains));
        });
    }
}

