/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContextHandlerCollectionTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVirtualHosts() throws Exception {
        Server server = new Server();
        LocalConnector connector0 = new LocalConnector(server);
        LocalConnector connector1 = new LocalConnector(server);
        connector1.setName("connector1");
        server.setConnectors(new Connector[]{connector0, connector1});
        ContextHandler contextA = new ContextHandler("/ctx");
        contextA.setVirtualHosts(new String[]{"www.example.com", "alias.example.com"});
        IsHandledHandler handlerA = new IsHandledHandler("A");
        contextA.setHandler((Handler)handlerA);
        contextA.setAllowNullPathInfo(true);
        ContextHandler contextB = new ContextHandler("/ctx");
        IsHandledHandler handlerB = new IsHandledHandler("B");
        contextB.setHandler((Handler)handlerB);
        contextB.setVirtualHosts(new String[]{"*.other.com", "@connector1"});
        ContextHandler contextC = new ContextHandler("/ctx");
        IsHandledHandler handlerC = new IsHandledHandler("C");
        contextC.setHandler((Handler)handlerC);
        ContextHandler contextD = new ContextHandler("/");
        IsHandledHandler handlerD = new IsHandledHandler("D");
        contextD.setHandler((Handler)handlerD);
        ContextHandler contextE = new ContextHandler("/ctx/foo");
        IsHandledHandler handlerE = new IsHandledHandler("E");
        contextE.setHandler((Handler)handlerE);
        ContextHandler contextF = new ContextHandler("/ctxlong");
        IsHandledHandler handlerF = new IsHandledHandler("F");
        contextF.setHandler((Handler)handlerF);
        ContextHandlerCollection c = new ContextHandlerCollection();
        c.addHandler((Handler)contextA);
        c.addHandler((Handler)contextB);
        c.addHandler((Handler)contextC);
        HandlerList list = new HandlerList();
        list.addHandler((Handler)contextE);
        list.addHandler((Handler)contextF);
        list.addHandler((Handler)contextD);
        c.addHandler((Handler)list);
        server.setHandler((Handler)c);
        try {
            server.start();
            Object[][] tests = new Object[][]{{connector0, "www.example.com.", "/ctx", handlerA}, {connector0, "www.example.com.", "/ctx/", handlerA}, {connector0, "www.example.com.", "/ctx/info", handlerA}, {connector0, "www.example.com", "/ctx/info", handlerA}, {connector0, "alias.example.com", "/ctx/info", handlerA}, {connector1, "www.example.com.", "/ctx/info", handlerA}, {connector1, "www.example.com", "/ctx/info", handlerA}, {connector1, "alias.example.com", "/ctx/info", handlerA}, {connector1, "www.other.com", "/ctx", null}, {connector1, "www.other.com", "/ctx/", handlerB}, {connector1, "www.other.com", "/ctx/info", handlerB}, {connector0, "www.other.com", "/ctx/info", handlerC}, {connector0, "www.example.com", "/ctxinfo", handlerD}, {connector1, "unknown.com", "/unknown", handlerD}, {connector0, "alias.example.com", "/ctx/foo/info", handlerE}, {connector0, "alias.example.com", "/ctxlong/info", handlerF}};
            for (int i = 0; i < tests.length; ++i) {
                Object[] test = tests[i];
                LocalConnector connector = (LocalConnector)test[0];
                String host = (String)test[1];
                String uri = (String)test[2];
                IsHandledHandler handler = (IsHandledHandler)((Object)test[3]);
                handlerA.reset();
                handlerB.reset();
                handlerC.reset();
                handlerD.reset();
                handlerE.reset();
                handlerF.reset();
                String t = String.format("test   %d %s@%s --> %s | %s%n", new Object[]{i, uri, host, connector.getName(), handler});
                String response = connector.getResponse("GET " + uri + " HTTP/1.0\nHost: " + host + "\n\n");
                if (handler == null) {
                    MatcherAssert.assertThat((String)t, (Object)response, (Matcher)Matchers.containsString((String)" 302 "));
                    continue;
                }
                MatcherAssert.assertThat((String)t, (Object)response, (Matcher)Matchers.endsWith((String)handler.toString()));
                if (handler.isHandled()) continue;
                Assertions.fail((String)("FAILED " + t + "\n" + response));
            }
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVirtualHostWildcard() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.setConnectors(new Connector[]{connector});
        ContextHandler context = new ContextHandler("/");
        IsHandledHandler handler = new IsHandledHandler("H");
        context.setHandler((Handler)handler);
        ContextHandlerCollection c = new ContextHandlerCollection();
        c.addHandler((Handler)context);
        server.setHandler((Handler)c);
        try {
            server.start();
            this.checkWildcardHost(true, server, null, new String[]{"example.com", ".example.com", "vhost.example.com"});
            this.checkWildcardHost(false, server, new String[]{null}, new String[]{"example.com", ".example.com", "vhost.example.com"});
            this.checkWildcardHost(true, server, new String[]{"example.com", "*.example.com"}, new String[]{"example.com", ".example.com", "vhost.example.com"});
            this.checkWildcardHost(false, server, new String[]{"example.com", "*.example.com"}, new String[]{"badexample.com", ".badexample.com", "vhost.badexample.com"});
            this.checkWildcardHost(false, server, new String[]{"*."}, new String[]{"anything.anything"});
            this.checkWildcardHost(true, server, new String[]{"*.example.com"}, new String[]{"vhost.example.com", ".example.com"});
            this.checkWildcardHost(false, server, new String[]{"*.example.com"}, new String[]{"vhost.www.example.com", "example.com", "www.vhost.example.com"});
            this.checkWildcardHost(true, server, new String[]{"*.sub.example.com"}, new String[]{"vhost.sub.example.com", ".sub.example.com"});
            this.checkWildcardHost(false, server, new String[]{"*.sub.example.com"}, new String[]{".example.com", "sub.example.com", "vhost.example.com"});
            this.checkWildcardHost(false, server, new String[]{"example.*.com", "example.com.*"}, new String[]{"example.vhost.com", "example.com.vhost", "example.com"});
        }
        finally {
            server.stop();
        }
    }

    private void checkWildcardHost(boolean succeed, Server server, String[] contextHosts, String[] requestHosts) throws Exception {
        LocalConnector connector = (LocalConnector)server.getConnectors()[0];
        ContextHandlerCollection handlerCollection = (ContextHandlerCollection)server.getHandler();
        ContextHandler context = (ContextHandler)handlerCollection.getHandlers()[0];
        IsHandledHandler handler = (IsHandledHandler)context.getHandler();
        context.setVirtualHosts(contextHosts);
        handlerCollection.mapContexts();
        for (String host : requestHosts) {
            String response = connector.getResponse("GET / HTTP/1.0\nHost: " + host + "\nConnection:close\n\n");
            if (succeed) {
                Assertions.assertTrue((boolean)handler.isHandled(), (String)("'" + host + "' should have been handled."));
            } else {
                Assertions.assertFalse((boolean)handler.isHandled(), (String)("'" + host + "' should not have been handled."));
            }
            handler.reset();
        }
    }

    @Test
    public void testFindContainer() throws Exception {
        Server server = new Server();
        ContextHandler contextA = new ContextHandler("/a");
        IsHandledHandler handlerA = new IsHandledHandler("A");
        contextA.setHandler((Handler)handlerA);
        ContextHandler contextB = new ContextHandler("/b");
        IsHandledHandler handlerB = new IsHandledHandler("B");
        HandlerWrapper wrapperB = new HandlerWrapper();
        wrapperB.setHandler((Handler)handlerB);
        contextB.setHandler((Handler)wrapperB);
        ContextHandler contextC = new ContextHandler("/c");
        IsHandledHandler handlerC = new IsHandledHandler("C");
        contextC.setHandler((Handler)handlerC);
        ContextHandlerCollection collection = new ContextHandlerCollection();
        collection.addHandler((Handler)contextA);
        collection.addHandler((Handler)contextB);
        collection.addHandler((Handler)contextC);
        HandlerWrapper wrapper = new HandlerWrapper();
        wrapper.setHandler((Handler)collection);
        server.setHandler((Handler)wrapper);
        Assertions.assertEquals((Object)wrapper, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)server, HandlerWrapper.class, (Handler)handlerA));
        Assertions.assertEquals((Object)contextA, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)server, ContextHandler.class, (Handler)handlerA));
        Assertions.assertEquals((Object)contextB, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)server, ContextHandler.class, (Handler)handlerB));
        Assertions.assertEquals((Object)wrapper, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)server, HandlerWrapper.class, (Handler)handlerB));
        Assertions.assertEquals((Object)contextB, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)collection, HandlerWrapper.class, (Handler)handlerB));
        Assertions.assertEquals((Object)wrapperB, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)contextB, HandlerWrapper.class, (Handler)handlerB));
    }

    @Test
    public void testWrappedContext() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.setConnectors(new Connector[]{connector});
        ContextHandler root = new ContextHandler("/");
        root.setHandler((Handler)new IsHandledHandler("root"));
        ContextHandler left = new ContextHandler("/left");
        left.setHandler((Handler)new IsHandledHandler("left"));
        HandlerList centre = new HandlerList();
        ContextHandler centreLeft = new ContextHandler("/leftcentre");
        centreLeft.setHandler((Handler)new IsHandledHandler("left of centre"));
        ContextHandler centreRight = new ContextHandler("/rightcentre");
        centreRight.setHandler((Handler)new IsHandledHandler("right of centre"));
        centre.setHandlers(new Handler[]{centreLeft, new WrappedHandler((Handler)centreRight)});
        ContextHandler right = new ContextHandler("/right");
        right.setHandler((Handler)new IsHandledHandler("right"));
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{root, left, centre, new WrappedHandler((Handler)right)});
        server.setHandler((Handler)contexts);
        server.start();
        String response = connector.getResponse("GET / HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"root"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Wrapped: TRUE")));
        response = connector.getResponse("GET /foobar/info HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"root"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Wrapped: TRUE")));
        response = connector.getResponse("GET /left/info HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"left"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Wrapped: TRUE")));
        response = connector.getResponse("GET /leftcentre/info HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"left of centre"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Wrapped: TRUE")));
        response = connector.getResponse("GET /rightcentre/info HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"right of centre"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Wrapped: TRUE"));
        response = connector.getResponse("GET /right/info HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"right"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Wrapped: TRUE"));
    }

    @Test
    public void testAsyncWrappedContext() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.setConnectors(new Connector[]{connector});
        ContextHandler root = new ContextHandler("/");
        root.setHandler((Handler)new AsyncHandler("root"));
        ContextHandler left = new ContextHandler("/left");
        left.setHandler((Handler)new AsyncHandler("left"));
        ContextHandler centreLeft = new ContextHandler("/leftcentre");
        centreLeft.setHandler((Handler)new AsyncHandler("left of centre"));
        ContextHandler centreRight = new ContextHandler("/rightcentre");
        centreRight.setHandler((Handler)new AsyncHandler("right of centre"));
        HandlerList centre = new HandlerList(new Handler[]{centreLeft, new WrappedHandler((Handler)centreRight)});
        ContextHandler right = new ContextHandler("/right");
        right.setHandler((Handler)new AsyncHandler("right"));
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{root, left, centre, new WrappedHandler((Handler)right)});
        server.setHandler((Handler)contexts);
        server.start();
        String response = connector.getResponse("GET / HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"root"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Wrapped: TRUE")));
        response = connector.getResponse("GET /foobar/info HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"root"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Wrapped: TRUE")));
        response = connector.getResponse("GET /left/info HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"left"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Wrapped: TRUE")));
        response = connector.getResponse("GET /leftcentre/info HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"left of centre"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Wrapped: TRUE")));
        response = connector.getResponse("GET /rightcentre/info HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"right of centre"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Wrapped: ASYNC"));
        response = connector.getResponse("GET /right/info HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"right"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Wrapped: ASYNC"));
    }

    private static final class AsyncHandler
    extends AbstractHandler {
        private final String name;

        public AsyncHandler(String string) {
            this.name = string;
        }

        public void handle(String s, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            String n = (String)baseRequest.getAttribute("async");
            if (n == null) {
                AsyncContext async = baseRequest.startAsync();
                async.setTimeout(1000L);
                baseRequest.setAttribute("async", (Object)this.name);
                async.dispatch();
            } else {
                response.getWriter().print(n);
            }
        }

        public String toString() {
            return this.name;
        }
    }

    private static final class IsHandledHandler
    extends AbstractHandler {
        private boolean handled;
        private final String name;

        public IsHandledHandler(String string) {
            this.name = string;
        }

        public boolean isHandled() {
            return this.handled;
        }

        public void handle(String s, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            this.handled = true;
            response.getWriter().print(this.name);
        }

        public void reset() {
            this.handled = false;
        }

        public String toString() {
            return this.name;
        }
    }

    private static final class WrappedHandler
    extends HandlerWrapper {
        WrappedHandler(Handler handler) {
            this.setHandler(handler);
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (response.containsHeader("Wrapped")) {
                response.setHeader("Wrapped", "ASYNC");
            } else {
                response.setHeader("Wrapped", "TRUE");
            }
            super.handle(target, baseRequest, request, response);
        }
    }
}

