/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AllowSymLinkAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.resource.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class ContextHandlerGetResourceTest {
    private static boolean OS_ALIAS_SUPPORTED;
    private static Server server;
    private static ContextHandler context;
    private static File docroot;
    private static File otherroot;
    private static final AtomicBoolean allowAliases;
    private static final AtomicBoolean allowSymlinks;

    @BeforeAll
    public static void beforeClass() throws Exception {
        File testRoot = MavenTestingUtils.getTargetTestingDir((String)ContextHandlerGetResourceTest.class.getSimpleName());
        FS.ensureEmpty((File)testRoot);
        docroot = new File(testRoot, "docroot").getCanonicalFile().getAbsoluteFile();
        FS.ensureEmpty((File)docroot);
        File index = new File(docroot, "index.html");
        index.createNewFile();
        File sub = new File(docroot, "subdir");
        sub.mkdir();
        File data = new File(sub, "data.txt");
        data.createNewFile();
        File verylong = new File(sub, "TextFile.Long.txt");
        verylong.createNewFile();
        otherroot = new File(testRoot, "otherroot").getCanonicalFile().getAbsoluteFile();
        FS.ensureEmpty((File)otherroot);
        File other = new File(otherroot, "other.txt");
        other.createNewFile();
        File transit = new File(docroot.getParentFile(), "transit");
        transit.delete();
        if (!OS.WINDOWS.isCurrentOs()) {
            File eightDotThree = new File(sub, "TEXTFI~1.TXT");
            Files.createSymbolicLink(eightDotThree.toPath(), verylong.toPath(), new FileAttribute[0]);
            Files.createSymbolicLink(new File(docroot, "other").toPath(), new File("../transit").toPath(), new FileAttribute[0]);
            Files.createSymbolicLink(transit.toPath(), otherroot.toPath(), new FileAttribute[0]);
            new File(docroot, "media/internal-physical/logs").mkdirs();
            Files.createSymbolicLink(new File(docroot, "media/internal").toPath(), new File(docroot, "media/internal-physical").toPath(), new FileAttribute[0]);
            new File(docroot, "var").mkdir();
            Files.createSymbolicLink(new File(docroot, "var/logs").toPath(), new File(docroot, "media/internal/logs").toPath(), new FileAttribute[0]);
            new File(docroot, "web").mkdir();
            Files.createSymbolicLink(new File(docroot, "web/logs").toPath(), new File(docroot, "var/logs").toPath(), new FileAttribute[0]);
            new File(docroot, "media/internal-physical/logs/file.log").createNewFile();
            System.err.println("docroot=" + docroot);
        }
        OS_ALIAS_SUPPORTED = new File(sub, "TEXTFI~1.TXT").exists();
        server = new Server();
        context = new ContextHandler("/");
        context.clearAliasChecks();
        context.addAliasCheck((ContextHandler.AliasCheck)new ContextHandler.ApproveNonExistentDirectoryAliases());
        context.setBaseResource(Resource.newResource((File)docroot));
        context.addAliasCheck(new ContextHandler.AliasCheck(){
            final AllowSymLinkAliasChecker symlinkcheck = new AllowSymLinkAliasChecker();

            public boolean check(String path, Resource resource) {
                if (allowAliases.get()) {
                    return true;
                }
                if (allowSymlinks.get()) {
                    return this.symlinkcheck.check(path, resource);
                }
                return allowAliases.get();
            }
        });
        server.setHandler((Handler)context);
        server.start();
    }

    @AfterAll
    public static void afterClass() throws Exception {
        server.stop();
    }

    @Test
    public void testBadPath() throws Exception {
        String path = "bad";
        Assertions.assertThrows(MalformedURLException.class, () -> context.getResource("bad"));
        Assertions.assertThrows(MalformedURLException.class, () -> context.getServletContext().getResource("bad"));
    }

    @Test
    public void testGetUnknown() throws Exception {
        String path = "/unknown.txt";
        Resource resource = context.getResource("/unknown.txt");
        Assertions.assertEquals((Object)"unknown.txt", (Object)resource.getFile().getName());
        Assertions.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assertions.assertFalse((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/unknown.txt");
        Assertions.assertNull((Object)url);
    }

    @Test
    public void testGetUnknownDir() throws Exception {
        String path = "/unknown/";
        Resource resource = context.getResource("/unknown/");
        Assertions.assertEquals((Object)"unknown", (Object)resource.getFile().getName());
        Assertions.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assertions.assertFalse((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/unknown/");
        Assertions.assertNull((Object)url);
    }

    @Test
    public void testRoot() throws Exception {
        String path = "/";
        Resource resource = context.getResource("/");
        Assertions.assertEquals((Object)docroot, (Object)resource.getFile());
        Assertions.assertTrue((boolean)resource.exists());
        Assertions.assertTrue((boolean)resource.isDirectory());
        URL url = context.getServletContext().getResource("/");
        Assertions.assertEquals((Object)docroot, (Object)new File(url.toURI()));
    }

    @Test
    public void testSubdir() throws Exception {
        String path = "/subdir";
        Resource resource = context.getResource("/subdir");
        Assertions.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assertions.assertTrue((boolean)resource.exists());
        Assertions.assertTrue((boolean)resource.isDirectory());
        Assertions.assertTrue((boolean)resource.toString().endsWith("/"));
        URL url = context.getServletContext().getResource("/subdir");
        Assertions.assertEquals((Object)docroot, (Object)new File(url.toURI()).getParentFile());
    }

    @Test
    public void testSubdirSlash() throws Exception {
        String path = "/subdir/";
        Resource resource = context.getResource("/subdir/");
        Assertions.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assertions.assertTrue((boolean)resource.exists());
        Assertions.assertTrue((boolean)resource.isDirectory());
        Assertions.assertTrue((boolean)resource.toString().endsWith("/"));
        URL url = context.getServletContext().getResource("/subdir/");
        Assertions.assertEquals((Object)docroot, (Object)new File(url.toURI()).getParentFile());
    }

    @Test
    public void testGetKnown() throws Exception {
        String path = "/index.html";
        Resource resource = context.getResource("/index.html");
        Assertions.assertEquals((Object)"index.html", (Object)resource.getFile().getName());
        Assertions.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assertions.assertTrue((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/index.html");
        Assertions.assertEquals((Object)docroot, (Object)new File(url.toURI()).getParentFile());
    }

    @Test
    public void testNormalize() throws Exception {
        String path = "/down/.././index.html";
        Resource resource = context.getResource("/down/.././index.html");
        Assertions.assertEquals((Object)"index.html", (Object)resource.getFile().getName());
        Assertions.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assertions.assertTrue((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/down/.././index.html");
        Assertions.assertEquals((Object)docroot, (Object)new File(url.toURI()).getParentFile());
    }

    @Test
    public void testTooNormal() throws Exception {
        String path = "/down/.././../";
        Resource resource = context.getResource("/down/.././../");
        Assertions.assertNull((Object)resource);
        URL url = context.getServletContext().getResource("/down/.././../");
        Assertions.assertNull((Object)url);
    }

    @Test
    public void testDeep() throws Exception {
        String path = "/subdir/data.txt";
        Resource resource = context.getResource("/subdir/data.txt");
        Assertions.assertEquals((Object)"data.txt", (Object)resource.getFile().getName());
        Assertions.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile().getParentFile());
        Assertions.assertTrue((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/subdir/data.txt");
        Assertions.assertEquals((Object)docroot, (Object)new File(url.toURI()).getParentFile().getParentFile());
    }

    @Test
    public void testEncodedSlash() throws Exception {
        String path = "/subdir%2Fdata.txt";
        Resource resource = context.getResource("/subdir%2Fdata.txt");
        Assertions.assertEquals((Object)"subdir%2Fdata.txt", (Object)resource.getFile().getName());
        Assertions.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assertions.assertFalse((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/subdir%2Fdata.txt");
        Assertions.assertNull((Object)url);
    }

    @Test
    public void testEncodedSlosh() throws Exception {
        String path = "/subdir%5Cdata.txt";
        Resource resource = context.getResource("/subdir%5Cdata.txt");
        Assertions.assertEquals((Object)"subdir%5Cdata.txt", (Object)resource.getFile().getName());
        Assertions.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assertions.assertFalse((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/subdir%5Cdata.txt");
        Assertions.assertNull((Object)url);
    }

    @Test
    public void testEncodedNull() throws Exception {
        String path = "/subdir/data.txt%00";
        Resource resource = context.getResource("/subdir/data.txt%00");
        Assertions.assertEquals((Object)"data.txt%00", (Object)resource.getFile().getName());
        Assertions.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile().getParentFile());
        Assertions.assertFalse((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/subdir/data.txt%00");
        Assertions.assertNull((Object)url);
    }

    @Test
    public void testSlashSlash() throws Exception {
        File expected = new File(docroot, FS.separators((String)"subdir/data.txt"));
        URL expectedUrl = expected.toURI().toURL();
        String path = "//subdir/data.txt";
        Resource resource = context.getResource(path);
        MatcherAssert.assertThat((String)("Resource: " + resource), (Object)resource, (Matcher)Matchers.nullValue());
        URL url = context.getServletContext().getResource(path);
        MatcherAssert.assertThat((String)("Resource: " + url), (Object)url, (Matcher)Matchers.nullValue());
        path = "/subdir//data.txt";
        resource = context.getResource(path);
        MatcherAssert.assertThat((String)("Resource: " + resource), (Object)resource, (Matcher)Matchers.nullValue());
        url = context.getServletContext().getResource(path);
        MatcherAssert.assertThat((String)("Resource: " + url), (Object)url, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testAliasedFile() throws Exception {
        Assumptions.assumeTrue((boolean)OS_ALIAS_SUPPORTED, (String)"OS Supports 8.3 Aliased / Alternate References");
        String path = "/subdir/TEXTFI~1.TXT";
        Resource resource = context.getResource("/subdir/TEXTFI~1.TXT");
        Assertions.assertNull((Object)resource);
        URL url = context.getServletContext().getResource("/subdir/TEXTFI~1.TXT");
        Assertions.assertNull((Object)url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAliasedFileAllowed() throws Exception {
        Assumptions.assumeTrue((boolean)OS_ALIAS_SUPPORTED, (String)"OS Supports 8.3 Aliased / Alternate References");
        try {
            allowAliases.set(true);
            String path = "/subdir/TEXTFI~1.TXT";
            Resource resource = context.getResource("/subdir/TEXTFI~1.TXT");
            Assertions.assertNotNull((Object)resource);
            Assertions.assertEquals((Object)context.getResource("/subdir/TextFile.Long.txt").getURI(), (Object)resource.getAlias());
            URL url = context.getServletContext().getResource("/subdir/TEXTFI~1.TXT");
            Assertions.assertNotNull((Object)url);
            Assertions.assertEquals((Object)docroot, (Object)new File(url.toURI()).getParentFile().getParentFile());
        }
        finally {
            allowAliases.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @EnabledOnOs(value={OS.LINUX, OS.MAC})
    public void testSymlinkKnown() throws Exception {
        try {
            allowSymlinks.set(true);
            String path = "/other/other.txt";
            Resource resource = context.getResource("/other/other.txt");
            Assertions.assertNotNull((Object)resource);
            Assertions.assertEquals((Object)"other.txt", (Object)resource.getFile().getName());
            Assertions.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile().getParentFile());
            Assertions.assertTrue((boolean)resource.exists());
            URL url = context.getServletContext().getResource("/other/other.txt");
            Assertions.assertEquals((Object)docroot, (Object)new File(url.toURI()).getParentFile().getParentFile());
        }
        finally {
            allowSymlinks.set(false);
        }
    }

    @Test
    @EnabledOnOs(value={OS.LINUX, OS.MAC})
    public void testSymlinkNested() throws Exception {
        try {
            allowSymlinks.set(true);
            String path = "/web/logs/file.log";
            Resource resource = context.getResource("/web/logs/file.log");
            Assertions.assertNotNull((Object)resource);
            Assertions.assertEquals((Object)"file.log", (Object)resource.getFile().getName());
            Assertions.assertTrue((boolean)resource.exists());
        }
        finally {
            allowSymlinks.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @EnabledOnOs(value={OS.LINUX, OS.MAC})
    public void testSymlinkUnknown() throws Exception {
        try {
            allowSymlinks.set(true);
            String path = "/other/unknown.txt";
            Resource resource = context.getResource("/other/unknown.txt");
            Assertions.assertNotNull((Object)resource);
            Assertions.assertEquals((Object)"unknown.txt", (Object)resource.getFile().getName());
            Assertions.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile().getParentFile());
            Assertions.assertFalse((boolean)resource.exists());
            URL url = context.getServletContext().getResource("/other/unknown.txt");
            Assertions.assertNull((Object)url);
        }
        finally {
            allowSymlinks.set(false);
        }
    }

    static {
        allowAliases = new AtomicBoolean(false);
        allowSymlinks = new AtomicBoolean(false);
    }
}

