/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDir;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDirExtension;
import org.eclipse.jetty.util.resource.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkDirExtension.class})
public class ContextHandlerTest {
    public WorkDir workDir;

    @Test
    public void testGetResourcePathsWhenSuppliedPathEndsInSlash() throws Exception {
        this.checkResourcePathsForExampleWebApp("/WEB-INF/");
    }

    @Test
    public void testGetResourcePathsWhenSuppliedPathDoesNotEndInSlash() throws Exception {
        this.checkResourcePathsForExampleWebApp("/WEB-INF");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVirtualHostNormalization() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.setConnectors(new Connector[]{connector});
        ContextHandler contextA = new ContextHandler("/");
        contextA.setVirtualHosts(new String[]{"www.example.com"});
        IsHandledHandler handlerA = new IsHandledHandler();
        contextA.setHandler((Handler)handlerA);
        ContextHandler contextB = new ContextHandler("/");
        IsHandledHandler handlerB = new IsHandledHandler();
        contextB.setHandler((Handler)handlerB);
        contextB.setVirtualHosts(new String[]{"www.example2.com."});
        ContextHandler contextC = new ContextHandler("/");
        IsHandledHandler handlerC = new IsHandledHandler();
        contextC.setHandler((Handler)handlerC);
        HandlerList c = new HandlerList();
        c.addHandler((Handler)contextA);
        c.addHandler((Handler)contextB);
        c.addHandler((Handler)contextC);
        server.setHandler((Handler)c);
        try {
            server.start();
            connector.getResponse("GET / HTTP/1.0\nHost: www.example.com.\n\n");
            Assertions.assertTrue((boolean)handlerA.isHandled());
            Assertions.assertFalse((boolean)handlerB.isHandled());
            Assertions.assertFalse((boolean)handlerC.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
            connector.getResponse("GET / HTTP/1.0\nHost: www.example2.com\n\n");
            Assertions.assertFalse((boolean)handlerA.isHandled());
            Assertions.assertTrue((boolean)handlerB.isHandled());
            Assertions.assertFalse((boolean)handlerC.isHandled());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamedConnector() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        LocalConnector connectorN = new LocalConnector(server);
        connectorN.setName("name");
        server.setConnectors(new Connector[]{connector, connectorN});
        ContextHandler contextA = new ContextHandler("/");
        contextA.setDisplayName("A");
        contextA.setVirtualHosts(new String[]{"www.example.com"});
        IsHandledHandler handlerA = new IsHandledHandler();
        contextA.setHandler((Handler)handlerA);
        ContextHandler contextB = new ContextHandler("/");
        contextB.setDisplayName("B");
        IsHandledHandler handlerB = new IsHandledHandler();
        contextB.setHandler((Handler)handlerB);
        contextB.setVirtualHosts(new String[]{"@name"});
        ContextHandler contextC = new ContextHandler("/");
        contextC.setDisplayName("C");
        IsHandledHandler handlerC = new IsHandledHandler();
        contextC.setHandler((Handler)handlerC);
        ContextHandler contextD = new ContextHandler("/");
        contextD.setDisplayName("D");
        IsHandledHandler handlerD = new IsHandledHandler();
        contextD.setHandler((Handler)handlerD);
        contextD.setVirtualHosts(new String[]{"www.example.com@name"});
        ContextHandler contextE = new ContextHandler("/");
        contextE.setDisplayName("E");
        IsHandledHandler handlerE = new IsHandledHandler();
        contextE.setHandler((Handler)handlerE);
        contextE.setVirtualHosts(new String[]{"*.example.com"});
        ContextHandler contextF = new ContextHandler("/");
        contextF.setDisplayName("F");
        IsHandledHandler handlerF = new IsHandledHandler();
        contextF.setHandler((Handler)handlerF);
        contextF.setVirtualHosts(new String[]{"*.example.com@name"});
        ContextHandler contextG = new ContextHandler("/");
        contextG.setDisplayName("G");
        IsHandledHandler handlerG = new IsHandledHandler();
        contextG.setHandler((Handler)handlerG);
        contextG.setVirtualHosts(new String[]{"*.com@name"});
        ContextHandler contextH = new ContextHandler("/");
        contextH.setDisplayName("H");
        IsHandledHandler handlerH = new IsHandledHandler();
        contextH.setHandler((Handler)handlerH);
        contextH.setVirtualHosts(new String[]{"*.com"});
        HandlerList c = new HandlerList();
        c.addHandler((Handler)contextA);
        c.addHandler((Handler)contextB);
        c.addHandler((Handler)contextC);
        c.addHandler((Handler)contextD);
        c.addHandler((Handler)contextE);
        c.addHandler((Handler)contextF);
        c.addHandler((Handler)contextG);
        c.addHandler((Handler)contextH);
        server.setHandler((Handler)c);
        server.start();
        try {
            connector.getResponse("GET / HTTP/1.0\nHost: www.example.com.\n\n");
            Assertions.assertTrue((boolean)handlerA.isHandled());
            Assertions.assertFalse((boolean)handlerB.isHandled());
            Assertions.assertFalse((boolean)handlerC.isHandled());
            Assertions.assertFalse((boolean)handlerD.isHandled());
            Assertions.assertFalse((boolean)handlerE.isHandled());
            Assertions.assertFalse((boolean)handlerF.isHandled());
            Assertions.assertFalse((boolean)handlerG.isHandled());
            Assertions.assertFalse((boolean)handlerH.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
            handlerD.reset();
            handlerE.reset();
            handlerF.reset();
            handlerG.reset();
            handlerH.reset();
            connector.getResponse("GET / HTTP/1.0\nHost: localhost\n\n");
            Assertions.assertFalse((boolean)handlerA.isHandled());
            Assertions.assertFalse((boolean)handlerB.isHandled());
            Assertions.assertTrue((boolean)handlerC.isHandled());
            Assertions.assertFalse((boolean)handlerD.isHandled());
            Assertions.assertFalse((boolean)handlerE.isHandled());
            Assertions.assertFalse((boolean)handlerF.isHandled());
            Assertions.assertFalse((boolean)handlerG.isHandled());
            Assertions.assertFalse((boolean)handlerH.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
            handlerD.reset();
            handlerE.reset();
            handlerF.reset();
            handlerG.reset();
            handlerH.reset();
            connectorN.getResponse("GET / HTTP/1.0\nHost: www.example.com.\n\n");
            Assertions.assertTrue((boolean)handlerA.isHandled());
            Assertions.assertFalse((boolean)handlerB.isHandled());
            Assertions.assertFalse((boolean)handlerC.isHandled());
            Assertions.assertFalse((boolean)handlerD.isHandled());
            Assertions.assertFalse((boolean)handlerE.isHandled());
            Assertions.assertFalse((boolean)handlerF.isHandled());
            Assertions.assertFalse((boolean)handlerG.isHandled());
            Assertions.assertFalse((boolean)handlerH.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
            handlerD.reset();
            handlerE.reset();
            handlerF.reset();
            handlerG.reset();
            handlerH.reset();
            connectorN.getResponse("GET / HTTP/1.0\nHost: localhost\n\n");
            Assertions.assertFalse((boolean)handlerA.isHandled());
            Assertions.assertTrue((boolean)handlerB.isHandled());
            Assertions.assertFalse((boolean)handlerC.isHandled());
            Assertions.assertFalse((boolean)handlerD.isHandled());
            Assertions.assertFalse((boolean)handlerE.isHandled());
            Assertions.assertFalse((boolean)handlerF.isHandled());
            Assertions.assertFalse((boolean)handlerG.isHandled());
            Assertions.assertFalse((boolean)handlerH.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
            handlerD.reset();
            handlerE.reset();
            handlerF.reset();
            handlerG.reset();
            handlerH.reset();
        }
        finally {
            server.stop();
        }
        HandlerList d = new HandlerList();
        d.addHandler((Handler)contextH);
        d.addHandler((Handler)contextG);
        d.addHandler((Handler)contextF);
        d.addHandler((Handler)contextE);
        d.addHandler((Handler)contextD);
        d.addHandler((Handler)contextC);
        d.addHandler((Handler)contextB);
        d.addHandler((Handler)contextA);
        server.setHandler((Handler)d);
        server.start();
        try {
            connector.getResponse("GET / HTTP/1.0\nHost: www.example.com.\n\n");
            Assertions.assertFalse((boolean)handlerA.isHandled());
            Assertions.assertFalse((boolean)handlerB.isHandled());
            Assertions.assertFalse((boolean)handlerC.isHandled());
            Assertions.assertFalse((boolean)handlerD.isHandled());
            Assertions.assertTrue((boolean)handlerE.isHandled());
            Assertions.assertFalse((boolean)handlerF.isHandled());
            Assertions.assertFalse((boolean)handlerG.isHandled());
            Assertions.assertFalse((boolean)handlerH.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
            handlerD.reset();
            handlerE.reset();
            handlerF.reset();
            handlerG.reset();
            handlerH.reset();
            connector.getResponse("GET / HTTP/1.0\nHost: localhost\n\n");
            Assertions.assertFalse((boolean)handlerA.isHandled());
            Assertions.assertFalse((boolean)handlerB.isHandled());
            Assertions.assertTrue((boolean)handlerC.isHandled());
            Assertions.assertFalse((boolean)handlerD.isHandled());
            Assertions.assertFalse((boolean)handlerE.isHandled());
            Assertions.assertFalse((boolean)handlerF.isHandled());
            Assertions.assertFalse((boolean)handlerG.isHandled());
            Assertions.assertFalse((boolean)handlerH.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
            handlerD.reset();
            handlerE.reset();
            handlerF.reset();
            handlerG.reset();
            handlerH.reset();
            connectorN.getResponse("GET / HTTP/1.0\nHost: www.example.com.\n\n");
            Assertions.assertFalse((boolean)handlerA.isHandled());
            Assertions.assertFalse((boolean)handlerB.isHandled());
            Assertions.assertFalse((boolean)handlerC.isHandled());
            Assertions.assertFalse((boolean)handlerD.isHandled());
            Assertions.assertFalse((boolean)handlerE.isHandled());
            Assertions.assertTrue((boolean)handlerF.isHandled());
            Assertions.assertFalse((boolean)handlerG.isHandled());
            Assertions.assertFalse((boolean)handlerH.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
            handlerD.reset();
            handlerE.reset();
            handlerF.reset();
            handlerG.reset();
            handlerH.reset();
            connectorN.getResponse("GET / HTTP/1.0\nHost: localhost\n\n");
            Assertions.assertFalse((boolean)handlerA.isHandled());
            Assertions.assertFalse((boolean)handlerB.isHandled());
            Assertions.assertTrue((boolean)handlerC.isHandled());
            Assertions.assertFalse((boolean)handlerD.isHandled());
            Assertions.assertFalse((boolean)handlerE.isHandled());
            Assertions.assertFalse((boolean)handlerF.isHandled());
            Assertions.assertFalse((boolean)handlerG.isHandled());
            Assertions.assertFalse((boolean)handlerH.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
            handlerD.reset();
            handlerE.reset();
            handlerF.reset();
            handlerG.reset();
            handlerH.reset();
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testContextGetContext() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.setConnectors(new Connector[]{connector});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        ContextHandler rootA = new ContextHandler((HandlerContainer)contexts, "/");
        ContextHandler fooA = new ContextHandler((HandlerContainer)contexts, "/foo");
        ContextHandler foobarA = new ContextHandler((HandlerContainer)contexts, "/foo/bar");
        server.start();
        Assertions.assertEquals((Object)rootA._scontext, (Object)rootA._scontext.getContext("/"));
        Assertions.assertEquals((Object)fooA._scontext, (Object)rootA._scontext.getContext("/foo"));
        Assertions.assertEquals((Object)foobarA._scontext, (Object)rootA._scontext.getContext("/foo/bar"));
        Assertions.assertEquals((Object)foobarA._scontext, (Object)rootA._scontext.getContext("/foo/bar/bob.jsp"));
        Assertions.assertEquals((Object)rootA._scontext, (Object)rootA._scontext.getContext("/other"));
        Assertions.assertEquals((Object)fooA._scontext, (Object)rootA._scontext.getContext("/foo/other"));
        Assertions.assertEquals((Object)rootA._scontext, (Object)foobarA._scontext.getContext("/"));
        Assertions.assertEquals((Object)fooA._scontext, (Object)foobarA._scontext.getContext("/foo"));
        Assertions.assertEquals((Object)foobarA._scontext, (Object)foobarA._scontext.getContext("/foo/bar"));
        Assertions.assertEquals((Object)foobarA._scontext, (Object)foobarA._scontext.getContext("/foo/bar/bob.jsp"));
        Assertions.assertEquals((Object)rootA._scontext, (Object)foobarA._scontext.getContext("/other"));
        Assertions.assertEquals((Object)fooA._scontext, (Object)foobarA._scontext.getContext("/foo/other"));
    }

    @Test
    public void testLifeCycle() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.setConnectors(new Connector[]{connector});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        ContextHandler root = new ContextHandler((HandlerContainer)contexts, "/");
        root.setHandler((Handler)new ContextPathHandler());
        ContextHandler foo = new ContextHandler((HandlerContainer)contexts, "/foo");
        foo.setHandler((Handler)new ContextPathHandler());
        ContextHandler foobar = new ContextHandler((HandlerContainer)contexts, "/foo/bar");
        foobar.setHandler((Handler)new ContextPathHandler());
        server.start();
        MatcherAssert.assertThat((Object)connector.getResponse("GET / HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo'"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/bar/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo/bar'"));
        foobar.setAvailable(false);
        MatcherAssert.assertThat((Object)connector.getResponse("GET / HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo'"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/bar/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)" 503 "));
        foobar.setAvailable(true);
        MatcherAssert.assertThat((Object)connector.getResponse("GET / HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo'"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/bar/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo/bar'"));
        foobar.stop();
        MatcherAssert.assertThat((Object)connector.getResponse("GET / HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo'"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/bar/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo'"));
        foo.shutdown().get();
        MatcherAssert.assertThat((Object)connector.getResponse("GET / HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"503"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/bar/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"503"));
        foo.stop();
        MatcherAssert.assertThat((Object)connector.getResponse("GET / HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/bar/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        foo.start();
        MatcherAssert.assertThat((Object)connector.getResponse("GET / HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo'"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/bar/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo'"));
        foobar.start();
        MatcherAssert.assertThat((Object)connector.getResponse("GET / HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo'"));
        MatcherAssert.assertThat((Object)connector.getResponse("GET /foo/bar/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo/bar'"));
    }

    @Test
    public void testContextInitializationDestruction() throws Exception {
        Server server = new Server();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        ContextHandler noServlets = new ContextHandler((HandlerContainer)contexts, "/noservlets");
        TestServletContextListener listener = new TestServletContextListener();
        noServlets.addEventListener((EventListener)((Object)listener));
        server.start();
        Assertions.assertEquals((int)1, (int)listener.initialized);
        server.stop();
        Assertions.assertEquals((int)1, (int)listener.destroyed);
    }

    @Test
    public void testContextVirtualGetContext() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.setConnectors(new Connector[]{connector});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        ContextHandler rootA = new ContextHandler((HandlerContainer)contexts, "/");
        rootA.setVirtualHosts(new String[]{"a.com"});
        ContextHandler rootB = new ContextHandler((HandlerContainer)contexts, "/");
        rootB.setVirtualHosts(new String[]{"b.com"});
        ContextHandler rootC = new ContextHandler((HandlerContainer)contexts, "/");
        rootC.setVirtualHosts(new String[]{"c.com"});
        ContextHandler fooA = new ContextHandler((HandlerContainer)contexts, "/foo");
        fooA.setVirtualHosts(new String[]{"a.com"});
        ContextHandler fooB = new ContextHandler((HandlerContainer)contexts, "/foo");
        fooB.setVirtualHosts(new String[]{"b.com"});
        ContextHandler foobarA = new ContextHandler((HandlerContainer)contexts, "/foo/bar");
        foobarA.setVirtualHosts(new String[]{"a.com"});
        server.start();
        Assertions.assertEquals((Object)rootA._scontext, (Object)rootA._scontext.getContext("/"));
        Assertions.assertEquals((Object)fooA._scontext, (Object)rootA._scontext.getContext("/foo"));
        Assertions.assertEquals((Object)foobarA._scontext, (Object)rootA._scontext.getContext("/foo/bar"));
        Assertions.assertEquals((Object)foobarA._scontext, (Object)rootA._scontext.getContext("/foo/bar/bob"));
        Assertions.assertEquals((Object)rootA._scontext, (Object)rootA._scontext.getContext("/other"));
        Assertions.assertEquals((Object)rootB._scontext, (Object)rootB._scontext.getContext("/other"));
        Assertions.assertEquals((Object)rootC._scontext, (Object)rootC._scontext.getContext("/other"));
        Assertions.assertEquals((Object)fooB._scontext, (Object)rootB._scontext.getContext("/foo/other"));
        Assertions.assertEquals((Object)rootC._scontext, (Object)rootC._scontext.getContext("/foo/other"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVirtualHostWildcard() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.setConnectors(new Connector[]{connector});
        ContextHandler context = new ContextHandler("/");
        IsHandledHandler handler = new IsHandledHandler();
        context.setHandler((Handler)handler);
        server.setHandler((Handler)context);
        try {
            server.start();
            this.checkWildcardHost(true, server, null, new String[]{"example.com", ".example.com", "vhost.example.com"});
            this.checkWildcardHost(false, server, new String[]{null}, new String[]{"example.com", ".example.com", "vhost.example.com"});
            this.checkWildcardHost(true, server, new String[]{"example.com", "*.example.com"}, new String[]{"example.com", ".example.com", "vhost.example.com"});
            this.checkWildcardHost(false, server, new String[]{"example.com", "*.example.com"}, new String[]{"badexample.com", ".badexample.com", "vhost.badexample.com"});
            this.checkWildcardHost(false, server, new String[]{"*."}, new String[]{"anything.anything"});
            this.checkWildcardHost(true, server, new String[]{"*.example.com"}, new String[]{"vhost.example.com", ".example.com"});
            this.checkWildcardHost(false, server, new String[]{"*.example.com"}, new String[]{"vhost.www.example.com", "example.com", "www.vhost.example.com"});
            this.checkWildcardHost(true, server, new String[]{"*.sub.example.com"}, new String[]{"vhost.sub.example.com", ".sub.example.com"});
            this.checkWildcardHost(false, server, new String[]{"*.sub.example.com"}, new String[]{".example.com", "sub.example.com", "vhost.example.com"});
            this.checkWildcardHost(false, server, new String[]{"example.*.com", "example.com.*"}, new String[]{"example.vhost.com", "example.com.vhost", "example.com"});
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testVirtualHostManagement() {
        ContextHandler context = new ContextHandler("/");
        context.setVirtualHosts(new String[]{"www.example.com"});
        Assertions.assertEquals((int)1, (int)context.getVirtualHosts().length);
        context.addVirtualHosts(new String[]{"foo.com@connector1", "*.example2.com"});
        Assertions.assertEquals((int)3, (int)context.getVirtualHosts().length);
        context.addVirtualHosts(new String[]{"www.example.com"});
        Assertions.assertEquals((int)3, (int)context.getVirtualHosts().length);
        context.removeVirtualHosts(new String[]{"*.example2.com"});
        Assertions.assertEquals((int)2, (int)context.getVirtualHosts().length);
        context.removeVirtualHosts(new String[]{"www.example3.com"});
        Assertions.assertEquals((int)2, (int)context.getVirtualHosts().length);
        context.removeVirtualHosts(new String[]{"www.example.com", "foo.com@connector1"});
        Assertions.assertArrayEquals(null, (Object[])context.getVirtualHosts());
    }

    @Test
    public void testAttributes() throws Exception {
        ContextHandler handler = new ContextHandler();
        handler.setServer(new Server());
        handler.setAttribute("aaa", (Object)"111");
        Assertions.assertEquals((Object)"111", (Object)handler.getServletContext().getAttribute("aaa"));
        Assertions.assertEquals(null, (Object)handler.getAttribute("bbb"));
        handler.start();
        handler.getServletContext().setAttribute("aaa", (Object)"000");
        handler.setAttribute("ccc", (Object)"333");
        handler.getServletContext().setAttribute("ddd", (Object)"444");
        Assertions.assertEquals((Object)"111", (Object)handler.getServletContext().getAttribute("aaa"));
        Assertions.assertEquals(null, (Object)handler.getServletContext().getAttribute("bbb"));
        handler.getServletContext().setAttribute("bbb", (Object)"222");
        Assertions.assertEquals((Object)"333", (Object)handler.getServletContext().getAttribute("ccc"));
        Assertions.assertEquals((Object)"444", (Object)handler.getServletContext().getAttribute("ddd"));
        Assertions.assertEquals((Object)"111", (Object)handler.getAttribute("aaa"));
        Assertions.assertEquals(null, (Object)handler.getAttribute("bbb"));
        Assertions.assertEquals((Object)"333", (Object)handler.getAttribute("ccc"));
        Assertions.assertEquals(null, (Object)handler.getAttribute("ddd"));
        handler.stop();
        Assertions.assertEquals((Object)"111", (Object)handler.getServletContext().getAttribute("aaa"));
        Assertions.assertEquals(null, (Object)handler.getServletContext().getAttribute("bbb"));
        Assertions.assertEquals((Object)"333", (Object)handler.getServletContext().getAttribute("ccc"));
        Assertions.assertEquals(null, (Object)handler.getServletContext().getAttribute("ddd"));
    }

    @Test
    public void testProtected() throws Exception {
        ContextHandler handler = new ContextHandler();
        String[] protectedTargets = new String[]{"/foo-inf", "/bar-inf"};
        handler.setProtectedTargets(protectedTargets);
        Assertions.assertTrue((boolean)handler.isProtectedTarget("/foo-inf/x/y/z"));
        Assertions.assertFalse((boolean)handler.isProtectedTarget("/foo/x/y/z"));
        Assertions.assertTrue((boolean)handler.isProtectedTarget("/foo-inf?x=y&z=1"));
        Assertions.assertFalse((boolean)handler.isProtectedTarget("/foo-inf-bar"));
        protectedTargets = new String[4];
        System.arraycopy(handler.getProtectedTargets(), 0, protectedTargets, 0, 2);
        protectedTargets[2] = "/abc";
        protectedTargets[3] = "/def";
        handler.setProtectedTargets(protectedTargets);
        Assertions.assertTrue((boolean)handler.isProtectedTarget("/foo-inf/x/y/z"));
        Assertions.assertFalse((boolean)handler.isProtectedTarget("/foo/x/y/z"));
        Assertions.assertTrue((boolean)handler.isProtectedTarget("/foo-inf?x=y&z=1"));
        Assertions.assertTrue((boolean)handler.isProtectedTarget("/abc/124"));
        Assertions.assertTrue((boolean)handler.isProtectedTarget("//def"));
        Assertions.assertTrue((boolean)handler.isProtectedTarget("/ABC/7777"));
    }

    @Test
    public void testIsShutdown() {
        ContextHandler handler = new ContextHandler();
        Assertions.assertEquals((Object)false, (Object)handler.isShutdown());
    }

    @Test
    public void testLogNameFromDisplayName() throws Exception {
        ContextHandler handler = new ContextHandler();
        handler.setServer(new Server());
        handler.setDisplayName("An Interesting Project: app.tast.ic");
        try {
            handler.start();
            MatcherAssert.assertThat((String)"handler.get", (Object)handler.getLogger().getName(), (Matcher)Matchers.is((Object)(ContextHandler.class.getName() + ".An_Interesting_Project__app_tast_ic")));
        }
        finally {
            handler.stop();
        }
    }

    @Test
    public void testLogNameFromContextPathDeep() throws Exception {
        ContextHandler handler = new ContextHandler();
        handler.setServer(new Server());
        handler.setContextPath("/app/tast/ic");
        try {
            handler.start();
            MatcherAssert.assertThat((String)"handler.get", (Object)handler.getLogger().getName(), (Matcher)Matchers.is((Object)(ContextHandler.class.getName() + ".app_tast_ic")));
        }
        finally {
            handler.stop();
        }
    }

    @Test
    public void testLogNameFromContextPathRoot() throws Exception {
        ContextHandler handler = new ContextHandler();
        handler.setServer(new Server());
        handler.setContextPath("");
        try {
            handler.start();
            MatcherAssert.assertThat((String)"handler.get", (Object)handler.getLogger().getName(), (Matcher)Matchers.is((Object)(ContextHandler.class.getName() + ".ROOT")));
        }
        finally {
            handler.stop();
        }
    }

    @Test
    public void testLogNameFromContextPathUndefined() throws Exception {
        ContextHandler handler = new ContextHandler();
        handler.setServer(new Server());
        try {
            handler.start();
            MatcherAssert.assertThat((String)"handler.get", (Object)handler.getLogger().getName(), (Matcher)Matchers.is((Object)(ContextHandler.class.getName() + ".ROOT")));
        }
        finally {
            handler.stop();
        }
    }

    @Test
    public void testLogNameFromContextPathEmpty() throws Exception {
        ContextHandler handler = new ContextHandler();
        handler.setServer(new Server());
        handler.setContextPath("");
        try {
            handler.start();
            MatcherAssert.assertThat((String)"handler.get", (Object)handler.getLogger().getName(), (Matcher)Matchers.is((Object)(ContextHandler.class.getName() + ".ROOT")));
        }
        finally {
            handler.stop();
        }
    }

    @Test
    public void testClassPathWithSpaces() throws IOException {
        ContextHandler handler = new ContextHandler();
        handler.setServer(new Server());
        handler.setContextPath("/");
        Path baseDir = MavenTestingUtils.getTargetTestingPath((String)"testClassPath_WithSpaces");
        FS.ensureEmpty((Path)baseDir);
        Path spacey = baseDir.resolve("and extra directory");
        FS.ensureEmpty((Path)spacey);
        Path jar = spacey.resolve("empty.jar");
        FS.touch((Path)jar);
        URLClassLoader cl = new URLClassLoader(new URL[]{jar.toUri().toURL()});
        handler.setClassLoader((ClassLoader)cl);
        String classpath = handler.getClassPath();
        MatcherAssert.assertThat((String)"classpath", (Object)classpath, (Matcher)Matchers.containsString((String)jar.toString()));
    }

    private void checkResourcePathsForExampleWebApp(String root) throws IOException {
        File testDirectory = this.setupTestDirectory();
        ContextHandler handler = new ContextHandler();
        Assertions.assertTrue((boolean)testDirectory.isDirectory(), (String)("Not a directory " + testDirectory));
        handler.setBaseResource(Resource.newResource((URL)Resource.toURL((File)testDirectory)));
        ArrayList paths = new ArrayList(handler.getResourcePaths(root));
        Assertions.assertEquals((int)2, (int)paths.size());
        Collections.sort(paths);
        Assertions.assertEquals((Object)"/WEB-INF/jsp/", paths.get(0));
        Assertions.assertEquals((Object)"/WEB-INF/web.xml", paths.get(1));
    }

    private File setupTestDirectory() throws IOException {
        Path root = this.workDir.getEmptyPathDir();
        Path webInfDir = root.resolve("WEB-INF");
        FS.ensureDirExists((Path)webInfDir);
        FS.ensureDirExists((Path)webInfDir.resolve("jsp"));
        FS.touch((Path)webInfDir.resolve("web.xml"));
        return root.toFile();
    }

    private void checkWildcardHost(boolean succeed, Server server, String[] contextHosts, String[] requestHosts) throws Exception {
        LocalConnector connector = (LocalConnector)server.getConnectors()[0];
        ContextHandler context = (ContextHandler)server.getHandler();
        context.setVirtualHosts(contextHosts);
        IsHandledHandler handler = (IsHandledHandler)context.getHandler();
        for (String host : requestHosts) {
            connector.getResponse("GET / HTTP/1.1\nHost: " + host + "\nConnection:close\n\n");
            if (succeed) {
                Assertions.assertTrue((boolean)handler.isHandled(), (String)("'" + host + "' should have been handled."));
            } else {
                Assertions.assertFalse((boolean)handler.isHandled(), (String)("'" + host + "' should not have been handled."));
            }
            handler.reset();
        }
    }

    private static class TestServletContextListener
    implements ServletContextListener {
        public int initialized = 0;
        public int destroyed = 0;

        private TestServletContextListener() {
        }

        public void contextInitialized(ServletContextEvent sce) {
            ++this.initialized;
        }

        public void contextDestroyed(ServletContextEvent sce) {
            ++this.destroyed;
        }
    }

    private static final class ContextPathHandler
    extends AbstractHandler {
        private ContextPathHandler() {
        }

        public void handle(String s, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            baseRequest.setHandled(true);
            response.setStatus(200);
            response.setContentType("text/plain; charset=utf-8");
            response.setHeader("Connection", "close");
            PrintWriter writer = response.getWriter();
            writer.println("ctx='" + request.getContextPath() + "'");
        }
    }

    private static final class IsHandledHandler
    extends AbstractHandler {
        private boolean handled;

        private IsHandledHandler() {
        }

        public boolean isHandled() {
            return this.handled;
        }

        public void handle(String s, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
            baseRequest.setHandled(true);
            this.handled = true;
        }

        public void reset() {
            this.handled = false;
        }
    }
}

