/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.LeakTrackingByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.DebugHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DebugHandlerTest {
    public static final HostnameVerifier __hostnameverifier = (hostname, session) -> true;
    private SSLContext sslContext;
    private Server server;
    private URI serverURI;
    private URI secureServerURI;
    private DebugHandler debugHandler;
    private ByteArrayOutputStream capturedLog;

    @BeforeEach
    public void startServer() throws Exception {
        this.server = new Server();
        ServerConnector httpConnector = new ServerConnector(this.server);
        httpConnector.setPort(0);
        this.server.addConnector((Connector)httpConnector);
        File keystorePath = MavenTestingUtils.getTestResourceFile((String)"keystore.p12");
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystorePath.getAbsolutePath());
        sslContextFactory.setKeyStorePassword("storepwd");
        LeakTrackingByteBufferPool pool = new LeakTrackingByteBufferPool((ByteBufferPool)new MappedByteBufferPool.Tagged());
        ServerConnector sslConnector = new ServerConnector(this.server, null, null, (ByteBufferPool)pool, 1, 1, AbstractConnectionFactory.getFactories((SslContextFactory.Server)sslContextFactory, (ConnectionFactory[])new ConnectionFactory[]{new HttpConnectionFactory()}));
        this.server.addConnector((Connector)sslConnector);
        this.debugHandler = new DebugHandler();
        this.capturedLog = new ByteArrayOutputStream();
        this.debugHandler.setOutputStream((OutputStream)this.capturedLog);
        this.debugHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                baseRequest.setHandled(true);
                response.setStatus(200);
            }
        });
        this.server.setHandler((Handler)this.debugHandler);
        this.server.start();
        String host = httpConnector.getHost();
        if (host == null) {
            host = "localhost";
        }
        this.serverURI = URI.create(String.format("http://%s:%d/", host, httpConnector.getLocalPort()));
        this.secureServerURI = URI.create(String.format("https://%s:%d/", host, sslConnector.getLocalPort()));
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream stream = sslContextFactory.getKeyStoreResource().getInputStream();){
            keystore.load(stream, "storepwd".toCharArray());
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keystore);
        this.sslContext = SSLContext.getInstance("TLS");
        this.sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
        try {
            HttpsURLConnection.setDefaultHostnameVerifier(__hostnameverifier);
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, SslContextFactory.TRUST_ALL_CERTS, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @AfterEach
    public void stopServer() throws Exception {
        this.server.stop();
    }

    @Test
    public void testThreadName() throws IOException {
        HttpURLConnection http = (HttpURLConnection)this.serverURI.resolve("/foo/bar?a=b").toURL().openConnection();
        MatcherAssert.assertThat((String)"Response Code", (Object)http.getResponseCode(), (Matcher)Matchers.is((Object)200));
        String log = this.capturedLog.toString(StandardCharsets.UTF_8.name());
        String expectedThreadName = ":/foo/bar?a=b";
        MatcherAssert.assertThat((String)"ThreadName", (Object)log, (Matcher)Matchers.containsString((String)expectedThreadName));
        MatcherAssert.assertThat((String)"ThreadName", (Object)log, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)("http:" + expectedThreadName))));
        MatcherAssert.assertThat((String)"ThreadName", (Object)log, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)("https:" + expectedThreadName))));
    }

    @Test
    public void testSecureThreadName() throws IOException {
        HttpURLConnection http = (HttpURLConnection)this.secureServerURI.resolve("/foo/bar?a=b").toURL().openConnection();
        MatcherAssert.assertThat((String)"Response Code", (Object)http.getResponseCode(), (Matcher)Matchers.is((Object)200));
        String log = this.capturedLog.toString(StandardCharsets.UTF_8.name());
        String expectedThreadName = ":/foo/bar?a=b";
        MatcherAssert.assertThat((String)"ThreadName", (Object)log, (Matcher)Matchers.containsString((String)expectedThreadName));
        MatcherAssert.assertThat((String)"ThreadName", (Object)log, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)("http:" + expectedThreadName))));
        MatcherAssert.assertThat((String)"ThreadName", (Object)log, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)("https:" + expectedThreadName))));
    }
}

