/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultHandlerTest {
    private Server server;
    private ServerConnector connector;
    private DefaultHandler handler;

    @BeforeEach
    public void before() throws Exception {
        this.server = new Server();
        this.connector = new ServerConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.handler = new DefaultHandler();
        this.server.setHandler((Handler)new HandlerList(new Handler[]{contexts, this.handler}));
        this.handler.setServeIcon(true);
        this.handler.setShowContexts(true);
        contexts.addHandler((Handler)new ContextHandler("/foo"));
        contexts.addHandler((Handler)new ContextHandler("/bar"));
        this.server.start();
    }

    @AfterEach
    public void after() throws Exception {
        this.server.stop();
    }

    @Test
    public void testRoot() throws Exception {
        try (Socket socket = new Socket("localhost", this.connector.getLocalPort());){
            String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
            OutputStream output = socket.getOutputStream();
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            HttpTester.Input input = HttpTester.from((InputStream)socket.getInputStream());
            HttpTester.Response response = HttpTester.parseResponse((HttpTester.Input)input);
            Assertions.assertEquals((int)404, (int)response.getStatus());
            Assertions.assertEquals((Object)"text/html;charset=UTF-8", (Object)response.get(HttpHeader.CONTENT_TYPE));
            String content = new String(response.getContentBytes(), StandardCharsets.UTF_8);
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"Contexts known to this server are:"));
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"/foo"));
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"/bar"));
        }
    }

    @Test
    public void testSomePath() throws Exception {
        try (Socket socket = new Socket("localhost", this.connector.getLocalPort());){
            String request = "GET /some/path HTTP/1.1\r\nHost: localhost\r\n\r\n";
            OutputStream output = socket.getOutputStream();
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            HttpTester.Input input = HttpTester.from((InputStream)socket.getInputStream());
            HttpTester.Response response = HttpTester.parseResponse((HttpTester.Input)input);
            Assertions.assertEquals((int)404, (int)response.getStatus());
            Assertions.assertEquals((Object)"text/html;charset=ISO-8859-1", (Object)response.get(HttpHeader.CONTENT_TYPE));
            String content = new String(response.getContentBytes(), StandardCharsets.ISO_8859_1);
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Contexts known to this server are:")));
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"/foo")));
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"/bar")));
        }
    }

    @Test
    public void testFavIcon() throws Exception {
        try (Socket socket = new Socket("localhost", this.connector.getLocalPort());){
            String request = "GET /favicon.ico HTTP/1.1\r\nHost: localhost\r\n\r\n";
            OutputStream output = socket.getOutputStream();
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            HttpTester.Input input = HttpTester.from((InputStream)socket.getInputStream());
            HttpTester.Response response = HttpTester.parseResponse((HttpTester.Input)input);
            Assertions.assertEquals((int)200, (int)response.getStatus());
            Assertions.assertEquals((Object)"image/x-icon", (Object)response.get(HttpHeader.CONTENT_TYPE));
        }
    }
}

