/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;

public class ResourceHandlerTest {
    private static String LN = System.getProperty("line.separator");
    private static Server _server;
    private static HttpConfiguration _config;
    private static ServerConnector _connector;
    private static LocalConnector _local;
    private static ContextHandler _contextHandler;
    private static ResourceHandler _resourceHandler;

    @BeforeAll
    public static void setUp() throws Exception {
        File dir = MavenTestingUtils.getTargetFile((String)"test-classes/simple");
        File bigger = new File(dir, "bigger.txt");
        File big = new File(dir, "big.txt");
        try (FileOutputStream out = new FileOutputStream(bigger);){
            for (int i = 0; i < 100; ++i) {
                try (FileInputStream in = new FileInputStream(big);){
                    IO.copy((InputStream)in, (OutputStream)out);
                    continue;
                }
            }
        }
        bigger.deleteOnExit();
        LN = System.getProperty("line.separator");
        try (BufferedReader reader = Files.newBufferedReader(big.toPath(), StandardCharsets.UTF_8);){
            char[] cbuf = new char[128];
            reader.read(cbuf);
            String sample = new String(cbuf);
            LN = sample.contains("\r\n") ? "\r\n" : (sample.contains("\n\r") ? "\n\r" : "\n");
        }
        _server = new Server();
        _config = new HttpConfiguration();
        _config.setOutputBufferSize(2048);
        _connector = new ServerConnector(_server, new ConnectionFactory[]{new HttpConnectionFactory(_config)});
        _local = new LocalConnector(_server);
        _server.setConnectors(new Connector[]{_connector, _local});
        _resourceHandler = new ResourceHandler();
        _resourceHandler.setResourceBase(MavenTestingUtils.getTargetFile((String)"test-classes/simple").getAbsolutePath());
        _resourceHandler.setWelcomeFiles(new String[]{"welcome.txt"});
        _contextHandler = new ContextHandler("/resource");
        _contextHandler.setHandler((Handler)_resourceHandler);
        _server.setHandler((Handler)_contextHandler);
        _server.start();
    }

    @AfterAll
    public static void tearDown() throws Exception {
        _server.stop();
    }

    @BeforeEach
    public void before() {
        _config.setOutputBufferSize(4096);
    }

    @Test
    public void testJettyDirRedirect() throws Exception {
        HttpTester.Response response = HttpTester.parseResponse((String)_local.getResponse("GET /resource HTTP/1.0\r\n\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)302));
        MatcherAssert.assertThat((Object)response.get(HttpHeader.LOCATION), (Matcher)Matchers.containsString((String)"/resource/"));
    }

    @Test
    public void testJettyDirListing() throws Exception {
        HttpTester.Response response = HttpTester.parseResponse((String)_local.getResponse("GET /resource/ HTTP/1.0\r\n\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"jetty-dir.css"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"Directory: /resource/"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"big.txt"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"bigger.txt"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"directory"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"simple.txt"));
    }

    @Test
    public void testHeaders() throws Exception {
        HttpTester.Response response = HttpTester.parseResponse((String)_local.getResponse("GET /resource/simple.txt HTTP/1.0\r\n\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.equalTo((Object)"text/plain"));
        MatcherAssert.assertThat((Object)response.get(HttpHeader.LAST_MODIFIED), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)response.get(HttpHeader.CONTENT_LENGTH), (Matcher)Matchers.equalTo((Object)"11"));
        MatcherAssert.assertThat((Object)response.get(HttpHeader.SERVER), (Matcher)Matchers.containsString((String)"Jetty"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"simple text"));
    }

    @Test
    public void testIfModifiedSince() throws Exception {
        HttpTester.Response response = HttpTester.parseResponse((String)_local.getResponse("GET /resource/simple.txt HTTP/1.0\r\n\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.get(HttpHeader.LAST_MODIFIED), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"simple text"));
        String lastModified = response.get(HttpHeader.LAST_MODIFIED);
        response = HttpTester.parseResponse((String)_local.getResponse("GET /resource/simple.txt HTTP/1.0\r\nIf-Modified-Since: " + lastModified + "\r\n\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)304));
    }

    @Test
    public void testBigFile() throws Exception {
        _config.setOutputBufferSize(2048);
        HttpTester.Response response = HttpTester.parseResponse((String)_local.getResponse("GET /resource/big.txt HTTP/1.0\r\n\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.startsWith((String)"     1\tThis is a big file"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.endsWith((String)("   400\tThis is a big file" + LN)));
    }

    @Test
    public void testBigFileBigBuffer() throws Exception {
        _config.setOutputBufferSize(16384);
        HttpTester.Response response = HttpTester.parseResponse((String)_local.getResponse("GET /resource/big.txt HTTP/1.0\r\n\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.startsWith((String)"     1\tThis is a big file"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.endsWith((String)("   400\tThis is a big file" + LN)));
    }

    @Test
    public void testBigFileLittleBuffer() throws Exception {
        _config.setOutputBufferSize(8);
        HttpTester.Response response = HttpTester.parseResponse((String)_local.getResponse("GET /resource/big.txt HTTP/1.0\r\n\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.startsWith((String)"     1\tThis is a big file"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.endsWith((String)("   400\tThis is a big file" + LN)));
    }

    @Test
    public void testBigger() throws Exception {
        try (Socket socket = new Socket("localhost", _connector.getLocalPort());){
            socket.getOutputStream().write("GET /resource/bigger.txt HTTP/1.0\n\n".getBytes());
            Thread.sleep(1000L);
            String response = IO.toString((InputStream)socket.getInputStream());
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)("   400\tThis is a big file" + LN + "     1\tThis is a big file")));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)("   400\tThis is a big file" + LN)));
        }
    }

    @Test
    public void testWelcome() throws Exception {
        HttpTester.Response response = HttpTester.parseResponse((String)_local.getResponse("GET /resource/directory/ HTTP/1.0\r\n\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"Hello"));
    }

    @Test
    public void testWelcomeRedirect() throws Exception {
        try {
            _resourceHandler.setRedirectWelcome(true);
            HttpTester.Response response = HttpTester.parseResponse((String)_local.getResponse("GET /resource/directory/ HTTP/1.0\r\n\r\n"));
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)302));
            MatcherAssert.assertThat((Object)response.get(HttpHeader.LOCATION), (Matcher)Matchers.containsString((String)"/resource/directory/welcome.txt"));
        }
        finally {
            _resourceHandler.setRedirectWelcome(false);
        }
    }

    @Test
    @DisabledIfSystemProperty(named="env", matches="ci")
    public void testSlowBiggest() throws Exception {
        InputStream in;
        _connector.setIdleTimeout(9000L);
        File dir = MavenTestingUtils.getTargetFile((String)"test-classes/simple");
        File biggest = new File(dir, "biggest.txt");
        try (FileOutputStream out = new FileOutputStream(biggest);){
            for (int i = 0; i < 10; ++i) {
                in = new FileInputStream(new File(dir, "bigger.txt"));
                try {
                    IO.copy((InputStream)in, (OutputStream)out);
                    continue;
                }
                finally {
                    in.close();
                }
            }
            ((OutputStream)out).write("\nTHE END\n".getBytes(StandardCharsets.ISO_8859_1));
        }
        biggest.deleteOnExit();
        try (Socket socket = new Socket("localhost", _connector.getLocalPort());
             OutputStream out = socket.getOutputStream();){
            in = socket.getInputStream();
            try {
                socket.getOutputStream().write("GET /resource/biggest.txt HTTP/1.0\n\n".getBytes());
                byte[] array = new byte[102400];
                Buffer buffer = null;
                while (true) {
                    Thread.sleep(25L);
                    int len = in.read(array);
                    if (len < 0) break;
                    buffer = BufferUtil.toBuffer((byte[])array, (int)0, (int)len);
                }
                Assertions.assertEquals((int)69, (int)((ByteBuffer)buffer).get(buffer.limit() - 4));
                Assertions.assertEquals((int)78, (int)((ByteBuffer)buffer).get(buffer.limit() - 3));
                Assertions.assertEquals((int)68, (int)((ByteBuffer)buffer).get(buffer.limit() - 2));
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    @Test
    public void testConditionalGetResponseCommitted() throws Exception {
        _config.setOutputBufferSize(8);
        _resourceHandler.setEtags(true);
        HttpTester.Response response = HttpTester.parseResponse((String)_local.getResponse("GET /resource/big.txt HTTP/1.0\r\nIf-Match: \"NO_MATCH\"\r\n\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)412));
    }

    @Test
    public void testConditionalHeadResponseCommitted() throws Exception {
        _config.setOutputBufferSize(8);
        _resourceHandler.setEtags(true);
        HttpTester.Response response = HttpTester.parseResponse((String)_local.getResponse("HEAD /resource/big.txt HTTP/1.0\r\nIf-Match: \"NO_MATCH\"\r\n\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)412));
    }
}

