/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ScopedHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ScopedHandlerTest {
    private StringBuilder _history = new StringBuilder();

    @BeforeEach
    public void resetHistory() {
        this._history.setLength(0);
    }

    @Test
    public void testSingle() throws Exception {
        TestHandler handler0 = new TestHandler("0");
        handler0.setServer(new Server());
        handler0.start();
        handler0.handle("target", null, null, null);
        handler0.stop();
        String history = this._history.toString();
        Assertions.assertEquals((Object)">S0>W0<W0<S0", (Object)history);
    }

    @Test
    public void testSimpleDouble() throws Exception {
        TestHandler handler0 = new TestHandler("0");
        TestHandler handler1 = new TestHandler("1");
        handler0.setServer(new Server());
        handler1.setServer(handler0.getServer());
        handler0.setHandler((Handler)handler1);
        handler0.start();
        handler0.handle("target", null, null, null);
        handler0.stop();
        String history = this._history.toString();
        Assertions.assertEquals((Object)">S0>S1>W0>W1<W1<W0<S1<S0", (Object)history);
    }

    @Test
    public void testSimpleTriple() throws Exception {
        TestHandler handler0 = new TestHandler("0");
        TestHandler handler1 = new TestHandler("1");
        TestHandler handler2 = new TestHandler("2");
        handler0.setServer(new Server());
        handler1.setServer(handler0.getServer());
        handler2.setServer(handler0.getServer());
        handler0.setHandler((Handler)handler1);
        handler1.setHandler((Handler)handler2);
        handler0.start();
        handler0.handle("target", null, null, null);
        handler0.stop();
        String history = this._history.toString();
        Assertions.assertEquals((Object)">S0>S1>S2>W0>W1>W2<W2<W1<W0<S2<S1<S0", (Object)history);
    }

    @Test
    public void testDouble() throws Exception {
        Request request = new Request(null, null);
        Response response = new Response(null, null);
        TestHandler handler0 = new TestHandler("0");
        OtherHandler handlerA = new OtherHandler("A");
        TestHandler handler1 = new TestHandler("1");
        OtherHandler handlerB = new OtherHandler("B");
        handler0.setServer(new Server());
        handlerA.setServer(handler0.getServer());
        handler1.setServer(handler0.getServer());
        handlerB.setServer(handler0.getServer());
        handler0.setHandler((Handler)handlerA);
        handlerA.setHandler((Handler)handler1);
        handler1.setHandler((Handler)handlerB);
        handler0.start();
        handler0.handle("target", request, (HttpServletRequest)request, (HttpServletResponse)response);
        handler0.stop();
        String history = this._history.toString();
        Assertions.assertEquals((Object)">S0>S1>W0>HA>W1>HB<HB<W1<HA<W0<S1<S0", (Object)history);
    }

    @Test
    public void testTriple() throws Exception {
        Request request = new Request(null, null);
        Response response = new Response(null, null);
        TestHandler handler0 = new TestHandler("0");
        OtherHandler handlerA = new OtherHandler("A");
        TestHandler handler1 = new TestHandler("1");
        OtherHandler handlerB = new OtherHandler("B");
        TestHandler handler2 = new TestHandler("2");
        OtherHandler handlerC = new OtherHandler("C");
        handler0.setServer(new Server());
        handlerA.setServer(handler0.getServer());
        handler1.setServer(handler0.getServer());
        handlerB.setServer(handler0.getServer());
        handler2.setServer(handler0.getServer());
        handlerC.setServer(handler0.getServer());
        handler0.setHandler((Handler)handlerA);
        handlerA.setHandler((Handler)handler1);
        handler1.setHandler((Handler)handlerB);
        handlerB.setHandler((Handler)handler2);
        handler2.setHandler((Handler)handlerC);
        handler0.start();
        handler0.handle("target", request, (HttpServletRequest)request, (HttpServletResponse)response);
        handler0.stop();
        String history = this._history.toString();
        Assertions.assertEquals((Object)">S0>S1>S2>W0>HA>W1>HB>W2>HC<HC<W2<HB<W1<HA<W0<S2<S1<S0", (Object)history);
    }

    private class OtherHandler
    extends HandlerWrapper {
        private final String _name;

        private OtherHandler(String name) {
            this._name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            try {
                ScopedHandlerTest.this._history.append(">H").append(this._name);
                super.handle(target, baseRequest, request, response);
            }
            finally {
                ScopedHandlerTest.this._history.append("<H").append(this._name);
            }
        }
    }

    private class TestHandler
    extends ScopedHandler {
        private final String _name;

        private TestHandler(String name) {
            this._name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            try {
                ScopedHandlerTest.this._history.append(">S").append(this._name);
                super.nextScope(target, baseRequest, request, response);
            }
            finally {
                ScopedHandlerTest.this._history.append("<S").append(this._name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            try {
                ScopedHandlerTest.this._history.append(">W").append(this._name);
                super.nextHandle(target, baseRequest, request, response);
            }
            finally {
                ScopedHandlerTest.this._history.append("<W").append(this._name);
            }
        }
    }
}

