/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.AllowAllVerifier;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import org.eclipse.jetty.toolchain.test.IO;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SecuredRedirectHandlerTest {
    private static Server server;
    private static HostnameVerifier origVerifier;
    private static SSLSocketFactory origSsf;
    private static URI serverHttpUri;
    private static URI serverHttpsUri;

    @BeforeAll
    public static void startServer() throws Exception {
        File keystore = MavenTestingUtils.getTestResourceFile((String)"keystore.p12");
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystore.getAbsolutePath());
        sslContextFactory.setKeyStorePassword("storepwd");
        server = new Server();
        int port = 32080;
        int securePort = 32443;
        HttpConfiguration httpConf = new HttpConfiguration();
        httpConf.setSecurePort(securePort);
        httpConf.setSecureScheme("https");
        ServerConnector httpConnector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConf)});
        httpConnector.setName("unsecured");
        httpConnector.setPort(port);
        HttpConfiguration httpsConf = new HttpConfiguration(httpConf);
        httpsConf.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector httpsConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsConf)});
        httpsConnector.setName("secured");
        httpsConnector.setPort(securePort);
        server.setConnectors(new Connector[]{httpConnector, httpsConnector});
        String[] secureHosts = new String[]{"@secured"};
        ContextHandler test1Context = new ContextHandler();
        test1Context.setContextPath("/test1");
        test1Context.setHandler((Handler)new HelloHandler("Hello1"));
        test1Context.setVirtualHosts(secureHosts);
        ContextHandler test2Context = new ContextHandler();
        test2Context.setContextPath("/test2");
        test2Context.setHandler((Handler)new HelloHandler("Hello2"));
        test2Context.setVirtualHosts(secureHosts);
        ContextHandler rootContext = new ContextHandler();
        rootContext.setContextPath("/");
        rootContext.setHandler((Handler)new RootHandler("/test1", "/test2"));
        rootContext.setVirtualHosts(secureHosts);
        ContextHandler redirectHandler = new ContextHandler();
        redirectHandler.setContextPath("/");
        redirectHandler.setHandler((Handler)new SecuredRedirectHandler());
        redirectHandler.setVirtualHosts(new String[]{"@unsecured"});
        ContextHandlerCollection contextHandlers = new ContextHandlerCollection();
        contextHandlers.setHandlers(new Handler[]{redirectHandler, rootContext, test1Context, test2Context});
        server.setHandler((Handler)new HandlerList(new Handler[]{contextHandlers, new DefaultHandler()}));
        server.start();
        String host = httpConnector.getHost();
        if (host == null) {
            host = "localhost";
        }
        serverHttpUri = new URI(String.format("http://%s:%d/", host, httpConnector.getLocalPort()));
        serverHttpsUri = new URI(String.format("https://%s:%d/", host, httpsConnector.getLocalPort()));
        origVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        origSsf = HttpsURLConnection.getDefaultSSLSocketFactory();
        HttpsURLConnection.setDefaultHostnameVerifier(new AllowAllVerifier());
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContextFactory.getSslContext().getSocketFactory());
    }

    @AfterAll
    public static void stopServer() throws Exception {
        HttpsURLConnection.setDefaultSSLSocketFactory(origSsf);
        HttpsURLConnection.setDefaultHostnameVerifier(origVerifier);
        server.stop();
        server.join();
    }

    @Test
    public void testRedirectUnsecuredRoot() throws Exception {
        URL url = serverHttpUri.resolve("/").toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setAllowUserInteraction(false);
        MatcherAssert.assertThat((String)"response code", (Object)connection.getResponseCode(), (Matcher)Matchers.is((Object)302));
        MatcherAssert.assertThat((String)"location header", (Object)connection.getHeaderField("Location"), (Matcher)Matchers.is((Object)serverHttpsUri.resolve("/").toASCIIString()));
        connection.disconnect();
    }

    @Test
    public void testRedirectSecuredRoot() throws Exception {
        URL url = serverHttpsUri.resolve("/").toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setAllowUserInteraction(false);
        MatcherAssert.assertThat((String)"response code", (Object)connection.getResponseCode(), (Matcher)Matchers.is((Object)200));
        String content = this.getContent(connection);
        MatcherAssert.assertThat((String)"response content", (Object)content, (Matcher)Matchers.containsString((String)"<a href=\"/test1\">"));
        connection.disconnect();
    }

    @Test
    public void testAccessUnsecuredHandler() throws Exception {
        URL url = serverHttpUri.resolve("/test1").toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setAllowUserInteraction(false);
        MatcherAssert.assertThat((String)"response code", (Object)connection.getResponseCode(), (Matcher)Matchers.is((Object)302));
        MatcherAssert.assertThat((String)"location header", (Object)connection.getHeaderField("Location"), (Matcher)Matchers.is((Object)serverHttpsUri.resolve("/test1").toASCIIString()));
        connection.disconnect();
    }

    @Test
    public void testAccessUnsecured404() throws Exception {
        URL url = serverHttpUri.resolve("/nothing/here").toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setAllowUserInteraction(false);
        MatcherAssert.assertThat((String)"response code", (Object)connection.getResponseCode(), (Matcher)Matchers.is((Object)302));
        MatcherAssert.assertThat((String)"location header", (Object)connection.getHeaderField("Location"), (Matcher)Matchers.is((Object)serverHttpsUri.resolve("/nothing/here").toASCIIString()));
        connection.disconnect();
    }

    @Test
    public void testAccessSecured404() throws Exception {
        URL url = serverHttpsUri.resolve("/nothing/here").toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setAllowUserInteraction(false);
        MatcherAssert.assertThat((String)"response code", (Object)connection.getResponseCode(), (Matcher)Matchers.is((Object)404));
        connection.disconnect();
    }

    private String getContent(HttpURLConnection connection) throws IOException {
        try (InputStream in = connection.getInputStream();){
            String string;
            try (InputStreamReader reader = new InputStreamReader(in);){
                StringWriter writer = new StringWriter();
                IO.copy((Reader)reader, (Writer)writer);
                string = writer.toString();
            }
            return string;
        }
    }

    public static class RootHandler
    extends AbstractHandler {
        private final String[] childContexts;

        public RootHandler(String ... children) {
            this.childContexts = children;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (!"/".equals(target)) {
                baseRequest.setHandled(true);
                response.sendError(404);
                return;
            }
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println("<html>");
            out.println("<head><title>Contexts</title></head>");
            out.println("<body>");
            out.println("<h4>Child Contexts</h4>");
            out.println("<ul>");
            for (String child : this.childContexts) {
                out.printf("<li><a href=\"%s\">%s</a></li>%n", child, child);
            }
            out.println("</ul>");
            out.println("</body></html>");
            baseRequest.setHandled(true);
        }
    }

    public static class HelloHandler
    extends AbstractHandler {
        private final String msg;

        public HelloHandler(String msg) {
            this.msg = msg;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.setContentType("text/plain");
            response.getWriter().printf("%s%n", this.msg);
            baseRequest.setHandled(true);
        }
    }
}

