/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StatisticsHandlerTest {
    private Server _server;
    private ConnectionStatistics _statistics;
    private LocalConnector _connector;
    private LatchHandler _latchHandler;
    private StatisticsHandler _statsHandler;

    @BeforeEach
    public void init() throws Exception {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._statistics = new ConnectionStatistics();
        this._connector.addBean((Object)this._statistics);
        this._server.addConnector((Connector)this._connector);
        this._latchHandler = new LatchHandler();
        this._statsHandler = new StatisticsHandler();
        this._server.setHandler((Handler)this._latchHandler);
        this._latchHandler.setHandler((Handler)this._statsHandler);
    }

    @AfterEach
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testRequest() throws Exception {
        final CyclicBarrier[] barrier = new CyclicBarrier[]{new CyclicBarrier(2), new CyclicBarrier(2)};
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
                request.setHandled(true);
                try {
                    barrier[0].await();
                    barrier[1].await();
                }
                catch (Exception x) {
                    Thread.currentThread().interrupt();
                    throw new IOException(x);
                }
            }
        });
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        this._connector.executeRequest(request);
        barrier[0].await();
        Assertions.assertEquals((long)1L, (long)this._statistics.getConnections());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequestsActiveMax());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatchedActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatchedActiveMax());
        barrier[1].await();
        Assertions.assertTrue((boolean)this._latchHandler.await());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequestsActiveMax());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getDispatchedActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatchedActiveMax());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getAsyncRequests());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getAsyncDispatches());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getExpires());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getResponses2xx());
        this._latchHandler.reset();
        barrier[0].reset();
        barrier[1].reset();
        this._connector.executeRequest(request);
        barrier[0].await();
        Assertions.assertEquals((long)2L, (long)this._statistics.getConnections());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequestsActiveMax());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatchedActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatchedActiveMax());
        barrier[1].await();
        Assertions.assertTrue((boolean)this._latchHandler.await());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequestsActiveMax());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getDispatchedActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatchedActiveMax());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getAsyncRequests());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getAsyncDispatches());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getExpires());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getResponses2xx());
    }

    @Test
    public void testTwoRequests() throws Exception {
        final CyclicBarrier[] barrier = new CyclicBarrier[]{new CyclicBarrier(3), new CyclicBarrier(3)};
        this._latchHandler.reset(2);
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
                request.setHandled(true);
                try {
                    barrier[0].await();
                    barrier[1].await();
                }
                catch (Exception x) {
                    Thread.currentThread().interrupt();
                    throw new IOException(x);
                }
            }
        });
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        this._connector.executeRequest(request);
        this._connector.executeRequest(request);
        barrier[0].await();
        Assertions.assertEquals((long)2L, (long)this._statistics.getConnections());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getRequestsActiveMax());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getDispatchedActive());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getDispatchedActiveMax());
        barrier[1].await();
        Assertions.assertTrue((boolean)this._latchHandler.await());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getRequestsActiveMax());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getDispatchedActive());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getDispatchedActiveMax());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getAsyncRequests());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getAsyncDispatches());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getExpires());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getResponses2xx());
    }

    @Test
    public void testSuspendResume() throws Exception {
        long dispatchTime = 10L;
        long requestTime = 50L;
        final AtomicReference asyncHolder = new AtomicReference();
        final CyclicBarrier[] barrier = new CyclicBarrier[]{new CyclicBarrier(2), new CyclicBarrier(2), new CyclicBarrier(2)};
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException {
                request.setHandled(true);
                try {
                    barrier[0].await();
                    Thread.sleep(10L);
                    if (asyncHolder.get() == null) {
                        asyncHolder.set(request.startAsync());
                    }
                }
                catch (Exception x) {
                    throw new ServletException((Throwable)x);
                }
                finally {
                    try {
                        barrier[1].await();
                    }
                    catch (Exception exception) {}
                }
            }
        });
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        this._connector.executeRequest(request);
        barrier[0].await();
        Assertions.assertEquals((long)1L, (long)this._statistics.getConnections());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatchedActive());
        barrier[1].await();
        Assertions.assertTrue((boolean)this._latchHandler.await());
        Assertions.assertNotNull(asyncHolder.get());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getDispatchedActive());
        this._latchHandler.reset();
        barrier[0].reset();
        barrier[1].reset();
        Thread.sleep(50L);
        ((AsyncContext)asyncHolder.get()).addListener(new AsyncListener(){

            public void onTimeout(AsyncEvent event) {
            }

            public void onStartAsync(AsyncEvent event) {
            }

            public void onError(AsyncEvent event) {
            }

            public void onComplete(AsyncEvent event) {
                try {
                    barrier[2].await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        ((AsyncContext)asyncHolder.get()).dispatch();
        barrier[0].await();
        Assertions.assertEquals((long)1L, (long)this._statistics.getConnections());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatchedActive());
        barrier[1].await();
        Assertions.assertTrue((boolean)this._latchHandler.await());
        barrier[2].await();
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getDispatchedActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getAsyncRequests());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getAsyncDispatches());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getExpires());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getResponses2xx());
        MatcherAssert.assertThat((Object)this._statsHandler.getRequestTimeTotal(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(37L)));
        Assertions.assertEquals((long)this._statsHandler.getRequestTimeTotal(), (long)this._statsHandler.getRequestTimeMax());
        Assertions.assertEquals((double)this._statsHandler.getRequestTimeTotal(), (double)this._statsHandler.getRequestTimeMean(), (double)0.01);
        MatcherAssert.assertThat((Object)this._statsHandler.getDispatchedTimeTotal(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(15L)));
        Assertions.assertTrue((this._statsHandler.getDispatchedTimeMean() + 10.0 <= (double)this._statsHandler.getDispatchedTimeTotal() ? 1 : 0) != 0);
        Assertions.assertTrue((this._statsHandler.getDispatchedTimeMax() + 10L <= this._statsHandler.getDispatchedTimeTotal() ? 1 : 0) != 0);
    }

    @Test
    public void asyncDispatchTest() throws Exception {
        final AtomicReference asyncHolder = new AtomicReference();
        final CyclicBarrier[] barrier = new CyclicBarrier[]{new CyclicBarrier(2), new CyclicBarrier(2), new CyclicBarrier(2), new CyclicBarrier(2)};
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException {
                request.setHandled(true);
                try {
                    if (asyncHolder.get() == null) {
                        barrier[0].await();
                        barrier[1].await();
                        AsyncContext asyncContext = request.startAsync();
                        asyncHolder.set(asyncContext);
                        asyncContext.dispatch();
                    } else {
                        barrier[2].await();
                        barrier[3].await();
                    }
                }
                catch (Exception x) {
                    throw new ServletException((Throwable)x);
                }
            }
        });
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        this._connector.executeRequest(request);
        barrier[0].await();
        Assertions.assertEquals((long)1L, (long)this._statistics.getConnections());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatchedActive());
        barrier[1].await();
        barrier[2].await();
        Assertions.assertEquals((long)1L, (long)this._statistics.getConnections());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)2, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatchedActive());
        barrier[3].await();
    }

    @Test
    public void waitForSuspendedRequestTest() throws Exception {
        final CyclicBarrier barrier = new CyclicBarrier(3);
        final AtomicReference asyncHolder = new AtomicReference();
        final CountDownLatch dispatched = new CountDownLatch(1);
        this._statsHandler.setGracefulShutdownWaitsForRequests(true);
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException {
                request.setHandled(true);
                try {
                    if (path.contains("async")) {
                        asyncHolder.set(request.startAsync());
                        barrier.await();
                    } else {
                        barrier.await();
                        dispatched.await();
                    }
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
        });
        this._server.start();
        this._connector.executeRequest("GET / HTTP/1.1\r\nHost: localhost\r\n\r\n");
        this._connector.executeRequest("GET /async HTTP/1.1\r\nHost: localhost\r\n\r\n");
        barrier.await();
        AsyncContext asyncContext = Objects.requireNonNull((AsyncContext)asyncHolder.get());
        CompletableFuture shutdown = this._statsHandler.shutdown();
        Assertions.assertThrows(TimeoutException.class, () -> shutdown.get(1L, TimeUnit.SECONDS));
        dispatched.countDown();
        Assertions.assertThrows(TimeoutException.class, () -> shutdown.get(1L, TimeUnit.SECONDS));
        asyncContext.complete();
        shutdown.get(5L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void doNotWaitForSuspendedRequestTest() throws Exception {
        final CyclicBarrier barrier = new CyclicBarrier(3);
        final AtomicReference asyncHolder = new AtomicReference();
        final CountDownLatch dispatched = new CountDownLatch(1);
        this._statsHandler.setGracefulShutdownWaitsForRequests(false);
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException {
                request.setHandled(true);
                try {
                    if (path.contains("async")) {
                        asyncHolder.set(request.startAsync());
                        barrier.await();
                    } else {
                        barrier.await();
                        dispatched.await();
                    }
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
        });
        this._server.start();
        this._connector.executeRequest("GET / HTTP/1.1\r\nHost: localhost\r\n\r\n");
        this._connector.executeRequest("GET /async HTTP/1.1\r\nHost: localhost\r\n\r\n");
        barrier.await();
        Assertions.assertNotNull(asyncHolder.get());
        CompletableFuture shutdown = this._statsHandler.shutdown();
        Assertions.assertThrows(TimeoutException.class, () -> shutdown.get(1L, TimeUnit.SECONDS));
        dispatched.countDown();
        shutdown.get(5L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testSuspendExpire() throws Exception {
        long dispatchTime = 10L;
        long timeout = 100L;
        final AtomicReference asyncHolder = new AtomicReference();
        final CyclicBarrier[] barrier = new CyclicBarrier[]{new CyclicBarrier(2), new CyclicBarrier(2), new CyclicBarrier(2)};
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException {
                request.setHandled(true);
                try {
                    barrier[0].await();
                    Thread.sleep(10L);
                    if (asyncHolder.get() == null) {
                        AsyncContext async = request.startAsync();
                        asyncHolder.set(async);
                        async.setTimeout(100L);
                    }
                }
                catch (Exception x) {
                    throw new ServletException((Throwable)x);
                }
                finally {
                    try {
                        barrier[1].await();
                    }
                    catch (Exception exception) {}
                }
            }
        });
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        this._connector.executeRequest(request);
        barrier[0].await();
        Assertions.assertEquals((long)1L, (long)this._statistics.getConnections());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatchedActive());
        barrier[1].await();
        Assertions.assertTrue((boolean)this._latchHandler.await());
        Assertions.assertNotNull(asyncHolder.get());
        ((AsyncContext)asyncHolder.get()).addListener(new AsyncListener(){

            public void onTimeout(AsyncEvent event) {
                event.getAsyncContext().complete();
            }

            public void onStartAsync(AsyncEvent event) {
            }

            public void onError(AsyncEvent event) {
            }

            public void onComplete(AsyncEvent event) {
                try {
                    barrier[2].await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getDispatchedActive());
        barrier[2].await();
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getDispatchedActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getAsyncRequests());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getAsyncDispatches());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getExpires());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getResponses2xx());
        Assertions.assertTrue((this._statsHandler.getRequestTimeTotal() >= 82L ? 1 : 0) != 0);
        Assertions.assertEquals((long)this._statsHandler.getRequestTimeTotal(), (long)this._statsHandler.getRequestTimeMax());
        Assertions.assertEquals((double)this._statsHandler.getRequestTimeTotal(), (double)this._statsHandler.getRequestTimeMean(), (double)0.01);
        MatcherAssert.assertThat((Object)this._statsHandler.getDispatchedTimeTotal(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(7L)));
    }

    @Test
    public void testSuspendComplete() throws Exception {
        long dispatchTime = 10L;
        final AtomicReference asyncHolder = new AtomicReference();
        final CyclicBarrier[] barrier = new CyclicBarrier[]{new CyclicBarrier(2), new CyclicBarrier(2)};
        final CountDownLatch latch = new CountDownLatch(1);
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException {
                request.setHandled(true);
                try {
                    barrier[0].await();
                    Thread.sleep(10L);
                    if (asyncHolder.get() == null) {
                        AsyncContext async = request.startAsync();
                        asyncHolder.set(async);
                    }
                }
                catch (Exception x) {
                    throw new ServletException((Throwable)x);
                }
                finally {
                    try {
                        barrier[1].await();
                    }
                    catch (Exception exception) {}
                }
            }
        });
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        this._connector.executeRequest(request);
        barrier[0].await();
        Assertions.assertEquals((long)1L, (long)this._statistics.getConnections());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatchedActive());
        barrier[1].await();
        Assertions.assertTrue((boolean)this._latchHandler.await());
        Assertions.assertNotNull(asyncHolder.get());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getDispatchedActive());
        ((AsyncContext)asyncHolder.get()).addListener(new AsyncListener(){

            public void onTimeout(AsyncEvent event) {
            }

            public void onStartAsync(AsyncEvent event) {
            }

            public void onError(AsyncEvent event) {
            }

            public void onComplete(AsyncEvent event) {
                try {
                    latch.countDown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        long requestTime = 20L;
        Thread.sleep(requestTime);
        ((AsyncContext)asyncHolder.get()).complete();
        latch.await();
        Assertions.assertEquals((int)1, (int)this._statsHandler.getRequests());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getRequestsActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getDispatched());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getDispatchedActive());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getAsyncRequests());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getAsyncDispatches());
        Assertions.assertEquals((int)0, (int)this._statsHandler.getExpires());
        Assertions.assertEquals((int)1, (int)this._statsHandler.getResponses2xx());
        Assertions.assertTrue((this._statsHandler.getRequestTimeTotal() >= (10L + requestTime) * 3L / 4L ? 1 : 0) != 0);
        Assertions.assertEquals((long)this._statsHandler.getRequestTimeTotal(), (long)this._statsHandler.getRequestTimeMax());
        Assertions.assertEquals((double)this._statsHandler.getRequestTimeTotal(), (double)this._statsHandler.getRequestTimeMean(), (double)0.01);
        Assertions.assertTrue((this._statsHandler.getDispatchedTimeTotal() >= 7L ? 1 : 0) != 0);
        Assertions.assertTrue((this._statsHandler.getDispatchedTimeTotal() < this._statsHandler.getRequestTimeTotal() ? 1 : 0) != 0);
        Assertions.assertEquals((long)this._statsHandler.getDispatchedTimeTotal(), (long)this._statsHandler.getDispatchedTimeMax());
        Assertions.assertEquals((double)this._statsHandler.getDispatchedTimeTotal(), (double)this._statsHandler.getDispatchedTimeMean(), (double)0.01);
    }

    @Test
    public void testAsyncRequestWithShutdown() throws Exception {
        final long delay = 500L;
        final CountDownLatch serverLatch = new CountDownLatch(1);
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                AsyncContext asyncContext = request.startAsync();
                asyncContext.setTimeout(0L);
                new Thread(() -> {
                    try {
                        Thread.sleep(delay);
                        asyncContext.complete();
                    }
                    catch (InterruptedException e) {
                        response.setStatus(500);
                        asyncContext.complete();
                    }
                }).start();
                serverLatch.countDown();
            }
        });
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        this._connector.executeRequest(request);
        Assertions.assertTrue((boolean)serverLatch.await(5L, TimeUnit.SECONDS));
        CompletableFuture shutdown = this._statsHandler.shutdown();
        Assertions.assertFalse((boolean)shutdown.isDone());
        Thread.sleep(delay / 2L);
        Assertions.assertFalse((boolean)shutdown.isDone());
        Thread.sleep(delay);
        Assertions.assertTrue((boolean)shutdown.isDone());
    }

    private static class LatchHandler
    extends HandlerWrapper {
        private volatile CountDownLatch _latch = new CountDownLatch(1);

        private LatchHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            CountDownLatch latch = this._latch;
            try {
                super.handle(path, request, httpRequest, httpResponse);
            }
            finally {
                latch.countDown();
            }
        }

        private void reset() {
            this._latch = new CountDownLatch(1);
        }

        private void reset(int count) {
            this._latch = new CountDownLatch(count);
        }

        private boolean await() throws InterruptedException {
            return this._latch.await(10000L, TimeUnit.MILLISECONDS);
        }
    }
}

