/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.AbstractSessionCache;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.NullSessionDataStore;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionCache;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.SessionHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SessionCookieTest {
    @Test
    public void testSecureSessionCookie() throws Exception {
        Server server = new Server();
        MockSessionIdManager idMgr = new MockSessionIdManager(server);
        idMgr.setWorkerName("node1");
        SessionHandler mgr = new SessionHandler();
        MockSessionCache cache = new MockSessionCache(mgr);
        cache.setSessionDataStore((SessionDataStore)new NullSessionDataStore());
        mgr.setSessionCache((SessionCache)cache);
        mgr.setSessionIdManager((SessionIdManager)idMgr);
        long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        Session session = new Session(mgr, new SessionData("123", "_foo", "0.0.0.0", now, now, now, 30L));
        SessionCookieConfig sessionCookieConfig = mgr.getSessionCookieConfig();
        sessionCookieConfig.setSecure(true);
        HttpCookie cookie = mgr.getSessionCookie((HttpSession)session, "/foo", true);
        Assertions.assertTrue((boolean)cookie.isSecure());
        cookie = mgr.getSessionCookie((HttpSession)session, "/foo", false);
        Assertions.assertTrue((boolean)cookie.isSecure());
        sessionCookieConfig.setSecure(false);
        cookie = mgr.getSessionCookie((HttpSession)session, "/foo", true);
        Assertions.assertTrue((boolean)cookie.isSecure());
        cookie = mgr.getSessionCookie((HttpSession)session, "/foo", false);
        Assertions.assertFalse((boolean)cookie.isSecure());
        mgr.setSecureRequestOnly(false);
        cookie = mgr.getSessionCookie((HttpSession)session, "/foo", false);
        Assertions.assertFalse((boolean)cookie.isSecure());
        cookie = mgr.getSessionCookie((HttpSession)session, "/foo", true);
        Assertions.assertFalse((boolean)cookie.isSecure());
    }

    public class MockSessionIdManager
    extends DefaultSessionIdManager {
        public MockSessionIdManager(Server server) {
            super(server);
        }

        public boolean isIdInUse(String id) {
            return false;
        }

        public void expireAll(String id) {
        }

        public String renewSessionId(String oldClusterId, String oldNodeId, HttpServletRequest request) {
            return "";
        }
    }

    public class MockSessionCache
    extends AbstractSessionCache {
        public MockSessionCache(SessionHandler manager) {
            super(manager);
        }

        public void shutdown() {
        }

        public Session newSession(SessionData data) {
            return null;
        }

        public Session doGet(String key) {
            return null;
        }

        public Session doPutIfAbsent(String key, Session session) {
            return null;
        }

        public Session doDelete(String key) {
            return null;
        }

        public boolean doReplace(String id, Session oldValue, Session newValue) {
            return false;
        }

        public Session newSession(HttpServletRequest request, SessionData data) {
            return null;
        }

        protected Session doComputeIfAbsent(String id, Function<String, Session> mappingFunction) {
            return mappingFunction.apply(id);
        }
    }
}

