/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SessionHandlerTest {
    @Test
    public void testSessionTrackingMode() {
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setSessionTrackingModes(new HashSet<SessionTrackingMode>(Arrays.asList(SessionTrackingMode.COOKIE, SessionTrackingMode.URL)));
        sessionHandler.setSessionTrackingModes(Collections.singleton(SessionTrackingMode.SSL));
        Assertions.assertThrows(IllegalArgumentException.class, () -> sessionHandler.setSessionTrackingModes(new HashSet<SessionTrackingMode>(Arrays.asList(SessionTrackingMode.SSL, SessionTrackingMode.URL))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionListenerOrdering() throws Exception {
        final StringBuffer result = new StringBuffer();
        Server server = new Server();
        SessionHandler sessionHandler = new SessionHandler();
        try {
            class Listener1
            implements HttpSessionListener {
                Listener1() {
                }

                public void sessionCreated(HttpSessionEvent se) {
                    result.append("Listener1 create;");
                }

                public void sessionDestroyed(HttpSessionEvent se) {
                    result.append("Listener1 destroy;");
                }
            }
            sessionHandler.addEventListener((EventListener)((Object)new Listener1()));
            class Listener2
            implements HttpSessionListener {
                Listener2() {
                }

                public void sessionCreated(HttpSessionEvent se) {
                    result.append("Listener2 create;");
                }

                public void sessionDestroyed(HttpSessionEvent se) {
                    result.append("Listener2 destroy;");
                }
            }
            sessionHandler.addEventListener((EventListener)((Object)new Listener2()));
            sessionHandler.setServer(server);
            sessionHandler.start();
            Session session = new Session(sessionHandler, new SessionData("aa", "_", "0.0", 0L, 0L, 0L, 0L));
            sessionHandler.callSessionCreatedListeners(session);
            sessionHandler.callSessionDestroyedListeners(session);
            Assertions.assertEquals((Object)"Listener1 create;Listener2 create;Listener2 destroy;Listener1 destroy;", (Object)result.toString());
        }
        finally {
            sessionHandler.stop();
        }
    }
}

