/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.jupiter.api.Test;

public class SSLCloseTest {
    @Test
    public void testClose() throws Exception {
        String line;
        File keystore = MavenTestingUtils.getTestResourceFile((String)"keystore.p12");
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStoreResource(Resource.newResource((File)keystore));
        sslContextFactory.setKeyStorePassword("storepwd");
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server, sslContextFactory);
        connector.setPort(0);
        server.addConnector((Connector)connector);
        server.setHandler((Handler)new WriteHandler());
        server.start();
        SSLContext ctx = SSLContext.getInstance("TLSv1.2");
        ctx.init(null, SslContextFactory.TRUST_ALL_CERTS, new SecureRandom());
        int port = connector.getLocalPort();
        Socket socket = ctx.getSocketFactory().createSocket("localhost", port);
        OutputStream os = socket.getOutputStream();
        os.write("GET /test HTTP/1.1\r\nHost:test\r\nConnection:close\r\n\r\n".getBytes());
        os.flush();
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        while ((line = in.readLine()) != null && line.trim().length() != 0) {
        }
        Thread.sleep(2000L);
        while (in.readLine() != null) {
            Thread.yield();
        }
    }

    private static class WriteHandler
    extends AbstractHandler {
        private WriteHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            try {
                baseRequest.setHandled(true);
                response.setStatus(200);
                response.setHeader("test", "value");
                ServletOutputStream out = response.getOutputStream();
                Object data = "Now is the time for all good men to come to the aid of the party.\n";
                data = (String)data + "How now brown cow.\n";
                data = (String)data + "The quick brown fox jumped over the lazy dog.\n";
                data = (String)data + (String)data + (String)data + (String)data;
                byte[] bytes = ((String)data).getBytes(StandardCharsets.UTF_8);
                for (int i = 0; i < 2; ++i) {
                    out.write(bytes);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new ServletException(e);
            }
        }
    }
}

