/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.SSLContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnJre;
import org.junit.jupiter.api.condition.JRE;

@DisabledOnJre(value={JRE.JAVA_8, JRE.JAVA_9, JRE.JAVA_10})
public class SSLReadEOFAfterResponseTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadEOFAfterResponse() throws Exception {
        File keystore = MavenTestingUtils.getTestResourceFile((String)"keystore.p12");
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStoreResource(Resource.newResource((File)keystore));
        sslContextFactory.setKeyStorePassword("storepwd");
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server, sslContextFactory);
        final int idleTimeout = 1000;
        connector.setIdleTimeout((long)idleTimeout);
        server.addConnector((Connector)connector);
        String content = "the quick brown fox jumped over the lazy dog";
        final byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                int read;
                ServletInputStream input = request.getInputStream();
                for (int length = bytes.length; length > 0; --length) {
                    read = input.read();
                    if (read >= 0) continue;
                    throw new IllegalStateException();
                }
                response.setContentLength(bytes.length);
                response.getOutputStream().write(bytes);
                response.flushBuffer();
                SSLReadEOFAfterResponseTest.this.sleep(idleTimeout / 2);
                read = input.read();
                if (read >= 0) {
                    throw new IllegalStateException();
                }
            }
        });
        server.start();
        try {
            SSLContext sslContext = sslContextFactory.getSslContext();
            try (Socket client = sslContext.getSocketFactory().createSocket("localhost", connector.getLocalPort());){
                client.setSoTimeout(5 * idleTimeout);
                OutputStream output = client.getOutputStream();
                String request = "POST / HTTP/1.1\r\nHost: localhost\r\nContent-Length: " + content.length() + "\r\n\r\n";
                output.write(request.getBytes(StandardCharsets.UTF_8));
                output.write(bytes);
                output.flush();
                InputStream input = client.getInputStream();
                int crlfs = 0;
                do {
                    int read = input.read();
                    MatcherAssert.assertThat((Object)read, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
                    if (read == 13 || read == 10) {
                        ++crlfs;
                        continue;
                    }
                    crlfs = 0;
                } while (crlfs != 4);
                for (byte b : bytes) {
                    Assertions.assertEquals((int)b, (int)input.read());
                }
                client.shutdownOutput();
                int read = input.read();
                Assertions.assertEquals((int)-1, (int)read);
            }
        }
        finally {
            server.stop();
        }
    }

    private void sleep(long time) throws IOException {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException x) {
            throw new InterruptedIOException();
        }
    }
}

