/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SocketCustomizationListener;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class SniSslConnectionFactoryTest {
    private Server _server;
    private ServerConnector _connector;

    private void start(String keystorePath) throws Exception {
        this.start((SslContextFactory.Server ssl) -> ssl.setKeyStorePath(keystorePath));
    }

    private void start(Consumer<SslContextFactory.Server> sslConfig) throws Exception {
        this.start((SslContextFactory.Server ssl, SecureRequestCustomizer customizer) -> sslConfig.accept((SslContextFactory.Server)ssl));
    }

    private void start(BiConsumer<SslContextFactory.Server, SecureRequestCustomizer> config) throws Exception {
        this._server = new Server();
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        SecureRequestCustomizer secureRequestCustomizer = new SecureRequestCustomizer();
        httpConfiguration.addCustomizer((HttpConfiguration.Customizer)secureRequestCustomizer);
        httpConfiguration.addCustomizer((connector, httpConfig, request) -> {
            EndPoint endPoint = request.getHttpChannel().getEndPoint();
            SslConnection.DecryptedEndPoint sslEndPoint = (SslConnection.DecryptedEndPoint)endPoint;
            SslConnection sslConnection = sslEndPoint.getSslConnection();
            SSLEngine sslEngine = sslConnection.getSSLEngine();
            SSLSession session = sslEngine.getSession();
            for (Certificate c : session.getLocalCertificates()) {
                request.getResponse().getHttpFields().add("X-CERT", ((X509Certificate)c).getSubjectDN().toString());
            }
        });
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        config.accept(sslContextFactory, secureRequestCustomizer);
        File keystoreFile = sslContextFactory.getKeyStoreResource().getFile();
        if (!keystoreFile.exists()) {
            throw new FileNotFoundException(keystoreFile.getAbsolutePath());
        }
        sslContextFactory.setKeyStorePassword("storepwd");
        this._connector = new ServerConnector(this._server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpConfiguration)});
        this._server.addConnector((Connector)this._connector);
        this._server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                baseRequest.setHandled(true);
                response.setStatus(200);
                response.setHeader("X-URL", request.getRequestURI());
                response.setHeader("X-HOST", request.getServerName());
            }
        });
        this._server.start();
    }

    @AfterEach
    public void after() {
        LifeCycle.stop((Object)this._server);
    }

    @Test
    public void testSNIConnectNoWild() throws Exception {
        this.start((SslContextFactory.Server ssl, SecureRequestCustomizer customizer) -> {
            ssl.setKeyStorePath("src/test/resources/keystore_sni_nowild.p12");
            customizer.setSniHostCheck(false);
        });
        String response = this.getResponse("www.acme.org", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: www.acme.org"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-CERT: OU=default"));
        response = this.getResponse("www.example.com", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: www.example.com"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-CERT: OU=example"));
    }

    @Test
    public void testSNIConnect() throws Exception {
        this.start("src/test/resources/keystore_sni.p12");
        String response = this.getResponse("jetty.eclipse.org", "jetty.eclipse.org");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: jetty.eclipse.org"));
        response = this.getResponse("www.example.com", "www.example.com");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: www.example.com"));
        response = this.getResponse("foo.domain.com", "*.domain.com");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: foo.domain.com"));
        response = this.getResponse("m.san.com", "san example");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: m.san.com"));
        response = this.getResponse("www.san.com", "san example");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: www.san.com"));
        response = this.getResponse("wrongHost", "wrongHost", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 400 "));
    }

    @Test
    public void testWildSNIConnect() throws Exception {
        this.start("src/test/resources/keystore_sni.p12");
        String response = this.getResponse("domain.com", "www.domain.com", "*.domain.com");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: www.domain.com"));
        response = this.getResponse("domain.com", "domain.com", "*.domain.com");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: domain.com"));
        response = this.getResponse("www.domain.com", "www.domain.com", "*.domain.com");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: www.domain.com"));
    }

    @Test
    public void testBadSNIConnect() throws Exception {
        this.start("src/test/resources/keystore_sni.p12");
        String response = this.getResponse("www.example.com", "some.other.com", "www.example.com");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 400 "));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Invalid SNI"));
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void testWrongSNIRejectedConnection() throws Exception {
        this.start((SslContextFactory.Server ssl) -> {
            ssl.setKeyStorePath("src/test/resources/keystore_sni.p12");
            ssl.setSniRequired(true);
        });
        Assertions.assertThrows(SSLHandshakeException.class, () -> this.getResponse("wrong.com", "wrong.com", null));
        Assertions.assertThrows(SSLHandshakeException.class, () -> this.getResponse(null, "wrong.com", null));
    }

    @Test
    public void testWrongSNIRejectedBadRequest() throws Exception {
        this.start((SslContextFactory.Server ssl, SecureRequestCustomizer customizer) -> {
            ssl.setKeyStorePath("src/test/resources/keystore_sni.p12");
            ssl.setSniRequired(false);
            customizer.setSniRequired(true);
        });
        HttpTester.Response response = HttpTester.parseResponse((String)this.getResponse("wrong.com", "wrong.com", null));
        Assertions.assertNotNull((Object)response);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
        response = HttpTester.parseResponse((String)this.getResponse(null, "wrong.com", null));
        Assertions.assertNotNull((Object)response);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void testWrongSNIRejectedFunction() throws Exception {
        this.start((SslContextFactory.Server ssl, SecureRequestCustomizer customizer) -> {
            ssl.setKeyStorePath("src/test/resources/keystore_sni.p12");
            ssl.setSniRequired(true);
            ssl.setSNISelector((keyType, issuers, session, sniHost, certificates) -> {
                if (sniHost == null) {
                    return "delegate_no_sni_match";
                }
                return ssl.sniSelect(keyType, issuers, session, sniHost, certificates);
            });
            customizer.setSniRequired(true);
        });
        Assertions.assertThrows(SSLHandshakeException.class, () -> this.getResponse("wrong.com", "wrong.com", null));
        HttpTester.Response response = HttpTester.parseResponse((String)this.getResponse(null, "wrong.com", null));
        Assertions.assertNotNull((Object)response);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void testWrongSNIRejectedConnectionWithNonSNIKeystore() throws Exception {
        this.start((SslContextFactory.Server ssl) -> {
            ssl.setKeyStorePath("src/test/resources/keystore.p12");
            ssl.setSniRequired(true);
        });
        Assertions.assertThrows(SSLHandshakeException.class, () -> this.getResponse("wrong.com", "wrong.com", null));
        Assertions.assertThrows(SSLHandshakeException.class, () -> this.getResponse(null, "wrong.com", null));
        HttpTester.Response response = HttpTester.parseResponse((String)this.getResponse("localhost", "localhost", null));
        Assertions.assertNotNull((Object)response);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSameConnectionRequestsForManyDomains() throws Exception {
        this.start("src/test/resources/keystore_sni.p12");
        this._server.setErrorHandler(new ErrorHandler());
        SslContextFactory.Client clientContextFactory = new SslContextFactory.Client(true);
        clientContextFactory.start();
        SSLSocketFactory factory = clientContextFactory.getSslContext().getSocketFactory();
        try (SSLSocket sslSocket = (SSLSocket)factory.createSocket("127.0.0.1", this._connector.getLocalPort());){
            SNIHostName serverName = new SNIHostName("m.san.com");
            SSLParameters params = sslSocket.getSSLParameters();
            params.setServerNames(Collections.singletonList(serverName));
            sslSocket.setSSLParameters(params);
            sslSocket.startHandshake();
            String request = "GET /ctx/path HTTP/1.1\r\nHost: m.san.com\r\n\r\n";
            OutputStream output = sslSocket.getOutputStream();
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            InputStream input = sslSocket.getInputStream();
            HttpTester.Response response = HttpTester.parseResponse((InputStream)input);
            Assertions.assertNotNull((Object)response);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            request = "GET /ctx/path HTTP/1.1\r\nHost: www.san.com\r\n\r\n";
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            response = HttpTester.parseResponse((InputStream)input);
            Assertions.assertNotNull((Object)response);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            request = "GET /ctx/path HTTP/1.1\r\nHost: www.example.com\r\n\r\n";
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            response = HttpTester.parseResponse((InputStream)input);
            Assertions.assertNotNull((Object)response);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"Invalid SNI"));
        }
        finally {
            clientContextFactory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSameConnectionRequestsForManyWildDomains() throws Exception {
        this.start("src/test/resources/keystore_sni.p12");
        SslContextFactory.Client clientContextFactory = new SslContextFactory.Client(true);
        clientContextFactory.start();
        SSLSocketFactory factory = clientContextFactory.getSslContext().getSocketFactory();
        try (SSLSocket sslSocket = (SSLSocket)factory.createSocket("127.0.0.1", this._connector.getLocalPort());){
            SNIHostName serverName = new SNIHostName("www.domain.com");
            SSLParameters params = sslSocket.getSSLParameters();
            params.setServerNames(Collections.singletonList(serverName));
            sslSocket.setSSLParameters(params);
            sslSocket.startHandshake();
            String request = "GET /ctx/path HTTP/1.1\r\nHost: www.domain.com\r\n\r\n";
            OutputStream output = sslSocket.getOutputStream();
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            InputStream input = sslSocket.getInputStream();
            HttpTester.Response response = HttpTester.parseResponse((InputStream)input);
            Assertions.assertNotNull((Object)response);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            request = "GET /ctx/path HTTP/1.1\r\nHost: assets.domain.com\r\n\r\n";
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            response = HttpTester.parseResponse((InputStream)input);
            Assertions.assertNotNull((Object)response);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            request = "GET /ctx/path HTTP/1.1\r\nHost: www.example.com\r\n\r\n";
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            response = HttpTester.parseResponse((InputStream)input);
            Assertions.assertNotNull((Object)response);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"Invalid SNI"));
        }
        finally {
            clientContextFactory.stop();
        }
    }

    @Test
    public void testSocketCustomization() throws Exception {
        this.start("src/test/resources/keystore_sni.p12");
        final LinkedBlockingQueue history = new LinkedBlockingQueue();
        this._connector.addBean((Object)new SocketCustomizationListener(){

            protected void customize(Socket socket, Class<? extends Connection> connection, boolean ssl) {
                history.add("customize connector " + connection + "," + ssl);
            }
        });
        ((SslConnectionFactory)this._connector.getBean(SslConnectionFactory.class)).addBean((Object)new SocketCustomizationListener(){

            protected void customize(Socket socket, Class<? extends Connection> connection, boolean ssl) {
                history.add("customize ssl " + connection + "," + ssl);
            }
        });
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).addBean((Object)new SocketCustomizationListener(){

            protected void customize(Socket socket, Class<? extends Connection> connection, boolean ssl) {
                history.add("customize http " + connection + "," + ssl);
            }
        });
        String response = this.getResponse("www.example.com", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: www.example.com"));
        Assertions.assertEquals((Object)"customize connector class org.eclipse.jetty.io.ssl.SslConnection,false", history.poll());
        Assertions.assertEquals((Object)"customize ssl class org.eclipse.jetty.io.ssl.SslConnection,false", history.poll());
        Assertions.assertEquals((Object)"customize connector class org.eclipse.jetty.server.HttpConnection,true", history.poll());
        Assertions.assertEquals((Object)"customize http class org.eclipse.jetty.server.HttpConnection,true", history.poll());
        Assertions.assertEquals((int)0, (int)history.size());
    }

    private String getResponse(String host, String cn) throws Exception {
        String response = this.getResponse(host, host, cn);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 "));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-URL: /ctx/path"));
        return response;
    }

    private String getResponse(String sniHost, String reqHost, String cn) throws Exception {
        SslContextFactory.Client clientContextFactory = new SslContextFactory.Client(true);
        clientContextFactory.start();
        SSLSocketFactory factory = clientContextFactory.getSslContext().getSocketFactory();
        try {
            String string;
            block11: {
                SSLSocket sslSocket = (SSLSocket)factory.createSocket("127.0.0.1", this._connector.getLocalPort());
                try {
                    if (sniHost != null) {
                        SNIHostName serverName = new SNIHostName(sniHost);
                        ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>();
                        serverNames.add(serverName);
                        SSLParameters params = sslSocket.getSSLParameters();
                        params.setServerNames(serverNames);
                        sslSocket.setSSLParameters(params);
                    }
                    sslSocket.startHandshake();
                    if (cn != null) {
                        X509Certificate cert = (X509Certificate)sslSocket.getSession().getPeerCertificates()[0];
                        MatcherAssert.assertThat((Object)cert.getSubjectX500Principal().getName("CANONICAL"), (Matcher)Matchers.startsWith((String)("cn=" + cn)));
                    }
                    String response = "GET /ctx/path HTTP/1.0\r\nHost: " + reqHost + ":" + this._connector.getLocalPort() + "\r\n\r\n";
                    sslSocket.getOutputStream().write(response.getBytes(StandardCharsets.ISO_8859_1));
                    string = IO.toString((InputStream)sslSocket.getInputStream());
                    if (sslSocket == null) break block11;
                }
                catch (Throwable throwable) {
                    if (sslSocket != null) {
                        try {
                            sslSocket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                sslSocket.close();
            }
            return string;
        }
        finally {
            clientContextFactory.stop();
        }
    }
}

