/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SocketCustomizationListener;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SslConnectionFactoryTest {
    private Server _server;
    private ServerConnector _connector;
    private int _port;

    @BeforeEach
    public void before() throws Exception {
        String keystorePath = "src/test/resources/keystore.p12";
        File keystoreFile = new File(keystorePath);
        if (!keystoreFile.exists()) {
            throw new FileNotFoundException(keystoreFile.getAbsolutePath());
        }
        this._server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        httpConfig.setSecurePort(8443);
        httpConfig.setOutputBufferSize(32768);
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystoreFile.getAbsolutePath());
        sslContextFactory.setKeyStorePassword("storepwd");
        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
        sslConnectionFactory.setEnsureSecureRequestCustomizer(true);
        ServerConnector https = this._connector = new ServerConnector(this._server, new ConnectionFactory[]{sslConnectionFactory, new HttpConnectionFactory()});
        https.setPort(0);
        https.setIdleTimeout(30000L);
        this._server.addConnector((Connector)https);
        this._server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                response.setStatus(200);
                response.getWriter().write("url=" + request.getRequestURI() + "\nhost=" + request.getServerName());
                response.flushBuffer();
            }
        });
        this._server.start();
        this._port = https.getLocalPort();
    }

    @AfterEach
    public void after() throws Exception {
        this._server.stop();
        this._server = null;
    }

    @Test
    public void testConnect() throws Exception {
        String response = this.getResponse("127.0.0.1", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"host=127.0.0.1"));
    }

    @Test
    public void testSNIConnect() throws Exception {
        String response = this.getResponse("localhost", "localhost", "localhost");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"host=localhost"));
    }

    @Test
    public void testBadHandshake() throws Exception {
        try (Socket socket = new Socket("127.0.0.1", this._port);
             OutputStream out = socket.getOutputStream();){
            out.write("Rubbish".getBytes());
            out.flush();
            socket.setSoTimeout(1000);
            MatcherAssert.assertThat((Object)socket.getInputStream().read(), (Matcher)Matchers.equalTo((Object)21));
        }
    }

    @Test
    public void testSocketCustomization() throws Exception {
        final LinkedBlockingQueue history = new LinkedBlockingQueue();
        this._connector.addBean((Object)new SocketCustomizationListener(){

            protected void customize(Socket socket, Class<? extends Connection> connection, boolean ssl) {
                history.add("customize connector " + connection + "," + ssl);
            }
        });
        ((SslConnectionFactory)this._connector.getBean(SslConnectionFactory.class)).addBean((Object)new SocketCustomizationListener(){

            protected void customize(Socket socket, Class<? extends Connection> connection, boolean ssl) {
                history.add("customize ssl " + connection + "," + ssl);
            }
        });
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).addBean((Object)new SocketCustomizationListener(){

            protected void customize(Socket socket, Class<? extends Connection> connection, boolean ssl) {
                history.add("customize http " + connection + "," + ssl);
            }
        });
        String response = this.getResponse("127.0.0.1", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"host=127.0.0.1"));
        Assertions.assertEquals((Object)"customize connector class org.eclipse.jetty.io.ssl.SslConnection,false", history.poll());
        Assertions.assertEquals((Object)"customize ssl class org.eclipse.jetty.io.ssl.SslConnection,false", history.poll());
        Assertions.assertEquals((Object)"customize connector class org.eclipse.jetty.server.HttpConnection,true", history.poll());
        Assertions.assertEquals((Object)"customize http class org.eclipse.jetty.server.HttpConnection,true", history.poll());
        Assertions.assertEquals((int)0, (int)history.size());
    }

    @Test
    public void testServerWithoutHttpConnectionFactory() throws Exception {
        this._server.stop();
        Assertions.assertNotNull((Object)this._connector.removeConnectionFactory(HttpVersion.HTTP_1_1.asString()));
        Assertions.assertThrows(IllegalStateException.class, () -> this._server.start());
    }

    private String getResponse(String host, String cn) throws Exception {
        String response = this.getResponse(host, host, cn);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"url=/ctx/path"));
        return response;
    }

    private String getResponse(String sniHost, String reqHost, String cn) throws Exception {
        SslContextFactory.Client clientContextFactory = new SslContextFactory.Client(true);
        clientContextFactory.start();
        SSLSocketFactory factory = clientContextFactory.getSslContext().getSocketFactory();
        SSLSocket sslSocket = (SSLSocket)factory.createSocket("127.0.0.1", this._port);
        if (cn != null) {
            SNIHostName serverName = new SNIHostName(sniHost);
            ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>();
            serverNames.add(serverName);
            SSLParameters params = sslSocket.getSSLParameters();
            params.setServerNames(serverNames);
            sslSocket.setSSLParameters(params);
        }
        sslSocket.startHandshake();
        if (cn != null) {
            X509Certificate cert = (X509Certificate)sslSocket.getSession().getPeerCertificates()[0];
            MatcherAssert.assertThat((Object)cert.getSubjectX500Principal().getName("CANONICAL"), (Matcher)Matchers.startsWith((String)("cn=" + cn)));
        }
        sslSocket.getOutputStream().write(("GET /ctx/path HTTP/1.0\r\nHost: " + reqHost + ":" + this._port + "\r\n\r\n").getBytes(StandardCharsets.ISO_8859_1));
        String response = IO.toString((InputStream)sslSocket.getInputStream());
        sslSocket.close();
        clientContextFactory.stop();
        return response;
    }
}

