/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SslContextFactoryReloadTest {
    public static final String KEYSTORE_1 = "src/test/resources/reload_keystore_1.p12";
    public static final String KEYSTORE_2 = "src/test/resources/reload_keystore_2.p12";
    private Server server;
    private SslContextFactory.Server sslContextFactory;
    private ServerConnector connector;

    private void start(Handler handler) throws Exception {
        this.server = new Server();
        this.sslContextFactory = new SslContextFactory.Server();
        this.sslContextFactory.setKeyStorePath(KEYSTORE_1);
        this.sslContextFactory.setKeyStorePassword("storepwd");
        HttpConfiguration httpsConfig = new HttpConfiguration();
        SecureRequestCustomizer customizer = new SecureRequestCustomizer();
        customizer.setSniHostCheck(false);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)customizer);
        this.connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(this.sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        this.server.addConnector((Connector)this.connector);
        this.server.setHandler(handler);
        this.server.start();
    }

    @AfterEach
    public void dispose() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void testReload() throws Exception {
        this.start((Handler)new EchoHandler());
        SSLContext ctx = SSLContext.getInstance("TLSv1.2");
        ctx.init(null, SslContextFactory.TRUST_ALL_CERTS, null);
        SSLSocketFactory socketFactory = ctx.getSocketFactory();
        try (SSLSocket client1 = (SSLSocket)socketFactory.createSocket("localhost", this.connector.getLocalPort());){
            String serverDN1 = client1.getSession().getPeerPrincipal().getName();
            MatcherAssert.assertThat((Object)serverDN1, (Matcher)Matchers.startsWith((String)"CN=localhost1"));
            String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
            OutputStream output1 = client1.getOutputStream();
            output1.write(request.getBytes(StandardCharsets.UTF_8));
            output1.flush();
            HttpTester.Response response1 = HttpTester.parseResponse((HttpTester.Input)HttpTester.from((InputStream)client1.getInputStream()));
            Assertions.assertNotNull((Object)response1);
            MatcherAssert.assertThat((Object)response1.getStatus(), (Matcher)Matchers.equalTo((Object)200));
            this.sslContextFactory.reload(sslContextFactory -> {
                sslContextFactory.setKeyStorePath(KEYSTORE_2);
                sslContextFactory.setKeyStorePassword("storepwd");
            });
            try (SSLSocket client2 = (SSLSocket)socketFactory.createSocket("localhost", this.connector.getLocalPort());){
                String serverDN2 = client2.getSession().getPeerPrincipal().getName();
                MatcherAssert.assertThat((Object)serverDN2, (Matcher)Matchers.startsWith((String)"CN=localhost2"));
                OutputStream output2 = client1.getOutputStream();
                output2.write(request.getBytes(StandardCharsets.UTF_8));
                output2.flush();
                HttpTester.Response response2 = HttpTester.parseResponse((HttpTester.Input)HttpTester.from((InputStream)client1.getInputStream()));
                Assertions.assertNotNull((Object)response2);
                MatcherAssert.assertThat((Object)response2.getStatus(), (Matcher)Matchers.equalTo((Object)200));
            }
            output1.write(request.getBytes(StandardCharsets.UTF_8));
            output1.flush();
            response1 = HttpTester.parseResponse((HttpTester.Input)HttpTester.from((InputStream)client1.getInputStream()));
            Assertions.assertNotNull((Object)response1);
            MatcherAssert.assertThat((Object)response1.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReloadWhileServing() throws Exception {
        this.start((Handler)new EchoHandler());
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler();
        scheduler.start();
        try {
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            ctx.init(null, SslContextFactory.TRUST_ALL_CERTS, null);
            SSLSocketFactory socketFactory = ctx.getSocketFactory();
            final AtomicInteger reloads = new AtomicInteger(4);
            long reloadPeriod = 500L;
            final AtomicBoolean running = new AtomicBoolean(true);
            scheduler.schedule(new Runnable((Scheduler)scheduler, reloadPeriod){
                final /* synthetic */ Scheduler val$scheduler;
                final /* synthetic */ long val$reloadPeriod;
                {
                    this.val$scheduler = scheduler;
                    this.val$reloadPeriod = l;
                }

                @Override
                public void run() {
                    if (reloads.decrementAndGet() == 0) {
                        running.set(false);
                    } else {
                        try {
                            SslContextFactoryReloadTest.this.sslContextFactory.reload(sslContextFactory -> {
                                if (sslContextFactory.getKeyStorePath().endsWith(SslContextFactoryReloadTest.KEYSTORE_1)) {
                                    sslContextFactory.setKeyStorePath(SslContextFactoryReloadTest.KEYSTORE_2);
                                } else {
                                    sslContextFactory.setKeyStorePath(SslContextFactoryReloadTest.KEYSTORE_1);
                                }
                            });
                            this.val$scheduler.schedule((Runnable)this, this.val$reloadPeriod, TimeUnit.MILLISECONDS);
                        }
                        catch (Exception x) {
                            running.set(false);
                            reloads.set(-1);
                        }
                    }
                }
            }, reloadPeriod, TimeUnit.MILLISECONDS);
            byte[] content = new byte[16384];
            while (running.get()) {
                SSLSocket client = (SSLSocket)socketFactory.createSocket("localhost", this.connector.getLocalPort());
                try {
                    client.getSession().invalidate();
                    String request1 = "POST / HTTP/1.1\r\nHost: localhost\r\nContent-Length: " + content.length + "\r\n\r\n";
                    OutputStream outputStream = client.getOutputStream();
                    outputStream.write(request1.getBytes(StandardCharsets.UTF_8));
                    outputStream.write(content);
                    outputStream.flush();
                    InputStream inputStream = client.getInputStream();
                    HttpTester.Response response1 = HttpTester.parseResponse((HttpTester.Input)HttpTester.from((InputStream)inputStream));
                    Assertions.assertNotNull((Object)response1);
                    MatcherAssert.assertThat((Object)response1.getStatus(), (Matcher)Matchers.equalTo((Object)200));
                    String request2 = "GET / HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
                    outputStream.write(request2.getBytes(StandardCharsets.UTF_8));
                    outputStream.flush();
                    HttpTester.Response response2 = HttpTester.parseResponse((HttpTester.Input)HttpTester.from((InputStream)inputStream));
                    Assertions.assertNotNull((Object)response2);
                    MatcherAssert.assertThat((Object)response2.getStatus(), (Matcher)Matchers.equalTo((Object)200));
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            Assertions.assertEquals((int)0, (int)reloads.get());
        }
        finally {
            scheduler.stop();
        }
    }

    private static class EchoHandler
    extends AbstractHandler {
        private EchoHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            if (HttpMethod.POST.is(request.getMethod())) {
                IO.copy((InputStream)request.getInputStream(), (OutputStream)response.getOutputStream());
            } else {
                response.setContentLength(0);
            }
        }
    }
}

