/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.FileInputStream;
import java.net.Socket;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jetty.server.ConnectorTimeoutTest;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.jupiter.api.BeforeEach;

public class SslSelectChannelTimeoutTest
extends ConnectorTimeoutTest {
    static SSLContext __sslContext;

    @Override
    protected Socket newSocket(String host, int port) throws Exception {
        return __sslContext.getSocketFactory().createSocket(host, port);
    }

    @BeforeEach
    public void init() throws Exception {
        String keystorePath = System.getProperty("basedir", ".") + "/src/test/resources/keystore.p12";
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystorePath);
        sslContextFactory.setKeyStorePassword("storepwd");
        ServerConnector connector = new ServerConnector(this._server, 1, 1, sslContextFactory);
        connector.setIdleTimeout(2000L);
        this.startServer(connector);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream stream = new FileInputStream(keystorePath);){
            keystore.load(stream, "storepwd".toCharArray());
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keystore);
        __sslContext = SSLContext.getInstance("SSL");
        __sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
    }
}

