/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.CharsetStringBuilder;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.UrlEncoded;

public class FormFields
extends CompletableFuture<Fields>
implements Runnable {
    public static final String MAX_FIELDS_ATTRIBUTE = "org.eclipse.jetty.server.Request.maxFormKeys";
    public static final String MAX_LENGTH_ATTRIBUTE = "org.eclipse.jetty.server.Request.maxFormContentSize";
    private static final CompletableFuture<Fields> EMPTY = CompletableFuture.completedFuture(new Fields());
    private final Content.Source _source;
    private final Fields _fields;
    private final CharsetStringBuilder _builder;
    private final int _maxFields;
    private final int _maxLength;
    private int _length;
    private String _name;
    private int _percent = 0;
    private byte _percentCode;

    public static Charset getFormEncodedCharset(Request request) {
        HttpConfiguration config = request.getConnectionMetaData().getHttpConfiguration();
        if (!config.getFormEncodedMethods().contains(request.getMethod())) {
            return null;
        }
        String contentType = request.getHeaders().get(HttpHeader.CONTENT_TYPE);
        if (request.getLength() == 0L || StringUtil.isBlank((String)contentType)) {
            return null;
        }
        MimeTypes.Type type = (MimeTypes.Type)MimeTypes.CACHE.get(MimeTypes.getContentTypeWithoutCharset((String)contentType));
        if (MimeTypes.Type.FORM_ENCODED != type) {
            return null;
        }
        String cs = MimeTypes.getCharsetFromContentType((String)contentType);
        return StringUtil.isEmpty((String)cs) ? StandardCharsets.UTF_8 : Charset.forName(cs);
    }

    public static CompletableFuture<Fields> from(Request request) {
        Object attr = request.getAttribute(FormFields.class.getName());
        if (attr instanceof FormFields) {
            FormFields futureFormFields = (FormFields)attr;
            return futureFormFields;
        }
        Charset charset = FormFields.getFormEncodedCharset(request);
        if (charset == null) {
            return EMPTY;
        }
        int maxFields = FormFields.getRequestAttribute(request, MAX_FIELDS_ATTRIBUTE);
        int maxLength = FormFields.getRequestAttribute(request, MAX_LENGTH_ATTRIBUTE);
        FormFields futureFormFields = new FormFields(request, charset, maxFields, maxLength);
        futureFormFields.run();
        request.setAttribute(FormFields.class.getName(), futureFormFields);
        return futureFormFields;
    }

    private static int getRequestAttribute(Request request, String attribute) {
        Object value = request.getAttribute(attribute);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException x) {
            return -1;
        }
    }

    public FormFields(Content.Source source, Charset charset, int maxFields, int maxSize) {
        this(source, charset, maxFields, maxSize, null);
    }

    public FormFields(Content.Source source, Charset charset, int maxFields, int maxSize, Fields fields) {
        this._source = source;
        this._maxFields = maxFields;
        this._maxLength = maxSize;
        this._builder = CharsetStringBuilder.forCharset((Charset)charset);
        this._fields = fields == null ? new Fields() : fields;
    }

    @Override
    public void run() {
        try {
            Content.Chunk chunk;
            do {
                Fields.Field field;
                if ((chunk = this._source.read()) == null) {
                    this._source.demand((Runnable)this);
                    return;
                }
                if (chunk instanceof Content.Chunk.Error) {
                    Content.Chunk.Error error = (Content.Chunk.Error)chunk;
                    this.completeExceptionally(error.getCause());
                    return;
                }
                while ((field = this.parse(chunk)) != null) {
                    if (this._maxFields > 0 && this._fields.getSize() > this._maxFields) {
                        chunk.release();
                        this.completeExceptionally(new IllegalStateException("form with too many fields"));
                        return;
                    }
                    this._fields.add(field);
                }
                chunk.release();
            } while (!chunk.isLast());
            this.complete(this._fields);
            return;
        }
        catch (Throwable x) {
            this.completeExceptionally(x);
            return;
        }
    }

    protected Fields.Field parse(Content.Chunk chunk) throws CharacterCodingException {
        String value = null;
        ByteBuffer buffer = chunk.getByteBuffer();
        block14: while (BufferUtil.hasContent((ByteBuffer)buffer)) {
            byte b = buffer.get();
            switch (this._percent) {
                case 1: {
                    this._percentCode = b;
                    ++this._percent;
                    continue block14;
                }
                case 2: {
                    this._builder.append(UrlEncoded.decodeHexByte((char)((char)this._percentCode), (char)((char)b)));
                    this._percent = 0;
                    continue block14;
                }
            }
            if (this._name == null) {
                switch (b) {
                    case 61: {
                        this._name = this._builder.takeString();
                        this.checkLength(chunk, this._name);
                        continue block14;
                    }
                    case 43: {
                        this._builder.append((byte)32);
                        continue block14;
                    }
                    case 37: {
                        ++this._percent;
                        continue block14;
                    }
                }
                this._builder.append(b);
                continue;
            }
            switch (b) {
                case 38: {
                    value = this._builder.takeString();
                    this.checkLength(chunk, value);
                    break block14;
                }
                case 43: {
                    this._builder.append((byte)32);
                    break;
                }
                case 37: {
                    ++this._percent;
                    break;
                }
                default: {
                    this._builder.append(b);
                }
            }
        }
        if (this._name != null) {
            if (value == null && chunk.isLast()) {
                if (this._percent > 0) {
                    this._builder.append((byte)37);
                    this._builder.append(this._percentCode);
                }
                value = this._builder.takeString();
                this.checkLength(chunk, value);
            }
            if (value != null) {
                Fields.Field field = new Fields.Field(this._name, value);
                this._name = null;
                return field;
            }
        }
        return null;
    }

    private void checkLength(Content.Chunk chunk, String nameOrValue) {
        if (this._maxLength > 0) {
            this._length += nameOrValue.length();
            if (this._length > this._maxLength) {
                chunk.release();
                throw new IllegalStateException("form too large");
            }
        }
    }
}

