/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Handler")
public interface Handler
extends LifeCycle,
Destroyable,
Invocable {
    public Request.Processor handle(Request var1) throws Exception;

    @ManagedAttribute(value="the Server instance associated to this Handler", readonly=true)
    public Server getServer();

    public void setServer(Server var1);

    public void destroy();

    public static abstract class Processor
    extends Abstract
    implements Request.Processor {
        public Processor() {
        }

        public Processor(Invocable.InvocationType type) {
            super(type);
        }

        @Override
        public Request.Processor handle(Request request) throws Exception {
            return this;
        }

        public static abstract class NonBlocking
        extends Processor {
            public NonBlocking() {
                super(Invocable.InvocationType.NON_BLOCKING);
            }
        }

        public static abstract class Blocking
        extends Processor {
            public Blocking() {
                super(Invocable.InvocationType.BLOCKING);
            }
        }
    }

    public static class Collection
    extends AbstractContainer {
        private volatile List<Handler> _handlers = new ArrayList<Handler>();

        public Collection(Handler ... handlers) {
            this(List.of(handlers));
        }

        public Collection(List<Handler> handlers) {
            this.setHandlers(handlers);
        }

        public String toString() {
            return super.toString();
        }

        @Override
        public Request.Processor handle(Request request) throws Exception {
            for (Handler h : this._handlers) {
                Request.Processor processor = h.handle(request);
                if (processor == null) continue;
                return processor;
            }
            return null;
        }

        @Override
        public List<Handler> getHandlers() {
            return this._handlers;
        }

        public void setHandlers(Handler ... handlers) {
            this.setHandlers(handlers.length == 0 ? null : List.of(handlers));
        }

        public void setHandlers(List<Handler> handlers) {
            List<Handler> newHandlers = this.newHandlers(handlers);
            Server server = this.getServer();
            Invocable.InvocationType invocationType = server == null ? null : server.getInvocationType();
            for (Handler handler : newHandlers) {
                Container container;
                if (handler == null) continue;
                if (handler == this || handler instanceof Container && (container = (Container)handler).getDescendants().contains(this)) {
                    throw new IllegalStateException("setHandler loop");
                }
                invocationType = Invocable.combine((Invocable.InvocationType)invocationType, (Invocable.InvocationType)handler.getInvocationType());
                if (server != null && server.isStarted() && server.getInvocationType() != Invocable.combine((Invocable.InvocationType)server.getInvocationType(), (Invocable.InvocationType)handler.getInvocationType())) {
                    throw new IllegalArgumentException("Cannot change invocation type of started server");
                }
                if (server == null) continue;
                handler.setServer(server);
            }
            this.updateBeans(this._handlers, handlers);
            this._handlers = newHandlers;
        }

        protected List<Handler> newHandlers(List<Handler> handlers) {
            return handlers == null ? List.of() : List.copyOf(handlers);
        }

        @Override
        public void addHandler(Handler handler) {
            ArrayList<Handler> list = new ArrayList<Handler>(this.getHandlers());
            list.add(handler);
            this.setHandlers(list);
        }

        public void removeHandler(Handler handler) {
            ArrayList<Handler> list = new ArrayList<Handler>(this.getHandlers());
            if (list.remove(handler)) {
                this.setHandlers(list);
            }
        }
    }

    public static class Wrapper
    extends AbstractContainer
    implements Nested {
        private Handler _handler;

        public Wrapper() {
            this((Handler)null);
        }

        public Wrapper(Handler handler) {
            this._handler = handler == null ? null : Nested.updateHandler(this, handler);
        }

        @Override
        public Handler getHandler() {
            return this._handler;
        }

        @Override
        public void setHandler(Handler handler) {
            this._handler = Nested.updateHandler(this, handler);
        }

        @Override
        public List<Handler> getHandlers() {
            Handler next = this.getHandler();
            if (next == null) {
                return Collections.emptyList();
            }
            return List.of(next);
        }

        @Override
        public Request.Processor handle(Request request) throws Exception {
            Handler next = this.getHandler();
            return next == null ? null : next.handle(request);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            Handler next = this.getHandler();
            return next == null ? Invocable.InvocationType.NON_BLOCKING : next.getInvocationType();
        }
    }

    public static abstract class AbstractContainer
    extends Abstract
    implements Container {
        @Override
        public <T extends Handler> List<T> getDescendants(Class<T> type) {
            ArrayList list = new ArrayList();
            this.expandHandler(this, list, type);
            return list;
        }

        private <H extends Handler> void expandHandler(Handler handler, List<H> list, Class<H> type) {
            if (!(handler instanceof Container)) {
                return;
            }
            Container container = (Container)handler;
            for (Handler child : container.getHandlers()) {
                if (type == null || type.isInstance(child)) {
                    list.add(child);
                }
                this.expandHandler(child, list, type);
            }
        }

        @Override
        public <T extends Handler> T getDescendant(Class<T> type) {
            return this.findHandler(this, type);
        }

        private <H extends Handler> H findHandler(Handler handler, Class<H> type) {
            if (!(handler instanceof Container)) {
                return null;
            }
            Container container = (Container)handler;
            for (Handler child : container.getHandlers()) {
                if (type == null || type.isInstance(child)) {
                    return (H)child;
                }
                H descendant = this.findHandler(child, type);
                if (descendant == null) continue;
                return descendant;
            }
            return null;
        }

        @Override
        public void setServer(Server server) {
            super.setServer(server);
            for (Handler child : this.getHandlers()) {
                child.setServer(server);
            }
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            Invocable.InvocationType invocationType = Invocable.InvocationType.NON_BLOCKING;
            for (Handler child : this.getHandlers()) {
                invocationType = Invocable.combine((Invocable.InvocationType)invocationType, (Invocable.InvocationType)child.getInvocationType());
            }
            return invocationType;
        }

        public static <T extends Container> T findContainerOf(Container root, Class<T> type, Handler handler) {
            if (root == null || handler == null) {
                return null;
            }
            List<T> branches = root.getDescendants(type);
            if (branches != null) {
                for (Container container : branches) {
                    List<?> candidates = container.getDescendants(handler.getClass());
                    if (candidates == null) continue;
                    for (Handler c : candidates) {
                        if (c != handler) continue;
                        return (T)container;
                    }
                }
            }
            return null;
        }
    }

    public static abstract class Abstract
    extends ContainerLifeCycle
    implements Handler {
        private static final Logger LOG = LoggerFactory.getLogger(Abstract.class);
        private final Invocable.InvocationType _invocationType;
        private Server _server;

        public Abstract() {
            this(Invocable.InvocationType.BLOCKING);
        }

        public Abstract(Invocable.InvocationType type) {
            this._invocationType = type;
        }

        @Override
        public Server getServer() {
            return this._server;
        }

        @Override
        public void setServer(Server server) {
            if (this._server == server) {
                return;
            }
            if (this.isStarted()) {
                throw new IllegalStateException(this.getState());
            }
            this._server = server;
        }

        public Invocable.InvocationType getInvocationType() {
            return this._invocationType;
        }

        protected void doStart() throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("starting {}", (Object)this);
            }
            if (this._server == null) {
                LOG.warn("No Server set for {}", (Object)this);
            }
            super.doStart();
        }

        protected void doStop() throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("stopping {}", (Object)this);
            }
            super.doStop();
        }

        @Override
        public void destroy() {
            if (this.isRunning()) {
                throw new IllegalStateException(this.getState());
            }
            super.destroy();
        }
    }

    public static interface Nested
    extends Container {
        public Handler getHandler();

        public void setHandler(Handler var1);

        default public void setHandler(Supplier<Handler> supplier) {
            this.setHandler(supplier.get());
        }

        @Override
        default public List<Handler> getHandlers() {
            Handler h = this.getHandler();
            if (h == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(h);
        }

        @Override
        default public void addHandler(Handler handler) {
            Handler existing = this.getHandler();
            this.setHandler(handler);
            if (existing != null && handler instanceof Container) {
                Container container = (Container)handler;
                container.addHandler(existing);
            }
        }

        default public void insertHandler(Nested handler) {
            Nested tail = handler;
            while (tail.getHandler() instanceof Wrapper) {
                tail = (Wrapper)tail.getHandler();
            }
            if (tail.getHandler() != null) {
                throw new IllegalArgumentException("bad tail of inserted wrapper chain");
            }
            tail.setHandler(this.getHandler());
            this.setHandler(handler);
        }

        public static Handler updateHandler(Nested nested, Handler handler) {
            Container container;
            Server server = nested.getServer();
            if (server != null && server.isStarted() && handler != null && server.getInvocationType() != Invocable.combine((Invocable.InvocationType)server.getInvocationType(), (Invocable.InvocationType)handler.getInvocationType())) {
                throw new IllegalArgumentException("Cannot change invocation type of started server");
            }
            if (handler == nested || handler instanceof Container && (container = (Container)handler).getDescendants().contains(nested)) {
                throw new IllegalStateException("setHandler loop");
            }
            if (handler != null && server != null) {
                handler.setServer(server);
            }
            if (nested instanceof ContainerLifeCycle) {
                container = (ContainerLifeCycle)nested;
                container.updateBean(nested.getHandler(), handler);
            }
            return handler;
        }
    }

    public static interface Container
    extends Handler {
        public void addHandler(Handler var1);

        default public void addHandler(Supplier<Handler> supplier) {
            this.addHandler(supplier.get());
        }

        @ManagedAttribute(value="The direct children Handlers of this container")
        public List<Handler> getHandlers();

        default public List<Handler> getDescendants() {
            return this.getDescendants(Handler.class);
        }

        default public <T extends Handler> List<T> getDescendants(Class<T> type) {
            ArrayList<Handler> handlers = new ArrayList<Handler>();
            for (Handler h : this.getHandlers()) {
                if (type.isInstance(h)) {
                    Handler t = h;
                    handlers.add(t);
                }
                if (!(h instanceof Container)) continue;
                Container c = (Container)h;
                handlers.addAll(c.getDescendants(type));
            }
            return handlers;
        }

        default public <T extends Handler> T getDescendant(Class<T> type) {
            for (Handler h : this.getHandlers()) {
                Container c;
                T t;
                if (type.isInstance(h)) {
                    Handler t2 = h;
                    return (T)t2;
                }
                if (!(h instanceof Container) || (t = (c = (Container)h).getDescendant(type)) == null) continue;
                return t;
            }
            return null;
        }

        default public <T extends Container> T getContainer(Handler handler, Class<T> type) {
            if (handler == null) {
                return null;
            }
            for (Container container : this.getDescendants(type)) {
                if (!container.getDescendants(handler.getClass()).contains(handler)) continue;
                return (T)container;
            }
            return null;
        }
    }
}

