/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.CookieCache;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Components;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.server.internal.HttpChannelState;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.thread.Invocable;

public interface Request
extends Attributes,
Content.Source {
    public static final List<Locale> __defaultLocale = Collections.singletonList(Locale.getDefault());

    public String getId();

    public Components getComponents();

    public ConnectionMetaData getConnectionMetaData();

    public String getMethod();

    public HttpURI getHttpURI();

    public Context getContext();

    public String getPathInContext();

    public HttpFields getHeaders();

    public long getTimeStamp();

    public boolean isSecure();

    public Content.Chunk read();

    default public boolean isPushSupported() {
        return false;
    }

    public void push(MetaData.Request var1);

    public boolean addErrorListener(Predicate<Throwable> var1);

    public TunnelSupport getTunnelSupport();

    public void addHttpStreamWrapper(Function<HttpStream, HttpStream.Wrapper> var1);

    public static String getLocalAddr(Request request) {
        if (request == null) {
            return null;
        }
        SocketAddress local = request.getConnectionMetaData().getLocalSocketAddress();
        if (local instanceof InetSocketAddress) {
            InetAddress address = ((InetSocketAddress)local).getAddress();
            String result = address == null ? ((InetSocketAddress)local).getHostString() : address.getHostAddress();
            return HostPort.normalizeHost((String)result);
        }
        return local.toString();
    }

    public static int getLocalPort(Request request) {
        if (request == null) {
            return -1;
        }
        SocketAddress local = request.getConnectionMetaData().getLocalSocketAddress();
        if (local instanceof InetSocketAddress) {
            return ((InetSocketAddress)local).getPort();
        }
        return -1;
    }

    public static String getRemoteAddr(Request request) {
        if (request == null) {
            return null;
        }
        SocketAddress remote = request.getConnectionMetaData().getRemoteSocketAddress();
        if (remote instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)remote;
            if (inetSocketAddress.isUnresolved()) {
                return inetSocketAddress.getHostString();
            }
            InetAddress address = inetSocketAddress.getAddress();
            String result = address == null ? inetSocketAddress.getHostString() : address.getHostAddress();
            return HostPort.normalizeHost((String)result);
        }
        return remote.toString();
    }

    public static int getRemotePort(Request request) {
        if (request == null) {
            return -1;
        }
        SocketAddress remote = request.getConnectionMetaData().getRemoteSocketAddress();
        if (remote instanceof InetSocketAddress) {
            return ((InetSocketAddress)remote).getPort();
        }
        return -1;
    }

    public static String getServerName(Request request) {
        if (request == null) {
            return null;
        }
        HttpURI uri = request.getHttpURI();
        if (uri.hasAuthority()) {
            return HostPort.normalizeHost((String)uri.getHost());
        }
        HostPort authority = request.getConnectionMetaData().getServerAuthority();
        if (authority != null) {
            return HostPort.normalizeHost((String)authority.getHost());
        }
        SocketAddress local = request.getConnectionMetaData().getLocalSocketAddress();
        if (local instanceof InetSocketAddress) {
            return HostPort.normalizeHost((String)((InetSocketAddress)local).getHostString());
        }
        return local.toString();
    }

    public static int getServerPort(Request request) {
        SocketAddress local;
        if (request == null) {
            return -1;
        }
        HttpURI uri = request.getHttpURI();
        if (uri.hasAuthority() && uri.getPort() > 0) {
            return uri.getPort();
        }
        HostPort authority = request.getConnectionMetaData().getServerAuthority();
        if (authority != null && authority.getPort() > 0) {
            return authority.getPort();
        }
        if (authority == null && (local = request.getConnectionMetaData().getLocalSocketAddress()) instanceof InetSocketAddress) {
            return ((InetSocketAddress)local).getPort();
        }
        HttpScheme scheme = (HttpScheme)HttpScheme.CACHE.get(request.getHttpURI().getScheme());
        if (scheme != null) {
            return scheme.getDefaultPort();
        }
        return -1;
    }

    public static List<Locale> getLocales(Request request) {
        HttpFields fields = request.getHeaders();
        if (fields == null) {
            return __defaultLocale;
        }
        List acceptable = fields.getQualityCSV(HttpHeader.ACCEPT_LANGUAGE);
        if (acceptable.isEmpty()) {
            return __defaultLocale;
        }
        return acceptable.stream().map(language -> {
            language = HttpField.stripParameters((String)language);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            return new Locale((String)language, country);
        }).collect(Collectors.toList());
    }

    public static InputStream asInputStream(Request request) {
        return Content.Source.asInputStream((Content.Source)request);
    }

    public static Fields extractQueryParameters(Request request) {
        Fields fields = new Fields(true);
        String query = request.getHttpURI().getQuery();
        if (StringUtil.isNotBlank((String)query)) {
            UrlEncoded.decodeUtf8To((String)query, (Fields)fields);
        }
        return fields;
    }

    public static Fields extractQueryParameters(Request request, Charset charset) {
        Fields fields = new Fields(true);
        String query = request.getHttpURI().getQuery();
        if (StringUtil.isNotBlank((String)query)) {
            UrlEncoded.decodeTo((String)query, (arg_0, arg_1) -> ((Fields)fields).add(arg_0, arg_1), (Charset)charset);
        }
        return fields;
    }

    public static List<HttpCookie> getCookies(Request request) {
        List cookies = (List)request.getAttribute(Request.class.getCanonicalName() + ".Cookies");
        if (cookies != null) {
            return cookies;
        }
        CookieCache cookieCache = (CookieCache)request.getComponents().getCache().get(Request.class.getCanonicalName() + ".CookieCache");
        if (cookieCache == null) {
            cookieCache = new CookieCache(request.getConnectionMetaData().getHttpConfiguration().getRequestCookieCompliance(), null);
            request.getComponents().getCache().put(Request.class.getCanonicalName() + ".CookieCache", cookieCache);
        }
        cookies = cookieCache.getCookies(request.getHeaders());
        request.setAttribute(Request.class.getCanonicalName() + ".Cookies", cookies);
        return cookies;
    }

    public static String toRedirectURI(Request request, String location) {
        if (!URIUtil.hasScheme((String)location) && !request.getConnectionMetaData().getHttpConfiguration().isRelativeRedirectAllowed()) {
            StringBuilder url = new StringBuilder(128);
            HttpURI uri = request.getHttpURI();
            URIUtil.appendSchemeHostPort((StringBuilder)url, (String)uri.getScheme(), (String)Request.getServerName(request), (int)Request.getServerPort(request));
            if (location.startsWith("/")) {
                location = URIUtil.normalizePathQuery((String)location);
            } else {
                String path = uri.getPath();
                String parent = path.endsWith("/") ? path : URIUtil.parentPath((String)path);
                location = URIUtil.normalizePathQuery((String)URIUtil.addEncodedPaths((String)parent, (String)location));
                if (location != null && !location.startsWith("/")) {
                    url.append('/');
                }
            }
            if (location == null) {
                throw new IllegalStateException("redirect path cannot be above root");
            }
            url.append(location);
            location = url.toString();
        }
        return location;
    }

    public static <T extends Wrapper> T as(Request request, Class<T> type) {
        while (request instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)request;
            if (type.isInstance(wrapper)) {
                return (T)wrapper;
            }
            request = wrapper.getWrapped();
        }
        return null;
    }

    public static <T extends Wrapper, R> R get(Request request, Class<T> type, Function<T, R> getter) {
        while (request instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)request;
            if (type.isInstance(wrapper)) {
                return getter.apply(wrapper);
            }
            request = wrapper.getWrapped();
        }
        return null;
    }

    public static Request unWrap(Request request) {
        while (request instanceof Wrapper) {
            Wrapper wrapped = (Wrapper)request;
            request = wrapped.getWrapped();
        }
        return request;
    }

    public static long getContentBytesRead(Request request) {
        Request originalRequest = Request.unWrap(request);
        if (originalRequest instanceof HttpChannelState.ChannelRequest) {
            HttpChannelState.ChannelRequest channelRequest = (HttpChannelState.ChannelRequest)originalRequest;
            return channelRequest.getContentBytesRead();
        }
        return -1L;
    }

    public static class Wrapper
    extends Attributes.Wrapper
    implements Request {
        public Wrapper(Request wrapped) {
            super((Attributes)wrapped);
        }

        @Override
        public String getId() {
            return this.getWrapped().getId();
        }

        @Override
        public Components getComponents() {
            return this.getWrapped().getComponents();
        }

        @Override
        public ConnectionMetaData getConnectionMetaData() {
            return this.getWrapped().getConnectionMetaData();
        }

        @Override
        public String getMethod() {
            return this.getWrapped().getMethod();
        }

        @Override
        public HttpURI getHttpURI() {
            return this.getWrapped().getHttpURI();
        }

        @Override
        public Context getContext() {
            return this.getWrapped().getContext();
        }

        @Override
        public String getPathInContext() {
            return this.getWrapped().getPathInContext();
        }

        @Override
        public HttpFields getHeaders() {
            return this.getWrapped().getHeaders();
        }

        @Override
        public long getTimeStamp() {
            return this.getWrapped().getTimeStamp();
        }

        @Override
        public boolean isSecure() {
            return this.getWrapped().isSecure();
        }

        public long getLength() {
            return this.getWrapped().getLength();
        }

        @Override
        public Content.Chunk read() {
            return this.getWrapped().read();
        }

        public void demand(Runnable demandCallback) {
            this.getWrapped().demand(demandCallback);
        }

        public void fail(Throwable failure) {
            this.getWrapped().fail(failure);
        }

        @Override
        public boolean isPushSupported() {
            return this.getWrapped().isPushSupported();
        }

        @Override
        public void push(MetaData.Request request) {
            this.getWrapped().push(request);
        }

        @Override
        public boolean addErrorListener(Predicate<Throwable> onError) {
            return this.getWrapped().addErrorListener(onError);
        }

        @Override
        public TunnelSupport getTunnelSupport() {
            return this.getWrapped().getTunnelSupport();
        }

        @Override
        public void addHttpStreamWrapper(Function<HttpStream, HttpStream.Wrapper> wrapper) {
            this.getWrapped().addHttpStreamWrapper(wrapper);
        }

        public Request getWrapped() {
            return (Request)super.getWrapped();
        }
    }

    public static class WrapperProcessor
    extends Wrapper
    implements Processor {
        private volatile Processor _processor;

        public WrapperProcessor(Request request) {
            super(request);
        }

        public WrapperProcessor wrapProcessor(Processor processor) {
            this._processor = processor;
            return processor == null ? null : this;
        }

        @Override
        public void process(Request ignored, Response response, Callback callback) throws Exception {
            Processor processor = this._processor;
            if (processor != null) {
                processor.process(this, response, callback);
            }
        }
    }

    @FunctionalInterface
    public static interface Processor
    extends Invocable {
        public void process(Request var1, Response var2, Callback var3) throws Exception;
    }
}

