/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorProcessor;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.Jetty;
import org.eclipse.jetty.util.Uptime;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.AttributeContainerMap;
import org.eclipse.jetty.util.component.ClassLoaderDump;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.Environment;
import org.eclipse.jetty.util.component.Graceful;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.FileSystemPool;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
extends Handler.Wrapper
implements Attributes {
    public static final String BASE_TEMP_DIR_ATTR = "org.eclipse.jetty.server.BaseTempDir";
    private static final Logger LOG = LoggerFactory.getLogger(Server.class);
    private static final String __serverInfo = "jetty/" + Server.getVersion();
    private final AttributeContainerMap _attributes = new AttributeContainerMap();
    private final ThreadPool _threadPool;
    private final List<Connector> _connectors = new CopyOnWriteArrayList<Connector>();
    private final Context _serverContext = new ServerContext();
    private final AutoLock _dateLock = new AutoLock();
    private String _serverInfo = __serverInfo;
    private boolean _stopAtShutdown;
    private boolean _dumpAfterStart;
    private boolean _dumpBeforeStop;
    private Request.Processor _errorProcessor;
    private RequestLog _requestLog;
    private boolean _dryRun;
    private volatile DateField _dateField;
    private long _stopTimeout;
    private Invocable.InvocationType _invocationType = Invocable.InvocationType.NON_BLOCKING;

    public Server() {
        this((ThreadPool)null);
    }

    public Server(@Name(value="port") int port) {
        this((ThreadPool)null);
        ServerConnector connector = new ServerConnector(this);
        connector.setPort(port);
        this.setConnectors(new Connector[]{connector});
        this.addBean(this._attributes);
    }

    public Server(@Name(value="address") InetSocketAddress addr) {
        this((ThreadPool)null);
        ServerConnector connector = new ServerConnector(this);
        connector.setHost(addr.getHostName());
        connector.setPort(addr.getPort());
        this.setConnectors(new Connector[]{connector});
    }

    public Server(@Name(value="threadpool") ThreadPool pool) {
        this._threadPool = pool != null ? pool : new QueuedThreadPool();
        this.addBean(this._threadPool);
        this.setServer(this);
        this.addBean(FileSystemPool.INSTANCE, false);
    }

    public String getServerInfo() {
        return this._serverInfo;
    }

    public void setServerInfo(String serverInfo) {
        this._serverInfo = serverInfo;
    }

    public Context getContext() {
        return this._serverContext;
    }

    @Override
    public Invocable.InvocationType getInvocationType() {
        Handler handler = this.getHandler();
        if (handler == null) {
            return Invocable.InvocationType.NON_BLOCKING;
        }
        return this.isRunning() ? this._invocationType : handler.getInvocationType();
    }

    public boolean isDryRun() {
        return this._dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this._dryRun = dryRun;
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    public Request.Processor getErrorProcessor() {
        return this._errorProcessor;
    }

    public void setRequestLog(RequestLog requestLog) {
        this.updateBean(this._requestLog, requestLog);
        this._requestLog = requestLog;
    }

    public void setErrorProcessor(Request.Processor errorProcessor) {
        this.updateBean(this._errorProcessor, errorProcessor);
        this._errorProcessor = errorProcessor;
    }

    @ManagedAttribute(value="version of this server")
    public static String getVersion() {
        return Jetty.VERSION;
    }

    public void setStopTimeout(long stopTimeout) {
        this._stopTimeout = stopTimeout;
    }

    public long getStopTimeout() {
        return this._stopTimeout;
    }

    public boolean getStopAtShutdown() {
        return this._stopAtShutdown;
    }

    public void setStopAtShutdown(boolean stop) {
        if (stop) {
            if (!this._stopAtShutdown && this.isStarted()) {
                ShutdownThread.register((LifeCycle[])new LifeCycle[]{this});
            }
        } else {
            ShutdownThread.deregister((LifeCycle)this);
        }
        this._stopAtShutdown = stop;
    }

    @ManagedAttribute(value="connectors for this server", readonly=true)
    public Connector[] getConnectors() {
        ArrayList<Connector> connectors = new ArrayList<Connector>(this._connectors);
        return connectors.toArray(new Connector[0]);
    }

    public void addConnector(Connector connector) {
        if (connector.getServer() != this) {
            throw new IllegalArgumentException("Connector " + connector + " cannot be shared among server " + connector.getServer() + " and server " + this);
        }
        this._connectors.add(connector);
        this.addBean(connector);
    }

    public void removeConnector(Connector connector) {
        if (this._connectors.remove(connector)) {
            this.removeBean(connector);
        }
    }

    public void setConnectors(Connector[] connectors) {
        if (connectors != null) {
            for (Connector connector : connectors) {
                if (connector.getServer() == this) continue;
                throw new IllegalArgumentException("Connector " + connector + " cannot be shared among server " + connector.getServer() + " and server " + this);
            }
        }
        Object[] oldConnectors = this.getConnectors();
        this.updateBeans(oldConnectors, connectors);
        this._connectors.removeAll(Arrays.asList(oldConnectors));
        if (connectors != null) {
            this._connectors.addAll(Arrays.asList(connectors));
        }
    }

    public void addBeanToAllConnectors(Object bean) {
        for (Connector connector : this.getConnectors()) {
            connector.addBean(bean);
        }
    }

    @ManagedAttribute(value="the server thread pool")
    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    @ManagedAttribute(value="dump state to stderr after start")
    public boolean isDumpAfterStart() {
        return this._dumpAfterStart;
    }

    public void setDumpAfterStart(boolean dumpAfterStart) {
        this._dumpAfterStart = dumpAfterStart;
    }

    @ManagedAttribute(value="dump state to stderr before stop")
    public boolean isDumpBeforeStop() {
        return this._dumpBeforeStop;
    }

    public void setDumpBeforeStop(boolean dumpBeforeStop) {
        this._dumpBeforeStop = dumpBeforeStop;
    }

    public HttpField getDateField() {
        long now = System.currentTimeMillis();
        long seconds = now / 1000L;
        DateField df = this._dateField;
        if (df == null || df._seconds != seconds) {
            try (AutoLock ignore = this._dateLock.lock();){
                df = this._dateField;
                if (df == null || df._seconds != seconds) {
                    PreEncodedHttpField field = new PreEncodedHttpField(HttpHeader.DATE, DateGenerator.formatDate((long)now));
                    this._dateField = new DateField(seconds, (HttpField)field);
                    PreEncodedHttpField preEncodedHttpField = field;
                    return preEncodedHttpField;
                }
            }
        }
        return df._dateField;
    }

    @Override
    protected void doStart() throws Exception {
        try {
            if (this.getStopAtShutdown()) {
                ShutdownThread.register((LifeCycle[])new LifeCycle[]{this});
            }
            ShutdownMonitor.register(this);
            ShutdownMonitor.getInstance().start();
            if (this._errorProcessor == null) {
                this.setErrorProcessor(new DynamicErrorProcessor());
            }
            String gitHash = Jetty.GIT_HASH;
            String timestamp = Jetty.BUILD_TIMESTAMP;
            LOG.info("jetty-{}; built: {}; git: {}; jvm {}", new Object[]{Server.getVersion(), timestamp, gitHash, System.getProperty("java.runtime.version", System.getProperty("java.version"))});
            if (!Jetty.STABLE) {
                LOG.warn("THIS IS NOT A STABLE RELEASE! DO NOT USE IN PRODUCTION!");
                LOG.warn("Download a stable release from https://download.eclipse.org/jetty/");
            }
            HttpGenerator.setJettyVersion((String)HttpConfiguration.SERVER_VERSION);
            ExceptionUtil.MultiException multiException = new ExceptionUtil.MultiException();
            if (!this._dryRun) {
                this._connectors.stream().filter(NetworkConnector.class::isInstance).map(NetworkConnector.class::cast).forEach(connector -> {
                    try {
                        connector.open();
                    }
                    catch (Throwable th) {
                        multiException.add(th);
                    }
                });
                multiException.ifExceptionThrow();
            }
            super.doStart();
            Handler handler = this.getHandler();
            Invocable.InvocationType invocationType = this._invocationType = handler == null ? Invocable.InvocationType.NON_BLOCKING : handler.getInvocationType();
            if (this._dryRun) {
                LOG.info(String.format("Started(dry run) %s @%dms", this, Uptime.getUptime()));
                throw new AbstractLifeCycle.StopException((AbstractLifeCycle)this);
            }
            for (Connector connector2 : this._connectors) {
                try {
                    connector2.start();
                }
                catch (Throwable e) {
                    multiException.add(e);
                    this._connectors.stream().filter(LifeCycle::isRunning).map(Object.class::cast).forEach(LifeCycle::stop);
                }
            }
            multiException.ifExceptionThrow();
            LOG.info(String.format("Started %s @%dms", this, Uptime.getUptime()));
        }
        catch (Throwable th) {
            this._connectors.stream().filter(NetworkConnector.class::isInstance).map(NetworkConnector.class::cast).forEach(nc -> {
                block2: {
                    try {
                        nc.close();
                    }
                    catch (Throwable th2) {
                        if (th == th2) break block2;
                        th.addSuppressed(th2);
                    }
                }
            });
            throw th;
        }
        finally {
            if (!(!this.isDumpAfterStart() || this._dryRun && this.isDumpBeforeStop())) {
                this.dumpStdErr();
            }
        }
    }

    protected void start(LifeCycle l) throws Exception {
        if (!(l instanceof Connector)) {
            super.start(l);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.isDumpBeforeStop()) {
            this.dumpStdErr();
        }
        LOG.info(String.format("Stopped %s", this));
        if (LOG.isDebugEnabled()) {
            LOG.debug("doStop {}", (Object)this);
        }
        Throwable multiException = null;
        if (this.getStopTimeout() > 0L) {
            long end = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.getStopTimeout());
            try {
                Graceful.shutdown((Container)this).get(this.getStopTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                multiException = ExceptionUtil.combine(multiException, (Throwable)e);
            }
            QueuedThreadPool qtp = (QueuedThreadPool)this.getBean(QueuedThreadPool.class);
            if (qtp != null) {
                qtp.setStopTimeout(Math.max(1000L, TimeUnit.NANOSECONDS.toMillis(end - System.nanoTime())));
            }
        }
        for (Connector connector : this._connectors) {
            try {
                connector.stop();
            }
            catch (Throwable e) {
                multiException = ExceptionUtil.combine((Throwable)multiException, (Throwable)e);
            }
        }
        try {
            super.doStop();
        }
        catch (Throwable e) {
            multiException = ExceptionUtil.combine(multiException, (Throwable)e);
        }
        if (this.getErrorProcessor() instanceof DynamicErrorProcessor) {
            this.setErrorProcessor(null);
        }
        if (this.getStopAtShutdown()) {
            ShutdownThread.deregister((LifeCycle)this);
        }
        ShutdownMonitor.deregister(this);
        ExceptionUtil.ifExceptionThrow((Throwable)multiException);
    }

    public void join() throws InterruptedException {
        this.getThreadPool().join();
    }

    public Object setAttribute(String name, Object attribute) {
        return this._attributes.setAttribute(name, attribute);
    }

    public Object removeAttribute(String name) {
        return this._attributes.removeAttribute(name);
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Set<String> getAttributeNameSet() {
        return this._attributes.getAttributeNameSet();
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public URI getURI() {
        NetworkConnector connector = null;
        for (Connector c : this._connectors) {
            if (!(c instanceof NetworkConnector)) continue;
            connector = (NetworkConnector)c;
            break;
        }
        if (connector == null) {
            return null;
        }
        ContextHandler context = this.getDescendant(ContextHandler.class);
        try {
            String host;
            String protocol = connector.getDefaultConnectionFactory().getProtocol();
            String scheme = "http";
            if (protocol.startsWith("SSL-") || protocol.equals("SSL")) {
                scheme = "https";
            }
            if ((host = connector.getHost()) == null) {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            int port = connector.getLocalPort();
            String path = "/";
            if (context != null) {
                int at;
                Optional<String> vhost = context.getVirtualHosts().stream().filter(h -> !h.startsWith("*.") && !h.startsWith("@")).findFirst();
                if (vhost.isPresent() && (at = (host = vhost.get()).indexOf(64)) > 0) {
                    host = host.substring(0, at);
                }
                path = context.getContextPath();
            }
            return new URI(scheme, null, host, port, path, null, null);
        }
        catch (Exception e) {
            LOG.warn("Unable to build server URI", (Throwable)e);
            return null;
        }
    }

    @Override
    public Server getServer() {
        return this;
    }

    public Resource getDefaultStyleSheet() {
        return this.newResource("jetty-dir.css");
    }

    public Resource getDefaultFavicon() {
        return this.newResource("favicon.ico");
    }

    private Resource newResource(String name) {
        URL url = this.getClass().getResource(name);
        if (url == null) {
            throw new IllegalStateException("Missing server resource: " + name);
        }
        return ResourceFactory.root().newMemoryResource(url);
    }

    public String toString() {
        return String.format("%s[%s,sto=%d]", super.toString(), Server.getVersion(), this.getStopTimeout());
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{new ClassLoaderDump(this.getClass().getClassLoader()), new DumpableCollection("environments", Environment.getAll()), FileSystemPool.INSTANCE});
    }

    public static void main(String ... args) {
        System.err.println(Server.getVersion());
    }

    private class ServerContext
    extends Attributes.Wrapper
    implements Context {
        private ServerContext() {
            super((Attributes)Server.this);
        }

        @Override
        public String getContextPath() {
            return null;
        }

        @Override
        public ClassLoader getClassLoader() {
            return Server.class.getClassLoader();
        }

        @Override
        public Resource getBaseResource() {
            return null;
        }

        @Override
        public List<String> getVirtualHosts() {
            return Collections.emptyList();
        }

        @Override
        public void run(Runnable runnable) {
            runnable.run();
        }

        @Override
        public void run(Runnable runnable, Request request) {
            runnable.run();
        }

        @Override
        public void execute(Runnable runnable) {
            Server.this.getThreadPool().execute(runnable);
        }

        @Override
        public Request.Processor getErrorProcessor() {
            return Server.this.getErrorProcessor();
        }

        public <T> T decorate(T o) {
            DecoratedObjectFactory factory = (DecoratedObjectFactory)Server.this.getBean(DecoratedObjectFactory.class);
            if (factory != null) {
                return (T)factory.decorate(o);
            }
            return o;
        }

        public void destroy(Object o) {
            DecoratedObjectFactory factory = (DecoratedObjectFactory)Server.this.getBean(DecoratedObjectFactory.class);
            if (factory != null) {
                factory.destroy(o);
            }
        }
    }

    private static class DateField {
        final long _seconds;
        final HttpField _dateField;

        public DateField(long seconds, HttpField dateField) {
            this._seconds = seconds;
            this._dateField = dateField;
        }
    }

    private static class DynamicErrorProcessor
    extends ErrorProcessor {
        private DynamicErrorProcessor() {
        }
    }

    private class ServerEnvironment
    extends Attributes.Wrapper
    implements Environment {
        private ServerEnvironment() {
            super((Attributes)Server.this);
        }

        public String getName() {
            return "Server";
        }

        public ClassLoader getClassLoader() {
            return Server.class.getClassLoader();
        }
    }
}

