/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectHandler
extends Handler.Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectHandler.class);
    private final Set<String> whiteList = new HashSet<String>();
    private final Set<String> blackList = new HashSet<String>();
    private Executor executor;
    private Scheduler scheduler;
    private ByteBufferPool bufferPool;
    private SelectorManager selector;
    private long connectTimeout = 15000L;
    private long idleTimeout = 30000L;
    private int bufferSize = 4096;

    public ConnectHandler() {
        this((Handler)null);
    }

    public ConnectHandler(Handler handler) {
        this.setHandler(handler);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.updateBean(this.scheduler, scheduler);
        this.scheduler = scheduler;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.bufferPool;
    }

    public void setByteBufferPool(ByteBufferPool bufferPool) {
        this.updateBean(this.bufferPool, bufferPool);
        this.bufferPool = bufferPool;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.executor == null) {
            this.executor = this.getServer().getThreadPool();
        }
        if (this.scheduler == null) {
            this.scheduler = (Scheduler)this.getServer().getBean(Scheduler.class);
            if (this.scheduler == null) {
                this.scheduler = new ScheduledExecutorScheduler(String.format("Proxy-Scheduler-%x", this.hashCode()), false);
            }
            this.addBean(this.scheduler);
        }
        if (this.bufferPool == null) {
            this.bufferPool = new MappedByteBufferPool();
            this.addBean(this.bufferPool);
        }
        this.selector = this.newSelectorManager();
        this.addBean(this.selector);
        this.selector.setConnectTimeout(this.getConnectTimeout());
        super.doStart();
    }

    protected SelectorManager newSelectorManager() {
        return new ConnectManager(this.getExecutor(), this.getScheduler(), 1);
    }

    @Override
    public Request.Processor handle(Request request) throws Exception {
        TunnelSupport tunnelSupport;
        if (HttpMethod.CONNECT.is(request.getMethod()) && (tunnelSupport = request.getTunnelSupport()) != null && tunnelSupport.getProtocol() == null) {
            return (req, res, cbk) -> {
                HttpURI httpURI = req.getHttpURI();
                String serverAddress = httpURI.getAuthority();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CONNECT request for {}", (Object)serverAddress);
                }
                this.handleConnect(req, res, cbk, serverAddress);
            };
        }
        return super.handle(request);
    }

    protected void handleConnect(final Request request, final Response response, final Callback callback, String serverAddress) {
        try {
            int port;
            boolean proceed = this.handleAuthentication(request, response, serverAddress);
            if (!proceed) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Missing proxy authentication");
                }
                this.sendConnectResponse(request, response, callback, 407);
                return;
            }
            HostPort hostPort = new HostPort(serverAddress);
            String host = hostPort.getHost();
            if (!this.validateDestination(host, port = hostPort.getPort(80))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Destination {}:{} forbidden", (Object)host, (Object)port);
                }
                this.sendConnectResponse(request, response, callback, 403);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connecting to {}:{}", (Object)host, (Object)port);
            }
            this.connectToServer(request, host, port, new Promise<SocketChannel>(){

                public void succeeded(SocketChannel channel) {
                    ConnectContext connectContext = new ConnectContext(request, response, callback, request.getTunnelSupport().getEndPoint());
                    if (channel.isConnected()) {
                        ConnectHandler.this.selector.accept((SelectableChannel)channel, (Object)connectContext);
                    } else {
                        ConnectHandler.this.selector.connect((SelectableChannel)channel, (Object)connectContext);
                    }
                }

                public void failed(Throwable x) {
                    ConnectHandler.this.onConnectFailure(request, response, callback, x);
                }
            });
        }
        catch (Exception x) {
            this.onConnectFailure(request, response, callback, x);
        }
    }

    protected void connectToServer(Request request, String host, int port, Promise<SocketChannel> promise) {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            channel.socket().setTcpNoDelay(true);
            channel.configureBlocking(false);
            InetSocketAddress address = this.newConnectAddress(host, port);
            channel.connect(address);
            promise.succeeded((Object)channel);
        }
        catch (Throwable x) {
            this.close(channel);
            promise.failed(x);
        }
    }

    private void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable x) {
            LOG.trace("IGNORED", x);
        }
    }

    protected InetSocketAddress newConnectAddress(String host, int port) {
        return new InetSocketAddress(host, port);
    }

    protected void onConnectSuccess(ConnectContext connectContext, UpstreamConnection upstreamConnection) {
        ConcurrentMap<String, Object> context = connectContext.getContext();
        Request request = connectContext.getRequest();
        this.prepareContext(request, context);
        EndPoint downstreamEndPoint = connectContext.getEndPoint();
        DownstreamConnection downstreamConnection = this.newDownstreamConnection(downstreamEndPoint, context);
        downstreamConnection.setInputBufferSize(this.getBufferSize());
        upstreamConnection.setConnection(downstreamConnection);
        downstreamConnection.setConnection(upstreamConnection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection setup completed: {}<->{}", (Object)downstreamConnection, (Object)upstreamConnection);
        }
        Response response = connectContext.getResponse();
        this.upgradeConnection(request, (Connection)downstreamConnection);
        this.sendConnectResponse(request, response, connectContext.callback, 200);
    }

    protected void onConnectFailure(Request request, Response response, Callback callback, Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CONNECT failed", failure);
        }
        this.sendConnectResponse(request, response, callback, 500);
    }

    private void sendConnectResponse(Request request, Response response, Callback callback, int statusCode) {
        block5: {
            try {
                response.getHeaders().putLongField(HttpHeader.CONTENT_LENGTH, 0L);
                if (statusCode != 200) {
                    response.getHeaders().put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                    Response.writeError(request, response, callback, statusCode);
                } else {
                    response.setStatus(200);
                    callback.succeeded();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CONNECT response sent {} {}", (Object)request.getConnectionMetaData().getProtocol(), (Object)statusCode);
                }
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug("Could not send CONNECT response", x);
            }
        }
    }

    protected boolean handleAuthentication(Request request, Response response, String address) {
        return true;
    }

    protected DownstreamConnection newDownstreamConnection(EndPoint endPoint, ConcurrentMap<String, Object> context) {
        return new DownstreamConnection(endPoint, this.getExecutor(), this.getByteBufferPool(), context);
    }

    protected UpstreamConnection newUpstreamConnection(EndPoint endPoint, ConnectContext connectContext) {
        return new UpstreamConnection(endPoint, this.getExecutor(), this.getByteBufferPool(), connectContext);
    }

    protected void prepareContext(Request request, ConcurrentMap<String, Object> context) {
    }

    private void upgradeConnection(Request request, Connection connection) {
        request.setAttribute(HttpStream.UPGRADE_CONNECTION_ATTRIBUTE, connection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Upgraded connection to {}", (Object)connection);
        }
    }

    protected int read(EndPoint endPoint, ByteBuffer buffer, ConcurrentMap<String, Object> context) throws IOException {
        return endPoint.fill(buffer);
    }

    protected void write(EndPoint endPoint, ByteBuffer buffer, Callback callback, ConcurrentMap<String, Object> context) {
        endPoint.write(callback, new ByteBuffer[]{buffer});
    }

    public Set<String> getWhiteListHosts() {
        return this.whiteList;
    }

    public Set<String> getBlackListHosts() {
        return this.blackList;
    }

    public boolean validateDestination(String host, int port) {
        String hostPort = host + ":" + port;
        if (!this.whiteList.isEmpty() && !this.whiteList.contains(hostPort)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Host {}:{} not whitelisted", (Object)host, (Object)port);
            }
            return false;
        }
        if (!this.blackList.isEmpty() && this.blackList.contains(hostPort)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Host {}:{} blacklisted", (Object)host, (Object)port);
            }
            return false;
        }
        return true;
    }

    protected class ConnectManager
    extends SelectorManager {
        protected ConnectManager(Executor executor, Scheduler scheduler, int selectors) {
            super(executor, scheduler, selectors);
        }

        protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey key) {
            SocketChannelEndPoint endPoint = new SocketChannelEndPoint((SocketChannel)channel, selector, key, this.getScheduler());
            endPoint.setIdleTimeout(ConnectHandler.this.getIdleTimeout());
            return endPoint;
        }

        public Connection newConnection(SelectableChannel channel, EndPoint endpoint, Object attachment) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connected to {}", (Object)((SocketChannel)channel).getRemoteAddress());
            }
            ConnectContext connectContext = (ConnectContext)attachment;
            UpstreamConnection connection = ConnectHandler.this.newUpstreamConnection(endpoint, connectContext);
            connection.setInputBufferSize(ConnectHandler.this.getBufferSize());
            return connection;
        }

        protected void connectionFailed(SelectableChannel channel, Throwable ex, Object attachment) {
            ConnectHandler.this.close(channel);
            ConnectContext connectContext = (ConnectContext)attachment;
            ConnectHandler.this.onConnectFailure(connectContext.request, connectContext.response, connectContext.callback, ex);
        }
    }

    protected static class ConnectContext {
        private final ConcurrentMap<String, Object> context = new ConcurrentHashMap<String, Object>();
        private final Request request;
        private final Response response;
        private final Callback callback;
        private final EndPoint endPoint;

        public ConnectContext(Request request, Response response, Callback callback, EndPoint endPoint) {
            this.request = request;
            this.response = response;
            this.callback = callback;
            this.endPoint = endPoint;
        }

        public ConcurrentMap<String, Object> getContext() {
            return this.context;
        }

        public Request getRequest() {
            return this.request;
        }

        public Response getResponse() {
            return this.response;
        }

        public Callback getCallback() {
            return this.callback;
        }

        public EndPoint getEndPoint() {
            return this.endPoint;
        }
    }

    public class DownstreamConnection
    extends TunnelConnection
    implements Connection.UpgradeTo {
        private ByteBuffer buffer;

        public DownstreamConnection(EndPoint endPoint, Executor executor, ByteBufferPool bufferPool, ConcurrentMap<String, Object> context) {
            super(endPoint, executor, bufferPool, context);
        }

        public void onUpgradeTo(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        public void onOpen() {
            super.onOpen();
            if (this.buffer == null) {
                this.fillInterested();
                return;
            }
            final int remaining = this.buffer.remaining();
            this.write(this.getConnection().getEndPoint(), this.buffer, new Callback(){

                public void succeeded() {
                    DownstreamConnection.this.buffer = null;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Wrote initial {} bytes to server {}", (Object)remaining, (Object)DownstreamConnection.this);
                    }
                    DownstreamConnection.this.fillInterested();
                }

                public void failed(Throwable x) {
                    DownstreamConnection.this.buffer = null;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed to write initial {} bytes to server {}", new Object[]{remaining, DownstreamConnection.this, x});
                    }
                    DownstreamConnection.this.close();
                    DownstreamConnection.this.getConnection().close();
                }
            });
        }

        @Override
        protected int read(EndPoint endPoint, ByteBuffer buffer) throws IOException {
            int read = ConnectHandler.this.read(endPoint, buffer, this.getContext());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read {} bytes from client {}", (Object)read, (Object)this);
            }
            return read;
        }

        @Override
        protected void write(EndPoint endPoint, ByteBuffer buffer, Callback callback) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Writing {} bytes to server {}", (Object)buffer.remaining(), (Object)this);
            }
            ConnectHandler.this.write(endPoint, buffer, callback, this.getContext());
        }
    }

    public class UpstreamConnection
    extends TunnelConnection {
        private final ConnectContext connectContext;

        public UpstreamConnection(EndPoint endPoint, Executor executor, ByteBufferPool bufferPool, ConnectContext connectContext) {
            super(endPoint, executor, bufferPool, connectContext.getContext());
            this.connectContext = connectContext;
        }

        public void onOpen() {
            super.onOpen();
            ConnectHandler.this.onConnectSuccess(this.connectContext, this);
            this.fillInterested();
        }

        @Override
        protected int read(EndPoint endPoint, ByteBuffer buffer) throws IOException {
            int read = ConnectHandler.this.read(endPoint, buffer, this.getContext());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read {} bytes from server {}", (Object)read, (Object)this);
            }
            return read;
        }

        @Override
        protected void write(EndPoint endPoint, ByteBuffer buffer, Callback callback) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Writing {} bytes to client {}", (Object)buffer.remaining(), (Object)this);
            }
            ConnectHandler.this.write(endPoint, buffer, callback, this.getContext());
        }
    }

    private static abstract class TunnelConnection
    extends AbstractConnection {
        private final IteratingCallback pipe = new ProxyIteratingCallback();
        private final ByteBufferPool bufferPool;
        private final ConcurrentMap<String, Object> context;
        private TunnelConnection connection;

        protected TunnelConnection(EndPoint endPoint, Executor executor, ByteBufferPool bufferPool, ConcurrentMap<String, Object> context) {
            super(endPoint, executor);
            this.bufferPool = bufferPool;
            this.context = context;
        }

        public ByteBufferPool getByteBufferPool() {
            return this.bufferPool;
        }

        public ConcurrentMap<String, Object> getContext() {
            return this.context;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void setConnection(TunnelConnection connection) {
            this.connection = connection;
        }

        public void onFillable() {
            this.pipe.iterate();
        }

        protected abstract int read(EndPoint var1, ByteBuffer var2) throws IOException;

        protected abstract void write(EndPoint var1, ByteBuffer var2, Callback var3);

        protected void close(Throwable failure) {
            this.getEndPoint().close(failure);
        }

        public String toConnectionString() {
            EndPoint endPoint = this.getEndPoint();
            return String.format("%s@%x[l:%s<=>r:%s]", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), endPoint.getLocalSocketAddress(), endPoint.getRemoteSocketAddress());
        }

        private class ProxyIteratingCallback
        extends IteratingCallback {
            private ByteBuffer buffer;
            private int filled;

            private ProxyIteratingCallback() {
            }

            protected IteratingCallback.Action process() {
                this.buffer = TunnelConnection.this.bufferPool.acquire(TunnelConnection.this.getInputBufferSize(), true);
                try {
                    int filled = this.filled = TunnelConnection.this.read(TunnelConnection.this.getEndPoint(), this.buffer);
                    if (filled > 0) {
                        TunnelConnection.this.write(TunnelConnection.this.connection.getEndPoint(), this.buffer, (Callback)this);
                        return IteratingCallback.Action.SCHEDULED;
                    }
                    if (filled == 0) {
                        TunnelConnection.this.bufferPool.release(this.buffer);
                        TunnelConnection.this.fillInterested();
                        return IteratingCallback.Action.IDLE;
                    }
                    TunnelConnection.this.bufferPool.release(this.buffer);
                    TunnelConnection.this.connection.getEndPoint().shutdownOutput();
                    return IteratingCallback.Action.SUCCEEDED;
                }
                catch (IOException x) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not fill {}", (Object)TunnelConnection.this, (Object)x);
                    }
                    TunnelConnection.this.bufferPool.release(this.buffer);
                    this.disconnect(x);
                    return IteratingCallback.Action.SUCCEEDED;
                }
            }

            public void succeeded() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Wrote {} bytes {}", (Object)this.filled, (Object)TunnelConnection.this);
                }
                TunnelConnection.this.bufferPool.release(this.buffer);
                super.succeeded();
            }

            protected void onCompleteSuccess() {
            }

            protected void onCompleteFailure(Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed to write {} bytes {}", new Object[]{this.filled, TunnelConnection.this, x});
                }
                TunnelConnection.this.bufferPool.release(this.buffer);
                this.disconnect(x);
            }

            private void disconnect(Throwable x) {
                TunnelConnection.this.close(x);
                TunnelConnection.this.connection.close(x);
            }
        }
    }
}

