/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.InetAccessSet;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.InetAddressPattern;
import org.eclipse.jetty.util.component.DumpableCollection;

public class InetAccessHandler
extends Handler.Wrapper {
    private final IncludeExcludeSet<InetAccessSet.PatternTuple, InetAccessSet.AccessTuple> _set = new IncludeExcludeSet(InetAccessSet.class);

    public void clear() {
        this._set.clear();
    }

    public void include(String pattern) {
        this._set.include((Object)InetAccessSet.PatternTuple.from(pattern));
    }

    public void include(String ... patterns) {
        for (String pattern : patterns) {
            this.include(pattern);
        }
    }

    public void include(String connectorName, String addressPattern, PathSpec pathSpec) {
        this._set.include((Object)new InetAccessSet.PatternTuple(connectorName, InetAddressPattern.from((String)addressPattern), pathSpec));
    }

    public void exclude(String pattern) {
        this._set.exclude((Object)InetAccessSet.PatternTuple.from(pattern));
    }

    public void exclude(String ... patterns) {
        for (String pattern : patterns) {
            this.exclude(pattern);
        }
    }

    public void exclude(String connectorName, String addressPattern, PathSpec pathSpec) {
        this._set.exclude((Object)new InetAccessSet.PatternTuple(connectorName, InetAddressPattern.from((String)addressPattern), pathSpec));
    }

    @Deprecated
    public void includeConnector(String name) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void excludeConnector(String name) {
        this._set.exclude((Object)new InetAccessSet.PatternTuple(name, null, null));
    }

    @Deprecated
    public void includeConnectors(String ... names) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void excludeConnectors(String ... names) {
        for (String name : names) {
            this.excludeConnector(name);
        }
    }

    @Override
    public Request.Processor handle(Request request) throws Exception {
        InetSocketAddress inetSocketAddress;
        SocketAddress socketAddress = request.getConnectionMetaData().getRemoteSocketAddress();
        if (socketAddress instanceof InetSocketAddress && !this.isAllowed((inetSocketAddress = (InetSocketAddress)socketAddress).getAddress(), request)) {
            return null;
        }
        return super.handle(request);
    }

    protected boolean isAllowed(InetAddress addr, Request request) {
        String connectorName = request.getConnectionMetaData().getConnector().getName();
        String path = request.getPathInContext();
        return this._set.test((Object)new InetAccessSet.AccessTuple(connectorName, addr, path));
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{new DumpableCollection("included", (Collection)this._set.getIncluded()), new DumpableCollection("excluded", (Collection)this._set.getExcluded())});
    }
}

