/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.URIUtil;

public class SecuredRedirectHandler
extends Handler.Wrapper {
    private final int _redirectCode;

    public SecuredRedirectHandler() {
        this(302);
    }

    public SecuredRedirectHandler(int code) {
        if (!HttpStatus.isRedirection((int)code)) {
            throw new IllegalArgumentException("Not a 3xx redirect code");
        }
        this._redirectCode = code;
    }

    @Override
    public Request.Processor handle(Request request) throws Exception {
        if (request.isSecure()) {
            return super.handle(request);
        }
        return (rq, rs, cb) -> {
            HttpConfiguration httpConfig = rq.getConnectionMetaData().getHttpConfiguration();
            int securePort = httpConfig.getSecurePort();
            if (securePort > 0) {
                String secureScheme = httpConfig.getSecureScheme();
                String url = URIUtil.newURI((String)secureScheme, (String)Request.getServerName(request), (int)securePort, (String)request.getHttpURI().getPath(), (String)request.getHttpURI().getQuery());
                rs.getHeaders().put(HttpHeader.LOCATION, url);
                rs.setStatus(this._redirectCode);
                rs.write(true, null, cb);
            } else {
                Response.writeError(rq, rs, cb, 403, "HttpConfiguration.securePort not configured");
            }
        };
    }
}

