/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.nio.ByteBuffer;
import java.util.EventListener;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;

public class StatisticsHandler
extends Handler.Wrapper {
    private final Set<String> _connectionStats = ConcurrentHashMap.newKeySet();
    private final CounterStatistic _requestStats = new CounterStatistic();
    private final CounterStatistic _handleStats = new CounterStatistic();
    private final CounterStatistic _processStats = new CounterStatistic();
    private final SampleStatistic _requestTimeStats = new SampleStatistic();
    private final SampleStatistic _handleTimeStats = new SampleStatistic();
    private final SampleStatistic _processTimeStats = new SampleStatistic();
    private final LongAdder _processThrows = new LongAdder();
    private final LongAdder _handleThrows = new LongAdder();
    private final LongAdder _responses1xx = new LongAdder();
    private final LongAdder _responses2xx = new LongAdder();
    private final LongAdder _responses3xx = new LongAdder();
    private final LongAdder _responses4xx = new LongAdder();
    private final LongAdder _responses5xx = new LongAdder();

    @Override
    public Request.Processor handle(Request request) throws Exception {
        long beginTimeStamp = System.nanoTime();
        this._handleStats.increment();
        StatisticsRequest statisticsRequest = new StatisticsRequest(request);
        try {
            Request.WrapperProcessor wrapperProcessor = statisticsRequest.wrapProcessor(super.handle(statisticsRequest));
            return wrapperProcessor;
        }
        catch (Throwable t) {
            this._handleThrows.increment();
            throw t;
        }
        finally {
            this._handleStats.decrement();
            this._handleTimeStats.record(System.nanoTime() - beginTimeStamp);
        }
    }

    @ManagedOperation(value="resets the statistics", impact="ACTION")
    public void reset() {
        this._connectionStats.clear();
        this._requestStats.reset();
        this._handleStats.reset();
        this._processStats.reset();
        this._requestTimeStats.reset();
        this._handleTimeStats.reset();
        this._processTimeStats.reset();
        this._processThrows.reset();
        this._handleThrows.reset();
        this._responses1xx.reset();
        this._responses2xx.reset();
        this._responses3xx.reset();
        this._responses4xx.reset();
        this._responses5xx.reset();
    }

    @ManagedAttribute(value="number of requests")
    public int getRequests() {
        return (int)this._requestStats.getTotal();
    }

    @ManagedAttribute(value="number of requests currently active")
    public int getRequestsActive() {
        return (int)this._requestStats.getCurrent();
    }

    @ManagedAttribute(value="maximum number of active requests")
    public int getRequestsActiveMax() {
        return (int)this._requestStats.getMax();
    }

    @ManagedAttribute(value="number of requests with 1xx response status")
    public int getResponses1xx() {
        return this._responses1xx.intValue();
    }

    @ManagedAttribute(value="number of requests with 2xx response status")
    public int getResponses2xx() {
        return this._responses2xx.intValue();
    }

    @ManagedAttribute(value="number of requests with 3xx response status")
    public int getResponses3xx() {
        return this._responses3xx.intValue();
    }

    @ManagedAttribute(value="number of requests with 4xx response status")
    public int getResponses4xx() {
        return this._responses4xx.intValue();
    }

    @ManagedAttribute(value="number of requests with 5xx response status")
    public int getResponses5xx() {
        return this._responses5xx.intValue();
    }

    @ManagedAttribute(value="number of requests that threw an exception during handling")
    public int getHandleThrows() {
        return this._handleThrows.intValue();
    }

    @ManagedAttribute(value="number of requests that threw an exception during processing")
    public int getProcessThrows() {
        return this._processThrows.intValue();
    }

    @ManagedAttribute(value="")
    public int getHandlings() {
        return (int)this._handleStats.getTotal();
    }

    @ManagedAttribute(value="")
    public int getProcessings() {
        return (int)this._processStats.getTotal();
    }

    @ManagedAttribute(value="")
    public int getProcessingsActive() {
        return (int)this._processStats.getCurrent();
    }

    @ManagedAttribute(value="")
    public int getProcessingsMax() {
        return (int)this._processStats.getMax();
    }

    @ManagedAttribute(value="total time spend in all request execution (in ns)")
    public long getRequestTimeTotal() {
        return this._requestTimeStats.getTotal();
    }

    @ManagedAttribute(value="maximum time spend executing requests (in ns)")
    public long getRequestTimeMax() {
        return this._requestTimeStats.getMax();
    }

    @ManagedAttribute(value="mean time spent executing requests (in ns)")
    public double getRequestTimeMean() {
        return this._requestTimeStats.getMean();
    }

    @ManagedAttribute(value="standard deviation for request execution (in ns)")
    public double getRequestTimeStdDev() {
        return this._requestTimeStats.getStdDev();
    }

    @ManagedAttribute(value="(in ns)")
    public long getHandlingTimeTotal() {
        return this._handleTimeStats.getTotal();
    }

    @ManagedAttribute(value="(in ns)")
    public long getHandlingTimeMax() {
        return this._handleTimeStats.getMax();
    }

    @ManagedAttribute(value="(in ns)")
    public double getHandlingTimeMean() {
        return this._handleTimeStats.getMean();
    }

    @ManagedAttribute(value="(in ns)")
    public double getHandlingTimeStdDev() {
        return this._handleTimeStats.getStdDev();
    }

    @ManagedAttribute(value="(in ns)")
    public long getProcessingTimeTotal() {
        return this._processTimeStats.getTotal();
    }

    @ManagedAttribute(value="(in ns)")
    public long getProcessingTimeMax() {
        return this._processTimeStats.getMax();
    }

    @ManagedAttribute(value="(in ns)")
    public double getProcessingTimeMean() {
        return this._processTimeStats.getMean();
    }

    @ManagedAttribute(value="(in ns)")
    public double getProcessingTimeStdDev() {
        return this._processTimeStats.getStdDev();
    }

    private class StatisticsRequest
    extends Request.WrapperProcessor {
        private final LongAdder _bytesRead;
        private final LongAdder _bytesWritten;
        private long _processStartTimeStamp;

        private StatisticsRequest(Request request) {
            super(request);
            this._bytesRead = new LongAdder();
            this._bytesWritten = new LongAdder();
        }

        public Object getAttribute(String name) {
            return switch (name) {
                case "o.e.j.s.h.StatsHandler.bytesRead" -> this._bytesRead.longValue();
                case "o.e.j.s.h.StatsHandler.bytesWritten" -> this._bytesWritten.longValue();
                case "o.e.j.s.h.StatsHandler.spentTime" -> this.spentTimeNs();
                case "o.e.j.s.h.StatsHandler.dataReadRate" -> this.dataRatePerSecond(this._bytesRead.longValue());
                case "o.e.j.s.h.StatsHandler.dataWriteRate" -> this.dataRatePerSecond(this._bytesWritten.longValue());
                default -> super.getAttribute(name);
            };
        }

        private long dataRatePerSecond(long dataCount) {
            return (long)((float)dataCount / ((float)this.spentTimeNs() / 1.0E9f));
        }

        private long spentTimeNs() {
            return System.nanoTime() - this._processStartTimeStamp;
        }

        @Override
        public void process(Request ignored, Response response, Callback callback) throws Exception {
            this._processStartTimeStamp = System.nanoTime();
            StatisticsHandler.this._processStats.increment();
            StatisticsHandler.this._requestStats.increment();
            final String id = this.getConnectionMetaData().getId();
            if (StatisticsHandler.this._connectionStats.add(id)) {
                this.getConnectionMetaData().getConnection().addEventListener((EventListener)new Connection.Listener(){

                    public void onClosed(Connection connection) {
                        StatisticsHandler.this._connectionStats.remove(id);
                    }
                });
            }
            this.addHttpStreamWrapper(s -> new HttpStream.Wrapper((HttpStream)s){

                @Override
                public void send(MetaData.Request request, MetaData.Response response, boolean last, ByteBuffer content, Callback callback) {
                    if (response != null) {
                        switch (response.getStatus() / 100) {
                            case 1: {
                                StatisticsHandler.this._responses1xx.increment();
                                break;
                            }
                            case 2: {
                                StatisticsHandler.this._responses2xx.increment();
                                break;
                            }
                            case 3: {
                                StatisticsHandler.this._responses3xx.increment();
                                break;
                            }
                            case 4: {
                                StatisticsHandler.this._responses4xx.increment();
                                break;
                            }
                            case 5: {
                                StatisticsHandler.this._responses5xx.increment();
                            }
                        }
                    }
                    StatisticsRequest.this._bytesWritten.add(BufferUtil.length((ByteBuffer)content));
                    super.send(request, response, last, content, callback);
                }

                @Override
                public Content.Chunk read() {
                    Content.Chunk chunk = super.read();
                    if (chunk != null) {
                        StatisticsRequest.this._bytesRead.add(chunk.remaining());
                    }
                    return chunk;
                }

                @Override
                public void succeeded() {
                    StatisticsHandler.this._requestStats.decrement();
                    StatisticsHandler.this._requestTimeStats.record(System.nanoTime() - this.getNanoTimeStamp());
                    super.succeeded();
                }

                @Override
                public void failed(Throwable x) {
                    StatisticsHandler.this._requestStats.decrement();
                    StatisticsHandler.this._requestTimeStats.record(System.nanoTime() - this.getNanoTimeStamp());
                    super.failed(x);
                }
            });
            try {
                super.process(this, response, callback);
            }
            catch (Throwable t) {
                StatisticsHandler.this._processThrows.increment();
                throw t;
            }
            finally {
                StatisticsHandler.this._processStats.decrement();
                StatisticsHandler.this._processTimeStats.record(System.nanoTime() - this._processStartTimeStamp);
            }
        }
    }

    static class MinimumDataRateHandler
    extends StatisticsHandler {
        private final long _minimumReadRate;
        private final long _minimumWriteRate;

        public MinimumDataRateHandler(long minimumReadRate, long minimumWriteRate) {
            this._minimumReadRate = minimumReadRate;
            this._minimumWriteRate = minimumWriteRate;
        }

        @Override
        public Request.Processor handle(Request request) throws Exception {
            MinimumDataRateRequest minimumDataRateRequest = new MinimumDataRateRequest(request);
            Request.Processor processor = super.handle(minimumDataRateRequest);
            if (processor == null) {
                return null;
            }
            return minimumDataRateRequest.wrapProcessor(processor);
        }

        private class MinimumDataRateRequest
        extends Request.WrapperProcessor {
            private StatisticsRequest _statisticsRequest;
            private Content.Chunk.Error _errorContent;

            private MinimumDataRateRequest(Request request) {
                super(request);
            }

            public Object getAttribute(String name) {
                return this._statisticsRequest.getAttribute(name);
            }

            @Override
            public void demand(Runnable demandCallback) {
                Long rr;
                if (MinimumDataRateHandler.this._minimumReadRate > 0L && (rr = (Long)this.getAttribute("o.e.j.s.h.StatsHandler.dataReadRate")) < MinimumDataRateHandler.this._minimumReadRate) {
                    this._errorContent = Content.Chunk.from((Throwable)new TimeoutException("read rate is too low: " + rr));
                    demandCallback.run();
                    return;
                }
                super.demand(demandCallback);
            }

            @Override
            public Content.Chunk read() {
                return this._errorContent != null ? this._errorContent : super.read();
            }

            @Override
            public Request.WrapperProcessor wrapProcessor(Request.Processor processor) {
                this._statisticsRequest = (StatisticsRequest)processor;
                return super.wrapProcessor(processor);
            }

            @Override
            public void process(Request ignored, Response response, Callback callback) throws Exception {
                super.process(ignored, new MinimumDataRateResponse(this, response), callback);
            }
        }

        private class MinimumDataRateResponse
        extends Response.Wrapper {
            private MinimumDataRateResponse(Request request, Response wrapped) {
                super(request, wrapped);
            }

            @Override
            public void write(boolean last, ByteBuffer content, Callback callback) {
                Long wr;
                MinimumDataRateRequest request;
                if (MinimumDataRateHandler.this._minimumWriteRate > 0L && (Long)(request = (MinimumDataRateRequest)this.getRequest()).getAttribute("o.e.j.s.h.StatsHandler.bytesWritten") > 0L && (wr = (Long)request.getAttribute("o.e.j.s.h.StatsHandler.dataWriteRate")) < MinimumDataRateHandler.this._minimumWriteRate) {
                    TimeoutException cause = new TimeoutException("write rate is too low: " + wr);
                    request._errorContent = Content.Chunk.from((Throwable)cause);
                    callback.failed((Throwable)cause);
                    return;
                }
                super.write(last, content, callback);
            }
        }
    }
}

