/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.gzip;

import java.nio.ByteBuffer;
import java.nio.channels.WritePendingException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.gzip.GzipFactory;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.eclipse.jetty.util.compression.CompressionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GzipResponse
extends Response.Wrapper {
    public static Logger LOG = LoggerFactory.getLogger(GzipResponse.class);
    private static final byte[] GZIP_HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    public static final HttpField VARY_ACCEPT_ENCODING = new PreEncodedHttpField(HttpHeader.VARY, HttpHeader.ACCEPT_ENCODING.asString());
    private final AtomicReference<GZState> _state = new AtomicReference<GZState>(GZState.MIGHT_COMPRESS);
    private final CRC32 _crc = new CRC32();
    private final GzipFactory _factory;
    private final HttpField _vary;
    private final int _bufferSize;
    private final boolean _syncFlush;
    private CompressionPool.Entry _deflaterEntry;
    private ByteBuffer _buffer;

    public GzipResponse(Request request, Response wrapped, GzipFactory factory, HttpField vary, int bufferSize, boolean syncFlush) {
        super(request, wrapped);
        this._factory = factory;
        this._vary = vary;
        this._bufferSize = bufferSize;
        this._syncFlush = syncFlush;
    }

    @Override
    public void write(boolean last, ByteBuffer content, Callback callback) {
        switch (this._state.get()) {
            case MIGHT_COMPRESS: {
                this.commit(last, callback, content);
                break;
            }
            case NOT_COMPRESSING: {
                super.write(last, content, callback);
                break;
            }
            case COMMITTING: {
                callback.failed((Throwable)new WritePendingException());
                break;
            }
            case COMPRESSING: {
                this.gzip(last, callback, content);
                break;
            }
            default: {
                callback.failed((Throwable)new IllegalStateException("state=" + (Object)((Object)this._state.get())));
            }
        }
    }

    private void addTrailer() {
        BufferUtil.putIntLittleEndian((ByteBuffer)this._buffer, (int)((int)this._crc.getValue()));
        BufferUtil.putIntLittleEndian((ByteBuffer)this._buffer, (int)((Deflater)this._deflaterEntry.get()).getTotalIn());
    }

    private void gzip(boolean complete, Callback callback, ByteBuffer content) {
        if (content != null || complete) {
            new GzipBufferCB(complete, callback, content).iterate();
        } else {
            callback.succeeded();
        }
    }

    protected void commit(boolean last, Callback callback, ByteBuffer content) {
        String baseType;
        GzipResponse response = this;
        Request request = response.getRequest();
        int sc = response.getStatus();
        if (sc > 0 && (sc < 200 || sc == 204 || sc == 205 || sc >= 300)) {
            LOG.debug("{} exclude by status {}", (Object)this, (Object)sc);
            this.noCompression();
            if (sc == 304) {
                String responseEtagGzip;
                String requestEtags = (String)request.getAttribute("o.e.j.s.h.gzip.GzipHandler.etag");
                String responseEtag = response.getHeaders().get(HttpHeader.ETAG);
                if (requestEtags != null && responseEtag != null && requestEtags.contains(responseEtagGzip = this.etagGzip(responseEtag))) {
                    response.getHeaders().put(HttpHeader.ETAG, responseEtagGzip);
                }
            }
            super.write(last, content, callback);
            return;
        }
        String ct = response.getHeaders().get(HttpHeader.CONTENT_TYPE);
        if (ct != null && !this._factory.isMimeTypeGzipable(baseType = HttpField.valueParameters((String)ct, null))) {
            LOG.debug("{} exclude by mimeType {}", (Object)this, (Object)ct);
            this.noCompression();
            super.write(last, content, callback);
            return;
        }
        HttpFields.Mutable fields = response.getHeaders();
        String ce = fields.get(HttpHeader.CONTENT_ENCODING);
        if (ce != null) {
            LOG.debug("{} exclude by content-encoding {}", (Object)this, (Object)ce);
            this.noCompression();
            super.write(last, content, callback);
            return;
        }
        if (this._state.compareAndSet(GZState.MIGHT_COMPRESS, GZState.COMMITTING)) {
            long contentLength;
            if (this._vary != null) {
                fields.ensureField(this._vary);
            }
            if ((contentLength = response.getHeaders().getLongField(HttpHeader.CONTENT_LENGTH)) < 0L && last) {
                contentLength = BufferUtil.length((ByteBuffer)content);
            }
            this._deflaterEntry = this._factory.getDeflaterEntry(request, contentLength);
            if (this._deflaterEntry == null) {
                LOG.debug("{} exclude no deflater", (Object)this);
                this._state.set(GZState.NOT_COMPRESSING);
                super.write(last, content, callback);
                return;
            }
            fields.put(CompressedContentFormat.GZIP.getContentEncoding());
            this._crc.reset();
            response.getHeaders().putLongField(HttpHeader.CONTENT_LENGTH, -1L);
            String etag = fields.get(HttpHeader.ETAG);
            if (etag != null) {
                fields.put(HttpHeader.ETAG, this.etagGzip(etag));
            }
            LOG.debug("{} compressing {}", (Object)this, (Object)this._deflaterEntry);
            this._state.set(GZState.COMPRESSING);
            if (BufferUtil.isEmpty((ByteBuffer)content)) {
                super.write(last, content, callback);
            } else {
                this.gzip(last, callback, content);
            }
        } else {
            callback.failed((Throwable)new WritePendingException());
        }
    }

    private String etagGzip(String etag) {
        return CompressedContentFormat.GZIP.etag(etag);
    }

    public void noCompression() {
        block4: while (true) {
            switch (this._state.get()) {
                case NOT_COMPRESSING: {
                    return;
                }
                case MIGHT_COMPRESS: {
                    if (!this._state.compareAndSet(GZState.MIGHT_COMPRESS, GZState.NOT_COMPRESSING)) continue block4;
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException(this._state.get().toString());
    }

    private static enum GZState {
        MIGHT_COMPRESS,
        NOT_COMPRESSING,
        COMMITTING,
        COMPRESSING,
        FINISHED;

    }

    private class GzipBufferCB
    extends IteratingNestedCallback {
        private ByteBuffer _copy;
        private final ByteBuffer _content;
        private final boolean _last;

        public GzipBufferCB(boolean complete, Callback callback, ByteBuffer content) {
            super(callback);
            this._content = content;
            this._last = complete;
        }

        protected void onCompleteFailure(Throwable x) {
            if (GzipResponse.this._deflaterEntry != null) {
                GzipResponse.this._deflaterEntry.release();
                GzipResponse.this._deflaterEntry = null;
            }
            super.onCompleteFailure(x);
        }

        /*
         * Enabled aggressive block sorting
         */
        protected IteratingCallback.Action process() throws Exception {
            if (GzipResponse.this._deflaterEntry == null) {
                if (GzipResponse.this._buffer != null) {
                    GzipResponse.this.getRequest().getComponents().getByteBufferPool().release(GzipResponse.this._buffer);
                    GzipResponse.this._buffer = null;
                }
                if (this._copy != null) {
                    GzipResponse.this.getRequest().getComponents().getByteBufferPool().release(this._copy);
                    this._copy = null;
                }
                return IteratingCallback.Action.SUCCEEDED;
            }
            if (GzipResponse.this._buffer == null) {
                GzipResponse.this._buffer = GzipResponse.this.getRequest().getComponents().getByteBufferPool().acquire(GzipResponse.this._bufferSize, false);
                BufferUtil.fill((ByteBuffer)GzipResponse.this._buffer, (byte[])GZIP_HEADER, (int)0, (int)GZIP_HEADER.length);
            } else {
                BufferUtil.clear((ByteBuffer)GzipResponse.this._buffer);
            }
            Deflater deflater = (Deflater)GzipResponse.this._deflaterEntry.get();
            if (!deflater.finished()) {
                block17: {
                    if (deflater.needsInput()) {
                        ByteBuffer slice;
                        ByteBuffer content;
                        ByteBuffer byteBuffer = content = this._content != null ? this._content : BufferUtil.EMPTY_BUFFER;
                        if (BufferUtil.isEmpty((ByteBuffer)content)) {
                            if (this._last) {
                                deflater.finish();
                                break block17;
                            } else {
                                if (BufferUtil.isEmpty((ByteBuffer)GzipResponse.this._buffer)) {
                                    return IteratingCallback.Action.SUCCEEDED;
                                }
                                GzipResponse.super.write(false, GzipResponse.this._buffer, (Callback)this);
                                return IteratingCallback.Action.SCHEDULED;
                            }
                        }
                        if (content.hasArray()) {
                            slice = content;
                        } else {
                            if (this._copy == null) {
                                this._copy = GzipResponse.this.getRequest().getComponents().getByteBufferPool().acquire(GzipResponse.this._bufferSize, false);
                            } else {
                                BufferUtil.clear((ByteBuffer)this._copy);
                            }
                            slice = this._copy;
                            BufferUtil.append((ByteBuffer)this._copy, (ByteBuffer)content);
                        }
                        byte[] array = slice.array();
                        int off = slice.arrayOffset() + slice.position();
                        int len = slice.remaining();
                        GzipResponse.this._crc.update(array, off, len);
                        ((Deflater)GzipResponse.this._deflaterEntry.get()).setInput(array, off, len);
                        slice.position(slice.position() + len);
                        if (this._last && this._content == null && BufferUtil.isEmpty((ByteBuffer)content)) {
                            deflater.finish();
                        }
                    }
                }
                int off = GzipResponse.this._buffer.arrayOffset() + GzipResponse.this._buffer.limit();
                int len = BufferUtil.space((ByteBuffer)GzipResponse.this._buffer);
                int produced = deflater.deflate(GzipResponse.this._buffer.array(), off, len, GzipResponse.this._syncFlush ? 2 : 0);
                GzipResponse.this._buffer.limit(GzipResponse.this._buffer.limit() + produced);
            }
            if (deflater.finished() && BufferUtil.space((ByteBuffer)GzipResponse.this._buffer) >= 8) {
                GzipResponse.this.addTrailer();
                GzipResponse.this._deflaterEntry.release();
                GzipResponse.this._deflaterEntry = null;
            }
            GzipResponse.super.write(GzipResponse.this._deflaterEntry == null, GzipResponse.this._buffer, (Callback)this);
            return IteratingCallback.Action.SCHEDULED;
        }

        public String toString() {
            return String.format("%s[content=%s last=%b copy=%s buffer=%s deflate=%s %s]", super.toString(), BufferUtil.toDetailString((ByteBuffer)this._content), this._last, BufferUtil.toDetailString((ByteBuffer)this._copy), BufferUtil.toDetailString((ByteBuffer)GzipResponse.this._buffer), GzipResponse.this._deflaterEntry, GzipResponse.this._deflaterEntry != null && ((Deflater)GzipResponse.this._deflaterEntry.get()).finished() ? "(finished)" : "");
        }
    }
}

