/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.URIUtil;

public class MovedContextHandler
extends ContextHandler {
    final Redirector _redirector;
    String _newContextURL;
    boolean _discardPathInfo;
    boolean _discardQuery;
    boolean _permanent;
    String _expires;

    public MovedContextHandler() {
        this._redirector = new Redirector();
        this.setHandler(this._redirector);
        this.setAllowNullPathInContext(true);
    }

    public MovedContextHandler(Handler.Collection parent, String contextPath, String newContextURL) {
        super(contextPath);
        parent.addHandler(this);
        this._newContextURL = newContextURL;
        this._redirector = new Redirector();
        this.setHandler(this._redirector);
    }

    public boolean isDiscardPathInfo() {
        return this._discardPathInfo;
    }

    public void setDiscardPathInfo(boolean discardPathInfo) {
        this._discardPathInfo = discardPathInfo;
    }

    public String getNewContextURL() {
        return this._newContextURL;
    }

    public void setNewContextURL(String newContextURL) {
        this._newContextURL = newContextURL;
    }

    public boolean isPermanent() {
        return this._permanent;
    }

    public void setPermanent(boolean permanent) {
        this._permanent = permanent;
    }

    public boolean isDiscardQuery() {
        return this._discardQuery;
    }

    public void setDiscardQuery(boolean discardQuery) {
        this._discardQuery = discardQuery;
    }

    public String getExpires() {
        return this._expires;
    }

    public void setExpires(String expires) {
        this._expires = expires;
    }

    private class Redirector
    extends Handler.Processor {
        private Redirector() {
        }

        @Override
        public void process(Request request, Response response, Callback callback) throws Exception {
            if (MovedContextHandler.this._newContextURL == null) {
                return;
            }
            String path = MovedContextHandler.this._newContextURL;
            if (!MovedContextHandler.this._discardPathInfo && request.getPathInContext() != null) {
                path = URIUtil.addPaths((String)path, (String)request.getPathInContext());
            }
            HttpURI uri = request.getHttpURI();
            StringBuilder location = new StringBuilder();
            location.append(uri.getScheme()).append("://").append(uri.getAuthority()).append(path);
            if (!MovedContextHandler.this._discardQuery && uri.getQuery() != null) {
                location.append('?');
                String q = uri.getQuery();
                q = q.replaceAll("\r\n?&=", "!");
                location.append(q);
            }
            response.getHeaders().put(HttpHeader.LOCATION, location.toString());
            if (MovedContextHandler.this._expires != null) {
                response.getHeaders().put(HttpHeader.EXPIRES, MovedContextHandler.this._expires);
            }
            response.setStatus(MovedContextHandler.this._permanent ? 301 : 302);
            callback.succeeded();
        }
    }
}

