/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.List;
import org.eclipse.jetty.http.CachingContentFactory;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ResourceContentFactory;
import org.eclipse.jetty.server.ResourceService;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class ResourceHandler
extends Handler.Wrapper {
    private final ResourceService _resourceService;
    private Resource _resourceBase;
    private MimeTypes _mimeTypes;
    private List<String> _welcomes = List.of("index.html");

    public ResourceHandler() {
        this._resourceService = new ResourceService();
    }

    @Override
    public void doStart() throws Exception {
        ContextHandler.Context context;
        if (this._resourceBase == null && (context = ContextHandler.getCurrentContext()) != null) {
            this._resourceBase = context.getBaseResource();
        }
        if (this._mimeTypes == null) {
            this._mimeTypes = new MimeTypes();
        }
        this.setupContentFactory();
        if (this._resourceService.getStylesheet() == null) {
            this._resourceService.setStylesheet(this.getServer().getDefaultStyleSheet());
        }
        super.doStart();
    }

    private void setupContentFactory() {
        CachingContentFactory contentFactory = new CachingContentFactory((HttpContent.ContentFactory)new ResourceContentFactory(ResourceFactory.of((Resource)this._resourceBase), this._mimeTypes, this._resourceService.getPrecompressedFormats()));
        this._resourceService.setContentFactory((HttpContent.ContentFactory)contentFactory);
        this._resourceService.setWelcomeFactory(request -> {
            if (this._welcomes == null) {
                return null;
            }
            for (String welcome : this._welcomes) {
                String welcomeInContext = URIUtil.addPaths((String)request.getPathInContext(), (String)welcome);
                Resource welcomePath = this._resourceBase.resolve(request.getPathInContext()).resolve(welcome);
                if (welcomePath == null || !welcomePath.exists()) continue;
                return welcomeInContext;
            }
            return null;
        });
    }

    @Override
    public Request.Processor handle(Request request) throws Exception {
        if (!HttpMethod.GET.is(request.getMethod()) && !HttpMethod.HEAD.is(request.getMethod())) {
            return super.handle(request);
        }
        HttpContent content = this._resourceService.getContent(request.getPathInContext(), request);
        if (content == null) {
            return super.handle(request);
        }
        return (rq, rs, cb) -> this._resourceService.doGet(rq, rs, cb, content);
    }

    HttpContent.ContentFactory getContentFactory() {
        return this._resourceService.getContentFactory();
    }

    public Resource getBaseResource() {
        return this._resourceBase;
    }

    public String getCacheControl() {
        return this._resourceService.getCacheControl();
    }

    public List<String> getGzipEquivalentFileExtensions() {
        return this._resourceService.getGzipEquivalentFileExtensions();
    }

    public MimeTypes getMimeTypes() {
        return this._mimeTypes;
    }

    public Resource getStylesheet() {
        return this._resourceService.getStylesheet();
    }

    public List<String> getWelcomeFiles() {
        return this._welcomes;
    }

    public boolean isAcceptRanges() {
        return this._resourceService.isAcceptRanges();
    }

    public boolean isDirAllowed() {
        return this._resourceService.isDirAllowed();
    }

    public boolean isEtags() {
        return this._resourceService.isEtags();
    }

    public List<CompressedContentFormat> getPrecompressedFormats() {
        return this._resourceService.getPrecompressedFormats();
    }

    public boolean isRedirectWelcome() {
        return this._resourceService.isRedirectWelcome();
    }

    public void setAcceptRanges(boolean acceptRanges) {
        this._resourceService.setAcceptRanges(acceptRanges);
    }

    public void setBaseResource(Resource base) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._resourceBase = base;
    }

    public void setCacheControl(String cacheControl) {
        this._resourceService.setCacheControl(cacheControl);
    }

    public void setDirAllowed(boolean dirAllowed) {
        this._resourceService.setDirAllowed(dirAllowed);
    }

    public void setEtags(boolean etags) {
        this._resourceService.setEtags(etags);
    }

    public void setGzipEquivalentFileExtensions(List<String> gzipEquivalentFileExtensions) {
        this._resourceService.setGzipEquivalentFileExtensions(gzipEquivalentFileExtensions);
    }

    public void setPrecompressedFormats(CompressedContentFormat ... precompressedFormats) {
        this.setPrecompressedFormats(List.of(precompressedFormats));
    }

    public void setPrecompressedFormats(List<CompressedContentFormat> precompressedFormats) {
        this._resourceService.setPrecompressedFormats(precompressedFormats);
        this.setupContentFactory();
    }

    public void setEncodingCacheSize(int encodingCacheSize) {
        this._resourceService.setEncodingCacheSize(encodingCacheSize);
    }

    public int getEncodingCacheSize() {
        return this._resourceService.getEncodingCacheSize();
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
        this.setupContentFactory();
    }

    public void setRedirectWelcome(boolean redirectWelcome) {
        this._resourceService.setRedirectWelcome(redirectWelcome);
    }

    public void setStylesheet(Resource stylesheet) {
        this._resourceService.setStylesheet(stylesheet);
    }

    public void setWelcomeFiles(String ... welcomeFiles) {
        this.setWelcomeFiles(List.of(welcomeFiles));
    }

    public void setWelcomeFiles(List<String> welcomeFiles) {
        this._welcomes = welcomeFiles;
    }

    public static class ResourceContext
    extends ContextHandler {
        public ResourceContext() {
            this.setHandler(new ResourceHandler());
        }
    }
}

