/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.internal;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHttpFields
implements HttpFields.Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseHttpFields.class);
    private final HttpFields.Mutable _fields = HttpFields.build();
    private final AtomicBoolean _committed = new AtomicBoolean();

    public HttpFields.Mutable getMutableHttpFields() {
        return this._fields;
    }

    public boolean commit() {
        boolean committed = this._committed.compareAndSet(false, true);
        if (committed && LOG.isDebugEnabled()) {
            LOG.debug("{} committed", (Object)this);
        }
        return committed;
    }

    public boolean isCommitted() {
        return this._committed.get();
    }

    public void reset() {
        this._committed.set(false);
        this._fields.clear();
    }

    public HttpField getField(int index) {
        return this._fields.getField(index);
    }

    public int size() {
        return this._fields.size();
    }

    public Stream<HttpField> stream() {
        return this._fields.stream();
    }

    public HttpFields takeAsImmutable() {
        if (this._committed.get()) {
            return this;
        }
        return this._fields.asImmutable();
    }

    public HttpFields.Mutable add(String name, String value) {
        return this._committed.get() ? this : this._fields.add(name, value);
    }

    public HttpFields.Mutable add(HttpHeader header, HttpHeaderValue value) {
        return this._fields.add(header, value);
    }

    public HttpFields.Mutable add(HttpHeader header, String value) {
        return this._committed.get() ? this : this._fields.add(header, value);
    }

    public HttpFields.Mutable add(HttpField field) {
        return this._committed.get() ? this : this._fields.add(field);
    }

    public HttpFields.Mutable add(HttpFields fields) {
        return this._committed.get() ? this : this._fields.add(fields);
    }

    public HttpFields.Mutable addCSV(HttpHeader header, String ... values) {
        return this._committed.get() ? this : this._fields.addCSV(header, values);
    }

    public HttpFields.Mutable addCSV(String name, String ... values) {
        return this._committed.get() ? this : this._fields.addCSV(name, values);
    }

    public HttpFields.Mutable addDateField(String name, long date) {
        return this._committed.get() ? this : this._fields.addDateField(name, date);
    }

    public HttpFields asImmutable() {
        return this._committed.get() ? this : this._fields.asImmutable();
    }

    public HttpFields.Mutable clear() {
        return this._committed.get() ? this : this._fields.clear();
    }

    public void ensureField(HttpField field) {
        if (!this._committed.get()) {
            this._fields.ensureField(field);
        }
    }

    public Iterator<HttpField> iterator() {
        final Iterator i = this._fields.iterator();
        return new Iterator<HttpField>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public HttpField next() {
                return (HttpField)i.next();
            }

            @Override
            public void remove() {
                if (ResponseHttpFields.this._committed.get()) {
                    throw new UnsupportedOperationException("Read Only");
                }
                i.remove();
            }
        };
    }

    public ListIterator<HttpField> listIterator() {
        final ListIterator i = this._fields.listIterator();
        return new ListIterator<HttpField>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public HttpField next() {
                return (HttpField)i.next();
            }

            @Override
            public boolean hasPrevious() {
                return i.hasPrevious();
            }

            @Override
            public HttpField previous() {
                return (HttpField)i.previous();
            }

            @Override
            public int nextIndex() {
                return i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return i.previousIndex();
            }

            @Override
            public void remove() {
                if (ResponseHttpFields.this._committed.get()) {
                    throw new UnsupportedOperationException("Read Only");
                }
                i.remove();
            }

            @Override
            public void set(HttpField httpField) {
                if (ResponseHttpFields.this._committed.get()) {
                    throw new UnsupportedOperationException("Read Only");
                }
                i.set(httpField);
            }

            @Override
            public void add(HttpField httpField) {
                if (ResponseHttpFields.this._committed.get()) {
                    throw new UnsupportedOperationException("Read Only");
                }
                i.add(httpField);
            }
        };
    }

    public HttpFields.Mutable put(HttpField field) {
        return this._committed.get() ? this : this._fields.put(field);
    }

    public HttpFields.Mutable put(String name, String value) {
        return this._committed.get() ? this : this._fields.put(name, value);
    }

    public HttpFields.Mutable put(HttpHeader header, HttpHeaderValue value) {
        return this._committed.get() ? this : this._fields.put(header, value);
    }

    public HttpFields.Mutable put(HttpHeader header, String value) {
        return this._committed.get() ? this : this._fields.put(header, value);
    }

    public HttpFields.Mutable put(String name, List<String> list) {
        return this._committed.get() ? this : this._fields.put(name, list);
    }

    public HttpFields.Mutable putDateField(HttpHeader name, long date) {
        return this._committed.get() ? this : this._fields.putDateField(name, date);
    }

    public HttpFields.Mutable putDateField(String name, long date) {
        return this._committed.get() ? this : this._fields.putDateField(name, date);
    }

    public HttpFields.Mutable putLongField(HttpHeader name, long value) {
        return this._committed.get() ? this : this._fields.putLongField(name, value);
    }

    public HttpFields.Mutable putLongField(String name, long value) {
        return this._committed.get() ? this : this._fields.putLongField(name, value);
    }

    public void computeField(HttpHeader header, BiFunction<HttpHeader, List<HttpField>, HttpField> computeFn) {
        if (!this._committed.get()) {
            this._fields.computeField(header, computeFn);
        }
    }

    public void computeField(String name, BiFunction<String, List<HttpField>, HttpField> computeFn) {
        if (!this._committed.get()) {
            this._fields.computeField(name, computeFn);
        }
    }

    public HttpFields.Mutable remove(HttpHeader name) {
        return this._committed.get() ? this : this._fields.remove(name);
    }

    public HttpFields.Mutable remove(EnumSet<HttpHeader> fields) {
        return this._committed.get() ? this : this._fields.remove(fields);
    }

    public HttpFields.Mutable remove(String name) {
        return this._committed.get() ? this : this._fields.remove(name);
    }

    public String toString() {
        return this._fields.toString();
    }
}

