/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.HostPort;

public interface ConnectionMetaData
extends Attributes {
    public String getId();

    public HttpConfiguration getHttpConfiguration();

    public HttpVersion getHttpVersion();

    public String getProtocol();

    public Connection getConnection();

    public Connector getConnector();

    public boolean isPersistent();

    public boolean isSecure();

    public SocketAddress getRemoteSocketAddress();

    public SocketAddress getLocalSocketAddress();

    public HostPort getServerAuthority();

    public static HostPort getServerAuthority(HttpConfiguration httpConfiguration, ConnectionMetaData connectionMetaData) {
        HostPort authority = httpConfiguration.getServerAuthority();
        if (authority != null) {
            return authority;
        }
        SocketAddress local = connectionMetaData.getLocalSocketAddress();
        if (local instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)local;
            return new HostPort(inet.getHostString(), inet.getPort());
        }
        return null;
    }

    public static class Wrapper
    extends Attributes.Wrapper
    implements ConnectionMetaData {
        private final ConnectionMetaData _wrapped;

        public Wrapper(ConnectionMetaData wrapped) {
            super((Attributes)wrapped);
            this._wrapped = wrapped;
        }

        protected ConnectionMetaData getWrappedConnectionMetaData() {
            return this._wrapped;
        }

        @Override
        public String getId() {
            return this._wrapped.getId();
        }

        @Override
        public HttpConfiguration getHttpConfiguration() {
            return this._wrapped.getHttpConfiguration();
        }

        @Override
        public HttpVersion getHttpVersion() {
            return this._wrapped.getHttpVersion();
        }

        @Override
        public String getProtocol() {
            return this._wrapped.getProtocol();
        }

        @Override
        public Connection getConnection() {
            return this._wrapped.getConnection();
        }

        @Override
        public Connector getConnector() {
            return this._wrapped.getConnector();
        }

        @Override
        public boolean isPersistent() {
            return this._wrapped.isPersistent();
        }

        @Override
        public boolean isSecure() {
            return this._wrapped.isSecure();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this._wrapped.getRemoteSocketAddress();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this._wrapped.getLocalSocketAddress();
        }

        @Override
        public HostPort getServerAuthority() {
            return this._wrapped.getServerAuthority();
        }
    }
}

