/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;

public interface HttpStream
extends Callback {
    public static final String UPGRADE_CONNECTION_ATTRIBUTE = HttpStream.class.getName() + ".upgradeConnection";

    public String getId();

    public long getNanoTimeStamp();

    public Content.Chunk read();

    public void demand();

    public void prepareResponse(HttpFields.Mutable var1);

    public void send(MetaData.Request var1, MetaData.Response var2, boolean var3, ByteBuffer var4, Callback var5);

    public boolean isPushSupported();

    public void push(MetaData.Request var1);

    public boolean isCommitted();

    default public TunnelSupport getTunnelSupport() {
        return null;
    }

    default public Throwable consumeAvailable() {
        Content.Chunk content;
        do {
            if ((content = this.read()) == null) {
                return new IOException("Content not consumed");
            }
            content.release();
            if (!(content instanceof Content.Chunk.Error)) continue;
            Content.Chunk.Error error = (Content.Chunk.Error)content;
            return error.getCause();
        } while (!content.isLast());
        return null;
    }

    public static class Wrapper
    implements HttpStream {
        private final HttpStream _wrapped;

        public Wrapper(HttpStream wrapped) {
            this._wrapped = wrapped;
        }

        public HttpStream getWrapped() {
            return this._wrapped;
        }

        @Override
        public final String getId() {
            return this.getWrapped().getId();
        }

        @Override
        public final long getNanoTimeStamp() {
            return this.getWrapped().getNanoTimeStamp();
        }

        @Override
        public Content.Chunk read() {
            return this.getWrapped().read();
        }

        @Override
        public void demand() {
            this.getWrapped().demand();
        }

        @Override
        public void prepareResponse(HttpFields.Mutable headers) {
            this.getWrapped().prepareResponse(headers);
        }

        @Override
        public void send(MetaData.Request request, MetaData.Response response, boolean last, ByteBuffer content, Callback callback) {
            this.getWrapped().send(request, response, last, content, callback);
        }

        @Override
        public final boolean isPushSupported() {
            return this.getWrapped().isPushSupported();
        }

        @Override
        public void push(MetaData.Request request) {
            this.getWrapped().push(request);
        }

        @Override
        public final boolean isCommitted() {
            return this.getWrapped().isCommitted();
        }

        @Override
        public TunnelSupport getTunnelSupport() {
            return this.getWrapped().getTunnelSupport();
        }

        @Override
        public final Throwable consumeAvailable() {
            return this.getWrapped().consumeAvailable();
        }

        public void succeeded() {
            this.getWrapped().succeeded();
        }

        public void failed(Throwable x) {
            this.getWrapped().failed(x);
        }

        public Invocable.InvocationType getInvocationType() {
            return this.getWrapped().getInvocationType();
        }
    }
}

