/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.ResourceHttpContent;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class ResourceContentFactory
implements HttpContent.ContentFactory {
    private final ResourceFactory _factory;
    private final MimeTypes _mimeTypes;
    private final List<CompressedContentFormat> _precompressedFormats;

    public ResourceContentFactory(ResourceFactory factory, MimeTypes mimeTypes, List<CompressedContentFormat> precompressedFormats) {
        Objects.requireNonNull(mimeTypes, "MimeTypes cannot be null");
        this._factory = factory;
        this._mimeTypes = mimeTypes;
        this._precompressedFormats = precompressedFormats;
    }

    public HttpContent getContent(String pathInContext) throws IOException {
        try {
            Resource resource = this._factory.newResource(pathInContext);
            return this.load(pathInContext, resource);
        }
        catch (Throwable t) {
            InvalidPathException saferException = new InvalidPathException(pathInContext, "Invalid PathInContext");
            saferException.initCause(t);
            throw saferException;
        }
    }

    private HttpContent load(String pathInContext, Resource resource) {
        if (resource == null || !resource.exists()) {
            return null;
        }
        if (resource.isDirectory()) {
            return new ResourceHttpContent(resource, this._mimeTypes.getMimeByExtension(resource.toString()));
        }
        String mt = this._mimeTypes.getMimeByExtension(pathInContext);
        if (this._precompressedFormats.size() > 0) {
            HashMap<CompressedContentFormat, ResourceHttpContent> compressedContents = new HashMap<CompressedContentFormat, ResourceHttpContent>(this._precompressedFormats.size());
            for (CompressedContentFormat format : this._precompressedFormats) {
                String compressedPathInContext = pathInContext + format.getExtension();
                Resource compressedResource = this._factory.newResource(compressedPathInContext);
                if (compressedResource == null || !compressedResource.exists() || compressedResource.lastModified().isBefore(resource.lastModified()) || compressedResource.length() >= resource.length()) continue;
                compressedContents.put(format, new ResourceHttpContent(compressedResource, this._mimeTypes.getMimeByExtension(compressedPathInContext)));
            }
            if (!compressedContents.isEmpty()) {
                return new ResourceHttpContent(resource, mt, compressedContents);
            }
        }
        return new ResourceHttpContent(resource, mt);
    }

    public String toString() {
        return "ResourceContentFactory[" + this._factory + "]@" + this.hashCode();
    }
}

