/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.http.ByteRange;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.DateParser;
import org.eclipse.jetty.http.EtagUtils;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MultiPart;
import org.eclipse.jetty.http.MultiPartByteRanges;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.http.QuotedQualityCSV;
import org.eclipse.jetty.http.ResourceHttpContent;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.AliasCheck;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ResourceListing;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceService {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceService.class);
    public static final int NO_CONTENT_LENGTH = -1;
    public static final int USE_KNOWN_CONTENT_LENGTH = -2;
    private List<CompressedContentFormat> _precompressedFormats = new ArrayList<CompressedContentFormat>();
    private WelcomeFactory _welcomeFactory;
    private boolean _redirectWelcome = false;
    private boolean _etags = false;
    private List<String> _gzipEquivalentFileExtensions;
    private HttpContent.ContentFactory _contentFactory;
    private final Map<String, List<String>> _preferredEncodingOrderCache = new ConcurrentHashMap<String, List<String>>();
    private List<String> _preferredEncodingOrder = new ArrayList<String>();
    private int _encodingCacheSize = 100;
    private boolean _dirAllowed = true;
    private boolean _acceptRanges = true;
    private HttpField _cacheControl;
    private Resource _stylesheet;

    public void setStylesheet(Resource stylesheet) {
        this._stylesheet = stylesheet;
    }

    public Resource getStylesheet() {
        return this._stylesheet;
    }

    public HttpContent getContent(String path, Request request) throws IOException {
        ContextHandler contextHandler = ContextHandler.getContextHandler(request);
        return this.getContent(path, contextHandler);
    }

    public HttpContent getContent(String path, AliasCheck aliasCheck) throws IOException {
        HttpContent content = this._contentFactory.getContent(path == null ? "" : path);
        if (content != null) {
            if (aliasCheck != null && !aliasCheck.checkAlias(path, content.getResource())) {
                return null;
            }
        } else if (this._stylesheet != null && path != null && path.endsWith("/jetty-dir.css")) {
            content = new ResourceHttpContent(this._stylesheet, "text/css");
        }
        return content;
    }

    public HttpContent.ContentFactory getContentFactory() {
        return this._contentFactory;
    }

    public void setContentFactory(HttpContent.ContentFactory contentFactory) {
        this._contentFactory = contentFactory;
    }

    public String getCacheControl() {
        return this._cacheControl.getValue();
    }

    public List<String> getGzipEquivalentFileExtensions() {
        return this._gzipEquivalentFileExtensions;
    }

    public void doGet(Request request, Response response, Callback callback, HttpContent content) throws Exception {
        block12: {
            Object pathInContext = request.getPathInContext();
            List reqRanges = request.getHeaders().getValuesList(HttpHeader.RANGE.asString());
            boolean endsWithSlash = ((String)pathInContext).endsWith("/");
            boolean checkPrecompressedVariants = this._precompressedFormats.size() > 0 && !endsWithSlash && reqRanges.isEmpty();
            try {
                Map precompressedContents;
                if (content.getResource().isDirectory()) {
                    this.sendWelcome(content, (String)pathInContext, endsWithSlash, request, response, callback);
                    return;
                }
                if (endsWithSlash && ((String)pathInContext).length() > 1) {
                    String q = request.getHttpURI().getQuery();
                    pathInContext = ((String)pathInContext).substring(0, ((String)pathInContext).length() - 1);
                    if (q != null && q.length() != 0) {
                        pathInContext = (String)pathInContext + "?" + q;
                    }
                    this.sendRedirect(request, response, callback, URIUtil.addPaths((String)request.getContext().getContextPath(), (String)pathInContext));
                    return;
                }
                if (this.passConditionalHeaders(request, response, content, callback)) {
                    return;
                }
                Map map = precompressedContents = checkPrecompressedVariants ? content.getPrecompressedContents() : null;
                if (precompressedContents != null && precompressedContents.size() > 0) {
                    response.getHeaders().put(HttpHeader.VARY, HttpHeader.ACCEPT_ENCODING.asString());
                    List<String> preferredEncodings = this.getPreferredEncodingOrder(request);
                    CompressedContentFormat precompressedContentEncoding = this.getBestPrecompressedContent(preferredEncodings, precompressedContents.keySet());
                    if (precompressedContentEncoding != null) {
                        HttpContent precompressedContent = (HttpContent)precompressedContents.get(precompressedContentEncoding);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("precompressed={}", (Object)precompressedContent);
                        }
                        content = precompressedContent;
                        response.getHeaders().put(HttpHeader.CONTENT_ENCODING, precompressedContentEncoding.getEncoding());
                    }
                }
                if (this.isGzippedContent((String)pathInContext)) {
                    response.getHeaders().put(HttpHeader.CONTENT_ENCODING, "gzip");
                }
                this.sendData(request, response, callback, content, reqRanges);
            }
            catch (InvalidPathException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("InvalidPathException for pathInContext: {}", pathInContext, (Object)e);
                }
                this.writeHttpError(request, response, callback, 404);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Failed to serve resource: {}", pathInContext, (Object)e);
                if (response.isCommitted()) break block12;
                this.writeHttpError(request, response, callback, e);
            }
        }
    }

    protected void writeHttpError(Request request, Response response, Callback callback, int status) {
        Response.writeError(request, response, callback, status);
    }

    protected void writeHttpError(Request request, Response response, Callback callback, Throwable cause) {
        Response.writeError(request, response, callback, cause);
    }

    protected void writeHttpError(Request request, Response response, Callback callback, int status, String msg, Throwable cause) {
        Response.writeError(request, response, callback, status, msg, cause);
    }

    protected void sendRedirect(Request request, Response response, Callback callback, String target) {
        Response.sendRedirect(request, response, callback, target);
    }

    private List<String> getPreferredEncodingOrder(Request request) {
        List values;
        Enumeration headers = request.getHeaders().getValues(HttpHeader.ACCEPT_ENCODING.asString());
        if (!headers.hasMoreElements()) {
            return Collections.emptyList();
        }
        String key = (String)headers.nextElement();
        if (headers.hasMoreElements()) {
            StringBuilder sb = new StringBuilder(key.length() * 2);
            do {
                sb.append(',').append((String)headers.nextElement());
            } while (headers.hasMoreElements());
            key = sb.toString();
        }
        if ((values = this._preferredEncodingOrderCache.get(key)) == null) {
            QuotedQualityCSV encodingQualityCSV = new QuotedQualityCSV(this._preferredEncodingOrder);
            encodingQualityCSV.addValue(key);
            values = encodingQualityCSV.getValues();
            if (this._preferredEncodingOrderCache.size() > this._encodingCacheSize) {
                this._preferredEncodingOrderCache.clear();
            }
            this._preferredEncodingOrderCache.put(key, values);
        }
        return values;
    }

    private boolean isGzippedContent(String path) {
        if (path == null || this._gzipEquivalentFileExtensions == null) {
            return false;
        }
        for (String suffix : this._gzipEquivalentFileExtensions) {
            if (!path.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private CompressedContentFormat getBestPrecompressedContent(List<String> preferredEncodings, Collection<CompressedContentFormat> availableFormats) {
        if (availableFormats.isEmpty()) {
            return null;
        }
        for (String encoding : preferredEncodings) {
            for (CompressedContentFormat format : availableFormats) {
                if (!format.getEncoding().equals(encoding)) continue;
                return format;
            }
            if ("*".equals(encoding)) {
                return availableFormats.iterator().next();
            }
            if (!HttpHeaderValue.IDENTITY.asString().equals(encoding)) continue;
            return null;
        }
        return null;
    }

    protected boolean passConditionalHeaders(Request request, Response response, HttpContent content, Callback callback) throws IOException {
        try {
            String etag;
            String ifm = null;
            String ifnm = null;
            String ifms = null;
            long ifums = -1L;
            for (HttpField field : request.getHeaders()) {
                if (field.getHeader() == null) continue;
                switch (field.getHeader()) {
                    case IF_MATCH: {
                        ifm = field.getValue();
                        break;
                    }
                    case IF_NONE_MATCH: {
                        ifnm = field.getValue();
                        break;
                    }
                    case IF_MODIFIED_SINCE: {
                        ifms = field.getValue();
                        break;
                    }
                    case IF_UNMODIFIED_SINCE: {
                        ifums = DateParser.parseDate((String)field.getValue());
                        break;
                    }
                }
            }
            if (this._etags && (etag = content.getETagValue()) != null) {
                String matched;
                if (ifm != null && (matched = this.matchesEtag(etag, ifm)) == null) {
                    this.writeHttpError(request, response, callback, 412);
                    return true;
                }
                if (ifnm != null) {
                    matched = this.matchesEtag(etag, ifnm);
                    if (matched != null) {
                        response.getHeaders().put(HttpHeader.ETAG, matched);
                        this.writeHttpError(request, response, callback, 304);
                        return true;
                    }
                    return false;
                }
            }
            if (ifms != null) {
                String mdlm = content.getLastModifiedValue();
                if (ifms.equals(mdlm)) {
                    this.writeHttpError(request, response, callback, 304);
                    return true;
                }
                long ifmsl = request.getHeaders().getDateField(HttpHeader.IF_MODIFIED_SINCE);
                if (ifmsl != -1L && Files.getLastModifiedTime(content.getResource().getPath(), new LinkOption[0]).toMillis() / 1000L <= ifmsl / 1000L) {
                    this.writeHttpError(request, response, callback, 304);
                    return true;
                }
            }
            if (ifums != -1L && Files.getLastModifiedTime(content.getResource().getPath(), new LinkOption[0]).toMillis() / 1000L > ifums / 1000L) {
                this.writeHttpError(request, response, callback, 412);
                return true;
            }
        }
        catch (IllegalArgumentException iae) {
            if (!response.isCommitted()) {
                this.writeHttpError(request, response, callback, 400, null, iae);
            }
            throw iae;
        }
        return false;
    }

    private String matchesEtag(String contentETag, String requestEtag) {
        if (contentETag == null || requestEtag == null) {
            return null;
        }
        QuotedCSV quoted = new QuotedCSV(true, new String[]{requestEtag});
        for (String tag : quoted) {
            if (!EtagUtils.matches((String)contentETag, (String)tag)) continue;
            return tag;
        }
        return null;
    }

    protected void sendWelcome(HttpContent content, String pathInContext, boolean endsWithSlash, Request request, Response response, Callback callback) throws Exception {
        HttpURI.Mutable uri;
        if (!endsWithSlash && !(uri = HttpURI.build((HttpURI)request.getHttpURI())).getCanonicalPath().endsWith("/")) {
            String parameter = uri.getParam();
            uri.path(uri.getCanonicalPath() + "/");
            uri.param(parameter);
            response.getHeaders().putLongField(HttpHeader.CONTENT_LENGTH, 0L);
            this.sendRedirect(request, response, callback, uri.getPathQuery());
            return;
        }
        if (this.welcome(request, response, callback)) {
            return;
        }
        if (!this.passConditionalHeaders(request, response, content, callback)) {
            this.sendDirectory(request, response, content, callback, pathInContext);
        }
    }

    private boolean welcome(Request request, Response response, Callback callback) throws IOException {
        WelcomeAction welcomeAction = this.processWelcome(request, response);
        if (welcomeAction == null) {
            return false;
        }
        this.welcomeActionProcess(request, response, callback, welcomeAction);
        return true;
    }

    protected void welcomeActionProcess(Request request, Response response, Callback callback, WelcomeAction welcomeAction) throws IOException {
        switch (welcomeAction.type) {
            case REDIRECT: {
                response.getHeaders().putLongField(HttpHeader.CONTENT_LENGTH, 0L);
                this.sendRedirect(request, response, callback, welcomeAction.target);
                break;
            }
            case SERVE: {
                HttpContent c = this._contentFactory.getContent(welcomeAction.target);
                this.sendData(request, response, callback, c, List.of());
            }
        }
    }

    private WelcomeAction processWelcome(Request request, Response response) throws IOException {
        String welcomeTarget = this._welcomeFactory.getWelcomeTarget(request);
        if (welcomeTarget == null) {
            return null;
        }
        String contextPath = request.getContext().getContextPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug("welcome={}", (Object)welcomeTarget);
        }
        if (this._redirectWelcome) {
            response.getHeaders().putLongField(HttpHeader.CONTENT_LENGTH, 0L);
            HttpURI.Mutable uri = HttpURI.build((HttpURI)request.getHttpURI());
            String parameter = uri.getParam();
            uri.path(URIUtil.addPaths((String)contextPath, (String)welcomeTarget));
            uri.param(parameter);
            return new WelcomeAction(WelcomeActionType.REDIRECT, uri.getPathQuery());
        }
        return new WelcomeAction(WelcomeActionType.SERVE, welcomeTarget);
    }

    private void sendDirectory(Request request, Response response, HttpContent httpContent, Callback callback, String pathInContext) {
        if (!this._dirAllowed) {
            this.writeHttpError(request, response, callback, 403);
            return;
        }
        String base = URIUtil.addEncodedPaths((String)request.getHttpURI().getPath(), (String)"/");
        String listing = ResourceListing.getAsXHTML(httpContent.getResource(), base, pathInContext.length() > 1, request.getHttpURI().getQuery());
        if (listing == null) {
            this.writeHttpError(request, response, callback, 403);
            return;
        }
        byte[] data = listing.getBytes(StandardCharsets.UTF_8);
        response.getHeaders().put(HttpHeader.CONTENT_TYPE, "text/html;charset=utf-8");
        response.getHeaders().putLongField(HttpHeader.CONTENT_LENGTH, (long)data.length);
        response.write(true, ByteBuffer.wrap(data), callback);
    }

    private void sendData(Request request, Response response, Callback callback, HttpContent content, List<String> reqRanges) {
        long contentLength = content.getContentLengthValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("sendData content=%s", content));
        }
        if (reqRanges.isEmpty()) {
            if (contentLength >= 0L) {
                this.putHeaders(response, content, -2L);
            } else {
                this.putHeaders(response, content, -1L);
            }
            this.writeHttpContent(request, response, callback, content);
            return;
        }
        List ranges = ByteRange.parse(reqRanges, (long)contentLength);
        if (ranges.isEmpty()) {
            this.putHeaders(response, content, -1L);
            response.getHeaders().put(HttpHeader.CONTENT_RANGE, ByteRange.toNonSatisfiableHeaderValue((long)contentLength));
            Response.writeError(request, response, callback, 416);
            return;
        }
        if (ranges.size() == 1) {
            ByteRange range2 = (ByteRange)ranges.get(0);
            this.putHeaders(response, content, range2.getLength());
            response.setStatus(206);
            response.getHeaders().put(HttpHeader.CONTENT_RANGE, range2.toHeaderValue(contentLength));
            Content.copy((Content.Source)new MultiPartByteRanges.PathContentSource(content.getResource().getPath(), range2), (Content.Sink)response, (Callback)callback);
            return;
        }
        this.putHeaders(response, content, -1L);
        response.setStatus(206);
        String contentType = "multipart/byteranges; boundary=";
        String boundary = MultiPart.generateBoundary(null, (int)24);
        response.getHeaders().put(HttpHeader.CONTENT_TYPE, contentType + boundary);
        MultiPartByteRanges.ContentSource byteRanges = new MultiPartByteRanges.ContentSource(boundary);
        ranges.forEach(range -> byteRanges.addPart((MultiPart.Part)new MultiPartByteRanges.Part(content.getContentTypeValue(), content.getResource().getPath(), range)));
        byteRanges.close();
        Content.copy((Content.Source)byteRanges, (Content.Sink)response, (Callback)callback);
    }

    protected void writeHttpContent(Request request, Response response, Callback callback, HttpContent content) {
        try {
            ByteBuffer buffer = content.getBuffer();
            if (buffer != null) {
                response.write(true, buffer, callback);
            } else {
                new ContentWriterIteratingCallback(content, response, callback).iterate();
            }
        }
        catch (Throwable x) {
            callback.failed(x);
        }
    }

    protected void putHeaders(Response response, HttpContent content, long contentLength) {
        HttpField et;
        HttpField ce;
        HttpField lm = content.getLastModified();
        if (lm != null) {
            response.getHeaders().put(lm);
        }
        if (contentLength == -2L) {
            response.getHeaders().put(content.getContentLength());
        } else if (contentLength > -1L) {
            response.getHeaders().putLongField(HttpHeader.CONTENT_LENGTH, contentLength);
        }
        HttpField ct = content.getContentType();
        if (ct != null) {
            response.getHeaders().put(ct);
        }
        if ((ce = content.getContentEncoding()) != null) {
            response.getHeaders().put(ce);
        }
        if (this._etags && (et = content.getETag()) != null) {
            response.getHeaders().put(et);
        }
        if (this._acceptRanges && !response.getHeaders().contains(HttpHeader.ACCEPT_RANGES)) {
            response.getHeaders().put((HttpField)new PreEncodedHttpField(HttpHeader.ACCEPT_RANGES, "bytes"));
        }
        if (this._cacheControl != null && !response.getHeaders().contains(HttpHeader.CACHE_CONTROL)) {
            response.getHeaders().put(this._cacheControl);
        }
    }

    public boolean isAcceptRanges() {
        return this._acceptRanges;
    }

    public boolean isDirAllowed() {
        return this._dirAllowed;
    }

    public boolean isEtags() {
        return this._etags;
    }

    public List<CompressedContentFormat> getPrecompressedFormats() {
        return this._precompressedFormats;
    }

    public boolean isRedirectWelcome() {
        return this._redirectWelcome;
    }

    public WelcomeFactory getWelcomeFactory() {
        return this._welcomeFactory;
    }

    public void setAcceptRanges(boolean acceptRanges) {
        this._acceptRanges = acceptRanges;
    }

    public void setCacheControl(String cacheControl) {
        this._cacheControl = new PreEncodedHttpField(HttpHeader.CACHE_CONTROL, cacheControl);
    }

    public void setDirAllowed(boolean dirAllowed) {
        this._dirAllowed = dirAllowed;
    }

    public void setEtags(boolean etags) {
        this._etags = etags;
    }

    public void setGzipEquivalentFileExtensions(List<String> gzipEquivalentFileExtensions) {
        this._gzipEquivalentFileExtensions = gzipEquivalentFileExtensions;
    }

    public void setPrecompressedFormats(List<CompressedContentFormat> precompressedFormats) {
        this._precompressedFormats.clear();
        this._precompressedFormats.addAll(precompressedFormats);
        this._preferredEncodingOrder.clear();
        this._preferredEncodingOrder.addAll(this._precompressedFormats.stream().map(CompressedContentFormat::getEncoding).toList());
    }

    public void setEncodingCacheSize(int encodingCacheSize) {
        this._encodingCacheSize = encodingCacheSize;
        if (encodingCacheSize > this._preferredEncodingOrderCache.size()) {
            this._preferredEncodingOrderCache.clear();
        }
    }

    public int getEncodingCacheSize() {
        return this._encodingCacheSize;
    }

    public void setRedirectWelcome(boolean redirectWelcome) {
        this._redirectWelcome = redirectWelcome;
    }

    public void setWelcomeFactory(WelcomeFactory welcomeFactory) {
        this._welcomeFactory = welcomeFactory;
    }

    public record WelcomeAction(WelcomeActionType type, String target) {
    }

    public static enum WelcomeActionType {
        REDIRECT,
        SERVE;

    }

    public static interface WelcomeFactory {
        public String getWelcomeTarget(Request var1) throws IOException;
    }

    private static class ContentWriterIteratingCallback
    extends IteratingCallback {
        private final ReadableByteChannel source;
        private final Content.Sink sink;
        private final Callback callback;
        private final ByteBuffer byteBuffer;

        public ContentWriterIteratingCallback(HttpContent content, Response target, Callback callback) throws IOException {
            this.source = Files.newByteChannel(content.getResource().getPath(), new OpenOption[0]);
            this.sink = target;
            this.callback = callback;
            int outputBufferSize = target.getRequest().getConnectionMetaData().getHttpConfiguration().getOutputBufferSize();
            boolean useOutputDirectByteBuffers = target.getRequest().getConnectionMetaData().getHttpConfiguration().isUseOutputDirectByteBuffers();
            this.byteBuffer = useOutputDirectByteBuffers ? ByteBuffer.allocateDirect(outputBufferSize) : ByteBuffer.allocate(outputBufferSize);
        }

        protected IteratingCallback.Action process() throws Throwable {
            if (!this.source.isOpen()) {
                return IteratingCallback.Action.SUCCEEDED;
            }
            this.byteBuffer.clear();
            int read = this.source.read(this.byteBuffer);
            if (read == -1) {
                IO.close((Closeable)this.source);
                this.sink.write(true, BufferUtil.EMPTY_BUFFER, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            this.byteBuffer.flip();
            this.sink.write(false, this.byteBuffer, (Callback)this);
            return IteratingCallback.Action.SCHEDULED;
        }

        protected void onCompleteSuccess() {
            this.callback.succeeded();
        }

        protected void onCompleteFailure(Throwable x) {
            this.callback.failed(x);
        }
    }
}

