/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.AliasCheck;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SymlinkAllowedResourceAliasChecker;
import org.eclipse.jetty.server.handler.ContextRequest;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.Index;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.ClassLoaderDump;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.Graceful;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextHandler
extends Handler.Wrapper
implements Attributes,
Graceful,
AliasCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ContextHandler.class);
    private static final ThreadLocal<Context> __context = new ThreadLocal();
    private final Attributes _persistentAttributes = new Attributes.Mapped();
    private final Context _context;
    private final List<ContextScopeListener> _contextListeners = new CopyOnWriteArrayList<ContextScopeListener>();
    private final List<VHost> _vhosts = new ArrayList<VHost>();
    private String _displayName;
    private String _contextPath = "/";
    private Resource _baseResource;
    private ClassLoader _classLoader;
    private Request.Processor _errorProcessor;
    private boolean _allowNullPathInContext;
    private Index<ProtectedTargetType> _protectedTargets = Index.empty((boolean)false);
    private final List<AliasCheck> _aliasChecks = new CopyOnWriteArrayList<AliasCheck>();
    private final AtomicReference<Availability> _availability = new AtomicReference<Availability>(Availability.STOPPED);

    public static Context getCurrentContext() {
        return __context.get();
    }

    public static String getServerInfo() {
        return "jetty/" + Server.getVersion();
    }

    public static ContextHandler getContextHandler(Request request) {
        ContextRequest contextRequest = Request.as(request, ContextRequest.class);
        return contextRequest == null ? null : (ContextHandler)contextRequest.getContext().getContextHandler();
    }

    public ContextHandler() {
        this((String)null);
    }

    public ContextHandler(String contextPath) {
        this(null, contextPath);
    }

    @Deprecated
    public ContextHandler(Handler.Container parent, String contextPath) {
        this._context = this.newContext();
        if (contextPath != null) {
            this.setContextPath(contextPath);
        }
        if (parent != null) {
            parent.addHandler(this);
        }
        if (File.separatorChar == '/') {
            this.addAliasCheck(new SymlinkAllowedResourceAliasChecker(this));
        }
    }

    protected Context newContext() {
        return new Context();
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{new ClassLoaderDump(this.getClassLoader()), Dumpable.named((String)("context " + this), (Object)this._context), Dumpable.named((String)("handler attributes " + this), (Object)this._persistentAttributes)});
    }

    @ManagedAttribute(value="Context")
    public Context getContext() {
        return this._context;
    }

    @ManagedAttribute(value="Checks if the /context is not redirected to /context/")
    public boolean getAllowNullPathInContext() {
        return this._allowNullPathInContext;
    }

    public void setAllowNullPathInContext(boolean allowNullPathInContext) {
        this._allowNullPathInContext = allowNullPathInContext;
    }

    public void setVirtualHosts(List<String> vhosts) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._vhosts.clear();
        if (vhosts != null && !vhosts.isEmpty()) {
            for (String vhost : vhosts) {
                if (vhost == null) continue;
                boolean wild = false;
                String connector = null;
                int at = vhost.indexOf(64);
                if (at >= 0) {
                    connector = vhost.substring(at + 1);
                    vhost = vhost.substring(0, at);
                }
                if (vhost.startsWith("*.")) {
                    vhost = vhost.substring(1);
                    wild = true;
                }
                this._vhosts.add(new VHost(this.normalizeHostname(vhost), wild, connector));
            }
        }
    }

    public void addVirtualHosts(String ... virtualHosts) {
        if (virtualHosts == null || virtualHosts.length == 0) {
            return;
        }
        ArrayList<String> vhosts = new ArrayList<String>(this.getVirtualHosts());
        vhosts.addAll(Arrays.asList(virtualHosts));
        this.setVirtualHosts(vhosts);
    }

    public void removeVirtualHosts(String ... virtualHosts) {
        ArrayList<String> vhosts = new ArrayList<String>(this.getVirtualHosts());
        if (virtualHosts == null || virtualHosts.length == 0 || vhosts.isEmpty()) {
            return;
        }
        for (String vh : virtualHosts) {
            vhosts.remove(this.normalizeHostname(vh));
        }
    }

    @ManagedAttribute(value="Virtual hosts accepted by the context", readonly=true)
    public List<String> getVirtualHosts() {
        return this._vhosts.stream().map(VHost::getName).collect(Collectors.toList());
    }

    public Object getAttribute(String name) {
        return this._persistentAttributes.getAttribute(name);
    }

    public Set<String> getAttributeNameSet() {
        return this._persistentAttributes.getAttributeNameSet();
    }

    public Object setAttribute(String name, Object attribute) {
        return this._persistentAttributes.setAttribute(name, attribute);
    }

    public Object removeAttribute(String name) {
        return this._persistentAttributes.removeAttribute(name);
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setClassLoader(ClassLoader contextLoader) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._classLoader = contextLoader;
    }

    @ManagedAttribute(value="The file classpath")
    public String getClassPath() {
        ClassLoader classLoader;
        if (this._classLoader == null || !((classLoader = this._classLoader) instanceof URLClassLoader)) {
            return null;
        }
        URLClassLoader loader = (URLClassLoader)classLoader;
        String classpath = URIUtil.streamOf((URLClassLoader)loader).map(URI::toASCIIString).collect(Collectors.joining(File.pathSeparator));
        if (StringUtil.isBlank((String)classpath)) {
            return null;
        }
        return classpath;
    }

    @ManagedAttribute(value="Context path of the Context")
    public String getContextPath() {
        return this._contextPath;
    }

    @ManagedAttribute(value="Display name of the Context")
    public String getDisplayName() {
        if (this._displayName != null) {
            return this._displayName;
        }
        if ("/".equals(this._contextPath)) {
            return "ROOT";
        }
        return this._contextPath;
    }

    public boolean addEventListener(EventListener listener) {
        if (super.addEventListener(listener)) {
            if (listener instanceof ContextScopeListener) {
                this._contextListeners.add((ContextScopeListener)listener);
                if (__context.get() != null) {
                    ((ContextScopeListener)listener).enterScope(__context.get(), null);
                }
            }
            return true;
        }
        return false;
    }

    public boolean removeEventListener(EventListener listener) {
        if (super.removeEventListener(listener)) {
            if (listener instanceof ContextScopeListener) {
                this._contextListeners.remove(listener);
            }
            return true;
        }
        return false;
    }

    protected void enterScope(Request request) {
        for (ContextScopeListener listener : this._contextListeners) {
            try {
                listener.enterScope(this._context, request);
            }
            catch (Throwable e) {
                LOG.warn("Unable to enter scope", e);
            }
        }
    }

    protected void exitScope(Request request) {
        int i = this._contextListeners.size();
        while (i-- > 0) {
            try {
                this._contextListeners.get(i).exitScope(this._context, request);
            }
            catch (Throwable e) {
                LOG.warn("Unable to exit scope", e);
            }
        }
    }

    @ManagedAttribute(value="true for graceful shutdown, which allows existing requests to complete")
    public boolean isShutdown() {
        return false;
    }

    public CompletableFuture<Void> shutdown() {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        completableFuture.complete(null);
        return completableFuture;
    }

    public boolean isAvailable() {
        return this._availability.get() == Availability.AVAILABLE && this.isStarted();
    }

    public void setAvailable(boolean available) {
        block11: {
            if (available) {
                block7: while (true) {
                    Availability availability = this._availability.get();
                    switch (availability) {
                        case AVAILABLE: {
                            break block11;
                        }
                        case UNAVAILABLE: {
                            if (!this._availability.compareAndSet(availability, Availability.AVAILABLE)) {
                                continue block7;
                            }
                            break block11;
                        }
                        default: {
                            throw new IllegalStateException(availability.toString());
                        }
                    }
                    break;
                }
            }
            block8: while (true) {
                Availability availability = this._availability.get();
                switch (availability) {
                    case AVAILABLE: 
                    case STARTING: {
                        if (this._availability.compareAndSet(availability, Availability.UNAVAILABLE)) break block8;
                        continue block8;
                    }
                }
                break;
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this.getContextPath() == null) {
            throw new IllegalStateException("Null contextPath");
        }
        this._availability.set(Availability.STARTING);
        try {
            this._context.call(() -> super.doStart(), null);
            this._availability.compareAndSet(Availability.STARTING, Availability.AVAILABLE);
            LOG.info("Started {}", (Object)this);
        }
        finally {
            this._availability.compareAndSet(Availability.STARTING, Availability.UNAVAILABLE);
        }
    }

    @Override
    protected void doStop() throws Exception {
        this._context.call(() -> super.doStop(), null);
    }

    public boolean checkVirtualHost(Request request) {
        if (this._vhosts.isEmpty()) {
            return true;
        }
        String host = this.normalizeHostname(request.getHttpURI().getHost());
        String connectorName = request.getConnectionMetaData().getConnector().getName();
        for (VHost vhost : this._vhosts) {
            int index;
            String contextVhost = vhost._vHost;
            String contextVConnector = vhost._vConnector;
            if (contextVConnector != null) {
                if (!contextVConnector.equalsIgnoreCase(connectorName)) continue;
                if (contextVhost == null) {
                    return true;
                }
            }
            if (contextVhost == null || !(vhost._wild ? (index = host.indexOf(".")) >= 0 && host.substring(index).equalsIgnoreCase(contextVhost) : host.equalsIgnoreCase(contextVhost))) continue;
            return true;
        }
        return false;
    }

    protected String getPathInContext(Request request) {
        String path = request.getPathInContext();
        if (!path.startsWith(this._context.getContextPath())) {
            return null;
        }
        if ("/".equals(this._context.getContextPath())) {
            return path;
        }
        if (path.length() == this._context.getContextPath().length()) {
            return "";
        }
        if (path.charAt(this._context.getContextPath().length()) != '/') {
            return null;
        }
        return path.substring(this._context.getContextPath().length());
    }

    @Override
    public void destroy() {
        this._context.run(() -> super.destroy());
    }

    @Override
    public Request.Processor handle(Request request) throws Exception {
        if (this.getHandler() == null) {
            return null;
        }
        if (!this.checkVirtualHost(request)) {
            return null;
        }
        String pathInContext = this.getPathInContext(request);
        if (pathInContext == null) {
            return null;
        }
        if (pathInContext.isEmpty() && !this.getAllowNullPathInContext()) {
            return this::processMovedPermanently;
        }
        if (!this.isAvailable() && this.isStarted()) {
            return this::processUnavailable;
        }
        ContextRequest contextRequest = this.wrap(request, pathInContext);
        if (contextRequest == null) {
            return null;
        }
        Request.Processor processor = this.processByContextHandler(contextRequest);
        if (processor != null) {
            return processor;
        }
        return contextRequest.wrapProcessor(this._context.get(contextRequest, contextRequest));
    }

    protected void processMovedPermanently(Request request, Response response, Callback callback) {
        String location = this._contextPath + "/";
        if (request.getHttpURI().getParam() != null) {
            location = location + ";" + request.getHttpURI().getParam();
        }
        if (request.getHttpURI().getQuery() != null) {
            location = location + ";" + request.getHttpURI().getQuery();
        }
        response.setStatus(301);
        response.getHeaders().add(new HttpField(HttpHeader.LOCATION, location));
        callback.succeeded();
    }

    protected void processUnavailable(Request request, Response response, Callback callback) {
        Response.writeError(request, response, callback, 503, null);
    }

    protected Request.Processor processByContextHandler(ContextRequest contextRequest) {
        if (!this._allowNullPathInContext && StringUtil.isEmpty((String)contextRequest.getPathInContext())) {
            return (request, response, callback) -> {
                String queryString = request.getHttpURI().getQuery();
                Response.sendRedirect(request, response, callback, 302, request.getHttpURI().getPath() + (String)(queryString == null ? "/" : "/?" + queryString), true);
            };
        }
        return null;
    }

    public void setContextPath(String contextPath) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._contextPath = URIUtil.canonicalPath((String)contextPath);
    }

    public void setDisplayName(String servletContextName) {
        this._displayName = servletContextName;
    }

    @ManagedAttribute(value="document root for context")
    public Resource getBaseResource() {
        return this._baseResource;
    }

    public void setBaseResource(Resource resourceBase) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._baseResource = resourceBase;
    }

    public void setBaseResource(Path path) {
        if (path == null) {
            this.setBaseResource((Resource)null);
            return;
        }
        Resource resource = ResourceFactory.of((Container)this).newResource(path);
        if (resource == null || !resource.exists()) {
            throw new IllegalArgumentException("Base Resource is not valid: " + path);
        }
        this.setBaseResource(resource);
    }

    @ManagedAttribute(value="The error processor to use for the context")
    public Request.Processor getErrorProcessor() {
        return this._errorProcessor;
    }

    public void setErrorProcessor(Request.Processor errorProcessor) {
        this.updateBean(this._errorProcessor, errorProcessor, true);
        this._errorProcessor = errorProcessor;
    }

    protected ContextRequest wrap(Request request, String pathInContext) {
        return new ContextRequest(this, this._context, request, pathInContext);
    }

    public void clearAttributes() {
        this._persistentAttributes.clearAttributes();
    }

    public boolean isProtectedTarget(String target) {
        ProtectedTargetType type;
        if (target == null || this._protectedTargets.isEmpty()) {
            return false;
        }
        if (target.startsWith("//")) {
            target = URIUtil.compactPath((String)target);
        }
        return (type = (ProtectedTargetType)((Object)this._protectedTargets.getBest(target))) == ProtectedTargetType.PREFIX || type == ProtectedTargetType.EXACT && this._protectedTargets.get(target) == ProtectedTargetType.EXACT;
    }

    public void setProtectedTargets(String[] targets) {
        Index.Builder builder = new Index.Builder();
        if (targets != null) {
            for (String t : targets) {
                if (!t.startsWith("/")) {
                    throw new IllegalArgumentException("Bad protected target: " + t);
                }
                builder.with(t, (Object)ProtectedTargetType.EXACT);
                builder.with(t + "/", (Object)ProtectedTargetType.PREFIX);
                builder.with(t + "?", (Object)ProtectedTargetType.PREFIX);
                builder.with(t + "#", (Object)ProtectedTargetType.PREFIX);
                builder.with(t + ";", (Object)ProtectedTargetType.PREFIX);
            }
        }
        this._protectedTargets = builder.caseSensitive(false).build();
    }

    public String[] getProtectedTargets() {
        if (this._protectedTargets == null) {
            return null;
        }
        return (String[])this._protectedTargets.keySet().stream().filter(s -> this._protectedTargets.get(s) == ProtectedTargetType.EXACT).toArray(String[]::new);
    }

    public void addAliasCheck(AliasCheck check) {
        this._aliasChecks.add(check);
        if (check instanceof LifeCycle) {
            this.addManaged((LifeCycle)check);
        } else {
            this.addBean(check);
        }
    }

    public List<AliasCheck> getAliasChecks() {
        return Collections.unmodifiableList(this._aliasChecks);
    }

    public void setAliasChecks(List<AliasCheck> checks) {
        this.clearAliasChecks();
        checks.forEach(this::addAliasCheck);
    }

    public void clearAliasChecks() {
        this._aliasChecks.forEach(arg_0 -> ((ContextHandler)this).removeBean(arg_0));
        this._aliasChecks.clear();
    }

    @Override
    public boolean checkAlias(String pathInContext, Resource resource) {
        if (resource.isAlias()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aliased resource: {} -> {}", (Object)resource, (Object)resource.getTargetURI());
            }
            for (AliasCheck check : this._aliasChecks) {
                if (!check.checkAlias(pathInContext, resource)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Aliased resource: {} approved by {}", (Object)resource, (Object)check);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        Handler nestedHandler;
        List<String> vhosts = this.getVirtualHosts();
        StringBuilder b = new StringBuilder();
        b.append(TypeUtil.toShortName(this.getClass())).append('@').append(Integer.toString(this.hashCode(), 16));
        b.append('{');
        if (this.getDisplayName() != null) {
            b.append(this.getDisplayName()).append(',');
        }
        b.append(this.getContextPath());
        b.append(",b=").append(this.getBaseResource());
        b.append(",a=").append((Object)this._availability.get());
        if (!vhosts.isEmpty()) {
            b.append(",vh=[");
            b.append(String.join((CharSequence)",", vhosts));
            b.append(']');
        }
        if ((nestedHandler = this.getHandler()) != null) {
            b.append(",h=");
            b.append(nestedHandler);
        }
        b.append('}');
        return b.toString();
    }

    private String normalizeHostname(String host) {
        if (host == null) {
            return null;
        }
        int connectorIndex = ((String)host).indexOf(64);
        String connector = null;
        if (connectorIndex > 0) {
            host = ((String)host).substring(0, connectorIndex);
            connector = ((String)host).substring(connectorIndex);
        }
        if (((String)host).endsWith(".")) {
            host = ((String)host).substring(0, ((String)host).length() - 1);
        }
        if (connector != null) {
            host = (String)host + connector;
        }
        return host;
    }

    public class Context
    extends Attributes.Layer
    implements org.eclipse.jetty.server.Context {
        public Context() {
            super(ContextHandler.this._persistentAttributes);
        }

        public <H extends ContextHandler> H getContextHandler() {
            return (H)ContextHandler.this;
        }

        public Object getAttribute(String name) {
            return super.getAttribute(name);
        }

        @Override
        public Request.Processor getErrorProcessor() {
            Request.Processor processor = ContextHandler.this.getErrorProcessor();
            if (processor == null) {
                processor = ContextHandler.this.getServer().getErrorProcessor();
            }
            return processor;
        }

        @Override
        public String getContextPath() {
            return ContextHandler.this._contextPath;
        }

        public String toString() {
            return "%s@%x".formatted(this.getClass().getSimpleName(), this.hashCode());
        }

        @Override
        public ClassLoader getClassLoader() {
            return ContextHandler.this._classLoader;
        }

        @Override
        public Resource getBaseResource() {
            return ContextHandler.this._baseResource;
        }

        @Override
        public List<String> getVirtualHosts() {
            return ContextHandler.this.getVirtualHosts();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T get(Supplier<T> supplier, Request request) {
            Context lastContext = __context.get();
            if (lastContext == this) {
                return supplier.get();
            }
            ClassLoader loader = this.getClassLoader();
            ClassLoader lastLoader = Thread.currentThread().getContextClassLoader();
            try {
                __context.set(this);
                if (loader != null) {
                    Thread.currentThread().setContextClassLoader(loader);
                }
                ContextHandler.this.enterScope(request);
                T t = supplier.get();
                return t;
            }
            finally {
                ContextHandler.this.exitScope(request);
                __context.set(lastContext);
                if (loader != null) {
                    Thread.currentThread().setContextClassLoader(lastLoader);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void call(Invocable.Callable callable, Request request) throws Exception {
            Context lastContext = __context.get();
            if (lastContext == this) {
                callable.call();
            } else {
                ClassLoader loader = this.getClassLoader();
                ClassLoader lastLoader = Thread.currentThread().getContextClassLoader();
                try {
                    __context.set(this);
                    if (loader != null) {
                        Thread.currentThread().setContextClassLoader(loader);
                    }
                    ContextHandler.this.enterScope(request);
                    callable.call();
                }
                finally {
                    ContextHandler.this.exitScope(request);
                    __context.set(lastContext);
                    if (loader != null) {
                        Thread.currentThread().setContextClassLoader(lastLoader);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept(Consumer<Throwable> consumer, Throwable t, Request request) {
            Context lastContext = __context.get();
            if (lastContext == this) {
                consumer.accept(t);
            } else {
                ClassLoader loader = this.getClassLoader();
                ClassLoader lastLoader = Thread.currentThread().getContextClassLoader();
                try {
                    __context.set(this);
                    if (loader != null) {
                        Thread.currentThread().setContextClassLoader(loader);
                    }
                    ContextHandler.this.enterScope(request);
                    consumer.accept(t);
                }
                finally {
                    ContextHandler.this.exitScope(request);
                    __context.set(lastContext);
                    if (loader != null) {
                        Thread.currentThread().setContextClassLoader(lastLoader);
                    }
                }
            }
        }

        @Override
        public void run(Runnable runnable) {
            this.run(runnable, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Runnable runnable, Request request) {
            Context lastContext = __context.get();
            if (lastContext == this) {
                runnable.run();
            } else {
                ClassLoader loader = this.getClassLoader();
                ClassLoader lastLoader = Thread.currentThread().getContextClassLoader();
                try {
                    __context.set(this);
                    if (loader != null) {
                        Thread.currentThread().setContextClassLoader(loader);
                    }
                    ContextHandler.this.enterScope(request);
                    runnable.run();
                }
                finally {
                    ContextHandler.this.exitScope(request);
                    __context.set(lastContext);
                    if (loader != null) {
                        Thread.currentThread().setContextClassLoader(lastLoader);
                    }
                }
            }
        }

        @Override
        public void execute(Runnable runnable) {
            ContextHandler.this.getServer().getContext().execute(() -> this.run(runnable));
        }

        protected DecoratedObjectFactory getDecoratedObjectFactory() {
            DecoratedObjectFactory factory = (DecoratedObjectFactory)ContextHandler.this.getBean(DecoratedObjectFactory.class);
            if (factory != null) {
                return factory;
            }
            return (DecoratedObjectFactory)ContextHandler.this.getServer().getBean(DecoratedObjectFactory.class);
        }

        public <T> T decorate(T o) {
            DecoratedObjectFactory factory = this.getDecoratedObjectFactory();
            if (factory != null) {
                return (T)factory.decorate(o);
            }
            return o;
        }

        public void destroy(Object o) {
            DecoratedObjectFactory factory = this.getDecoratedObjectFactory();
            if (factory != null) {
                factory.destroy(o);
            }
        }
    }

    public static enum Availability {
        STOPPED,
        STARTING,
        AVAILABLE,
        UNAVAILABLE,
        SHUTDOWN;

    }

    private static class VHost {
        private final String _vHost;
        private final boolean _wild;
        private final String _vConnector;

        private VHost(String vHost, boolean wild, String vConnector) {
            this._vHost = vHost;
            this._wild = wild;
            this._vConnector = vConnector;
        }

        String getVHost() {
            return this._vHost;
        }

        String getName() {
            if (this._vConnector != null) {
                return "@" + this._vConnector;
            }
            return this._vHost;
        }

        public String toString() {
            return "VHost{_vHost='" + this._vHost + "', _wild=" + this._wild + ", _vConnector='" + this._vConnector + "'}";
        }
    }

    public static interface ContextScopeListener
    extends EventListener {
        default public void enterScope(org.eclipse.jetty.server.Context context, Request request) {
        }

        default public void exitScope(org.eclipse.jetty.server.Context context, Request request) {
        }
    }

    private static enum ProtectedTargetType {
        EXACT,
        PREFIX;

    }
}

