/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextResponse;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextRequest
extends Request.WrapperProcessor
implements Invocable,
Supplier<Request.Processor>,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ContextRequest.class);
    private final String _pathInContext;
    private final ContextHandler _contextHandler;
    private final ContextHandler.Context _context;
    private Response _response;
    private Callback _callback;

    protected ContextRequest(ContextHandler contextHandler, ContextHandler.Context context, Request wrapped, String pathInContext) {
        super(wrapped);
        this._pathInContext = pathInContext;
        this._contextHandler = contextHandler;
        this._context = context;
    }

    @Override
    public Request.Processor get() {
        try {
            return this._contextHandler.getHandler().handle(this);
        }
        catch (Throwable t) {
            if (!LOG.isDebugEnabled() && (t instanceof BadMessageException || t instanceof QuietException)) {
                LOG.warn("context bad message {}", (Object)t.getMessage());
            } else {
                LOG.warn("context handle failed {}", (Object)this, (Object)t);
            }
            return null;
        }
    }

    @Override
    public void process(Request request, Response response, Callback callback) throws Exception {
        this._response = response;
        this._callback = callback;
        this._context.run(this, this);
    }

    public Callback getCallback() {
        return this._callback;
    }

    protected ContextResponse newContextResponse(Request request, Response response) {
        return new ContextResponse(this._context, request, response);
    }

    @Override
    public void run() {
        try {
            super.process(this, this.newContextResponse(this, this._response), this._callback);
        }
        catch (Throwable t) {
            Response.writeError((Request)this, this._response, this._callback, t);
        }
    }

    @Override
    public void demand(Runnable demandCallback) {
        super.demand(() -> this._context.run(demandCallback, this));
    }

    @Override
    public boolean addErrorListener(Predicate<Throwable> onError) {
        return super.addErrorListener(t -> {
            this._context.accept(onError::test, (Throwable)t, this);
            return true;
        });
    }

    @Override
    public ContextHandler.Context getContext() {
        return this._context;
    }

    @Override
    public String getPathInContext() {
        return this._pathInContext;
    }

    public Object getAttribute(String name) {
        return switch (name) {
            case "o.e.j.s.h.ScopedRequest.contextPath" -> this._context.getContextPath();
            case "o.e.j.s.h.ScopedRequest.pathInContext" -> this._pathInContext;
            default -> super.getAttribute(name);
        };
    }
}

