/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHandler
extends Handler.Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownHandler.class);
    private final String _shutdownToken;
    private boolean _sendShutdownAtStart;
    private boolean _exitJvm = false;

    public ShutdownHandler(String shutdownToken) {
        this(shutdownToken, false, false);
    }

    public ShutdownHandler(String shutdownToken, boolean exitJVM, boolean sendShutdownAtStart) {
        this._shutdownToken = shutdownToken;
    }

    public void sendShutdown() throws IOException {
        URL url = new URL(this.getServerUrl() + "/shutdown?token=" + this._shutdownToken);
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.getResponseCode();
            LOG.info("Shutting down {}: {} {}", new Object[]{url, connection.getResponseCode(), connection.getResponseMessage()});
        }
        catch (SocketException e) {
            LOG.debug("Not running");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getServerUrl() {
        NetworkConnector connector = null;
        for (Connector c : this.getServer().getConnectors()) {
            if (!(c instanceof NetworkConnector)) continue;
            connector = (NetworkConnector)c;
            break;
        }
        if (connector == null) {
            return "http://localhost";
        }
        return "http://localhost:" + connector.getPort();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this._sendShutdownAtStart) {
            this.sendShutdown();
        }
    }

    @Override
    public Request.Processor handle(Request request) throws Exception {
        return null;
    }
}

