/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.resource.Resource;

public class TryPathsHandler
extends Handler.Wrapper {
    private List<String> paths;

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    @Override
    public Request.Processor handle(Request request) throws Exception {
        String interpolated = this.interpolate(request, "$path");
        Resource rootResource = request.getContext().getBaseResource();
        if (rootResource != null) {
            String path;
            Resource resource;
            Iterator<String> iterator = this.paths.iterator();
            while (iterator.hasNext() && ((resource = rootResource.resolve(interpolated = this.interpolate(request, path = iterator.next()))) == null || !resource.exists())) {
            }
        }
        Request.WrapperProcessor result = new Request.WrapperProcessor(new TryPathsRequest(request, interpolated));
        return result.wrapProcessor(super.handle(result));
    }

    private Request.Processor fallback(Request request) throws Exception {
        String fallback = this.paths.isEmpty() ? "$path" : this.paths.get(this.paths.size() - 1);
        String interpolated = this.interpolate(request, fallback);
        return super.handle(new TryPathsRequest(request, interpolated));
    }

    private String interpolate(Request request, String value) {
        String path = request.getPathInContext();
        return value.replace("$path", path);
    }

    private static class TryPathsRequest
    extends Request.Wrapper {
        private final String pathInContext;

        public TryPathsRequest(Request wrapped, String pathInContext) {
            super(wrapped);
            this.pathInContext = pathInContext;
        }

        @Override
        public String getPathInContext() {
            return this.pathInContext;
        }
    }
}

