/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.gzip;

import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.pathmap.PathSpecSet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.gzip.GzipFactory;
import org.eclipse.jetty.server.handler.gzip.GzipRequest;
import org.eclipse.jetty.server.handler.gzip.GzipResponse;
import org.eclipse.jetty.server.handler.gzip.HeaderWrappingRequest;
import org.eclipse.jetty.util.AsciiLowerCaseSet;
import org.eclipse.jetty.util.IncludeExclude;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.compression.CompressionPool;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GzipHandler
extends Handler.Wrapper
implements GzipFactory {
    public static final EnumSet<HttpHeader> ETAG_HEADERS = EnumSet.of(HttpHeader.IF_MATCH, HttpHeader.IF_NONE_MATCH);
    public static final String GZIP_HANDLER_ETAGS = "o.e.j.s.h.gzip.GzipHandler.etag";
    public static final String GZIP = "gzip";
    public static final String DEFLATE = "deflate";
    public static final int DEFAULT_MIN_GZIP_SIZE = 32;
    public static final int BREAK_EVEN_GZIP_SIZE = 23;
    private static final Logger LOG = LoggerFactory.getLogger(GzipHandler.class);
    private static final HttpField X_CE_GZIP = new PreEncodedHttpField("X-Content-Encoding", "gzip");
    private static final Pattern COMMA_GZIP = Pattern.compile(".*, *gzip");
    private InflaterPool _inflaterPool;
    private DeflaterPool _deflaterPool;
    private int _minGzipSize = 32;
    private boolean _syncFlush = false;
    private int _inflateBufferSize = -1;
    private final IncludeExclude<String> _methods = new IncludeExclude();
    private final IncludeExclude<String> _inflatePaths = new IncludeExclude(PathSpecSet.class);
    private final IncludeExclude<String> _paths = new IncludeExclude(PathSpecSet.class);
    private final IncludeExclude<String> _mimeTypes = new IncludeExclude(AsciiLowerCaseSet.class);
    private HttpField _vary = GzipResponse.VARY_ACCEPT_ENCODING;

    public GzipHandler() {
        this._methods.include((Object)HttpMethod.GET.asString());
        this._methods.include((Object)HttpMethod.POST.asString());
        for (String type : MimeTypes.getKnownMimeTypes()) {
            if ("image/svg+xml".equals(type)) {
                this._paths.exclude((Object)"*.svgz");
                continue;
            }
            if (!type.startsWith("image/") && !type.startsWith("audio/") && !type.startsWith("video/")) continue;
            this._mimeTypes.exclude((Object)type);
        }
        this._mimeTypes.exclude((Object)"application/compress");
        this._mimeTypes.exclude((Object)"application/zip");
        this._mimeTypes.exclude((Object)"application/gzip");
        this._mimeTypes.exclude((Object)"application/bzip2");
        this._mimeTypes.exclude((Object)"application/brotli");
        this._mimeTypes.exclude((Object)"application/x-xz");
        this._mimeTypes.exclude((Object)"application/x-rar-compressed");
        this._mimeTypes.exclude((Object)"text/event-stream");
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} mime types {}", (Object)this, this._mimeTypes);
        }
    }

    @Override
    protected void doStart() throws Exception {
        Server server = this.getServer();
        if (this._inflaterPool == null) {
            this._inflaterPool = InflaterPool.ensurePool((Container)server);
            this.addBean(this._inflaterPool);
        }
        if (this._deflaterPool == null) {
            this._deflaterPool = DeflaterPool.ensurePool((Container)server);
            this.addBean(this._deflaterPool);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this._inflaterPool);
        this._inflaterPool = null;
        this.removeBean(this._deflaterPool);
        this._deflaterPool = null;
    }

    public HttpField getVary() {
        return this._vary;
    }

    public void setVary(HttpField vary) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._vary = vary == null || vary instanceof PreEncodedHttpField ? vary : new PreEncodedHttpField(vary.getHeader(), vary.getName(), vary.getValue());
    }

    public void addExcludedMethods(String ... methods) {
        for (String m : methods) {
            this._methods.exclude((Object)m);
        }
    }

    public void addExcludedMimeTypes(String ... types) {
        for (String t : types) {
            this._mimeTypes.exclude((Object[])StringUtil.csvSplit((String)t));
        }
    }

    public void addExcludedPaths(String ... pathspecs) {
        for (String p : pathspecs) {
            this._paths.exclude((Object[])StringUtil.csvSplit((String)p));
        }
    }

    public void addExcludedInflationPaths(String ... pathspecs) {
        for (String p : pathspecs) {
            this._inflatePaths.exclude((Object[])StringUtil.csvSplit((String)p));
        }
    }

    public void addIncludedMethods(String ... methods) {
        for (String m : methods) {
            this._methods.include((Object)m);
        }
    }

    public boolean isSyncFlush() {
        return this._syncFlush;
    }

    public void setSyncFlush(boolean syncFlush) {
        this._syncFlush = syncFlush;
    }

    public void addIncludedMimeTypes(String ... types) {
        for (String t : types) {
            this._mimeTypes.include((Object[])StringUtil.csvSplit((String)t));
        }
    }

    public void addIncludedPaths(String ... pathspecs) {
        for (String p : pathspecs) {
            this._paths.include((Object[])StringUtil.csvSplit((String)p));
        }
    }

    public void addIncludedInflationPaths(String ... pathspecs) {
        for (String p : pathspecs) {
            this._inflatePaths.include((Object[])StringUtil.csvSplit((String)p));
        }
    }

    @Override
    public CompressionPool.Entry getDeflaterEntry(Request request, long contentLength) {
        if (contentLength >= 0L && contentLength < (long)this._minGzipSize) {
            LOG.debug("{} excluded minGzipSize {}", (Object)this, (Object)request);
            return null;
        }
        if (!request.getHeaders().contains(HttpHeader.ACCEPT_ENCODING, GZIP)) {
            LOG.debug("{} excluded not gzip accept {}", (Object)this, (Object)request);
            return null;
        }
        return this._deflaterPool.acquire();
    }

    public String[] getExcludedMethods() {
        Set excluded = this._methods.getExcluded();
        return excluded.toArray(new String[0]);
    }

    public String[] getExcludedMimeTypes() {
        Set excluded = this._mimeTypes.getExcluded();
        return excluded.toArray(new String[0]);
    }

    public String[] getExcludedPaths() {
        Set excluded = this._paths.getExcluded();
        return excluded.toArray(new String[0]);
    }

    public String[] getExcludedInflationPaths() {
        Set excluded = this._inflatePaths.getExcluded();
        return excluded.toArray(new String[0]);
    }

    public String[] getIncludedMethods() {
        Set includes = this._methods.getIncluded();
        return includes.toArray(new String[0]);
    }

    public String[] getIncludedMimeTypes() {
        Set includes = this._mimeTypes.getIncluded();
        return includes.toArray(new String[0]);
    }

    public String[] getIncludedPaths() {
        Set includes = this._paths.getIncluded();
        return includes.toArray(new String[0]);
    }

    public String[] getIncludedInflationPaths() {
        Set includes = this._inflatePaths.getIncluded();
        return includes.toArray(new String[0]);
    }

    public int getMinGzipSize() {
        return this._minGzipSize;
    }

    protected HttpField getVaryField() {
        return this._vary;
    }

    public int getInflateBufferSize() {
        return this._inflateBufferSize;
    }

    public void setInflateBufferSize(int size) {
        this._inflateBufferSize = size;
    }

    @Override
    public Request.Processor handle(Request request) throws Exception {
        HeaderWrappingRequest wrappedRequest;
        String path = request.getPathInContext();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} handle {}", (Object)this, (Object)request);
        }
        HttpFields httpFields = request.getHeaders();
        boolean inflated = this._inflateBufferSize > 0 && httpFields.contains(HttpHeader.CONTENT_ENCODING, GZIP) && this.isPathInflatable(path);
        GzipRequest gzipRequest = Request.as(request, GzipRequest.class);
        boolean alreadyGzipped = gzipRequest != null;
        HttpFields.Mutable newFields = null;
        if (inflated || httpFields.contains(ETAG_HEADERS)) {
            newFields = HttpFields.build((int)(httpFields.size() + 1));
            block5: for (HttpField field : httpFields) {
                if (field.getHeader() == null) {
                    newFields.add(field);
                    continue;
                }
                switch (field.getHeader()) {
                    case IF_MATCH: 
                    case IF_NONE_MATCH: {
                        String etags = field.getValue();
                        String etagsNoSuffix = CompressedContentFormat.GZIP.stripSuffixes(etags);
                        if (etagsNoSuffix.equals(etags)) {
                            newFields.add(field);
                            continue block5;
                        }
                        newFields.add(new HttpField(field.getHeader(), etagsNoSuffix));
                        request.setAttribute(GZIP_HANDLER_ETAGS, etags);
                        continue block5;
                    }
                    case CONTENT_LENGTH: {
                        newFields.add(inflated ? new HttpField("X-Content-Length", field.getValue()) : field);
                        continue block5;
                    }
                    case CONTENT_ENCODING: {
                        if (inflated) {
                            if (field.getValue().equalsIgnoreCase(GZIP)) {
                                newFields.add(X_CE_GZIP);
                                continue block5;
                            }
                            if (!COMMA_GZIP.matcher(field.getValue()).matches()) continue block5;
                            String v = field.getValue();
                            v = v.substring(0, v.lastIndexOf(44));
                            newFields.add(X_CE_GZIP);
                            newFields.add(new HttpField(HttpHeader.CONTENT_ENCODING, v));
                            continue block5;
                        }
                        newFields.add(field);
                        continue block5;
                    }
                }
                newFields.add(field);
            }
        }
        if (alreadyGzipped) {
            LOG.debug("{} already intercepting {}", (Object)this, (Object)request);
            wrappedRequest = new HeaderWrappingRequest(request, (HttpFields)newFields);
            return wrappedRequest.wrapProcessor(super.handle(wrappedRequest));
        }
        if (!this._methods.test((Object)request.getMethod())) {
            LOG.debug("{} excluded by method {}", (Object)this, (Object)request);
            wrappedRequest = new HeaderWrappingRequest(request, (HttpFields)newFields);
            return wrappedRequest.wrapProcessor(super.handle(wrappedRequest));
        }
        if (!this.isPathGzipable(path)) {
            LOG.debug("{} excluded by path {}", (Object)this, (Object)request);
            wrappedRequest = new HeaderWrappingRequest(request, (HttpFields)newFields);
            return wrappedRequest.wrapProcessor(super.handle(wrappedRequest));
        }
        String mimeType = MimeTypes.getDefaultMimeByExtension((String)path);
        if (mimeType != null && !this.isMimeTypeGzipable(mimeType = HttpField.valueParameters((String)mimeType, null))) {
            LOG.debug("{} excluded by path suffix mime type {}", (Object)this, (Object)request);
            HeaderWrappingRequest wrappedRequest2 = new HeaderWrappingRequest(request, (HttpFields)newFields);
            return wrappedRequest2.wrapProcessor(super.handle(wrappedRequest2));
        }
        gzipRequest = new GzipRequest(request, this, inflated, (HttpFields)newFields);
        return gzipRequest.wrapProcessor(super.handle(gzipRequest));
    }

    @Override
    public boolean isMimeTypeGzipable(String mimetype) {
        return this._mimeTypes.test((Object)mimetype);
    }

    protected boolean isPathGzipable(String requestURI) {
        if (requestURI == null) {
            return true;
        }
        return this._paths.test((Object)requestURI);
    }

    protected boolean isPathInflatable(String requestURI) {
        if (requestURI == null) {
            return true;
        }
        return this._inflatePaths.test((Object)requestURI);
    }

    public void setExcludedMethods(String ... methods) {
        this._methods.getExcluded().clear();
        this._methods.exclude((Object[])methods);
    }

    public void setExcludedMimeTypes(String ... types) {
        this._mimeTypes.getExcluded().clear();
        this._mimeTypes.exclude((Object[])types);
    }

    public void setExcludedMimeTypesList(String csvTypes) {
        this.setExcludedMimeTypes(StringUtil.csvSplit((String)csvTypes));
    }

    public void setExcludedPaths(String ... pathspecs) {
        this._paths.getExcluded().clear();
        this._paths.exclude((Object[])pathspecs);
    }

    public void setExcludedInflatePaths(String ... pathspecs) {
        this._inflatePaths.getExcluded().clear();
        this._inflatePaths.exclude((Object[])pathspecs);
    }

    public void setIncludedMethods(String ... methods) {
        this._methods.getIncluded().clear();
        this._methods.include((Object[])methods);
    }

    public void setIncludedMimeTypes(String ... types) {
        this._mimeTypes.getIncluded().clear();
        this._mimeTypes.include((Object[])types);
    }

    public void setIncludedMimeTypesList(String csvTypes) {
        this.setIncludedMimeTypes(StringUtil.csvSplit((String)csvTypes));
    }

    public void setIncludedPaths(String ... pathspecs) {
        this._paths.getIncluded().clear();
        this._paths.include((Object[])pathspecs);
    }

    public void setIncludedInflatePaths(String ... pathspecs) {
        this._inflatePaths.getIncluded().clear();
        this._inflatePaths.include((Object[])pathspecs);
    }

    public void setMinGzipSize(int minGzipSize) {
        if (minGzipSize < 23) {
            LOG.warn("minGzipSize of {} is inefficient for short content, break even is size {}", (Object)minGzipSize, (Object)23);
        }
        this._minGzipSize = Math.max(0, minGzipSize);
    }

    public void setIncludedMethodList(String csvMethods) {
        this.setIncludedMethods(StringUtil.csvSplit((String)csvMethods));
    }

    public String getIncludedMethodList() {
        return String.join((CharSequence)",", this.getIncludedMethods());
    }

    public void setExcludedMethodList(String csvMethods) {
        this.setExcludedMethods(StringUtil.csvSplit((String)csvMethods));
    }

    public String getExcludedMethodList() {
        return String.join((CharSequence)",", this.getExcludedMethods());
    }

    public DeflaterPool getDeflaterPool() {
        return this._deflaterPool;
    }

    public InflaterPool getInflaterPool() {
        return this._inflaterPool;
    }

    public void setDeflaterPool(DeflaterPool deflaterPool) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this.updateBean(this._deflaterPool, deflaterPool);
        this._deflaterPool = deflaterPool;
    }

    public void setInflaterPool(InflaterPool inflaterPool) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this.updateBean(this._inflaterPool, inflaterPool);
        this._inflaterPool = inflaterPool;
    }

    public String toString() {
        return String.format("%s@%x{%s,min=%s,inflate=%s}", this.getClass().getSimpleName(), this.hashCode(), this.getState(), this._minGzipSize, this._inflateBufferSize);
    }
}

